<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/analytics/data/v1beta/analytics_data_api.proto

namespace Google\Analytics\Data\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An audience export is a list of users in an audience at the time of the
 * list's creation. One audience may have multiple audience exports created for
 * different days.
 *
 * Generated from protobuf message <code>google.analytics.data.v1beta.AudienceExport</code>
 */
class AudienceExport extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. The audience export resource name assigned during
     * creation. This resource name identifies this `AudienceExport`.
     * Format: `properties/{property}/audienceExports/{audience_export}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $audience = '';
    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $audience_display_name = '';
    /**
     * Required. The dimensions requested and displayed in the query response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1beta.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $dimensions;
    /**
     * Output only. The current state for this AudienceExport.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1beta.AudienceExport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = null;
    /**
     * Output only. The time when CreateAudienceExport was called and the
     * AudienceExport began the `CREATING` state.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $begin_creating_time = null;
    /**
     * Output only. The total quota tokens charged during creation of the
     * AudienceExport. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceExport
     * enters the `ACTIVE` or `FAILED` states.
     *
     * Generated from protobuf field <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $creation_quota_tokens_charged = 0;
    /**
     * Output only. The total number of rows in the AudienceExport result.
     *
     * Generated from protobuf field <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $row_count = null;
    /**
     * Output only. Error message is populated when an audience export fails
     * during creation. A common reason for such a failure is quota exhaustion.
     *
     * Generated from protobuf field <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error_message = null;
    /**
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     *
     * Generated from protobuf field <code>optional double percentage_completed = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $percentage_completed = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Identifier. The audience export resource name assigned during
     *           creation. This resource name identifies this `AudienceExport`.
     *           Format: `properties/{property}/audienceExports/{audience_export}`
     *     @type string $audience
     *           Required. The audience resource name. This resource name identifies the
     *           audience being listed and is shared between the Analytics Data & Admin
     *           APIs.
     *           Format: `properties/{property}/audiences/{audience}`
     *     @type string $audience_display_name
     *           Output only. The descriptive display name for this audience. For example,
     *           "Purchasers".
     *     @type array<\Google\Analytics\Data\V1beta\AudienceDimension>|\Google\Protobuf\Internal\RepeatedField $dimensions
     *           Required. The dimensions requested and displayed in the query response.
     *     @type int $state
     *           Output only. The current state for this AudienceExport.
     *     @type \Google\Protobuf\Timestamp $begin_creating_time
     *           Output only. The time when CreateAudienceExport was called and the
     *           AudienceExport began the `CREATING` state.
     *     @type int $creation_quota_tokens_charged
     *           Output only. The total quota tokens charged during creation of the
     *           AudienceExport. Because this token count is based on activity from the
     *           `CREATING` state, this tokens charged will be fixed once an AudienceExport
     *           enters the `ACTIVE` or `FAILED` states.
     *     @type int $row_count
     *           Output only. The total number of rows in the AudienceExport result.
     *     @type string $error_message
     *           Output only. Error message is populated when an audience export fails
     *           during creation. A common reason for such a failure is quota exhaustion.
     *     @type float $percentage_completed
     *           Output only. The percentage completed for this audience export ranging
     *           between 0 to 100.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Analytics\Data\V1Beta\AnalyticsDataApi::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Identifier. The audience export resource name assigned during
     * creation. This resource name identifies this `AudienceExport`.
     * Format: `properties/{property}/audienceExports/{audience_export}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. The audience export resource name assigned during
     * creation. This resource name identifies this `AudienceExport`.
     * Format: `properties/{property}/audienceExports/{audience_export}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getAudience()
    {
        return $this->audience;
    }

    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setAudience($var)
    {
        GPBUtil::checkString($var, True);
        $this->audience = $var;

        return $this;
    }

    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAudienceDisplayName()
    {
        return $this->audience_display_name;
    }

    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAudienceDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->audience_display_name = $var;

        return $this;
    }

    /**
     * Required. The dimensions requested and displayed in the query response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1beta.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDimensions()
    {
        return $this->dimensions;
    }

    /**
     * Required. The dimensions requested and displayed in the query response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1beta.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Analytics\Data\V1beta\AudienceDimension>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDimensions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Analytics\Data\V1beta\AudienceDimension::class);
        $this->dimensions = $arr;

        return $this;
    }

    /**
     * Output only. The current state for this AudienceExport.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1beta.AudienceExport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : 0;
    }

    public function hasState()
    {
        return isset($this->state);
    }

    public function clearState()
    {
        unset($this->state);
    }

    /**
     * Output only. The current state for this AudienceExport.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1beta.AudienceExport.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Analytics\Data\V1beta\AudienceExport\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The time when CreateAudienceExport was called and the
     * AudienceExport began the `CREATING` state.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getBeginCreatingTime()
    {
        return $this->begin_creating_time;
    }

    public function hasBeginCreatingTime()
    {
        return isset($this->begin_creating_time);
    }

    public function clearBeginCreatingTime()
    {
        unset($this->begin_creating_time);
    }

    /**
     * Output only. The time when CreateAudienceExport was called and the
     * AudienceExport began the `CREATING` state.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setBeginCreatingTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->begin_creating_time = $var;

        return $this;
    }

    /**
     * Output only. The total quota tokens charged during creation of the
     * AudienceExport. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceExport
     * enters the `ACTIVE` or `FAILED` states.
     *
     * Generated from protobuf field <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getCreationQuotaTokensCharged()
    {
        return $this->creation_quota_tokens_charged;
    }

    /**
     * Output only. The total quota tokens charged during creation of the
     * AudienceExport. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceExport
     * enters the `ACTIVE` or `FAILED` states.
     *
     * Generated from protobuf field <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setCreationQuotaTokensCharged($var)
    {
        GPBUtil::checkInt32($var);
        $this->creation_quota_tokens_charged = $var;

        return $this;
    }

    /**
     * Output only. The total number of rows in the AudienceExport result.
     *
     * Generated from protobuf field <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRowCount()
    {
        return isset($this->row_count) ? $this->row_count : 0;
    }

    public function hasRowCount()
    {
        return isset($this->row_count);
    }

    public function clearRowCount()
    {
        unset($this->row_count);
    }

    /**
     * Output only. The total number of rows in the AudienceExport result.
     *
     * Generated from protobuf field <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRowCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->row_count = $var;

        return $this;
    }

    /**
     * Output only. Error message is populated when an audience export fails
     * during creation. A common reason for such a failure is quota exhaustion.
     *
     * Generated from protobuf field <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getErrorMessage()
    {
        return isset($this->error_message) ? $this->error_message : '';
    }

    public function hasErrorMessage()
    {
        return isset($this->error_message);
    }

    public function clearErrorMessage()
    {
        unset($this->error_message);
    }

    /**
     * Output only. Error message is populated when an audience export fails
     * during creation. A common reason for such a failure is quota exhaustion.
     *
     * Generated from protobuf field <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setErrorMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->error_message = $var;

        return $this;
    }

    /**
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     *
     * Generated from protobuf field <code>optional double percentage_completed = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getPercentageCompleted()
    {
        return isset($this->percentage_completed) ? $this->percentage_completed : 0.0;
    }

    public function hasPercentageCompleted()
    {
        return isset($this->percentage_completed);
    }

    public function clearPercentageCompleted()
    {
        unset($this->percentage_completed);
    }

    /**
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     *
     * Generated from protobuf field <code>optional double percentage_completed = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setPercentageCompleted($var)
    {
        GPBUtil::checkDouble($var);
        $this->percentage_completed = $var;

        return $this;
    }

}

