<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/workloadmanager/v1/service.proto

namespace Google\Cloud\WorkloadManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Workload Manager Evaluation configuration.
 * An Evaluation defines a set of rules to be validated against a scope
 * of Cloud resources.
 *
 * Generated from protobuf message <code>google.cloud.workloadmanager.v1.Evaluation</code>
 */
class Evaluation extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of resource that has the form
     * `projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Description of the Evaluation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    protected $description = '';
    /**
     * Resource filter for an evaluation defining the scope of resources to be
     * evaluated.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.ResourceFilter resource_filter = 3;</code>
     */
    protected $resource_filter = null;
    /**
     * The names of the rules used for this evaluation.
     *
     * Generated from protobuf field <code>repeated string rule_names = 4;</code>
     */
    private $rule_names;
    /**
     * Output only. [Output only] The current lifecycle state of the evaluation
     * resource.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.ResourceStatus resource_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $resource_status = null;
    /**
     * Output only. [Output only] Create time stamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. [Output only] Update time stamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Labels as key value pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     */
    private $labels;
    /**
     * Crontab format schedule for scheduled evaluation, currently only supports
     * the following fixed schedules:
     * * `0 *&#47;1 * * *` # Hourly
     * * `0 *&#47;6 * * *` # Every 6 hours
     * * `0 *&#47;12 * * *` # Every 12 hours
     * * `0 0 *&#47;1 * *` # Daily
     * * `0 0 *&#47;7 * *` # Weekly
     * * `0 0 *&#47;14 * *` # Every 14 days
     * * `0 0 1 *&#47;1 *` # Monthly
     *
     * Generated from protobuf field <code>optional string schedule = 10;</code>
     */
    protected $schedule = null;
    /**
     * The Cloud Storage bucket name for custom rules.
     *
     * Generated from protobuf field <code>string custom_rules_bucket = 11;</code>
     */
    protected $custom_rules_bucket = '';
    /**
     * Evaluation type.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.Evaluation.EvaluationType evaluation_type = 12;</code>
     */
    protected $evaluation_type = 0;
    /**
     * Optional. The BigQuery destination for detailed evaluation results.
     * If this field is specified, the results of each evaluation execution are
     * exported to BigQuery.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.BigQueryDestination big_query_destination = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $big_query_destination = null;
    /**
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * The key will be used for CMEK encryption of the evaluation resource.
     *
     * Generated from protobuf field <code>string kms_key = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $kms_key = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Name of resource that has the form
     *           `projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}`.
     *     @type string $description
     *           Description of the Evaluation.
     *     @type \Google\Cloud\WorkloadManager\V1\ResourceFilter $resource_filter
     *           Resource filter for an evaluation defining the scope of resources to be
     *           evaluated.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $rule_names
     *           The names of the rules used for this evaluation.
     *     @type \Google\Cloud\WorkloadManager\V1\ResourceStatus $resource_status
     *           Output only. [Output only] The current lifecycle state of the evaluation
     *           resource.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. [Output only] Create time stamp.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. [Output only] Update time stamp.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels as key value pairs.
     *     @type string $schedule
     *           Crontab format schedule for scheduled evaluation, currently only supports
     *           the following fixed schedules:
     *           * `0 *&#47;1 * * *` # Hourly
     *           * `0 *&#47;6 * * *` # Every 6 hours
     *           * `0 *&#47;12 * * *` # Every 12 hours
     *           * `0 0 *&#47;1 * *` # Daily
     *           * `0 0 *&#47;7 * *` # Weekly
     *           * `0 0 *&#47;14 * *` # Every 14 days
     *           * `0 0 1 *&#47;1 *` # Monthly
     *     @type string $custom_rules_bucket
     *           The Cloud Storage bucket name for custom rules.
     *     @type int $evaluation_type
     *           Evaluation type.
     *     @type \Google\Cloud\WorkloadManager\V1\BigQueryDestination $big_query_destination
     *           Optional. The BigQuery destination for detailed evaluation results.
     *           If this field is specified, the results of each evaluation execution are
     *           exported to BigQuery.
     *     @type string $kms_key
     *           Optional. Immutable. Customer-managed encryption key name, in the format
     *           projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     *           The key will be used for CMEK encryption of the evaluation resource.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Workloadmanager\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of resource that has the form
     * `projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of resource that has the form
     * `projects/{project_id}/locations/{location_id}/evaluations/{evaluation_id}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Description of the Evaluation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Description of the Evaluation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Resource filter for an evaluation defining the scope of resources to be
     * evaluated.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.ResourceFilter resource_filter = 3;</code>
     * @return \Google\Cloud\WorkloadManager\V1\ResourceFilter|null
     */
    public function getResourceFilter()
    {
        return $this->resource_filter;
    }

    public function hasResourceFilter()
    {
        return isset($this->resource_filter);
    }

    public function clearResourceFilter()
    {
        unset($this->resource_filter);
    }

    /**
     * Resource filter for an evaluation defining the scope of resources to be
     * evaluated.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.ResourceFilter resource_filter = 3;</code>
     * @param \Google\Cloud\WorkloadManager\V1\ResourceFilter $var
     * @return $this
     */
    public function setResourceFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\WorkloadManager\V1\ResourceFilter::class);
        $this->resource_filter = $var;

        return $this;
    }

    /**
     * The names of the rules used for this evaluation.
     *
     * Generated from protobuf field <code>repeated string rule_names = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRuleNames()
    {
        return $this->rule_names;
    }

    /**
     * The names of the rules used for this evaluation.
     *
     * Generated from protobuf field <code>repeated string rule_names = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRuleNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->rule_names = $arr;

        return $this;
    }

    /**
     * Output only. [Output only] The current lifecycle state of the evaluation
     * resource.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.ResourceStatus resource_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\WorkloadManager\V1\ResourceStatus|null
     */
    public function getResourceStatus()
    {
        return $this->resource_status;
    }

    public function hasResourceStatus()
    {
        return isset($this->resource_status);
    }

    public function clearResourceStatus()
    {
        unset($this->resource_status);
    }

    /**
     * Output only. [Output only] The current lifecycle state of the evaluation
     * resource.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.ResourceStatus resource_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\WorkloadManager\V1\ResourceStatus $var
     * @return $this
     */
    public function setResourceStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\WorkloadManager\V1\ResourceStatus::class);
        $this->resource_status = $var;

        return $this;
    }

    /**
     * Output only. [Output only] Create time stamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. [Output only] Create time stamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. [Output only] Update time stamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. [Output only] Update time stamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Labels as key value pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels as key value pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Crontab format schedule for scheduled evaluation, currently only supports
     * the following fixed schedules:
     * * `0 *&#47;1 * * *` # Hourly
     * * `0 *&#47;6 * * *` # Every 6 hours
     * * `0 *&#47;12 * * *` # Every 12 hours
     * * `0 0 *&#47;1 * *` # Daily
     * * `0 0 *&#47;7 * *` # Weekly
     * * `0 0 *&#47;14 * *` # Every 14 days
     * * `0 0 1 *&#47;1 *` # Monthly
     *
     * Generated from protobuf field <code>optional string schedule = 10;</code>
     * @return string
     */
    public function getSchedule()
    {
        return isset($this->schedule) ? $this->schedule : '';
    }

    public function hasSchedule()
    {
        return isset($this->schedule);
    }

    public function clearSchedule()
    {
        unset($this->schedule);
    }

    /**
     * Crontab format schedule for scheduled evaluation, currently only supports
     * the following fixed schedules:
     * * `0 *&#47;1 * * *` # Hourly
     * * `0 *&#47;6 * * *` # Every 6 hours
     * * `0 *&#47;12 * * *` # Every 12 hours
     * * `0 0 *&#47;1 * *` # Daily
     * * `0 0 *&#47;7 * *` # Weekly
     * * `0 0 *&#47;14 * *` # Every 14 days
     * * `0 0 1 *&#47;1 *` # Monthly
     *
     * Generated from protobuf field <code>optional string schedule = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setSchedule($var)
    {
        GPBUtil::checkString($var, True);
        $this->schedule = $var;

        return $this;
    }

    /**
     * The Cloud Storage bucket name for custom rules.
     *
     * Generated from protobuf field <code>string custom_rules_bucket = 11;</code>
     * @return string
     */
    public function getCustomRulesBucket()
    {
        return $this->custom_rules_bucket;
    }

    /**
     * The Cloud Storage bucket name for custom rules.
     *
     * Generated from protobuf field <code>string custom_rules_bucket = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomRulesBucket($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_rules_bucket = $var;

        return $this;
    }

    /**
     * Evaluation type.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.Evaluation.EvaluationType evaluation_type = 12;</code>
     * @return int
     */
    public function getEvaluationType()
    {
        return $this->evaluation_type;
    }

    /**
     * Evaluation type.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.Evaluation.EvaluationType evaluation_type = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setEvaluationType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\WorkloadManager\V1\Evaluation\EvaluationType::class);
        $this->evaluation_type = $var;

        return $this;
    }

    /**
     * Optional. The BigQuery destination for detailed evaluation results.
     * If this field is specified, the results of each evaluation execution are
     * exported to BigQuery.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.BigQueryDestination big_query_destination = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\WorkloadManager\V1\BigQueryDestination|null
     */
    public function getBigQueryDestination()
    {
        return $this->big_query_destination;
    }

    public function hasBigQueryDestination()
    {
        return isset($this->big_query_destination);
    }

    public function clearBigQueryDestination()
    {
        unset($this->big_query_destination);
    }

    /**
     * Optional. The BigQuery destination for detailed evaluation results.
     * If this field is specified, the results of each evaluation execution are
     * exported to BigQuery.
     *
     * Generated from protobuf field <code>.google.cloud.workloadmanager.v1.BigQueryDestination big_query_destination = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\WorkloadManager\V1\BigQueryDestination $var
     * @return $this
     */
    public function setBigQueryDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\WorkloadManager\V1\BigQueryDestination::class);
        $this->big_query_destination = $var;

        return $this;
    }

    /**
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * The key will be used for CMEK encryption of the evaluation resource.
     *
     * Generated from protobuf field <code>string kms_key = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKey()
    {
        return $this->kms_key;
    }

    /**
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * The key will be used for CMEK encryption of the evaluation resource.
     *
     * Generated from protobuf field <code>string kms_key = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key = $var;

        return $this;
    }

}

