<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vmwareengine/v1/vmwareengine_resources.proto

namespace Google\Cloud\VmwareEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Autoscaling settings define the rules used by VMware Engine to
 * automatically scale-out and scale-in the clusters in a private cloud.
 *
 * Generated from protobuf message <code>google.cloud.vmwareengine.v1.AutoscalingSettings</code>
 */
class AutoscalingSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The map with autoscaling policies applied to the cluster.
     * The key is the identifier of the policy.
     * It must meet the following requirements:
     * * Only contains 1-63 alphanumeric characters and hyphens
     * * Begins with an alphabetical character
     * * Ends with a non-hyphen character
     * * Not formatted as a UUID
     * * Complies with [RFC
     * 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
     * Currently there map must contain only one element
     * that describes the autoscaling policy for compute nodes.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy> autoscaling_policies = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $autoscaling_policies;
    /**
     * Optional. Minimum number of nodes of any type in a cluster.
     * If not specified the default limits apply.
     *
     * Generated from protobuf field <code>int32 min_cluster_node_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $min_cluster_node_count = 0;
    /**
     * Optional. Maximum number of nodes of any type in a cluster.
     * If not specified the default limits apply.
     *
     * Generated from protobuf field <code>int32 max_cluster_node_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $max_cluster_node_count = 0;
    /**
     * Optional. The minimum duration between consecutive autoscale operations.
     * It starts once addition or removal of nodes is fully completed.
     * Defaults to 30 minutes if not specified. Cool down period must be in whole
     * minutes (for example, 30, 31, 50, 180 minutes).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration cool_down_period = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cool_down_period = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array|\Google\Protobuf\Internal\MapField $autoscaling_policies
     *           Required. The map with autoscaling policies applied to the cluster.
     *           The key is the identifier of the policy.
     *           It must meet the following requirements:
     *           * Only contains 1-63 alphanumeric characters and hyphens
     *           * Begins with an alphabetical character
     *           * Ends with a non-hyphen character
     *           * Not formatted as a UUID
     *           * Complies with [RFC
     *           1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
     *           Currently there map must contain only one element
     *           that describes the autoscaling policy for compute nodes.
     *     @type int $min_cluster_node_count
     *           Optional. Minimum number of nodes of any type in a cluster.
     *           If not specified the default limits apply.
     *     @type int $max_cluster_node_count
     *           Optional. Maximum number of nodes of any type in a cluster.
     *           If not specified the default limits apply.
     *     @type \Google\Protobuf\Duration $cool_down_period
     *           Optional. The minimum duration between consecutive autoscale operations.
     *           It starts once addition or removal of nodes is fully completed.
     *           Defaults to 30 minutes if not specified. Cool down period must be in whole
     *           minutes (for example, 30, 31, 50, 180 minutes).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vmwareengine\V1\VmwareengineResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The map with autoscaling policies applied to the cluster.
     * The key is the identifier of the policy.
     * It must meet the following requirements:
     * * Only contains 1-63 alphanumeric characters and hyphens
     * * Begins with an alphabetical character
     * * Ends with a non-hyphen character
     * * Not formatted as a UUID
     * * Complies with [RFC
     * 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
     * Currently there map must contain only one element
     * that describes the autoscaling policy for compute nodes.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy> autoscaling_policies = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAutoscalingPolicies()
    {
        return $this->autoscaling_policies;
    }

    /**
     * Required. The map with autoscaling policies applied to the cluster.
     * The key is the identifier of the policy.
     * It must meet the following requirements:
     * * Only contains 1-63 alphanumeric characters and hyphens
     * * Begins with an alphabetical character
     * * Ends with a non-hyphen character
     * * Not formatted as a UUID
     * * Complies with [RFC
     * 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
     * Currently there map must contain only one element
     * that describes the autoscaling policy for compute nodes.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.vmwareengine.v1.AutoscalingSettings.AutoscalingPolicy> autoscaling_policies = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAutoscalingPolicies($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VmwareEngine\V1\AutoscalingSettings\AutoscalingPolicy::class);
        $this->autoscaling_policies = $arr;

        return $this;
    }

    /**
     * Optional. Minimum number of nodes of any type in a cluster.
     * If not specified the default limits apply.
     *
     * Generated from protobuf field <code>int32 min_cluster_node_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMinClusterNodeCount()
    {
        return $this->min_cluster_node_count;
    }

    /**
     * Optional. Minimum number of nodes of any type in a cluster.
     * If not specified the default limits apply.
     *
     * Generated from protobuf field <code>int32 min_cluster_node_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMinClusterNodeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_cluster_node_count = $var;

        return $this;
    }

    /**
     * Optional. Maximum number of nodes of any type in a cluster.
     * If not specified the default limits apply.
     *
     * Generated from protobuf field <code>int32 max_cluster_node_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMaxClusterNodeCount()
    {
        return $this->max_cluster_node_count;
    }

    /**
     * Optional. Maximum number of nodes of any type in a cluster.
     * If not specified the default limits apply.
     *
     * Generated from protobuf field <code>int32 max_cluster_node_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMaxClusterNodeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_cluster_node_count = $var;

        return $this;
    }

    /**
     * Optional. The minimum duration between consecutive autoscale operations.
     * It starts once addition or removal of nodes is fully completed.
     * Defaults to 30 minutes if not specified. Cool down period must be in whole
     * minutes (for example, 30, 31, 50, 180 minutes).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration cool_down_period = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getCoolDownPeriod()
    {
        return $this->cool_down_period;
    }

    public function hasCoolDownPeriod()
    {
        return isset($this->cool_down_period);
    }

    public function clearCoolDownPeriod()
    {
        unset($this->cool_down_period);
    }

    /**
     * Optional. The minimum duration between consecutive autoscale operations.
     * It starts once addition or removal of nodes is fully completed.
     * Defaults to 30 minutes if not specified. Cool down period must be in whole
     * minutes (for example, 30, 31, 50, 180 minutes).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration cool_down_period = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setCoolDownPeriod($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->cool_down_period = $var;

        return $this;
    }

}

