<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/platform.proto

namespace Google\Cloud\VisionAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message describing VertexCustomConfig.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.VertexCustomConfig</code>
 */
class VertexCustomConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The max prediction frame per second. This attribute sets how fast the
     * operator sends prediction requests to Vertex AI endpoint. Default value is
     * 0, which means there is no max prediction fps limit. The operator sends
     * prediction requests at input fps.
     *
     * Generated from protobuf field <code>int32 max_prediction_fps = 1;</code>
     */
    protected $max_prediction_fps = 0;
    /**
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.DedicatedResources dedicated_resources = 2;</code>
     */
    protected $dedicated_resources = null;
    /**
     * If not empty, the prediction result will be sent to the specified cloud
     * function for post processing.
     * * The cloud function will receive AppPlatformCloudFunctionRequest where
     * the annotations field will be the json format of proto PredictResponse.
     * * The cloud function should return AppPlatformCloudFunctionResponse with
     * PredictResponse stored in the annotations field.
     * * To drop the prediction output, simply clear the payload field in the
     * returned AppPlatformCloudFunctionResponse.
     *
     * Generated from protobuf field <code>string post_processing_cloud_function = 3;</code>
     */
    protected $post_processing_cloud_function = '';
    /**
     * If true, the prediction request received by custom model will also contain
     * metadata with the following schema:
     * 'appPlatformMetadata': {
     *       'ingestionTime': DOUBLE; (UNIX timestamp)
     *       'application': STRING;
     *       'instanceId': STRING;
     *       'node': STRING;
     *       'processor': STRING;
     *  }
     *
     * Generated from protobuf field <code>bool attach_application_metadata = 4;</code>
     */
    protected $attach_application_metadata = false;
    /**
     * Optional. By setting the configuration_input_topic, processor will
     * subscribe to given topic, only pub/sub topic is supported now. Example
     * channel:
     * //pubsub.googleapis.com/projects/visionai-testing-stable/topics/test-topic
     * message schema should be:
     * message Message {
     * // The ID of the stream that associates with the application instance.
     * string stream_id = 1;
     * // The target fps. By default, the custom processor will *not* send any
     * data to the Vertex Prediction container. Note that once the
     * dynamic_config_input_topic is set, max_prediction_fps will not work and be
     * preceded by the fps set inside the topic.
     * int32 fps = 2;
     * }
     *
     * Generated from protobuf field <code>optional string dynamic_config_input_topic = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $dynamic_config_input_topic = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $max_prediction_fps
     *           The max prediction frame per second. This attribute sets how fast the
     *           operator sends prediction requests to Vertex AI endpoint. Default value is
     *           0, which means there is no max prediction fps limit. The operator sends
     *           prediction requests at input fps.
     *     @type \Google\Cloud\VisionAI\V1\DedicatedResources $dedicated_resources
     *           A description of resources that are dedicated to the DeployedModel, and
     *           that need a higher degree of manual configuration.
     *     @type string $post_processing_cloud_function
     *           If not empty, the prediction result will be sent to the specified cloud
     *           function for post processing.
     *           * The cloud function will receive AppPlatformCloudFunctionRequest where
     *           the annotations field will be the json format of proto PredictResponse.
     *           * The cloud function should return AppPlatformCloudFunctionResponse with
     *           PredictResponse stored in the annotations field.
     *           * To drop the prediction output, simply clear the payload field in the
     *           returned AppPlatformCloudFunctionResponse.
     *     @type bool $attach_application_metadata
     *           If true, the prediction request received by custom model will also contain
     *           metadata with the following schema:
     *           'appPlatformMetadata': {
     *                 'ingestionTime': DOUBLE; (UNIX timestamp)
     *                 'application': STRING;
     *                 'instanceId': STRING;
     *                 'node': STRING;
     *                 'processor': STRING;
     *            }
     *     @type string $dynamic_config_input_topic
     *           Optional. By setting the configuration_input_topic, processor will
     *           subscribe to given topic, only pub/sub topic is supported now. Example
     *           channel:
     *           //pubsub.googleapis.com/projects/visionai-testing-stable/topics/test-topic
     *           message schema should be:
     *           message Message {
     *           // The ID of the stream that associates with the application instance.
     *           string stream_id = 1;
     *           // The target fps. By default, the custom processor will *not* send any
     *           data to the Vertex Prediction container. Note that once the
     *           dynamic_config_input_topic is set, max_prediction_fps will not work and be
     *           preceded by the fps set inside the topic.
     *           int32 fps = 2;
     *           }
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Platform::initOnce();
        parent::__construct($data);
    }

    /**
     * The max prediction frame per second. This attribute sets how fast the
     * operator sends prediction requests to Vertex AI endpoint. Default value is
     * 0, which means there is no max prediction fps limit. The operator sends
     * prediction requests at input fps.
     *
     * Generated from protobuf field <code>int32 max_prediction_fps = 1;</code>
     * @return int
     */
    public function getMaxPredictionFps()
    {
        return $this->max_prediction_fps;
    }

    /**
     * The max prediction frame per second. This attribute sets how fast the
     * operator sends prediction requests to Vertex AI endpoint. Default value is
     * 0, which means there is no max prediction fps limit. The operator sends
     * prediction requests at input fps.
     *
     * Generated from protobuf field <code>int32 max_prediction_fps = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxPredictionFps($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_prediction_fps = $var;

        return $this;
    }

    /**
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.DedicatedResources dedicated_resources = 2;</code>
     * @return \Google\Cloud\VisionAI\V1\DedicatedResources|null
     */
    public function getDedicatedResources()
    {
        return $this->dedicated_resources;
    }

    public function hasDedicatedResources()
    {
        return isset($this->dedicated_resources);
    }

    public function clearDedicatedResources()
    {
        unset($this->dedicated_resources);
    }

    /**
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.DedicatedResources dedicated_resources = 2;</code>
     * @param \Google\Cloud\VisionAI\V1\DedicatedResources $var
     * @return $this
     */
    public function setDedicatedResources($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\DedicatedResources::class);
        $this->dedicated_resources = $var;

        return $this;
    }

    /**
     * If not empty, the prediction result will be sent to the specified cloud
     * function for post processing.
     * * The cloud function will receive AppPlatformCloudFunctionRequest where
     * the annotations field will be the json format of proto PredictResponse.
     * * The cloud function should return AppPlatformCloudFunctionResponse with
     * PredictResponse stored in the annotations field.
     * * To drop the prediction output, simply clear the payload field in the
     * returned AppPlatformCloudFunctionResponse.
     *
     * Generated from protobuf field <code>string post_processing_cloud_function = 3;</code>
     * @return string
     */
    public function getPostProcessingCloudFunction()
    {
        return $this->post_processing_cloud_function;
    }

    /**
     * If not empty, the prediction result will be sent to the specified cloud
     * function for post processing.
     * * The cloud function will receive AppPlatformCloudFunctionRequest where
     * the annotations field will be the json format of proto PredictResponse.
     * * The cloud function should return AppPlatformCloudFunctionResponse with
     * PredictResponse stored in the annotations field.
     * * To drop the prediction output, simply clear the payload field in the
     * returned AppPlatformCloudFunctionResponse.
     *
     * Generated from protobuf field <code>string post_processing_cloud_function = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPostProcessingCloudFunction($var)
    {
        GPBUtil::checkString($var, True);
        $this->post_processing_cloud_function = $var;

        return $this;
    }

    /**
     * If true, the prediction request received by custom model will also contain
     * metadata with the following schema:
     * 'appPlatformMetadata': {
     *       'ingestionTime': DOUBLE; (UNIX timestamp)
     *       'application': STRING;
     *       'instanceId': STRING;
     *       'node': STRING;
     *       'processor': STRING;
     *  }
     *
     * Generated from protobuf field <code>bool attach_application_metadata = 4;</code>
     * @return bool
     */
    public function getAttachApplicationMetadata()
    {
        return $this->attach_application_metadata;
    }

    /**
     * If true, the prediction request received by custom model will also contain
     * metadata with the following schema:
     * 'appPlatformMetadata': {
     *       'ingestionTime': DOUBLE; (UNIX timestamp)
     *       'application': STRING;
     *       'instanceId': STRING;
     *       'node': STRING;
     *       'processor': STRING;
     *  }
     *
     * Generated from protobuf field <code>bool attach_application_metadata = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setAttachApplicationMetadata($var)
    {
        GPBUtil::checkBool($var);
        $this->attach_application_metadata = $var;

        return $this;
    }

    /**
     * Optional. By setting the configuration_input_topic, processor will
     * subscribe to given topic, only pub/sub topic is supported now. Example
     * channel:
     * //pubsub.googleapis.com/projects/visionai-testing-stable/topics/test-topic
     * message schema should be:
     * message Message {
     * // The ID of the stream that associates with the application instance.
     * string stream_id = 1;
     * // The target fps. By default, the custom processor will *not* send any
     * data to the Vertex Prediction container. Note that once the
     * dynamic_config_input_topic is set, max_prediction_fps will not work and be
     * preceded by the fps set inside the topic.
     * int32 fps = 2;
     * }
     *
     * Generated from protobuf field <code>optional string dynamic_config_input_topic = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDynamicConfigInputTopic()
    {
        return isset($this->dynamic_config_input_topic) ? $this->dynamic_config_input_topic : '';
    }

    public function hasDynamicConfigInputTopic()
    {
        return isset($this->dynamic_config_input_topic);
    }

    public function clearDynamicConfigInputTopic()
    {
        unset($this->dynamic_config_input_topic);
    }

    /**
     * Optional. By setting the configuration_input_topic, processor will
     * subscribe to given topic, only pub/sub topic is supported now. Example
     * channel:
     * //pubsub.googleapis.com/projects/visionai-testing-stable/topics/test-topic
     * message schema should be:
     * message Message {
     * // The ID of the stream that associates with the application instance.
     * string stream_id = 1;
     * // The target fps. By default, the custom processor will *not* send any
     * data to the Vertex Prediction container. Note that once the
     * dynamic_config_input_topic is set, max_prediction_fps will not work and be
     * preceded by the fps set inside the topic.
     * int32 fps = 2;
     * }
     *
     * Generated from protobuf field <code>optional string dynamic_config_input_topic = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDynamicConfigInputTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->dynamic_config_input_topic = $var;

        return $this;
    }

}

