<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/warehouse.proto

namespace Google\Cloud\VisionAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Search result contains asset name and corresponding time ranges.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.SearchResultItem</code>
 */
class SearchResultItem extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the asset.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     *
     * Generated from protobuf field <code>string asset = 1;</code>
     */
    protected $asset = '';
    /**
     * The matched asset segments.
     * Deprecated: please use singular `segment` field.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Partition.TemporalPartition segments = 2 [deprecated = true];</code>
     * @deprecated
     */
    private $segments;
    /**
     * The matched asset segment.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Partition.TemporalPartition segment = 5;</code>
     */
    protected $segment = null;
    /**
     * Available to IMAGE corpus types.
     * Relevance of this `SearchResultItem` to user search query (text query or
     * image query).
     * By default this represents cosine similarity between the query and the
     * retrieved media content. The value is in the range of [-1, 1].
     * Note that search ranking is not only decided by this relevance score, but
     * also other factors such as the match of annotations.
     *
     * Generated from protobuf field <code>double relevance = 6;</code>
     */
    protected $relevance = 0.0;
    /**
     * Search result annotations specified by result_annotation_keys in search
     * request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Annotation requested_annotations = 3;</code>
     */
    private $requested_annotations;
    /**
     * Criteria or facet-selection based annotation matching results associated to
     * this search result item. Only contains results for criteria or
     * facet_selections with fetch_matched_annotations=true.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.AnnotationMatchingResult annotation_matching_results = 4;</code>
     */
    private $annotation_matching_results;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $asset
     *           The resource name of the asset.
     *           Format:
     *           `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     *     @type array<\Google\Cloud\VisionAI\V1\Partition\TemporalPartition>|\Google\Protobuf\Internal\RepeatedField $segments
     *           The matched asset segments.
     *           Deprecated: please use singular `segment` field.
     *     @type \Google\Cloud\VisionAI\V1\Partition\TemporalPartition $segment
     *           The matched asset segment.
     *     @type float $relevance
     *           Available to IMAGE corpus types.
     *           Relevance of this `SearchResultItem` to user search query (text query or
     *           image query).
     *           By default this represents cosine similarity between the query and the
     *           retrieved media content. The value is in the range of [-1, 1].
     *           Note that search ranking is not only decided by this relevance score, but
     *           also other factors such as the match of annotations.
     *     @type array<\Google\Cloud\VisionAI\V1\Annotation>|\Google\Protobuf\Internal\RepeatedField $requested_annotations
     *           Search result annotations specified by result_annotation_keys in search
     *           request.
     *     @type array<\Google\Cloud\VisionAI\V1\AnnotationMatchingResult>|\Google\Protobuf\Internal\RepeatedField $annotation_matching_results
     *           Criteria or facet-selection based annotation matching results associated to
     *           this search result item. Only contains results for criteria or
     *           facet_selections with fetch_matched_annotations=true.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Warehouse::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the asset.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     *
     * Generated from protobuf field <code>string asset = 1;</code>
     * @return string
     */
    public function getAsset()
    {
        return $this->asset;
    }

    /**
     * The resource name of the asset.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     *
     * Generated from protobuf field <code>string asset = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setAsset($var)
    {
        GPBUtil::checkString($var, True);
        $this->asset = $var;

        return $this;
    }

    /**
     * The matched asset segments.
     * Deprecated: please use singular `segment` field.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Partition.TemporalPartition segments = 2 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getSegments()
    {
        if ($this->segments->count() !== 0) {
            @trigger_error('segments is deprecated.', E_USER_DEPRECATED);
        }
        return $this->segments;
    }

    /**
     * The matched asset segments.
     * Deprecated: please use singular `segment` field.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Partition.TemporalPartition segments = 2 [deprecated = true];</code>
     * @param array<\Google\Cloud\VisionAI\V1\Partition\TemporalPartition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setSegments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VisionAI\V1\Partition\TemporalPartition::class);
        if ($arr->count() !== 0) {
            @trigger_error('segments is deprecated.', E_USER_DEPRECATED);
        }
        $this->segments = $arr;

        return $this;
    }

    /**
     * The matched asset segment.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Partition.TemporalPartition segment = 5;</code>
     * @return \Google\Cloud\VisionAI\V1\Partition\TemporalPartition|null
     */
    public function getSegment()
    {
        return $this->segment;
    }

    public function hasSegment()
    {
        return isset($this->segment);
    }

    public function clearSegment()
    {
        unset($this->segment);
    }

    /**
     * The matched asset segment.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Partition.TemporalPartition segment = 5;</code>
     * @param \Google\Cloud\VisionAI\V1\Partition\TemporalPartition $var
     * @return $this
     */
    public function setSegment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\Partition\TemporalPartition::class);
        $this->segment = $var;

        return $this;
    }

    /**
     * Available to IMAGE corpus types.
     * Relevance of this `SearchResultItem` to user search query (text query or
     * image query).
     * By default this represents cosine similarity between the query and the
     * retrieved media content. The value is in the range of [-1, 1].
     * Note that search ranking is not only decided by this relevance score, but
     * also other factors such as the match of annotations.
     *
     * Generated from protobuf field <code>double relevance = 6;</code>
     * @return float
     */
    public function getRelevance()
    {
        return $this->relevance;
    }

    /**
     * Available to IMAGE corpus types.
     * Relevance of this `SearchResultItem` to user search query (text query or
     * image query).
     * By default this represents cosine similarity between the query and the
     * retrieved media content. The value is in the range of [-1, 1].
     * Note that search ranking is not only decided by this relevance score, but
     * also other factors such as the match of annotations.
     *
     * Generated from protobuf field <code>double relevance = 6;</code>
     * @param float $var
     * @return $this
     */
    public function setRelevance($var)
    {
        GPBUtil::checkDouble($var);
        $this->relevance = $var;

        return $this;
    }

    /**
     * Search result annotations specified by result_annotation_keys in search
     * request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Annotation requested_annotations = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRequestedAnnotations()
    {
        return $this->requested_annotations;
    }

    /**
     * Search result annotations specified by result_annotation_keys in search
     * request.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Annotation requested_annotations = 3;</code>
     * @param array<\Google\Cloud\VisionAI\V1\Annotation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRequestedAnnotations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VisionAI\V1\Annotation::class);
        $this->requested_annotations = $arr;

        return $this;
    }

    /**
     * Criteria or facet-selection based annotation matching results associated to
     * this search result item. Only contains results for criteria or
     * facet_selections with fetch_matched_annotations=true.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.AnnotationMatchingResult annotation_matching_results = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAnnotationMatchingResults()
    {
        return $this->annotation_matching_results;
    }

    /**
     * Criteria or facet-selection based annotation matching results associated to
     * this search result item. Only contains results for criteria or
     * facet_selections with fetch_matched_annotations=true.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.AnnotationMatchingResult annotation_matching_results = 4;</code>
     * @param array<\Google\Cloud\VisionAI\V1\AnnotationMatchingResult>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAnnotationMatchingResults($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VisionAI\V1\AnnotationMatchingResult::class);
        $this->annotation_matching_results = $arr;

        return $this;
    }

}

