<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/platform.proto

namespace Google\Cloud\VisionAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message describing node object.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.Node</code>
 */
class Node extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. A unique name for the node.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * A user friendly display name for the node.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * Node config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.ProcessorConfig node_config = 3;</code>
     */
    protected $node_config = null;
    /**
     * Processor name refer to the chosen processor resource.
     *
     * Generated from protobuf field <code>string processor = 4;</code>
     */
    protected $processor = '';
    /**
     * Parent node. Input node should not have parent node. For V1 Alpha1/Beta
     * only media warehouse node can have multiple parents, other types of nodes
     * will only have one parent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Node.InputEdge parents = 5;</code>
     */
    private $parents;
    protected $stream_output_config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $output_all_output_channels_to_stream
     *           By default, the output of the node will only be available to downstream
     *           nodes. To consume the direct output from the application node, the output
     *           must be sent to Vision AI Streams at first.
     *           By setting output_all_output_channels_to_stream to true, App Platform
     *           will automatically send all the outputs of the current node to Vision AI
     *           Stream resources (one stream per output channel). The output stream
     *           resource will be created by App Platform automatically during deployment
     *           and deleted after application un-deployment.
     *           Note that this config applies to all the Application Instances.
     *           The output stream can be override at instance level by
     *           configuring the `output_resources` section of Instance resource.
     *           `producer_node` should be current node, `output_resource_binding` should
     *           be the output channel name (or leave it blank if there is only 1 output
     *           channel of the processor) and `output_resource` should be the target
     *           output stream.
     *     @type string $name
     *           Required. A unique name for the node.
     *     @type string $display_name
     *           A user friendly display name for the node.
     *     @type \Google\Cloud\VisionAI\V1\ProcessorConfig $node_config
     *           Node config.
     *     @type string $processor
     *           Processor name refer to the chosen processor resource.
     *     @type array<\Google\Cloud\VisionAI\V1\Node\InputEdge>|\Google\Protobuf\Internal\RepeatedField $parents
     *           Parent node. Input node should not have parent node. For V1 Alpha1/Beta
     *           only media warehouse node can have multiple parents, other types of nodes
     *           will only have one parent.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Platform::initOnce();
        parent::__construct($data);
    }

    /**
     * By default, the output of the node will only be available to downstream
     * nodes. To consume the direct output from the application node, the output
     * must be sent to Vision AI Streams at first.
     * By setting output_all_output_channels_to_stream to true, App Platform
     * will automatically send all the outputs of the current node to Vision AI
     * Stream resources (one stream per output channel). The output stream
     * resource will be created by App Platform automatically during deployment
     * and deleted after application un-deployment.
     * Note that this config applies to all the Application Instances.
     * The output stream can be override at instance level by
     * configuring the `output_resources` section of Instance resource.
     * `producer_node` should be current node, `output_resource_binding` should
     * be the output channel name (or leave it blank if there is only 1 output
     * channel of the processor) and `output_resource` should be the target
     * output stream.
     *
     * Generated from protobuf field <code>bool output_all_output_channels_to_stream = 6;</code>
     * @return bool
     */
    public function getOutputAllOutputChannelsToStream()
    {
        return $this->readOneof(6);
    }

    public function hasOutputAllOutputChannelsToStream()
    {
        return $this->hasOneof(6);
    }

    /**
     * By default, the output of the node will only be available to downstream
     * nodes. To consume the direct output from the application node, the output
     * must be sent to Vision AI Streams at first.
     * By setting output_all_output_channels_to_stream to true, App Platform
     * will automatically send all the outputs of the current node to Vision AI
     * Stream resources (one stream per output channel). The output stream
     * resource will be created by App Platform automatically during deployment
     * and deleted after application un-deployment.
     * Note that this config applies to all the Application Instances.
     * The output stream can be override at instance level by
     * configuring the `output_resources` section of Instance resource.
     * `producer_node` should be current node, `output_resource_binding` should
     * be the output channel name (or leave it blank if there is only 1 output
     * channel of the processor) and `output_resource` should be the target
     * output stream.
     *
     * Generated from protobuf field <code>bool output_all_output_channels_to_stream = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setOutputAllOutputChannelsToStream($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Required. A unique name for the node.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. A unique name for the node.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A user friendly display name for the node.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A user friendly display name for the node.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Node config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.ProcessorConfig node_config = 3;</code>
     * @return \Google\Cloud\VisionAI\V1\ProcessorConfig|null
     */
    public function getNodeConfig()
    {
        return $this->node_config;
    }

    public function hasNodeConfig()
    {
        return isset($this->node_config);
    }

    public function clearNodeConfig()
    {
        unset($this->node_config);
    }

    /**
     * Node config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.ProcessorConfig node_config = 3;</code>
     * @param \Google\Cloud\VisionAI\V1\ProcessorConfig $var
     * @return $this
     */
    public function setNodeConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\ProcessorConfig::class);
        $this->node_config = $var;

        return $this;
    }

    /**
     * Processor name refer to the chosen processor resource.
     *
     * Generated from protobuf field <code>string processor = 4;</code>
     * @return string
     */
    public function getProcessor()
    {
        return $this->processor;
    }

    /**
     * Processor name refer to the chosen processor resource.
     *
     * Generated from protobuf field <code>string processor = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setProcessor($var)
    {
        GPBUtil::checkString($var, True);
        $this->processor = $var;

        return $this;
    }

    /**
     * Parent node. Input node should not have parent node. For V1 Alpha1/Beta
     * only media warehouse node can have multiple parents, other types of nodes
     * will only have one parent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Node.InputEdge parents = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getParents()
    {
        return $this->parents;
    }

    /**
     * Parent node. Input node should not have parent node. For V1 Alpha1/Beta
     * only media warehouse node can have multiple parents, other types of nodes
     * will only have one parent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.Node.InputEdge parents = 5;</code>
     * @param array<\Google\Cloud\VisionAI\V1\Node\InputEdge>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setParents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VisionAI\V1\Node\InputEdge::class);
        $this->parents = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getStreamOutputConfig()
    {
        return $this->whichOneof("stream_output_config");
    }

}

