<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/platform.proto

namespace Google\Cloud\VisionAI\V1\Instance;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message of input resource used in one application instance.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.Instance.InputResource</code>
 */
class InputResource extends \Google\Protobuf\Internal\Message
{
    /**
     * Data type for the current input resource.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.DataType data_type = 6;</code>
     */
    protected $data_type = 0;
    /**
     * The name of graph node who receives the input resource.
     * For example:
     * input_resource:
     * visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/input-stream-a
     * consumer_node: stream-input
     *
     * Generated from protobuf field <code>string consumer_node = 2;</code>
     */
    protected $consumer_node = '';
    /**
     * The specific input resource binding which will consume the current Input
     * Resource, can be ignored is there is only 1 input binding.
     *
     * Generated from protobuf field <code>string input_resource_binding = 3;</code>
     */
    protected $input_resource_binding = '';
    /**
     * Contains resource annotations.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.ResourceAnnotations annotations = 5;</code>
     */
    protected $annotations = null;
    protected $input_resource_information;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $input_resource
     *           The direct input resource name.
     *           If the instance type is STREAMING_PREDICTION, the input resource is in
     *           format of
     *           "projects/123/locations/us-central1/clusters/456/streams/stream-a".
     *           If the instance type is BATCH_PREDICTION from Cloud Storage input
     *           container, the input resource is in format of "gs://bucket-a".
     *     @type \Google\Cloud\VisionAI\V1\StreamWithAnnotation $annotated_stream
     *           If the input resource is VisionAI Stream, the associated annotations
     *           can be specified using annotated_stream instead.
     *     @type int $data_type
     *           Data type for the current input resource.
     *     @type string $consumer_node
     *           The name of graph node who receives the input resource.
     *           For example:
     *           input_resource:
     *           visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/input-stream-a
     *           consumer_node: stream-input
     *     @type string $input_resource_binding
     *           The specific input resource binding which will consume the current Input
     *           Resource, can be ignored is there is only 1 input binding.
     *     @type \Google\Cloud\VisionAI\V1\ResourceAnnotations $annotations
     *           Contains resource annotations.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Platform::initOnce();
        parent::__construct($data);
    }

    /**
     * The direct input resource name.
     * If the instance type is STREAMING_PREDICTION, the input resource is in
     * format of
     * "projects/123/locations/us-central1/clusters/456/streams/stream-a".
     * If the instance type is BATCH_PREDICTION from Cloud Storage input
     * container, the input resource is in format of "gs://bucket-a".
     *
     * Generated from protobuf field <code>string input_resource = 1;</code>
     * @return string
     */
    public function getInputResource()
    {
        return $this->readOneof(1);
    }

    public function hasInputResource()
    {
        return $this->hasOneof(1);
    }

    /**
     * The direct input resource name.
     * If the instance type is STREAMING_PREDICTION, the input resource is in
     * format of
     * "projects/123/locations/us-central1/clusters/456/streams/stream-a".
     * If the instance type is BATCH_PREDICTION from Cloud Storage input
     * container, the input resource is in format of "gs://bucket-a".
     *
     * Generated from protobuf field <code>string input_resource = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setInputResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * If the input resource is VisionAI Stream, the associated annotations
     * can be specified using annotated_stream instead.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.StreamWithAnnotation annotated_stream = 4 [deprecated = true];</code>
     * @return \Google\Cloud\VisionAI\V1\StreamWithAnnotation|null
     * @deprecated
     */
    public function getAnnotatedStream()
    {
        if ($this->hasOneof(4)) {
            @trigger_error('annotated_stream is deprecated.', E_USER_DEPRECATED);
        }
        return $this->readOneof(4);
    }

    public function hasAnnotatedStream()
    {
        if ($this->hasOneof(4)) {
            @trigger_error('annotated_stream is deprecated.', E_USER_DEPRECATED);
        }
        return $this->hasOneof(4);
    }

    /**
     * If the input resource is VisionAI Stream, the associated annotations
     * can be specified using annotated_stream instead.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.StreamWithAnnotation annotated_stream = 4 [deprecated = true];</code>
     * @param \Google\Cloud\VisionAI\V1\StreamWithAnnotation $var
     * @return $this
     * @deprecated
     */
    public function setAnnotatedStream($var)
    {
        @trigger_error('annotated_stream is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\StreamWithAnnotation::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Data type for the current input resource.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.DataType data_type = 6;</code>
     * @return int
     */
    public function getDataType()
    {
        return $this->data_type;
    }

    /**
     * Data type for the current input resource.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.DataType data_type = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setDataType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VisionAI\V1\DataType::class);
        $this->data_type = $var;

        return $this;
    }

    /**
     * The name of graph node who receives the input resource.
     * For example:
     * input_resource:
     * visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/input-stream-a
     * consumer_node: stream-input
     *
     * Generated from protobuf field <code>string consumer_node = 2;</code>
     * @return string
     */
    public function getConsumerNode()
    {
        return $this->consumer_node;
    }

    /**
     * The name of graph node who receives the input resource.
     * For example:
     * input_resource:
     * visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/input-stream-a
     * consumer_node: stream-input
     *
     * Generated from protobuf field <code>string consumer_node = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setConsumerNode($var)
    {
        GPBUtil::checkString($var, True);
        $this->consumer_node = $var;

        return $this;
    }

    /**
     * The specific input resource binding which will consume the current Input
     * Resource, can be ignored is there is only 1 input binding.
     *
     * Generated from protobuf field <code>string input_resource_binding = 3;</code>
     * @return string
     */
    public function getInputResourceBinding()
    {
        return $this->input_resource_binding;
    }

    /**
     * The specific input resource binding which will consume the current Input
     * Resource, can be ignored is there is only 1 input binding.
     *
     * Generated from protobuf field <code>string input_resource_binding = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setInputResourceBinding($var)
    {
        GPBUtil::checkString($var, True);
        $this->input_resource_binding = $var;

        return $this;
    }

    /**
     * Contains resource annotations.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.ResourceAnnotations annotations = 5;</code>
     * @return \Google\Cloud\VisionAI\V1\ResourceAnnotations|null
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    public function hasAnnotations()
    {
        return isset($this->annotations);
    }

    public function clearAnnotations()
    {
        unset($this->annotations);
    }

    /**
     * Contains resource annotations.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.ResourceAnnotations annotations = 5;</code>
     * @param \Google\Cloud\VisionAI\V1\ResourceAnnotations $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\ResourceAnnotations::class);
        $this->annotations = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getInputResourceInformation()
    {
        return $this->whichOneof("input_resource_information");
    }

}


