<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/warehouse.proto

namespace Google\Cloud\VisionAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An Index is a resource in Corpus. It contains an indexed version of the
 * assets and annotations. When deployed to an endpoint, it will allow users to
 * search the Index.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.Index</code>
 */
class Index extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Resource name of the Index resource.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Optional. Optional user-specified display name of the index.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Optional. Optional description of the index.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Output only. State of the index.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Index.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The create timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The update timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. References to the deployed index instance.
     * Index of VIDEO_ON_DEMAND corpus can have at most one deployed index.
     * Index of IMAGE corpus can have multiple deployed indexes.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.DeployedIndexReference deployed_indexes = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $deployed_indexes;
    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Separation enabled via an Org Policy constraint. It is set to true
     * when the index is a valid zone separated index and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = null;
    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Isolation enabled via an Org Policy constraint. It is set to true when
     * the index is a valid zone isolated index and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = null;
    protected $asset_filter;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $entire_corpus
     *           Include all assets under the corpus.
     *     @type string $name
     *           Output only. Resource name of the Index resource.
     *           Format:
     *           `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
     *     @type string $display_name
     *           Optional. Optional user-specified display name of the index.
     *     @type string $description
     *           Optional. Optional description of the index.
     *     @type int $state
     *           Output only. State of the index.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The create timestamp.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update timestamp.
     *     @type array<\Google\Cloud\VisionAI\V1\DeployedIndexReference>|\Google\Protobuf\Internal\RepeatedField $deployed_indexes
     *           Output only. References to the deployed index instance.
     *           Index of VIDEO_ON_DEMAND corpus can have at most one deployed index.
     *           Index of IMAGE corpus can have multiple deployed indexes.
     *     @type bool $satisfies_pzs
     *           Output only. This boolean field is only set for projects that have Physical
     *           Zone Separation enabled via an Org Policy constraint. It is set to true
     *           when the index is a valid zone separated index and false if it isn't.
     *     @type bool $satisfies_pzi
     *           Output only. This boolean field is only set for projects that have Physical
     *           Zone Isolation enabled via an Org Policy constraint. It is set to true when
     *           the index is a valid zone isolated index and false if it isn't.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Warehouse::initOnce();
        parent::__construct($data);
    }

    /**
     * Include all assets under the corpus.
     *
     * Generated from protobuf field <code>bool entire_corpus = 9;</code>
     * @return bool
     */
    public function getEntireCorpus()
    {
        return $this->readOneof(9);
    }

    public function hasEntireCorpus()
    {
        return $this->hasOneof(9);
    }

    /**
     * Include all assets under the corpus.
     *
     * Generated from protobuf field <code>bool entire_corpus = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setEntireCorpus($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Output only. Resource name of the Index resource.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Resource name of the Index resource.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. Optional user-specified display name of the index.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. Optional user-specified display name of the index.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. Optional description of the index.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. Optional description of the index.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. State of the index.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Index.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the index.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Index.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VisionAI\V1\Index\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The create timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The create timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. References to the deployed index instance.
     * Index of VIDEO_ON_DEMAND corpus can have at most one deployed index.
     * Index of IMAGE corpus can have multiple deployed indexes.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.DeployedIndexReference deployed_indexes = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDeployedIndexes()
    {
        return $this->deployed_indexes;
    }

    /**
     * Output only. References to the deployed index instance.
     * Index of VIDEO_ON_DEMAND corpus can have at most one deployed index.
     * Index of IMAGE corpus can have multiple deployed indexes.
     *
     * Generated from protobuf field <code>repeated .google.cloud.visionai.v1.DeployedIndexReference deployed_indexes = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\VisionAI\V1\DeployedIndexReference>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDeployedIndexes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VisionAI\V1\DeployedIndexReference::class);
        $this->deployed_indexes = $arr;

        return $this;
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Separation enabled via an Org Policy constraint. It is set to true
     * when the index is a valid zone separated index and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Separation enabled via an Org Policy constraint. It is set to true
     * when the index is a valid zone separated index and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Isolation enabled via an Org Policy constraint. It is set to true when
     * the index is a valid zone isolated index and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return isset($this->satisfies_pzi) ? $this->satisfies_pzi : false;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Isolation enabled via an Org Policy constraint. It is set to true when
     * the index is a valid zone isolated index and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getAssetFilter()
    {
        return $this->whichOneof("asset_filter");
    }

}

