<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/visionai/v1/warehouse.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VisionAI\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\VisionAI\V1\AddCollectionItemRequest;
use Google\Cloud\VisionAI\V1\AddCollectionItemResponse;
use Google\Cloud\VisionAI\V1\AnalyzeAssetRequest;
use Google\Cloud\VisionAI\V1\AnalyzeCorpusRequest;
use Google\Cloud\VisionAI\V1\Annotation;
use Google\Cloud\VisionAI\V1\Asset;
use Google\Cloud\VisionAI\V1\AssetSource;
use Google\Cloud\VisionAI\V1\ClipAssetRequest;
use Google\Cloud\VisionAI\V1\ClipAssetResponse;
use Google\Cloud\VisionAI\V1\Collection;
use Google\Cloud\VisionAI\V1\CollectionItem;
use Google\Cloud\VisionAI\V1\Corpus;
use Google\Cloud\VisionAI\V1\CreateAnnotationRequest;
use Google\Cloud\VisionAI\V1\CreateAssetRequest;
use Google\Cloud\VisionAI\V1\CreateCollectionRequest;
use Google\Cloud\VisionAI\V1\CreateCorpusRequest;
use Google\Cloud\VisionAI\V1\CreateDataSchemaRequest;
use Google\Cloud\VisionAI\V1\CreateIndexEndpointRequest;
use Google\Cloud\VisionAI\V1\CreateIndexRequest;
use Google\Cloud\VisionAI\V1\CreateSearchConfigRequest;
use Google\Cloud\VisionAI\V1\CreateSearchHypernymRequest;
use Google\Cloud\VisionAI\V1\Criteria;
use Google\Cloud\VisionAI\V1\DataSchema;
use Google\Cloud\VisionAI\V1\DateTimeRangeArray;
use Google\Cloud\VisionAI\V1\DeleteAnnotationRequest;
use Google\Cloud\VisionAI\V1\DeleteAssetRequest;
use Google\Cloud\VisionAI\V1\DeleteCollectionRequest;
use Google\Cloud\VisionAI\V1\DeleteCorpusRequest;
use Google\Cloud\VisionAI\V1\DeleteDataSchemaRequest;
use Google\Cloud\VisionAI\V1\DeleteIndexEndpointRequest;
use Google\Cloud\VisionAI\V1\DeleteIndexRequest;
use Google\Cloud\VisionAI\V1\DeleteSearchConfigRequest;
use Google\Cloud\VisionAI\V1\DeleteSearchHypernymRequest;
use Google\Cloud\VisionAI\V1\DeployIndexRequest;
use Google\Cloud\VisionAI\V1\DeployedIndex;
use Google\Cloud\VisionAI\V1\FacetGroup;
use Google\Cloud\VisionAI\V1\GenerateHlsUriRequest;
use Google\Cloud\VisionAI\V1\GenerateHlsUriResponse;
use Google\Cloud\VisionAI\V1\GenerateRetrievalUrlRequest;
use Google\Cloud\VisionAI\V1\GenerateRetrievalUrlResponse;
use Google\Cloud\VisionAI\V1\GetAnnotationRequest;
use Google\Cloud\VisionAI\V1\GetAssetRequest;
use Google\Cloud\VisionAI\V1\GetCollectionRequest;
use Google\Cloud\VisionAI\V1\GetCorpusRequest;
use Google\Cloud\VisionAI\V1\GetDataSchemaRequest;
use Google\Cloud\VisionAI\V1\GetIndexEndpointRequest;
use Google\Cloud\VisionAI\V1\GetIndexRequest;
use Google\Cloud\VisionAI\V1\GetSearchConfigRequest;
use Google\Cloud\VisionAI\V1\GetSearchHypernymRequest;
use Google\Cloud\VisionAI\V1\ImageQuery;
use Google\Cloud\VisionAI\V1\ImportAssetsRequest;
use Google\Cloud\VisionAI\V1\Index;
use Google\Cloud\VisionAI\V1\IndexAssetRequest;
use Google\Cloud\VisionAI\V1\IndexEndpoint;
use Google\Cloud\VisionAI\V1\IngestAssetRequest;
use Google\Cloud\VisionAI\V1\IngestAssetResponse;
use Google\Cloud\VisionAI\V1\ListAnnotationsRequest;
use Google\Cloud\VisionAI\V1\ListAnnotationsResponse;
use Google\Cloud\VisionAI\V1\ListAssetsRequest;
use Google\Cloud\VisionAI\V1\ListAssetsResponse;
use Google\Cloud\VisionAI\V1\ListCollectionsRequest;
use Google\Cloud\VisionAI\V1\ListCollectionsResponse;
use Google\Cloud\VisionAI\V1\ListCorporaRequest;
use Google\Cloud\VisionAI\V1\ListCorporaResponse;
use Google\Cloud\VisionAI\V1\ListDataSchemasRequest;
use Google\Cloud\VisionAI\V1\ListDataSchemasResponse;
use Google\Cloud\VisionAI\V1\ListIndexEndpointsRequest;
use Google\Cloud\VisionAI\V1\ListIndexEndpointsResponse;
use Google\Cloud\VisionAI\V1\ListIndexesRequest;
use Google\Cloud\VisionAI\V1\ListIndexesResponse;
use Google\Cloud\VisionAI\V1\ListSearchConfigsRequest;
use Google\Cloud\VisionAI\V1\ListSearchConfigsResponse;
use Google\Cloud\VisionAI\V1\ListSearchHypernymsRequest;
use Google\Cloud\VisionAI\V1\ListSearchHypernymsResponse;
use Google\Cloud\VisionAI\V1\Partition\TemporalPartition;
use Google\Cloud\VisionAI\V1\RemoveCollectionItemRequest;
use Google\Cloud\VisionAI\V1\RemoveCollectionItemResponse;
use Google\Cloud\VisionAI\V1\RemoveIndexAssetRequest;
use Google\Cloud\VisionAI\V1\SchemaKeySortingStrategy;
use Google\Cloud\VisionAI\V1\SearchAssetsRequest;
use Google\Cloud\VisionAI\V1\SearchAssetsResponse;
use Google\Cloud\VisionAI\V1\SearchConfig;
use Google\Cloud\VisionAI\V1\SearchHypernym;
use Google\Cloud\VisionAI\V1\SearchIndexEndpointRequest;
use Google\Cloud\VisionAI\V1\SearchIndexEndpointResponse;
use Google\Cloud\VisionAI\V1\UndeployIndexRequest;
use Google\Cloud\VisionAI\V1\UpdateAnnotationRequest;
use Google\Cloud\VisionAI\V1\UpdateAssetRequest;
use Google\Cloud\VisionAI\V1\UpdateCollectionRequest;
use Google\Cloud\VisionAI\V1\UpdateCorpusRequest;
use Google\Cloud\VisionAI\V1\UpdateDataSchemaRequest;
use Google\Cloud\VisionAI\V1\UpdateIndexEndpointRequest;
use Google\Cloud\VisionAI\V1\UpdateIndexRequest;
use Google\Cloud\VisionAI\V1\UpdateSearchConfigRequest;
use Google\Cloud\VisionAI\V1\UpdateSearchHypernymRequest;
use Google\Cloud\VisionAI\V1\UploadAssetRequest;
use Google\Cloud\VisionAI\V1\ViewCollectionItemsRequest;
use Google\Cloud\VisionAI\V1\ViewCollectionItemsResponse;
use Google\Cloud\VisionAI\V1\ViewIndexedAssetsRequest;
use Google\Cloud\VisionAI\V1\ViewIndexedAssetsResponse;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Service that manages media content + metadata for streaming.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $warehouseClient = new WarehouseClient();
 * try {
 *     $item = new CollectionItem();
 *     $response = $warehouseClient->addCollectionItem($item);
 * } finally {
 *     $warehouseClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated This class will be removed in the next major version update.
 */
class WarehouseGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.visionai.v1.Warehouse';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'warehouse-visionai.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'warehouse-visionai.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $annotationNameTemplate;

    private static $assetNameTemplate;

    private static $collectionNameTemplate;

    private static $corpusNameTemplate;

    private static $dataSchemaNameTemplate;

    private static $indexNameTemplate;

    private static $indexEndpointNameTemplate;

    private static $locationNameTemplate;

    private static $searchConfigNameTemplate;

    private static $searchHypernymNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/warehouse_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/warehouse_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/warehouse_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/warehouse_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAnnotationNameTemplate()
    {
        if (self::$annotationNameTemplate == null) {
            self::$annotationNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}');
        }

        return self::$annotationNameTemplate;
    }

    private static function getAssetNameTemplate()
    {
        if (self::$assetNameTemplate == null) {
            self::$assetNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}');
        }

        return self::$assetNameTemplate;
    }

    private static function getCollectionNameTemplate()
    {
        if (self::$collectionNameTemplate == null) {
            self::$collectionNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}');
        }

        return self::$collectionNameTemplate;
    }

    private static function getCorpusNameTemplate()
    {
        if (self::$corpusNameTemplate == null) {
            self::$corpusNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}');
        }

        return self::$corpusNameTemplate;
    }

    private static function getDataSchemaNameTemplate()
    {
        if (self::$dataSchemaNameTemplate == null) {
            self::$dataSchemaNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}');
        }

        return self::$dataSchemaNameTemplate;
    }

    private static function getIndexNameTemplate()
    {
        if (self::$indexNameTemplate == null) {
            self::$indexNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}');
        }

        return self::$indexNameTemplate;
    }

    private static function getIndexEndpointNameTemplate()
    {
        if (self::$indexEndpointNameTemplate == null) {
            self::$indexEndpointNameTemplate = new PathTemplate('projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}');
        }

        return self::$indexEndpointNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getSearchConfigNameTemplate()
    {
        if (self::$searchConfigNameTemplate == null) {
            self::$searchConfigNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}');
        }

        return self::$searchConfigNameTemplate;
    }

    private static function getSearchHypernymNameTemplate()
    {
        if (self::$searchHypernymNameTemplate == null) {
            self::$searchHypernymNameTemplate = new PathTemplate('projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}');
        }

        return self::$searchHypernymNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'annotation' => self::getAnnotationNameTemplate(),
                'asset' => self::getAssetNameTemplate(),
                'collection' => self::getCollectionNameTemplate(),
                'corpus' => self::getCorpusNameTemplate(),
                'dataSchema' => self::getDataSchemaNameTemplate(),
                'index' => self::getIndexNameTemplate(),
                'indexEndpoint' => self::getIndexEndpointNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'searchConfig' => self::getSearchConfigNameTemplate(),
                'searchHypernym' => self::getSearchHypernymNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a annotation
     * resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     * @param string $asset
     * @param string $annotation
     *
     * @return string The formatted annotation resource.
     */
    public static function annotationName($projectNumber, $location, $corpus, $asset, $annotation)
    {
        return self::getAnnotationNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
            'asset' => $asset,
            'annotation' => $annotation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a asset
     * resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     * @param string $asset
     *
     * @return string The formatted asset resource.
     */
    public static function assetName($projectNumber, $location, $corpus, $asset)
    {
        return self::getAssetNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a collection
     * resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     * @param string $collection
     *
     * @return string The formatted collection resource.
     */
    public static function collectionName($projectNumber, $location, $corpus, $collection)
    {
        return self::getCollectionNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
            'collection' => $collection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a corpus
     * resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     *
     * @return string The formatted corpus resource.
     */
    public static function corpusName($projectNumber, $location, $corpus)
    {
        return self::getCorpusNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_schema
     * resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     * @param string $dataSchema
     *
     * @return string The formatted data_schema resource.
     */
    public static function dataSchemaName($projectNumber, $location, $corpus, $dataSchema)
    {
        return self::getDataSchemaNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
            'data_schema' => $dataSchema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a index
     * resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     * @param string $index
     *
     * @return string The formatted index resource.
     */
    public static function indexName($projectNumber, $location, $corpus, $index)
    {
        return self::getIndexNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
            'index' => $index,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * index_endpoint resource.
     *
     * @param string $project
     * @param string $location
     * @param string $indexEndpoint
     *
     * @return string The formatted index_endpoint resource.
     */
    public static function indexEndpointName($project, $location, $indexEndpoint)
    {
        return self::getIndexEndpointNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'index_endpoint' => $indexEndpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * search_config resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     * @param string $searchConfig
     *
     * @return string The formatted search_config resource.
     */
    public static function searchConfigName($projectNumber, $location, $corpus, $searchConfig)
    {
        return self::getSearchConfigNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
            'search_config' => $searchConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * search_hypernym resource.
     *
     * @param string $projectNumber
     * @param string $location
     * @param string $corpus
     * @param string $searchHypernym
     *
     * @return string The formatted search_hypernym resource.
     */
    public static function searchHypernymName($projectNumber, $location, $corpus, $searchHypernym)
    {
        return self::getSearchHypernymNameTemplate()->render([
            'project_number' => $projectNumber,
            'location' => $location,
            'corpus' => $corpus,
            'search_hypernym' => $searchHypernym,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - annotation: projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}
     * - asset: projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}
     * - collection: projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}
     * - corpus: projects/{project_number}/locations/{location}/corpora/{corpus}
     * - dataSchema: projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}
     * - index: projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}
     * - indexEndpoint: projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}
     * - location: projects/{project}/locations/{location}
     * - searchConfig: projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}
     * - searchHypernym: projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'warehouse-visionai.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Adds an item into a Collection.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $item = new CollectionItem();
     *     $response = $warehouseClient->addCollectionItem($item);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param CollectionItem $item         Required. The item to be added.
     * @param array          $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\AddCollectionItemResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addCollectionItem($item, array $optionalArgs = [])
    {
        $request = new AddCollectionItemRequest();
        $requestParamHeaders = [];
        $request->setItem($item);
        $requestParamHeaders['item.collection'] = $item->getCollection();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('AddCollectionItem', AddCollectionItemResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Analyze asset to power search capability.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $operationResponse = $warehouseClient->analyzeAsset($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->analyzeAsset($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'analyzeAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset to analyze.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeAsset($name, array $optionalArgs = [])
    {
        $request = new AnalyzeAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('AnalyzeAsset', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Analyzes a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $operationResponse = $warehouseClient->analyzeCorpus($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->analyzeCorpus($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'analyzeCorpus');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The parent corpus resource where the assets will be analyzed.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeCorpus($name, array $optionalArgs = [])
    {
        $request = new AnalyzeCorpusRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('AnalyzeCorpus', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Supported by STREAM_VIDEO corpus type.
     * Generates clips for downloading. The api takes in a time range, and
     * generates a clip of the first content available after start_time and
     * before end_time, which may overflow beyond these bounds.
     * Returned clips are truncated if the total size of the clips are larger
     * than 100MB.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $temporalPartition = new TemporalPartition();
     *     $response = $warehouseClient->clipAsset($formattedName, $temporalPartition);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string            $name              Required. The resource name of the asset to request clips for.
     *                                             Format:
     *                                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param TemporalPartition $temporalPartition Required. The time range to request clips for.
     * @param array             $optionalArgs      {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\ClipAssetResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function clipAsset($name, $temporalPartition, array $optionalArgs = [])
    {
        $request = new ClipAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setTemporalPartition($temporalPartition);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ClipAsset', ClipAssetResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates annotation inside asset.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $annotation = new Annotation();
     *     $response = $warehouseClient->createAnnotation($formattedParent, $annotation);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent resource where this annotation will be created.
     *                                 Format:
     *                                 `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param Annotation $annotation   Required. The annotation to create.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $annotationId
     *           Optional. The ID to use for the annotation, which will become the final
     *           component of the annotation's resource name if user choose to specify.
     *           Otherwise, annotation id will be generated by system.
     *
     *           This value should be up to 63 characters, and valid characters
     *           are /[a-z][0-9]-/. The first character must be a letter, the last could be
     *           a letter or a number.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Annotation
     *
     * @throws ApiException if the remote call fails
     */
    public function createAnnotation($parent, $annotation, array $optionalArgs = [])
    {
        $request = new CreateAnnotationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAnnotation($annotation);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['annotationId'])) {
            $request->setAnnotationId($optionalArgs['annotationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateAnnotation', Annotation::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an asset inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $asset = new Asset();
     *     $response = $warehouseClient->createAsset($formattedParent, $asset);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource where this asset will be created.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     * @param Asset  $asset        Required. The asset to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $assetId
     *           Optional. The ID to use for the asset, which will become the final
     *           component of the asset's resource name if user choose to specify.
     *           Otherwise, asset id will be generated by system.
     *
     *           This value should be up to 63 characters, and valid characters
     *           are /[a-z][0-9]-/. The first character must be a letter, the last could be
     *           a letter or a number.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Asset
     *
     * @throws ApiException if the remote call fails
     */
    public function createAsset($parent, $asset, array $optionalArgs = [])
    {
        $request = new CreateAssetRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAsset($asset);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['assetId'])) {
            $request->setAssetId($optionalArgs['assetId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateAsset', Asset::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a collection.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $collection = new Collection();
     *     $operationResponse = $warehouseClient->createCollection($formattedParent, $collection);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->createCollection($formattedParent, $collection);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'createCollection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent resource where this collection will be created.
     *                                 Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
     * @param Collection $collection   Required. The collection resource to be created.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $collectionId
     *           Optional. The ID to use for the collection, which will become the final
     *           component of the resource name if user choose to specify. Otherwise,
     *           collection id will be generated by system.
     *
     *           This value should be up to 55 characters, and valid characters
     *           are /[a-z][0-9]-/. The first character must be a letter, the last could be
     *           a letter or a number.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCollection($parent, $collection, array $optionalArgs = [])
    {
        $request = new CreateCollectionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCollection($collection);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['collectionId'])) {
            $request->setCollectionId($optionalArgs['collectionId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateCollection', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a corpus inside a project.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $parent = 'parent';
     *     $corpus = new Corpus();
     *     $operationResponse = $warehouseClient->createCorpus($parent, $corpus);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->createCorpus($parent, $corpus);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'createCorpus');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Form: `projects/{project_number}/locations/{location_id}`
     * @param Corpus $corpus       Required. The corpus to be created.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCorpus($parent, $corpus, array $optionalArgs = [])
    {
        $request = new CreateCorpusRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCorpus($corpus);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateCorpus', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates data schema inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $dataSchema = new DataSchema();
     *     $response = $warehouseClient->createDataSchema($formattedParent, $dataSchema);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent resource where this data schema will be created.
     *                                 Format:
     *                                 `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     * @param DataSchema $dataSchema   Required. The data schema to create.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\DataSchema
     *
     * @throws ApiException if the remote call fails
     */
    public function createDataSchema($parent, $dataSchema, array $optionalArgs = [])
    {
        $request = new CreateDataSchemaRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDataSchema($dataSchema);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateDataSchema', DataSchema::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an Index under the corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $index = new Index();
     *     $operationResponse = $warehouseClient->createIndex($formattedParent, $index);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->createIndex($formattedParent, $index);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'createIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Value for the parent. The resource name of the Corpus under which
     *                             this index is created. Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     * @param Index  $index        Required. The index being created.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $indexId
     *           Optional. The ID for the index. This will become the final resource name
     *           for the index. If the user does not specify this value, it will be
     *           generated by system.
     *
     *           This value should be up to 63 characters, and valid characters
     *           are /[a-z][0-9]-/. The first character must be a letter, the last could be
     *           a letter or a number.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createIndex($parent, $index, array $optionalArgs = [])
    {
        $request = new CreateIndexRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setIndex($index);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['indexId'])) {
            $request->setIndexId($optionalArgs['indexId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateIndex', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->locationName('[PROJECT]', '[LOCATION]');
     *     $indexEndpoint = new IndexEndpoint();
     *     $operationResponse = $warehouseClient->createIndexEndpoint($formattedParent, $indexEndpoint);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->createIndexEndpoint($formattedParent, $indexEndpoint);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'createIndexEndpoint');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string        $parent        Required. Format: `projects/{project}/locations/{location}`
     * @param IndexEndpoint $indexEndpoint Required. The resource being created.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type string $indexEndpointId
     *           Optional. The ID to use for the IndexEndpoint, which will become the final
     *           component of the IndexEndpoint's resource name if the user specifies it.
     *           Otherwise, IndexEndpoint id will be autogenerated.
     *
     *           This value should be up to 63 characters, and valid characters
     *           are a-z, 0-9 and dash (-). The first character must be a letter, the last
     *           must be a letter or a number.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createIndexEndpoint($parent, $indexEndpoint, array $optionalArgs = [])
    {
        $request = new CreateIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setIndexEndpoint($indexEndpoint);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['indexEndpointId'])) {
            $request->setIndexEndpointId($optionalArgs['indexEndpointId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateIndexEndpoint', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a search configuration inside a corpus.
     *
     * Please follow the rules below to create a valid CreateSearchConfigRequest.
     * --- General Rules ---
     * 1. Request.search_config_id must not be associated with an existing
     * SearchConfig.
     * 2. Request must contain at least one non-empty search_criteria_property or
     * facet_property.
     * 3. mapped_fields must not be empty, and must map to existing UGA keys.
     * 4. All mapped_fields must be of the same type.
     * 5. All mapped_fields must share the same granularity.
     * 6. All mapped_fields must share the same semantic SearchConfig match
     * options.
     * For property-specific rules, please reference the comments for
     * FacetProperty and SearchCriteriaProperty.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $searchConfig = new SearchConfig();
     *     $searchConfigId = 'search_config_id';
     *     $response = $warehouseClient->createSearchConfig($formattedParent, $searchConfig, $searchConfigId);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The parent resource where this search configuration will be
     *                                     created. Format:
     *                                     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     * @param SearchConfig $searchConfig   Required. The search config to create.
     * @param string       $searchConfigId Required. ID to use for the new search config. Will become the final
     *                                     component of the SearchConfig's resource name. This value should be up to
     *                                     63 characters, and valid characters are /[a-z][0-9]-_/. The first character
     *                                     must be a letter, the last could be a letter or a number.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\SearchConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createSearchConfig($parent, $searchConfig, $searchConfigId, array $optionalArgs = [])
    {
        $request = new CreateSearchConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSearchConfig($searchConfig);
        $request->setSearchConfigId($searchConfigId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSearchConfig', SearchConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a SearchHypernym inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $searchHypernym = new SearchHypernym();
     *     $response = $warehouseClient->createSearchHypernym($formattedParent, $searchHypernym);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string         $parent         Required. The parent resource where this SearchHypernym will be created.
     *                                       Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
     * @param SearchHypernym $searchHypernym Required. The SearchHypernym to create.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type string $searchHypernymId
     *           Optional. The search hypernym id.
     *           If omitted, a random UUID will be generated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\SearchHypernym
     *
     * @throws ApiException if the remote call fails
     */
    public function createSearchHypernym($parent, $searchHypernym, array $optionalArgs = [])
    {
        $request = new CreateSearchHypernymRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSearchHypernym($searchHypernym);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['searchHypernymId'])) {
            $request->setSearchHypernymId($optionalArgs['searchHypernymId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSearchHypernym', SearchHypernym::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes annotation inside asset.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->annotationName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]', '[ANNOTATION]');
     *     $warehouseClient->deleteAnnotation($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the annotation to delete.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAnnotation($name, array $optionalArgs = [])
    {
        $request = new DeleteAnnotationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteAnnotation', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes asset inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $operationResponse = $warehouseClient->deleteAsset($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->deleteAsset($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'deleteAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the asset to delete.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAsset($name, array $optionalArgs = [])
    {
        $request = new DeleteAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteAsset', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a collection.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->collectionName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[COLLECTION]');
     *     $operationResponse = $warehouseClient->deleteCollection($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->deleteCollection($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'deleteCollection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the collection to delete. Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCollection($name, array $optionalArgs = [])
    {
        $request = new DeleteCollectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteCollection', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a corpus only if its empty.
     * Returns empty response.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $warehouseClient->deleteCorpus($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the corpus to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCorpus($name, array $optionalArgs = [])
    {
        $request = new DeleteCorpusRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteCorpus', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes data schema inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->dataSchemaName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[DATA_SCHEMA]');
     *     $warehouseClient->deleteDataSchema($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the data schema to delete.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDataSchema($name, array $optionalArgs = [])
    {
        $request = new DeleteDataSchemaRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteDataSchema', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Delete a single Index. In order to delete an index, the caller must
     * make sure that it is not deployed to any index endpoint.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->indexName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[INDEX]');
     *     $operationResponse = $warehouseClient->deleteIndex($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->deleteIndex($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'deleteIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the index to delete.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteIndex($name, array $optionalArgs = [])
    {
        $request = new DeleteIndexRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteIndex', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $operationResponse = $warehouseClient->deleteIndexEndpoint($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->deleteIndexEndpoint($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'deleteIndexEndpoint');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteIndexEndpoint($name, array $optionalArgs = [])
    {
        $request = new DeleteIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteIndexEndpoint', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a search configuration inside a corpus.
     *
     * For a DeleteSearchConfigRequest to be valid,
     * Request.search_configuration.name must already exist.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->searchConfigName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[SEARCH_CONFIG]');
     *     $warehouseClient->deleteSearchConfig($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the search configuration to delete.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSearchConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteSearchConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSearchConfig', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a SearchHypernym inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->searchHypernymName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[SEARCH_HYPERNYM]');
     *     $warehouseClient->deleteSearchHypernym($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the SearchHypernym to delete.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSearchHypernym($name, array $optionalArgs = [])
    {
        $request = new DeleteSearchHypernymRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSearchHypernym', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deploys an Index to IndexEndpoint.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedIndexEndpoint = $warehouseClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $deployedIndex = new DeployedIndex();
     *     $operationResponse = $warehouseClient->deployIndex($formattedIndexEndpoint, $deployedIndex);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->deployIndex($formattedIndexEndpoint, $deployedIndex);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'deployIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string        $indexEndpoint Required. IndexEndpoint the index is deployed to.
     *                                     Format:
     *                                     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * @param DeployedIndex $deployedIndex Required. Index to deploy.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployIndex($indexEndpoint, $deployedIndex, array $optionalArgs = [])
    {
        $request = new DeployIndexRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $request->setDeployedIndex($deployedIndex);
        $requestParamHeaders['index_endpoint'] = $indexEndpoint;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeployIndex', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Generates a uri for an HLS manifest. The api takes in a collection of time
     * ranges, and generates a URI for an HLS manifest that covers all the
     * requested time ranges.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $response = $warehouseClient->generateHlsUri($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset to request clips for.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type TemporalPartition[] $temporalPartitions
     *           The time range to request clips for. Will be ignored if `get_live_view` is
     *           set to True. The total time range requested should be smaller than 24h.
     *     @type bool $liveViewEnabled
     *           Option to exclusively show a livestream of the asset with up to 3 minutes
     *           of backlog data.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\GenerateHlsUriResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateHlsUri($name, array $optionalArgs = [])
    {
        $request = new GenerateHlsUriRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['temporalPartitions'])) {
            $request->setTemporalPartitions($optionalArgs['temporalPartitions']);
        }

        if (isset($optionalArgs['liveViewEnabled'])) {
            $request->setLiveViewEnabled($optionalArgs['liveViewEnabled']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateHlsUri', GenerateHlsUriResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Generates a signed url for downloading the asset.
     * For video warehouse, please see comment of UploadAsset about how to allow
     * retrieval of cloud storage files in a different project.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $response = $warehouseClient->generateRetrievalUrl($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset to request signed url for.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\GenerateRetrievalUrlResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateRetrievalUrl($name, array $optionalArgs = [])
    {
        $request = new GenerateRetrievalUrlRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateRetrievalUrl', GenerateRetrievalUrlResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Reads annotation inside asset.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->annotationName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]', '[ANNOTATION]');
     *     $response = $warehouseClient->getAnnotation($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the annotation to retrieve.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Annotation
     *
     * @throws ApiException if the remote call fails
     */
    public function getAnnotation($name, array $optionalArgs = [])
    {
        $request = new GetAnnotationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAnnotation', Annotation::class, $optionalArgs, $request)->wait();
    }

    /**
     * Reads an asset inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $response = $warehouseClient->getAsset($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the asset to retrieve.
     *                             Format:
     *                             projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Asset
     *
     * @throws ApiException if the remote call fails
     */
    public function getAsset($name, array $optionalArgs = [])
    {
        $request = new GetAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAsset', Asset::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a collection.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->collectionName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[COLLECTION]');
     *     $response = $warehouseClient->getCollection($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the collection to retrieve. Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Collection
     *
     * @throws ApiException if the remote call fails
     */
    public function getCollection($name, array $optionalArgs = [])
    {
        $request = new GetCollectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCollection', Collection::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets corpus details inside a project.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $response = $warehouseClient->getCorpus($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the corpus to retrieve.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Corpus
     *
     * @throws ApiException if the remote call fails
     */
    public function getCorpus($name, array $optionalArgs = [])
    {
        $request = new GetCorpusRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCorpus', Corpus::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets data schema inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->dataSchemaName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[DATA_SCHEMA]');
     *     $response = $warehouseClient->getDataSchema($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the data schema to retrieve.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\DataSchema
     *
     * @throws ApiException if the remote call fails
     */
    public function getDataSchema($name, array $optionalArgs = [])
    {
        $request = new GetDataSchemaRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDataSchema', DataSchema::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the details of a single Index under a Corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->indexName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[INDEX]');
     *     $response = $warehouseClient->getIndex($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the Index resource.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Index
     *
     * @throws ApiException if the remote call fails
     */
    public function getIndex($name, array $optionalArgs = [])
    {
        $request = new GetIndexRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIndex', Index::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $response = $warehouseClient->getIndexEndpoint($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the IndexEndpoint resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\IndexEndpoint
     *
     * @throws ApiException if the remote call fails
     */
    public function getIndexEndpoint($name, array $optionalArgs = [])
    {
        $request = new GetIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIndexEndpoint', IndexEndpoint::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a search configuration inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->searchConfigName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[SEARCH_CONFIG]');
     *     $response = $warehouseClient->getSearchConfig($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the search configuration to retrieve.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\SearchConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getSearchConfig($name, array $optionalArgs = [])
    {
        $request = new GetSearchConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSearchConfig', SearchConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a SearchHypernym inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->searchHypernymName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[SEARCH_HYPERNYM]');
     *     $response = $warehouseClient->getSearchHypernym($formattedName);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the SearchHypernym to retrieve.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\SearchHypernym
     *
     * @throws ApiException if the remote call fails
     */
    public function getSearchHypernym($name, array $optionalArgs = [])
    {
        $request = new GetSearchHypernymRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSearchHypernym', SearchHypernym::class, $optionalArgs, $request)->wait();
    }

    /**
     * Imports assets (images plus annotations) from a meta file on cloud storage.
     * Each row in the meta file is corresponding to an image (specified by a
     * cloud storage uri) and its annotations.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     $operationResponse = $warehouseClient->importAssets($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->importAssets($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'importAssets');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent corpus resource where the assets will be imported.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $assetsGcsUri
     *           The file contains all assets information to be imported.
     *           * The file is in JSONL format.
     *           * Each line corresponding to one asset.
     *           * Each line will be converted into InputImageAsset proto.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function importAssets($parent, array $optionalArgs = [])
    {
        $request = new ImportAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['assetsGcsUri'])) {
            $request->setAssetsGcsUri($optionalArgs['assetsGcsUri']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ImportAssets', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Index one asset for search.
     * Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $operationResponse = $warehouseClient->indexAsset($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->indexAsset($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'indexAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset to index.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $index
     *           Optional. The name of the index.
     *           Format:
     *           `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function indexAsset($name, array $optionalArgs = [])
    {
        $request = new IndexAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['index'])) {
            $request->setIndex($optionalArgs['index']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('IndexAsset', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Ingests data for the asset. It is not allowed to ingest a data chunk which
     * is already expired according to TTL.
     * This method is only available via the gRPC API (not HTTP since
     * bi-directional streaming is not supported via HTTP).
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $request = new IngestAssetRequest();
     *     // Write all requests to the server, then read all responses until the
     *     // stream is complete
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $warehouseClient->ingestAsset();
     *     $stream->writeAll($requests);
     *     foreach ($stream->closeWriteAndReadAll() as $element) {
     *         // doSomethingWith($element);
     *     }
     *     // Alternatively:
     *     // Write requests individually, making read() calls if
     *     // required. Call closeWrite() once writes are complete, and read the
     *     // remaining responses from the server.
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $warehouseClient->ingestAsset();
     *     foreach ($requests as $request) {
     *         $stream->write($request);
     *         // if required, read a single response from the stream
     *         $element = $stream->read();
     *         // doSomethingWith($element)
     *     }
     *     $stream->closeWrite();
     *     $element = $stream->read();
     *     while (!is_null($element)) {
     *         // doSomethingWith($element)
     *         $element = $stream->read();
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return \Google\ApiCore\BidiStream
     *
     * @throws ApiException if the remote call fails
     */
    public function ingestAsset(array $optionalArgs = [])
    {
        return $this->startCall('IngestAsset', IngestAssetResponse::class, $optionalArgs, null, Call::BIDI_STREAMING_CALL);
    }

    /**
     * Lists a list of annotations inside asset.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listAnnotations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listAnnotations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $parent
     *           The parent, which owns this collection of annotations.
     *           Format:
     *           `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter applied to the returned list.
     *           We only support filtering for the following fields:
     *           For corpus of STREAM_VIDEO type:
     *           `partition.temporal_partition.start_time`,
     *           `partition.temporal_partition.end_time`, and `key`.
     *           For corpus of VIDEO_ON_DEMAND type,
     *           `partition.relative_temporal_partition.start_offset`,
     *           `partition.relative_temporal_partition.end_offset`, and `key`.
     *           For corpus of IMAGE type, only `key` is supported.
     *           Timestamps are specified in the RFC-3339 format, and only one restriction
     *           may be applied per field, joined by conjunctions.
     *           Format:
     *           "partition.temporal_partition.start_time > "2012-04-21T11:30:00-04:00" AND
     *           partition.temporal_partition.end_time < "2012-04-22T11:30:00-04:00" AND
     *           key = "example_key""
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAnnotations(array $optionalArgs = [])
    {
        $request = new ListAnnotationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAnnotations', $optionalArgs, ListAnnotationsResponse::class, $request);
    }

    /**
     * Lists an list of assets inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of assets.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter applied to the returned list.
     *           Only the following filterings are supported:
     *           "assets_with_contents = true", which returns assets with contents uploaded;
     *           "assets_with_contents = false", which returns assets without contents.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAssets($parent, array $optionalArgs = [])
    {
        $request = new ListAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAssets', $optionalArgs, ListAssetsResponse::class, $request);
    }

    /**
     * Lists collections inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listCollections($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listCollections($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent corpus. Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCollections($parent, array $optionalArgs = [])
    {
        $request = new ListCollectionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListCollections', $optionalArgs, ListCollectionsResponse::class, $request);
    }

    /**
     * Lists all corpora in a project.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listCorpora($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listCorpora($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the project from which to list corpora.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter applied to the returned corpora list.
     *           Only the following restrictions are supported:
     *           `type=<Corpus.Type>`,
     *           `type!=<Corpus.Type>`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCorpora($parent, array $optionalArgs = [])
    {
        $request = new ListCorporaRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListCorpora', $optionalArgs, ListCorporaResponse::class, $request);
    }

    /**
     * Lists a list of data schemas inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listDataSchemas($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listDataSchemas($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of data schemas.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDataSchemas($parent, array $optionalArgs = [])
    {
        $request = new ListDataSchemasRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDataSchemas', $optionalArgs, ListDataSchemasResponse::class, $request);
    }

    /**
     * Lists all IndexEndpoints in a project.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listIndexEndpoints($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listIndexEndpoints($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. The filter applied to the returned list.
     *           We only support filtering for the `deployed_image_index.image_index` field.
     *           However, to filter by a corpus instead of an image index, simply use
     *           `deployed_image_index.corpus`, which will return all endpoints with
     *           `deployed_image_index.image_index` inside of the given corpus.
     *           A basic filter on image index would look like:
     *           deployed_image_index.image_index =
     *           "projects/123/locations/us-central1/corpora/my_corpus/imageIndexes/my_image_index"
     *           A basic filter on corpus would look like:
     *           deployed_image_index.corpus =
     *           "projects/123/locations/us-central1/corpora/my_corpus"
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listIndexEndpoints($parent, array $optionalArgs = [])
    {
        $request = new ListIndexEndpointsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListIndexEndpoints', $optionalArgs, ListIndexEndpointsResponse::class, $request);
    }

    /**
     * List all Indexes in a given Corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listIndexes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listIndexes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent corpus that owns this collection of indexes.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listIndexes($parent, array $optionalArgs = [])
    {
        $request = new ListIndexesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListIndexes', $optionalArgs, ListIndexesResponse::class, $request);
    }

    /**
     * Lists all search configurations inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listSearchConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listSearchConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of search configurations.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSearchConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListSearchConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSearchConfigs', $optionalArgs, ListSearchConfigsResponse::class, $request);
    }

    /**
     * Lists SearchHypernyms inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedParent = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listSearchHypernyms($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listSearchHypernyms($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of SearchHypernyms.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSearchHypernyms($parent, array $optionalArgs = [])
    {
        $request = new ListSearchHypernymsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSearchHypernyms', $optionalArgs, ListSearchHypernymsResponse::class, $request);
    }

    /**
     * Removes an item from a collection.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $item = new CollectionItem();
     *     $response = $warehouseClient->removeCollectionItem($item);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param CollectionItem $item         Required. The item to be removed.
     * @param array          $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\RemoveCollectionItemResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function removeCollectionItem($item, array $optionalArgs = [])
    {
        $request = new RemoveCollectionItemRequest();
        $requestParamHeaders = [];
        $request->setItem($item);
        $requestParamHeaders['item.collection'] = $item->getCollection();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('RemoveCollectionItem', RemoveCollectionItemResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Remove one asset's index data for search.
     * Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $operationResponse = $warehouseClient->removeIndexAsset($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->removeIndexAsset($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'removeIndexAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset to index.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $index
     *           Optional. The name of the index.
     *           Format:
     *           `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function removeIndexAsset($name, array $optionalArgs = [])
    {
        $request = new RemoveIndexAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['index'])) {
            $request->setIndex($optionalArgs['index']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RemoveIndexAsset', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Search media asset.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedCorpus = $warehouseClient->corpusName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->searchAssets($formattedCorpus);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->searchAssets($formattedCorpus);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $corpus       Required. The parent corpus to search.
     *                             Format: `projects/{project_id}/locations/{location_id}/corpora/{corpus_id}'
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type SchemaKeySortingStrategy $schemaKeySortingStrategy
     *           Sort by the value under the data schema key.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type DateTimeRangeArray $contentTimeRanges
     *           Time ranges that matching video content must fall within. If no ranges are
     *           provided, there will be no time restriction. This field is treated just
     *           like the criteria below, but defined separately for convenience as it is
     *           used frequently. Note that if the end_time is in the future, it will be
     *           clamped to the time the request was received.
     *     @type Criteria[] $criteria
     *           Criteria applied to search results.
     *     @type FacetGroup[] $facetSelections
     *           Stores most recent facet selection state. Only facet groups with user's
     *           selection will be presented here. Selection state is either selected or
     *           unselected. Only selected facet buckets will be used as search criteria.
     *     @type string[] $resultAnnotationKeys
     *           A list of annotation keys to specify the annotations to be retrieved and
     *           returned with each search result.
     *           Annotation granularity must be GRANULARITY_ASSET_LEVEL and its search
     *           strategy must not be NO_SEARCH.
     *     @type string $searchQuery
     *           Global search query. Allows user to search assets without needing to
     *           specify which field the value belongs to.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchAssets($corpus, array $optionalArgs = [])
    {
        $request = new SearchAssetsRequest();
        $requestParamHeaders = [];
        $request->setCorpus($corpus);
        $requestParamHeaders['corpus'] = $corpus;
        if (isset($optionalArgs['schemaKeySortingStrategy'])) {
            $request->setSchemaKeySortingStrategy($optionalArgs['schemaKeySortingStrategy']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['contentTimeRanges'])) {
            $request->setContentTimeRanges($optionalArgs['contentTimeRanges']);
        }

        if (isset($optionalArgs['criteria'])) {
            $request->setCriteria($optionalArgs['criteria']);
        }

        if (isset($optionalArgs['facetSelections'])) {
            $request->setFacetSelections($optionalArgs['facetSelections']);
        }

        if (isset($optionalArgs['resultAnnotationKeys'])) {
            $request->setResultAnnotationKeys($optionalArgs['resultAnnotationKeys']);
        }

        if (isset($optionalArgs['searchQuery'])) {
            $request->setSearchQuery($optionalArgs['searchQuery']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('SearchAssets', $optionalArgs, SearchAssetsResponse::class, $request);
    }

    /**
     * Search a deployed index endpoint (IMAGE corpus type only).
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedIndexEndpoint = $warehouseClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->searchIndexEndpoint($formattedIndexEndpoint);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->searchIndexEndpoint($formattedIndexEndpoint);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $indexEndpoint Required. The index endpoint to search.
     *                              Format:
     *                              `projects/{project_id}/locations/{location_id}/indexEndpoints/{index_endpoint_id}'
     * @param array  $optionalArgs  {
     *     Optional.
     *
     *     @type ImageQuery $imageQuery
     *           An image-only query.
     *     @type string $textQuery
     *           A text-only query.
     *     @type Criteria[] $criteria
     *           Criteria applied to search results.
     *     @type Criteria[] $exclusionCriteria
     *           Criteria to exclude from search results.
     *           Note that `fetch_matched_annotations` will be ignored.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchIndexEndpoint($indexEndpoint, array $optionalArgs = [])
    {
        $request = new SearchIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $requestParamHeaders['index_endpoint'] = $indexEndpoint;
        if (isset($optionalArgs['imageQuery'])) {
            $request->setImageQuery($optionalArgs['imageQuery']);
        }

        if (isset($optionalArgs['textQuery'])) {
            $request->setTextQuery($optionalArgs['textQuery']);
        }

        if (isset($optionalArgs['criteria'])) {
            $request->setCriteria($optionalArgs['criteria']);
        }

        if (isset($optionalArgs['exclusionCriteria'])) {
            $request->setExclusionCriteria($optionalArgs['exclusionCriteria']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('SearchIndexEndpoint', $optionalArgs, SearchIndexEndpointResponse::class, $request);
    }

    /**
     * Undeploys an Index from IndexEndpoint.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedIndexEndpoint = $warehouseClient->indexEndpointName('[PROJECT]', '[LOCATION]', '[INDEX_ENDPOINT]');
     *     $operationResponse = $warehouseClient->undeployIndex($formattedIndexEndpoint);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->undeployIndex($formattedIndexEndpoint);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'undeployIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $indexEndpoint Required. Resource name of the IndexEndpoint resource on which the
     *                              undeployment will act. Format:
     *                              `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * @param array  $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeployIndex($indexEndpoint, array $optionalArgs = [])
    {
        $request = new UndeployIndexRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $requestParamHeaders['index_endpoint'] = $indexEndpoint;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UndeployIndex', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates annotation inside asset.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $annotation = new Annotation();
     *     $response = $warehouseClient->updateAnnotation($annotation);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param Annotation $annotation   Required. The annotation to update.
     *                                 The annotation's `name` field is used to identify the annotation to be
     *                                 updated. Format:
     *                                 `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Annotation
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAnnotation($annotation, array $optionalArgs = [])
    {
        $request = new UpdateAnnotationRequest();
        $requestParamHeaders = [];
        $request->setAnnotation($annotation);
        $requestParamHeaders['annotation.name'] = $annotation->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAnnotation', Annotation::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an asset inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $asset = new Asset();
     *     $response = $warehouseClient->updateAsset($asset);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param Asset $asset        Required. The asset to update.
     *
     *                            The asset's `name` field is used to identify the asset to be updated.
     *                            Format:
     *                            `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Asset
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAsset($asset, array $optionalArgs = [])
    {
        $request = new UpdateAssetRequest();
        $requestParamHeaders = [];
        $request->setAsset($asset);
        $requestParamHeaders['asset.name'] = $asset->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAsset', Asset::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a collection.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $collection = new Collection();
     *     $response = $warehouseClient->updateCollection($collection);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param Collection $collection   Required. The collection to update.
     *
     *                                 The collection's `name` field is used to identify the collection to be
     *                                 updated. Format:
     *                                 `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *           - Unset `update_mask` or set `update_mask` to be a single "*" only will
     *           update all updatable fields with the value provided in `collection`.
     *           - To update `display_name` value to empty string, set it in the
     *           `collection`
     *           to empty string, and set `update_mask` with "display_name". Same applies
     *           to other updatable string fields in the `collection`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Collection
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCollection($collection, array $optionalArgs = [])
    {
        $request = new UpdateCollectionRequest();
        $requestParamHeaders = [];
        $request->setCollection($collection);
        $requestParamHeaders['collection.name'] = $collection->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateCollection', Collection::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a corpus in a project.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $corpus = new Corpus();
     *     $response = $warehouseClient->updateCorpus($corpus);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param Corpus $corpus       Required. The corpus which replaces the resource on the server.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Corpus
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCorpus($corpus, array $optionalArgs = [])
    {
        $request = new UpdateCorpusRequest();
        $requestParamHeaders = [];
        $request->setCorpus($corpus);
        $requestParamHeaders['corpus.name'] = $corpus->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateCorpus', Corpus::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates data schema inside corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $dataSchema = new DataSchema();
     *     $response = $warehouseClient->updateDataSchema($dataSchema);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param DataSchema $dataSchema   Required. The data schema's `name` field is used to identify the data
     *                                 schema to be updated. Format:
     *                                 `projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}`
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\DataSchema
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDataSchema($dataSchema, array $optionalArgs = [])
    {
        $request = new UpdateDataSchemaRequest();
        $requestParamHeaders = [];
        $request->setDataSchema($dataSchema);
        $requestParamHeaders['data_schema.name'] = $dataSchema->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateDataSchema', DataSchema::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an Index under the corpus.
     * Users can perform a metadata-only update or trigger a full index rebuild
     * with different update_mask values.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $index = new Index();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $warehouseClient->updateIndex($index, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->updateIndex($index, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'updateIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param Index     $index        Required. The resource being updated.
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Index resource by the update. The fields specified in the update_mask are
     *                                relative to the resource, not the full request. A field of the resource
     *                                will be overwritten if it is in the mask. Empty field mask is not allowed.
     *                                If the mask is "*", it triggers a full update of the index, and also a
     *                                whole rebuild of index data.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateIndex($index, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateIndexRequest();
        $requestParamHeaders = [];
        $request->setIndex($index);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['index.name'] = $index->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateIndex', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates an IndexEndpoint.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $indexEndpoint = new IndexEndpoint();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $warehouseClient->updateIndexEndpoint($indexEndpoint, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->updateIndexEndpoint($indexEndpoint, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'updateIndexEndpoint');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param IndexEndpoint $indexEndpoint Required. The resource being updated.
     * @param FieldMask     $updateMask    Required. Field mask is used to specify the fields to be overwritten in the
     *                                     IndexEndpoint resource by the update.
     *                                     The fields specified in the update_mask are relative to the resource, not
     *                                     the full request.
     *                                     A field of the resource will be overwritten if it is in the mask.
     *                                     Empty field mask is not allowed.
     *                                     If the mask is "*", then this is a full replacement of the resource.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateIndexEndpoint($indexEndpoint, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateIndexEndpointRequest();
        $requestParamHeaders = [];
        $request->setIndexEndpoint($indexEndpoint);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['index_endpoint.name'] = $indexEndpoint->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateIndexEndpoint', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates a search configuration inside a corpus.
     *
     * Please follow the rules below to create a valid UpdateSearchConfigRequest.
     * --- General Rules ---
     * 1. Request.search_configuration.name must already exist.
     * 2. Request must contain at least one non-empty search_criteria_property or
     * facet_property.
     * 3. mapped_fields must not be empty, and must map to existing UGA keys.
     * 4. All mapped_fields must be of the same type.
     * 5. All mapped_fields must share the same granularity.
     * 6. All mapped_fields must share the same semantic SearchConfig match
     * options.
     * For property-specific rules, please reference the comments for
     * FacetProperty and SearchCriteriaProperty.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $searchConfig = new SearchConfig();
     *     $response = $warehouseClient->updateSearchConfig($searchConfig);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param SearchConfig $searchConfig Required. The search configuration to update.
     *
     *                                   The search configuration's `name` field is used to identify the resource to
     *                                   be updated. Format:
     *                                   `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated. If left unset, all field paths will be
     *           updated/overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\SearchConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSearchConfig($searchConfig, array $optionalArgs = [])
    {
        $request = new UpdateSearchConfigRequest();
        $requestParamHeaders = [];
        $request->setSearchConfig($searchConfig);
        $requestParamHeaders['search_config.name'] = $searchConfig->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSearchConfig', SearchConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a SearchHypernym inside a corpus.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $searchHypernym = new SearchHypernym();
     *     $response = $warehouseClient->updateSearchHypernym($searchHypernym);
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param SearchHypernym $searchHypernym Required. The SearchHypernym to update.
     *                                       The search hypernym's `name` field is used to identify the search hypernym
     *                                       to be updated. Format:
     *                                       `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated. If left unset, all field paths will be
     *           updated/overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\SearchHypernym
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSearchHypernym($searchHypernym, array $optionalArgs = [])
    {
        $request = new UpdateSearchHypernymRequest();
        $requestParamHeaders = [];
        $request->setSearchHypernym($searchHypernym);
        $requestParamHeaders['search_hypernym.name'] = $searchHypernym->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSearchHypernym', SearchHypernym::class, $optionalArgs, $request)->wait();
    }

    /**
     * Upload asset by specifing the asset Cloud Storage uri.
     * For video warehouse, it requires users who call this API have read access
     * to the cloud storage file. Once it is uploaded, it can be retrieved by
     * GenerateRetrievalUrl API which by default, only can retrieve cloud storage
     * files from the same project of the warehouse. To allow retrieval cloud
     * storage files that are in a separate project, it requires to find the
     * vision ai service account (Go to IAM, check checkbox to show "Include
     * Google-provided role grants", search for "Cloud Vision AI Service Agent")
     * and grant the read access of the cloud storage files to that service
     * account.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedName = $warehouseClient->assetName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[ASSET]');
     *     $operationResponse = $warehouseClient->uploadAsset($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $warehouseClient->uploadAsset($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $warehouseClient->resumeOperation($operationName, 'uploadAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the asset to upload.
     *                             Format:
     *                             `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type AssetSource $assetSource
     *           The source of the asset.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function uploadAsset($name, array $optionalArgs = [])
    {
        $request = new UploadAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['assetSource'])) {
            $request->setAssetSource($optionalArgs['assetSource']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UploadAsset', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * View items inside a collection.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedCollection = $warehouseClient->collectionName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[COLLECTION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->viewCollectionItems($formattedCollection);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->viewCollectionItems($formattedCollection);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $collection   Required. The collection to view. Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function viewCollectionItems($collection, array $optionalArgs = [])
    {
        $request = new ViewCollectionItemsRequest();
        $requestParamHeaders = [];
        $request->setCollection($collection);
        $requestParamHeaders['collection'] = $collection;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ViewCollectionItems', $optionalArgs, ViewCollectionItemsResponse::class, $request);
    }

    /**
     * Lists assets inside an index.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $formattedIndex = $warehouseClient->indexName('[PROJECT_NUMBER]', '[LOCATION]', '[CORPUS]', '[INDEX]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->viewIndexedAssets($formattedIndex);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->viewIndexedAssets($formattedIndex);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param string $index        Required. The index that owns this collection of assets.
     *                             Format:
     *                             `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter applied to the returned list.
     *           Only the following filterings are supported:
     *           "asset_id = xxxx", which returns asset with specified id.
     *           "asset_id = xxxx, yyyy, zzzz", which returns assets with specified ids.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function viewIndexedAssets($index, array $optionalArgs = [])
    {
        $request = new ViewIndexedAssetsRequest();
        $requestParamHeaders = [];
        $request->setIndex($index);
        $requestParamHeaders['index'] = $index;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ViewIndexedAssets', $optionalArgs, ViewIndexedAssetsResponse::class, $request);
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     $response = $warehouseClient->getLocation();
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $warehouseClient = new WarehouseClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $warehouseClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $warehouseClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $warehouseClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
