<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/visionai/v1/streams_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VisionAI\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\VisionAI\V1\Channel;
use Google\Cloud\VisionAI\V1\Cluster;
use Google\Cloud\VisionAI\V1\CreateClusterRequest;
use Google\Cloud\VisionAI\V1\CreateEventRequest;
use Google\Cloud\VisionAI\V1\CreateSeriesRequest;
use Google\Cloud\VisionAI\V1\CreateStreamRequest;
use Google\Cloud\VisionAI\V1\DeleteClusterRequest;
use Google\Cloud\VisionAI\V1\DeleteEventRequest;
use Google\Cloud\VisionAI\V1\DeleteSeriesRequest;
use Google\Cloud\VisionAI\V1\DeleteStreamRequest;
use Google\Cloud\VisionAI\V1\Event;
use Google\Cloud\VisionAI\V1\GenerateStreamHlsTokenRequest;
use Google\Cloud\VisionAI\V1\GenerateStreamHlsTokenResponse;
use Google\Cloud\VisionAI\V1\GetClusterRequest;
use Google\Cloud\VisionAI\V1\GetEventRequest;
use Google\Cloud\VisionAI\V1\GetSeriesRequest;
use Google\Cloud\VisionAI\V1\GetStreamRequest;
use Google\Cloud\VisionAI\V1\GetStreamThumbnailRequest;
use Google\Cloud\VisionAI\V1\ListClustersRequest;
use Google\Cloud\VisionAI\V1\ListClustersResponse;
use Google\Cloud\VisionAI\V1\ListEventsRequest;
use Google\Cloud\VisionAI\V1\ListEventsResponse;
use Google\Cloud\VisionAI\V1\ListSeriesRequest;
use Google\Cloud\VisionAI\V1\ListSeriesResponse;
use Google\Cloud\VisionAI\V1\ListStreamsRequest;
use Google\Cloud\VisionAI\V1\ListStreamsResponse;
use Google\Cloud\VisionAI\V1\MaterializeChannelRequest;
use Google\Cloud\VisionAI\V1\Series;
use Google\Cloud\VisionAI\V1\Stream;
use Google\Cloud\VisionAI\V1\UpdateClusterRequest;
use Google\Cloud\VisionAI\V1\UpdateEventRequest;
use Google\Cloud\VisionAI\V1\UpdateSeriesRequest;
use Google\Cloud\VisionAI\V1\UpdateStreamRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service describing handlers for resources.
 * Vision API and Vision AI API are two independent APIs developed by the same
 * team. Vision API is for people to annotate their image while Vision AI is an
 * e2e solution for customer to build their own computer vision application.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $streamsServiceClient = new StreamsServiceClient();
 * try {
 *     $formattedParent = $streamsServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $clusterId = 'cluster_id';
 *     $cluster = new Cluster();
 *     $operationResponse = $streamsServiceClient->createCluster($formattedParent, $clusterId, $cluster);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $streamsServiceClient->createCluster($formattedParent, $clusterId, $cluster);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'createCluster');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $streamsServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated This class will be removed in the next major version update.
 */
class StreamsServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.visionai.v1.StreamsService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'visionai.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'visionai.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $channelNameTemplate;

    private static $clusterNameTemplate;

    private static $eventNameTemplate;

    private static $locationNameTemplate;

    private static $seriesNameTemplate;

    private static $streamNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/streams_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/streams_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/streams_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/streams_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getChannelNameTemplate()
    {
        if (self::$channelNameTemplate == null) {
            self::$channelNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}/channels/{channel}');
        }

        return self::$channelNameTemplate;
    }

    private static function getClusterNameTemplate()
    {
        if (self::$clusterNameTemplate == null) {
            self::$clusterNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}');
        }

        return self::$clusterNameTemplate;
    }

    private static function getEventNameTemplate()
    {
        if (self::$eventNameTemplate == null) {
            self::$eventNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}/events/{event}');
        }

        return self::$eventNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getSeriesNameTemplate()
    {
        if (self::$seriesNameTemplate == null) {
            self::$seriesNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}/series/{series}');
        }

        return self::$seriesNameTemplate;
    }

    private static function getStreamNameTemplate()
    {
        if (self::$streamNameTemplate == null) {
            self::$streamNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}/streams/{stream}');
        }

        return self::$streamNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'channel' => self::getChannelNameTemplate(),
                'cluster' => self::getClusterNameTemplate(),
                'event' => self::getEventNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'series' => self::getSeriesNameTemplate(),
                'stream' => self::getStreamNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a channel
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $channel
     *
     * @return string The formatted channel resource.
     */
    public static function channelName($project, $location, $cluster, $channel)
    {
        return self::getChannelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'channel' => $channel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName($project, $location, $cluster)
    {
        return self::getClusterNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a event
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $event
     *
     * @return string The formatted event resource.
     */
    public static function eventName($project, $location, $cluster, $event)
    {
        return self::getEventNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'event' => $event,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a series
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $series
     *
     * @return string The formatted series resource.
     */
    public static function seriesName($project, $location, $cluster, $series)
    {
        return self::getSeriesNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'series' => $series,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a stream
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $stream
     *
     * @return string The formatted stream resource.
     */
    public static function streamName($project, $location, $cluster, $stream)
    {
        return self::getStreamNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'stream' => $stream,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - channel: projects/{project}/locations/{location}/clusters/{cluster}/channels/{channel}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - event: projects/{project}/locations/{location}/clusters/{cluster}/events/{event}
     * - location: projects/{project}/locations/{location}
     * - series: projects/{project}/locations/{location}/clusters/{cluster}/series/{series}
     * - stream: projects/{project}/locations/{location}/clusters/{cluster}/streams/{stream}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'visionai.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new Cluster in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $clusterId = 'cluster_id';
     *     $cluster = new Cluster();
     *     $operationResponse = $streamsServiceClient->createCluster($formattedParent, $clusterId, $cluster);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->createCluster($formattedParent, $clusterId, $cluster);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'createCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. Value for parent.
     * @param string  $clusterId    Required. Id of the requesting object.
     * @param Cluster $cluster      Required. The resource being created.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCluster($parent, $clusterId, $cluster, array $optionalArgs = [])
    {
        $request = new CreateClusterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setClusterId($clusterId);
        $request->setCluster($cluster);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateCluster', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Event in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $eventId = 'event_id';
     *     $event = new Event();
     *     $operationResponse = $streamsServiceClient->createEvent($formattedParent, $eventId, $event);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->createEvent($formattedParent, $eventId, $event);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'createEvent');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Value for parent.
     * @param string $eventId      Required. Id of the requesting object.
     * @param Event  $event        Required. The resource being created.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEvent($parent, $eventId, $event, array $optionalArgs = [])
    {
        $request = new CreateEventRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEventId($eventId);
        $request->setEvent($event);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateEvent', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Series in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $seriesId = 'series_id';
     *     $series = new Series();
     *     $operationResponse = $streamsServiceClient->createSeries($formattedParent, $seriesId, $series);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->createSeries($formattedParent, $seriesId, $series);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'createSeries');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Value for parent.
     * @param string $seriesId     Required. Id of the requesting object.
     * @param Series $series       Required. The resource being created.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createSeries($parent, $seriesId, $series, array $optionalArgs = [])
    {
        $request = new CreateSeriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSeriesId($seriesId);
        $request->setSeries($series);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateSeries', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Stream in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $streamId = 'stream_id';
     *     $stream = new Stream();
     *     $operationResponse = $streamsServiceClient->createStream($formattedParent, $streamId, $stream);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->createStream($formattedParent, $streamId, $stream);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'createStream');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Value for parent.
     * @param string $streamId     Required. Id of the requesting object.
     * @param Stream $stream       Required. The resource being created.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createStream($parent, $streamId, $stream, array $optionalArgs = [])
    {
        $request = new CreateStreamRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setStreamId($streamId);
        $request->setStream($stream);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateStream', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Cluster.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $operationResponse = $streamsServiceClient->deleteCluster($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->deleteCluster($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'deleteCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCluster($name, array $optionalArgs = [])
    {
        $request = new DeleteClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteCluster', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Event.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->eventName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[EVENT]');
     *     $operationResponse = $streamsServiceClient->deleteEvent($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->deleteEvent($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'deleteEvent');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEvent($name, array $optionalArgs = [])
    {
        $request = new DeleteEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteEvent', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Series.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->seriesName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[SERIES]');
     *     $operationResponse = $streamsServiceClient->deleteSeries($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->deleteSeries($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'deleteSeries');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSeries($name, array $optionalArgs = [])
    {
        $request = new DeleteSeriesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteSeries', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Stream.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->streamName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[STREAM]');
     *     $operationResponse = $streamsServiceClient->deleteStream($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->deleteStream($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'deleteStream');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteStream($name, array $optionalArgs = [])
    {
        $request = new DeleteStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteStream', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Generate the JWT auth token required to get the stream HLS contents.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $stream = 'stream';
     *     $response = $streamsServiceClient->generateStreamHlsToken($stream);
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $stream       Required. The name of the stream.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\GenerateStreamHlsTokenResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateStreamHlsToken($stream, array $optionalArgs = [])
    {
        $request = new GenerateStreamHlsTokenRequest();
        $requestParamHeaders = [];
        $request->setStream($stream);
        $requestParamHeaders['stream'] = $stream;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateStreamHlsToken', GenerateStreamHlsTokenResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Cluster.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $response = $streamsServiceClient->getCluster($formattedName);
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Cluster
     *
     * @throws ApiException if the remote call fails
     */
    public function getCluster($name, array $optionalArgs = [])
    {
        $request = new GetClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCluster', Cluster::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Event.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->eventName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[EVENT]');
     *     $response = $streamsServiceClient->getEvent($formattedName);
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Event
     *
     * @throws ApiException if the remote call fails
     */
    public function getEvent($name, array $optionalArgs = [])
    {
        $request = new GetEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEvent', Event::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Series.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->seriesName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[SERIES]');
     *     $response = $streamsServiceClient->getSeries($formattedName);
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Series
     *
     * @throws ApiException if the remote call fails
     */
    public function getSeries($name, array $optionalArgs = [])
    {
        $request = new GetSeriesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSeries', Series::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Stream.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedName = $streamsServiceClient->streamName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[STREAM]');
     *     $response = $streamsServiceClient->getStream($formattedName);
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Stream
     *
     * @throws ApiException if the remote call fails
     */
    public function getStream($name, array $optionalArgs = [])
    {
        $request = new GetStreamRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetStream', Stream::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the thumbnail (image snapshot) of a single Stream.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $stream = 'stream';
     *     $gcsObjectName = 'gcs_object_name';
     *     $operationResponse = $streamsServiceClient->getStreamThumbnail($stream, $gcsObjectName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->getStreamThumbnail($stream, $gcsObjectName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'getStreamThumbnail');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $stream        Required. The name of the stream for to get the thumbnail from.
     * @param string $gcsObjectName Required. The name of the GCS object to store the thumbnail image.
     * @param array  $optionalArgs  {
     *     Optional.
     *
     *     @type string $event
     *           Optional. The name of the event. If unspecified, the thumbnail will be
     *           retrieved from the latest event.
     *     @type string $requestId
     *           Optional. An optional request ID to identify the requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function getStreamThumbnail($stream, $gcsObjectName, array $optionalArgs = [])
    {
        $request = new GetStreamThumbnailRequest();
        $requestParamHeaders = [];
        $request->setStream($stream);
        $request->setGcsObjectName($gcsObjectName);
        $requestParamHeaders['stream'] = $stream;
        if (isset($optionalArgs['event'])) {
            $request->setEvent($optionalArgs['event']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('GetStreamThumbnail', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Lists Clusters in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $streamsServiceClient->listClusters($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $streamsServiceClient->listClusters($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListClustersRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listClusters($parent, array $optionalArgs = [])
    {
        $request = new ListClustersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListClusters', $optionalArgs, ListClustersResponse::class, $request);
    }

    /**
     * Lists Events in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $streamsServiceClient->listEvents($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $streamsServiceClient->listEvents($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListEventsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEvents($parent, array $optionalArgs = [])
    {
        $request = new ListEventsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEvents', $optionalArgs, ListEventsResponse::class, $request);
    }

    /**
     * Lists Series in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $streamsServiceClient->listSeries($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $streamsServiceClient->listSeries($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListSeriesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSeries($parent, array $optionalArgs = [])
    {
        $request = new ListSeriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSeries', $optionalArgs, ListSeriesResponse::class, $request);
    }

    /**
     * Lists Streams in a given project and location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $streamsServiceClient->listStreams($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $streamsServiceClient->listStreams($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListStreamsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listStreams($parent, array $optionalArgs = [])
    {
        $request = new ListStreamsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListStreams', $optionalArgs, ListStreamsResponse::class, $request);
    }

    /**
     * Materialize a channel.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $formattedParent = $streamsServiceClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $channelId = 'channel_id';
     *     $channel = new Channel();
     *     $operationResponse = $streamsServiceClient->materializeChannel($formattedParent, $channelId, $channel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->materializeChannel($formattedParent, $channelId, $channel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'materializeChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. Value for parent.
     * @param string  $channelId    Required. Id of the channel.
     * @param Channel $channel      Required. The resource being created.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function materializeChannel($parent, $channelId, $channel, array $optionalArgs = [])
    {
        $request = new MaterializeChannelRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setChannelId($channelId);
        $request->setChannel($channel);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('MaterializeChannel', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Cluster.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $cluster = new Cluster();
     *     $operationResponse = $streamsServiceClient->updateCluster($updateMask, $cluster);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->updateCluster($updateMask, $cluster);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'updateCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Cluster resource by the update.
     *                                The fields specified in the update_mask are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Cluster   $cluster      Required. The resource being updated
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCluster($updateMask, $cluster, array $optionalArgs = [])
    {
        $request = new UpdateClusterRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setCluster($cluster);
        $requestParamHeaders['cluster.name'] = $cluster->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateCluster', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Event.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $event = new Event();
     *     $operationResponse = $streamsServiceClient->updateEvent($updateMask, $event);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->updateEvent($updateMask, $event);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'updateEvent');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Event resource by the update.
     *                                The fields specified in the update_mask are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Event     $event        Required. The resource being updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEvent($updateMask, $event, array $optionalArgs = [])
    {
        $request = new UpdateEventRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setEvent($event);
        $requestParamHeaders['event.name'] = $event->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateEvent', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Event.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $series = new Series();
     *     $operationResponse = $streamsServiceClient->updateSeries($updateMask, $series);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->updateSeries($updateMask, $series);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'updateSeries');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Series resource by the update. The fields specified in the update_mask are
     *                                relative to the resource, not the full request. A field will be overwritten
     *                                if it is in the mask. If the user does not provide a mask then all fields
     *                                will be overwritten.
     * @param Series    $series       Required. The resource being updated
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSeries($updateMask, $series, array $optionalArgs = [])
    {
        $request = new UpdateSeriesRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setSeries($series);
        $requestParamHeaders['series.name'] = $series->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateSeries', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Stream.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $stream = new Stream();
     *     $operationResponse = $streamsServiceClient->updateStream($updateMask, $stream);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $streamsServiceClient->updateStream($updateMask, $stream);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $streamsServiceClient->resumeOperation($operationName, 'updateStream');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Stream resource by the update.
     *                                The fields specified in the update_mask are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Stream    $stream       Required. The resource being updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateStream($updateMask, $stream, array $optionalArgs = [])
    {
        $request = new UpdateStreamRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setStream($stream);
        $requestParamHeaders['stream.name'] = $stream->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateStream', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     $response = $streamsServiceClient->getLocation();
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $streamsServiceClient = new StreamsServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $streamsServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $streamsServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $streamsServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
