<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/visionai/v1/lva_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VisionAI\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\VisionAI\V1\Analysis;
use Google\Cloud\VisionAI\V1\BatchRunProcessRequest;
use Google\Cloud\VisionAI\V1\BatchRunProcessRequest\BatchRunProcessOptions;
use Google\Cloud\VisionAI\V1\CreateAnalysisRequest;
use Google\Cloud\VisionAI\V1\CreateOperatorRequest;
use Google\Cloud\VisionAI\V1\CreateProcessRequest;
use Google\Cloud\VisionAI\V1\DeleteAnalysisRequest;
use Google\Cloud\VisionAI\V1\DeleteOperatorRequest;
use Google\Cloud\VisionAI\V1\DeleteProcessRequest;
use Google\Cloud\VisionAI\V1\GetAnalysisRequest;
use Google\Cloud\VisionAI\V1\GetOperatorRequest;
use Google\Cloud\VisionAI\V1\GetProcessRequest;
use Google\Cloud\VisionAI\V1\ListAnalysesRequest;
use Google\Cloud\VisionAI\V1\ListAnalysesResponse;
use Google\Cloud\VisionAI\V1\ListOperatorsRequest;
use Google\Cloud\VisionAI\V1\ListOperatorsResponse;
use Google\Cloud\VisionAI\V1\ListProcessesRequest;
use Google\Cloud\VisionAI\V1\ListProcessesResponse;
use Google\Cloud\VisionAI\V1\ListPublicOperatorsRequest;
use Google\Cloud\VisionAI\V1\ListPublicOperatorsResponse;
use Google\Cloud\VisionAI\V1\Operator;
use Google\Cloud\VisionAI\V1\OperatorQuery;
use Google\Cloud\VisionAI\V1\Process;
use Google\Cloud\VisionAI\V1\ResolveOperatorInfoRequest;
use Google\Cloud\VisionAI\V1\ResolveOperatorInfoResponse;
use Google\Cloud\VisionAI\V1\UpdateAnalysisRequest;
use Google\Cloud\VisionAI\V1\UpdateOperatorRequest;
use Google\Cloud\VisionAI\V1\UpdateProcessRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service describing handlers for resources. The service enables clients to run
 * Live Video Analytics (LVA) on the streaming inputs.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
 * try {
 *     $formattedParent = $liveVideoAnalyticsClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
 *     $requests = [];
 *     $operationResponse = $liveVideoAnalyticsClient->batchRunProcess($formattedParent, $requests);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $liveVideoAnalyticsClient->batchRunProcess($formattedParent, $requests);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'batchRunProcess');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $liveVideoAnalyticsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated This class will be removed in the next major version update.
 */
class LiveVideoAnalyticsGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.visionai.v1.LiveVideoAnalytics';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'visionai.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'visionai.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $analysisNameTemplate;

    private static $clusterNameTemplate;

    private static $locationNameTemplate;

    private static $operatorNameTemplate;

    private static $processNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/live_video_analytics_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/live_video_analytics_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/live_video_analytics_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/live_video_analytics_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAnalysisNameTemplate()
    {
        if (self::$analysisNameTemplate == null) {
            self::$analysisNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}/analyses/{analysis}');
        }

        return self::$analysisNameTemplate;
    }

    private static function getClusterNameTemplate()
    {
        if (self::$clusterNameTemplate == null) {
            self::$clusterNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}');
        }

        return self::$clusterNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getOperatorNameTemplate()
    {
        if (self::$operatorNameTemplate == null) {
            self::$operatorNameTemplate = new PathTemplate('projects/{project}/locations/{location}/operators/{operator}');
        }

        return self::$operatorNameTemplate;
    }

    private static function getProcessNameTemplate()
    {
        if (self::$processNameTemplate == null) {
            self::$processNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}/processes/{process}');
        }

        return self::$processNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'analysis' => self::getAnalysisNameTemplate(),
                'cluster' => self::getClusterNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'operator' => self::getOperatorNameTemplate(),
                'process' => self::getProcessNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a analysis
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $analysis
     *
     * @return string The formatted analysis resource.
     */
    public static function analysisName($project, $location, $cluster, $analysis)
    {
        return self::getAnalysisNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'analysis' => $analysis,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName($project, $location, $cluster)
    {
        return self::getClusterNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a operator
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $operator
     *
     * @return string The formatted operator resource.
     */
    public static function operatorName($project, $location, $operator)
    {
        return self::getOperatorNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'operator' => $operator,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a process
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $process
     *
     * @return string The formatted process resource.
     */
    public static function processName($project, $location, $cluster, $process)
    {
        return self::getProcessNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'process' => $process,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - analysis: projects/{project}/locations/{location}/clusters/{cluster}/analyses/{analysis}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - location: projects/{project}/locations/{location}
     * - operator: projects/{project}/locations/{location}/operators/{operator}
     * - process: projects/{project}/locations/{location}/clusters/{cluster}/processes/{process}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'visionai.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Run all of the processes to "completion". Max time for each process is
     * the LRO time limit.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $requests = [];
     *     $operationResponse = $liveVideoAnalyticsClient->batchRunProcess($formattedParent, $requests);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->batchRunProcess($formattedParent, $requests);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'batchRunProcess');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string                 $parent       Required. The parent resource shared by all processes being created.
     * @param CreateProcessRequest[] $requests     Required. The create process requests.
     * @param array                  $optionalArgs {
     *     Optional.
     *
     *     @type BatchRunProcessOptions $options
     *           Optional. Options for batch processes.
     *     @type string $batchId
     *           Output only. The batch ID.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchRunProcess($parent, $requests, array $optionalArgs = [])
    {
        $request = new BatchRunProcessRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        if (isset($optionalArgs['batchId'])) {
            $request->setBatchId($optionalArgs['batchId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('BatchRunProcess', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Analysis in a given project and location.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $analysisId = 'analysis_id';
     *     $analysis = new Analysis();
     *     $operationResponse = $liveVideoAnalyticsClient->createAnalysis($formattedParent, $analysisId, $analysis);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->createAnalysis($formattedParent, $analysisId, $analysis);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'createAnalysis');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. Value for parent.
     * @param string   $analysisId   Required. Id of the requesting object.
     * @param Analysis $analysis     Required. The resource being created.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAnalysis($parent, $analysisId, $analysis, array $optionalArgs = [])
    {
        $request = new CreateAnalysisRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAnalysisId($analysisId);
        $request->setAnalysis($analysis);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateAnalysis', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Operator in a given project and location.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $operatorId = 'operator_id';
     *     $operator = new Operator();
     *     $operationResponse = $liveVideoAnalyticsClient->createOperator($formattedParent, $operatorId, $operator);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->createOperator($formattedParent, $operatorId, $operator);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'createOperator');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. Value for parent.
     * @param string   $operatorId   Required. Id of the requesting object.
     * @param Operator $operator     Required. The resource being created.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createOperator($parent, $operatorId, $operator, array $optionalArgs = [])
    {
        $request = new CreateOperatorRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setOperatorId($operatorId);
        $request->setOperator($operator);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateOperator', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Process in a given project and location.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     $processId = 'process_id';
     *     $process = new Process();
     *     $operationResponse = $liveVideoAnalyticsClient->createProcess($formattedParent, $processId, $process);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->createProcess($formattedParent, $processId, $process);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'createProcess');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. Value for parent.
     * @param string  $processId    Required. Id of the requesting object.
     * @param Process $process      Required. The resource being created.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createProcess($parent, $processId, $process, array $optionalArgs = [])
    {
        $request = new CreateProcessRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setProcessId($processId);
        $request->setProcess($process);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateProcess', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Analysis.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedName = $liveVideoAnalyticsClient->analysisName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[ANALYSIS]');
     *     $operationResponse = $liveVideoAnalyticsClient->deleteAnalysis($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->deleteAnalysis($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'deleteAnalysis');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAnalysis($name, array $optionalArgs = [])
    {
        $request = new DeleteAnalysisRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteAnalysis', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Operator.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedName = $liveVideoAnalyticsClient->operatorName('[PROJECT]', '[LOCATION]', '[OPERATOR]');
     *     $operationResponse = $liveVideoAnalyticsClient->deleteOperator($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->deleteOperator($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'deleteOperator');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteOperator($name, array $optionalArgs = [])
    {
        $request = new DeleteOperatorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteOperator', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Process.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedName = $liveVideoAnalyticsClient->processName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[PROCESS]');
     *     $operationResponse = $liveVideoAnalyticsClient->deleteProcess($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->deleteProcess($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'deleteProcess');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteProcess($name, array $optionalArgs = [])
    {
        $request = new DeleteProcessRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteProcess', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets details of a single Analysis.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedName = $liveVideoAnalyticsClient->analysisName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[ANALYSIS]');
     *     $response = $liveVideoAnalyticsClient->getAnalysis($formattedName);
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Analysis
     *
     * @throws ApiException if the remote call fails
     */
    public function getAnalysis($name, array $optionalArgs = [])
    {
        $request = new GetAnalysisRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAnalysis', Analysis::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Operator.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedName = $liveVideoAnalyticsClient->operatorName('[PROJECT]', '[LOCATION]', '[OPERATOR]');
     *     $response = $liveVideoAnalyticsClient->getOperator($formattedName);
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Operator
     *
     * @throws ApiException if the remote call fails
     */
    public function getOperator($name, array $optionalArgs = [])
    {
        $request = new GetOperatorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetOperator', Operator::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Process.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedName = $liveVideoAnalyticsClient->processName('[PROJECT]', '[LOCATION]', '[CLUSTER]', '[PROCESS]');
     *     $response = $liveVideoAnalyticsClient->getProcess($formattedName);
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Process
     *
     * @throws ApiException if the remote call fails
     */
    public function getProcess($name, array $optionalArgs = [])
    {
        $request = new GetProcessRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetProcess', Process::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists Analyses in a given project and location.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listAnalyses($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listAnalyses($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListAnalysesRequest
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results
     *     @type string $orderBy
     *           Hint for how to order the results
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAnalyses($parent, array $optionalArgs = [])
    {
        $request = new ListAnalysesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAnalyses', $optionalArgs, ListAnalysesResponse::class, $request);
    }

    /**
     * Lists Operators in a given project and location.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listOperators($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listOperators($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListOperatorsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOperators($parent, array $optionalArgs = [])
    {
        $request = new ListOperatorsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListOperators', $optionalArgs, ListOperatorsResponse::class, $request);
    }

    /**
     * Lists Processes in a given project and location.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->clusterName('[PROJECT]', '[LOCATION]', '[CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listProcesses($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listProcesses($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListProcessesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results
     *     @type string $orderBy
     *           Hint for how to order the results
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProcesses($parent, array $optionalArgs = [])
    {
        $request = new ListProcessesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListProcesses', $optionalArgs, ListProcessesResponse::class, $request);
    }

    /**
     * ListPublicOperators returns all the operators in public registry.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listPublicOperators($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listPublicOperators($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListPublicOperatorsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPublicOperators($parent, array $optionalArgs = [])
    {
        $request = new ListPublicOperatorsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListPublicOperators', $optionalArgs, ListPublicOperatorsResponse::class, $request);
    }

    /**
     * ResolveOperatorInfo returns the operator information based on the request.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $formattedParent = $liveVideoAnalyticsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $queries = [];
     *     $response = $liveVideoAnalyticsClient->resolveOperatorInfo($formattedParent, $queries);
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param string          $parent       Required. Parent value for ResolveOperatorInfoRequest.
     * @param OperatorQuery[] $queries      Required. The operator queries.
     * @param array           $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\ResolveOperatorInfoResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resolveOperatorInfo($parent, $queries, array $optionalArgs = [])
    {
        $request = new ResolveOperatorInfoRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setQueries($queries);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ResolveOperatorInfo', ResolveOperatorInfoResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the parameters of a single Analysis.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $analysis = new Analysis();
     *     $operationResponse = $liveVideoAnalyticsClient->updateAnalysis($updateMask, $analysis);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->updateAnalysis($updateMask, $analysis);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'updateAnalysis');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Analysis resource by the update.
     *                                The fields specified in the update_mask are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Analysis  $analysis     Required. The resource being updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAnalysis($updateMask, $analysis, array $optionalArgs = [])
    {
        $request = new UpdateAnalysisRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setAnalysis($analysis);
        $requestParamHeaders['analysis.name'] = $analysis->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateAnalysis', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Operator.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $operator = new Operator();
     *     $operationResponse = $liveVideoAnalyticsClient->updateOperator($updateMask, $operator);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->updateOperator($updateMask, $operator);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'updateOperator');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Operator resource by the update.
     *                                The fields specified in the update_mask are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Operator  $operator     Required. The resource being updated
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateOperator($updateMask, $operator, array $optionalArgs = [])
    {
        $request = new UpdateOperatorRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setOperator($operator);
        $requestParamHeaders['operator.name'] = $operator->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateOperator', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Process.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $process = new Process();
     *     $operationResponse = $liveVideoAnalyticsClient->updateProcess($updateMask, $process);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $liveVideoAnalyticsClient->updateProcess($updateMask, $process);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $liveVideoAnalyticsClient->resumeOperation($operationName, 'updateProcess');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Process resource by the update.
     *                                The fields specified in the update_mask are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Process   $process      Required. The resource being updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateProcess($updateMask, $process, array $optionalArgs = [])
    {
        $request = new UpdateProcessRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setProcess($process);
        $requestParamHeaders['process.name'] = $process->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateProcess', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     $response = $liveVideoAnalyticsClient->getLocation();
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $liveVideoAnalyticsClient = new LiveVideoAnalyticsClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $liveVideoAnalyticsClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $liveVideoAnalyticsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
