<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/visionai/v1/platform.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VisionAI\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\VisionAI\V1\AddApplicationStreamInputRequest;
use Google\Cloud\VisionAI\V1\Application;
use Google\Cloud\VisionAI\V1\ApplicationInstance;
use Google\Cloud\VisionAI\V1\ApplicationStreamInput;
use Google\Cloud\VisionAI\V1\CreateApplicationInstancesRequest;
use Google\Cloud\VisionAI\V1\CreateApplicationRequest;
use Google\Cloud\VisionAI\V1\CreateDraftRequest;
use Google\Cloud\VisionAI\V1\CreateProcessorRequest;
use Google\Cloud\VisionAI\V1\DeleteApplicationInstancesRequest;
use Google\Cloud\VisionAI\V1\DeleteApplicationRequest;
use Google\Cloud\VisionAI\V1\DeleteDraftRequest;
use Google\Cloud\VisionAI\V1\DeleteProcessorRequest;
use Google\Cloud\VisionAI\V1\DeployApplicationRequest;
use Google\Cloud\VisionAI\V1\Draft;
use Google\Cloud\VisionAI\V1\GetApplicationRequest;
use Google\Cloud\VisionAI\V1\GetDraftRequest;
use Google\Cloud\VisionAI\V1\GetInstanceRequest;
use Google\Cloud\VisionAI\V1\GetProcessorRequest;
use Google\Cloud\VisionAI\V1\Instance;
use Google\Cloud\VisionAI\V1\ListApplicationsRequest;
use Google\Cloud\VisionAI\V1\ListApplicationsResponse;
use Google\Cloud\VisionAI\V1\ListDraftsRequest;
use Google\Cloud\VisionAI\V1\ListDraftsResponse;
use Google\Cloud\VisionAI\V1\ListInstancesRequest;
use Google\Cloud\VisionAI\V1\ListInstancesResponse;
use Google\Cloud\VisionAI\V1\ListPrebuiltProcessorsRequest;
use Google\Cloud\VisionAI\V1\ListPrebuiltProcessorsResponse;
use Google\Cloud\VisionAI\V1\ListProcessorsRequest;
use Google\Cloud\VisionAI\V1\ListProcessorsResponse;
use Google\Cloud\VisionAI\V1\Processor;
use Google\Cloud\VisionAI\V1\RemoveApplicationStreamInputRequest;
use Google\Cloud\VisionAI\V1\RemoveApplicationStreamInputRequest\TargetStreamInput;
use Google\Cloud\VisionAI\V1\UndeployApplicationRequest;
use Google\Cloud\VisionAI\V1\UpdateApplicationInstancesRequest;
use Google\Cloud\VisionAI\V1\UpdateApplicationInstancesRequest\UpdateApplicationInstance;
use Google\Cloud\VisionAI\V1\UpdateApplicationRequest;
use Google\Cloud\VisionAI\V1\UpdateApplicationStreamInputRequest;
use Google\Cloud\VisionAI\V1\UpdateDraftRequest;
use Google\Cloud\VisionAI\V1\UpdateProcessorRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service describing handlers for resources
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $appPlatformClient = new AppPlatformClient();
 * try {
 *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
 *     $operationResponse = $appPlatformClient->addApplicationStreamInput($formattedName);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $appPlatformClient->addApplicationStreamInput($formattedName);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'addApplicationStreamInput');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $appPlatformClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated This class will be removed in the next major version update.
 */
class AppPlatformGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.visionai.v1.AppPlatform';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'visionai.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'visionai.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $applicationNameTemplate;

    private static $draftNameTemplate;

    private static $instanceNameTemplate;

    private static $locationNameTemplate;

    private static $processorNameTemplate;

    private static $streamNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/app_platform_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/app_platform_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/app_platform_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/app_platform_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getApplicationNameTemplate()
    {
        if (self::$applicationNameTemplate == null) {
            self::$applicationNameTemplate = new PathTemplate('projects/{project}/locations/{location}/applications/{application}');
        }

        return self::$applicationNameTemplate;
    }

    private static function getDraftNameTemplate()
    {
        if (self::$draftNameTemplate == null) {
            self::$draftNameTemplate = new PathTemplate('projects/{project}/locations/{location}/applications/{application}/drafts/{draft}');
        }

        return self::$draftNameTemplate;
    }

    private static function getInstanceNameTemplate()
    {
        if (self::$instanceNameTemplate == null) {
            self::$instanceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/applications/{application}/instances/{instance}');
        }

        return self::$instanceNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getProcessorNameTemplate()
    {
        if (self::$processorNameTemplate == null) {
            self::$processorNameTemplate = new PathTemplate('projects/{project}/locations/{location}/processors/{processor}');
        }

        return self::$processorNameTemplate;
    }

    private static function getStreamNameTemplate()
    {
        if (self::$streamNameTemplate == null) {
            self::$streamNameTemplate = new PathTemplate('projects/{project}/locations/{location}/clusters/{cluster}/streams/{stream}');
        }

        return self::$streamNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'application' => self::getApplicationNameTemplate(),
                'draft' => self::getDraftNameTemplate(),
                'instance' => self::getInstanceNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'processor' => self::getProcessorNameTemplate(),
                'stream' => self::getStreamNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a application
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $application
     *
     * @return string The formatted application resource.
     */
    public static function applicationName($project, $location, $application)
    {
        return self::getApplicationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'application' => $application,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a draft
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $application
     * @param string $draft
     *
     * @return string The formatted draft resource.
     */
    public static function draftName($project, $location, $application, $draft)
    {
        return self::getDraftNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'application' => $application,
            'draft' => $draft,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $application
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName($project, $location, $application, $instance)
    {
        return self::getInstanceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'application' => $application,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a processor
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     *
     * @return string The formatted processor resource.
     */
    public static function processorName($project, $location, $processor)
    {
        return self::getProcessorNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a stream
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $stream
     *
     * @return string The formatted stream resource.
     */
    public static function streamName($project, $location, $cluster, $stream)
    {
        return self::getStreamNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'stream' => $stream,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - application: projects/{project}/locations/{location}/applications/{application}
     * - draft: projects/{project}/locations/{location}/applications/{application}/drafts/{draft}
     * - instance: projects/{project}/locations/{location}/applications/{application}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - processor: projects/{project}/locations/{location}/processors/{processor}
     * - stream: projects/{project}/locations/{location}/clusters/{cluster}/streams/{stream}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'visionai.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Adds target stream input to the Application.
     * If the Application is deployed, the corresponding new Application instance
     * will be created. If the stream has already been in the Application, the RPC
     * will fail.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $operationResponse = $appPlatformClient->addApplicationStreamInput($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->addApplicationStreamInput($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'addApplicationStreamInput');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. the name of the application to retrieve.
     *                             Format:
     *                             "projects/{project}/locations/{location}/applications/{application}"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type ApplicationStreamInput[] $applicationStreamInputs
     *           The stream inputs to add, the stream resource name is the key of each
     *           StreamInput, and it must be unique within each application.
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addApplicationStreamInput($name, array $optionalArgs = [])
    {
        $request = new AddApplicationStreamInputRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['applicationStreamInputs'])) {
            $request->setApplicationStreamInputs($optionalArgs['applicationStreamInputs']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('AddApplicationStreamInput', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Application in a given project and location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->locationName('[PROJECT]', '[LOCATION]');
     *     $applicationId = 'application_id';
     *     $application = new Application();
     *     $operationResponse = $appPlatformClient->createApplication($formattedParent, $applicationId, $application);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->createApplication($formattedParent, $applicationId, $application);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'createApplication');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. Value for parent.
     * @param string      $applicationId Required. Id of the requesting object.
     * @param Application $application   Required. The resource being created.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createApplication($parent, $applicationId, $application, array $optionalArgs = [])
    {
        $request = new CreateApplicationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setApplicationId($applicationId);
        $request->setApplication($application);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateApplication', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Adds target stream input to the Application.
     * If the Application is deployed, the corresponding new Application instance
     * will be created. If the stream has already been in the Application, the RPC
     * will fail.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $applicationInstances = [];
     *     $operationResponse = $appPlatformClient->createApplicationInstances($formattedName, $applicationInstances);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->createApplicationInstances($formattedName, $applicationInstances);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'createApplicationInstances');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string                $name                 Required. the name of the application to retrieve.
     *                                                    Format:
     *                                                    "projects/{project}/locations/{location}/applications/{application}"
     * @param ApplicationInstance[] $applicationInstances Required. The resources being created.
     * @param array                 $optionalArgs         {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createApplicationInstances($name, $applicationInstances, array $optionalArgs = [])
    {
        $request = new CreateApplicationInstancesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setApplicationInstances($applicationInstances);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateApplicationInstances', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Draft in a given project and location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $draftId = 'draft_id';
     *     $draft = new Draft();
     *     $operationResponse = $appPlatformClient->createDraft($formattedParent, $draftId, $draft);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->createDraft($formattedParent, $draftId, $draft);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'createDraft');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Value for parent.
     * @param string $draftId      Required. Id of the requesting object.
     * @param Draft  $draft        Required. The resource being created.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDraft($parent, $draftId, $draft, array $optionalArgs = [])
    {
        $request = new CreateDraftRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDraftId($draftId);
        $request->setDraft($draft);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateDraft', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new Processor in a given project and location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->locationName('[PROJECT]', '[LOCATION]');
     *     $processorId = 'processor_id';
     *     $processor = new Processor();
     *     $operationResponse = $appPlatformClient->createProcessor($formattedParent, $processorId, $processor);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->createProcessor($formattedParent, $processorId, $processor);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'createProcessor');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. Value for parent.
     * @param string    $processorId  Required. Id of the requesting object.
     * @param Processor $processor    Required. The resource being created.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createProcessor($parent, $processorId, $processor, array $optionalArgs = [])
    {
        $request = new CreateProcessorRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setProcessorId($processorId);
        $request->setProcessor($processor);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateProcessor', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Application.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $operationResponse = $appPlatformClient->deleteApplication($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->deleteApplication($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'deleteApplication');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $force
     *           Optional. If set to true, any instances and drafts from this application
     *           will also be deleted. (Otherwise, the request will only work if the
     *           application has no instances and drafts.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApplication($name, array $optionalArgs = [])
    {
        $request = new DeleteApplicationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteApplication', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Remove target stream input to the Application, if the Application is
     * deployed, the corresponding instance based will be deleted. If the stream
     * is not in the Application, the RPC will fail.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $formattedInstanceIds = [
     *         $appPlatformClient->instanceName('[PROJECT]', '[LOCATION]', '[APPLICATION]', '[INSTANCE]'),
     *     ];
     *     $operationResponse = $appPlatformClient->deleteApplicationInstances($formattedName, $formattedInstanceIds);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->deleteApplicationInstances($formattedName, $formattedInstanceIds);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'deleteApplicationInstances');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string   $name         Required. the name of the application to retrieve.
     *                               Format:
     *                               "projects/{project}/locations/{location}/applications/{application}"
     * @param string[] $instanceIds  Required. Id of the requesting object.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApplicationInstances($name, $instanceIds, array $optionalArgs = [])
    {
        $request = new DeleteApplicationInstancesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setInstanceIds($instanceIds);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteApplicationInstances', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Draft.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->draftName('[PROJECT]', '[LOCATION]', '[APPLICATION]', '[DRAFT]');
     *     $operationResponse = $appPlatformClient->deleteDraft($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->deleteDraft($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'deleteDraft');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDraft($name, array $optionalArgs = [])
    {
        $request = new DeleteDraftRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteDraft', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Processor.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $operationResponse = $appPlatformClient->deleteProcessor($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->deleteProcessor($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'deleteProcessor');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteProcessor($name, array $optionalArgs = [])
    {
        $request = new DeleteProcessorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteProcessor', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deploys a single Application.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $operationResponse = $appPlatformClient->deployApplication($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->deployApplication($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'deployApplication');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. the name of the application to retrieve.
     *                             Format:
     *                             "projects/{project}/locations/{location}/applications/{application}"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, validate the request and preview the application graph, but do not
     *           actually deploy it.
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $enableMonitoring
     *           Optional. Whether or not to enable monitoring for the application on
     *           deployment.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployApplication($name, array $optionalArgs = [])
    {
        $request = new DeployApplicationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['enableMonitoring'])) {
            $request->setEnableMonitoring($optionalArgs['enableMonitoring']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeployApplication', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets details of a single Application.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $response = $appPlatformClient->getApplication($formattedName);
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Application
     *
     * @throws ApiException if the remote call fails
     */
    public function getApplication($name, array $optionalArgs = [])
    {
        $request = new GetApplicationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetApplication', Application::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Draft.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->draftName('[PROJECT]', '[LOCATION]', '[APPLICATION]', '[DRAFT]');
     *     $response = $appPlatformClient->getDraft($formattedName);
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Draft
     *
     * @throws ApiException if the remote call fails
     */
    public function getDraft($name, array $optionalArgs = [])
    {
        $request = new GetDraftRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDraft', Draft::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Instance.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->instanceName('[PROJECT]', '[LOCATION]', '[APPLICATION]', '[INSTANCE]');
     *     $response = $appPlatformClient->getInstance($formattedName);
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Instance
     *
     * @throws ApiException if the remote call fails
     */
    public function getInstance($name, array $optionalArgs = [])
    {
        $request = new GetInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetInstance', Instance::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single Processor.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $response = $appPlatformClient->getProcessor($formattedName);
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\Processor
     *
     * @throws ApiException if the remote call fails
     */
    public function getProcessor($name, array $optionalArgs = [])
    {
        $request = new GetProcessorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetProcessor', Processor::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists Applications in a given project and location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $appPlatformClient->listApplications($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $appPlatformClient->listApplications($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListApplicationsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApplications($parent, array $optionalArgs = [])
    {
        $request = new ListApplicationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListApplications', $optionalArgs, ListApplicationsResponse::class, $request);
    }

    /**
     * Lists Drafts in a given project and location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $appPlatformClient->listDrafts($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $appPlatformClient->listDrafts($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListDraftsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDrafts($parent, array $optionalArgs = [])
    {
        $request = new ListDraftsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListDrafts', $optionalArgs, ListDraftsResponse::class, $request);
    }

    /**
     * Lists Instances in a given project and location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $appPlatformClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $appPlatformClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListInstancesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInstances($parent, array $optionalArgs = [])
    {
        $request = new ListInstancesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListInstances', $optionalArgs, ListInstancesResponse::class, $request);
    }

    /**
     * ListPrebuiltProcessors is a custom pass-through verb that Lists Prebuilt
     * Processors.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $appPlatformClient->listPrebuiltProcessors($formattedParent);
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent path.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VisionAI\V1\ListPrebuiltProcessorsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPrebuiltProcessors($parent, array $optionalArgs = [])
    {
        $request = new ListPrebuiltProcessorsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ListPrebuiltProcessors', ListPrebuiltProcessorsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists Processors in a given project and location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedParent = $appPlatformClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $appPlatformClient->listProcessors($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $appPlatformClient->listProcessors($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListProcessorsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results.
     *     @type string $orderBy
     *           Hint for how to order the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProcessors($parent, array $optionalArgs = [])
    {
        $request = new ListProcessorsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListProcessors', $optionalArgs, ListProcessorsResponse::class, $request);
    }

    /**
     * Remove target stream input to the Application, if the Application is
     * deployed, the corresponding instance based will be deleted. If the stream
     * is not in the Application, the RPC will fail.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $operationResponse = $appPlatformClient->removeApplicationStreamInput($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->removeApplicationStreamInput($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'removeApplicationStreamInput');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. the name of the application to retrieve.
     *                             Format:
     *                             "projects/{project}/locations/{location}/applications/{application}"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type TargetStreamInput[] $targetStreamInputs
     *           The target stream to remove.
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function removeApplicationStreamInput($name, array $optionalArgs = [])
    {
        $request = new RemoveApplicationStreamInputRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['targetStreamInputs'])) {
            $request->setTargetStreamInputs($optionalArgs['targetStreamInputs']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RemoveApplicationStreamInput', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Undeploys a single Application.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $operationResponse = $appPlatformClient->undeployApplication($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->undeployApplication($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'undeployApplication');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. the name of the application to retrieve.
     *                             Format:
     *                             "projects/{project}/locations/{location}/applications/{application}"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeployApplication($name, array $optionalArgs = [])
    {
        $request = new UndeployApplicationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UndeployApplication', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Application.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $application = new Application();
     *     $operationResponse = $appPlatformClient->updateApplication($application);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->updateApplication($application);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'updateApplication');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param Application $application  Required. The resource being updated.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           Application resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateApplication($application, array $optionalArgs = [])
    {
        $request = new UpdateApplicationRequest();
        $requestParamHeaders = [];
        $request->setApplication($application);
        $requestParamHeaders['application.name'] = $application->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateApplication', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Adds target stream input to the Application.
     * If the Application is deployed, the corresponding new Application instance
     * will be created. If the stream has already been in the Application, the RPC
     * will fail.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $operationResponse = $appPlatformClient->updateApplicationInstances($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->updateApplicationInstances($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'updateApplicationInstances');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. the name of the application to retrieve.
     *                             Format:
     *                             "projects/{project}/locations/{location}/applications/{application}"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type UpdateApplicationInstance[] $applicationInstances
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $allowMissing
     *           If true, Update Request will create one resource if the target resource
     *           doesn't exist, this time, the field_mask will be ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateApplicationInstances($name, array $optionalArgs = [])
    {
        $request = new UpdateApplicationInstancesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['applicationInstances'])) {
            $request->setApplicationInstances($optionalArgs['applicationInstances']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateApplicationInstances', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Update target stream input to the Application, if the Application is
     * deployed, the corresponding instance based will be deployed. For
     * CreateOrUpdate behavior, set allow_missing to true.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $formattedName = $appPlatformClient->applicationName('[PROJECT]', '[LOCATION]', '[APPLICATION]');
     *     $operationResponse = $appPlatformClient->updateApplicationStreamInput($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->updateApplicationStreamInput($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'updateApplicationStreamInput');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. the name of the application to retrieve.
     *                             Format:
     *                             "projects/{project}/locations/{location}/applications/{application}"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type ApplicationStreamInput[] $applicationStreamInputs
     *           The stream inputs to update, the stream resource name is the key of each
     *           StreamInput, and it must be unique within each application.
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $allowMissing
     *           If true, UpdateApplicationStreamInput will insert stream input to
     *           application even if the target stream is not included in the application.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateApplicationStreamInput($name, array $optionalArgs = [])
    {
        $request = new UpdateApplicationStreamInputRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['applicationStreamInputs'])) {
            $request->setApplicationStreamInputs($optionalArgs['applicationStreamInputs']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateApplicationStreamInput', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Draft.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $draft = new Draft();
     *     $operationResponse = $appPlatformClient->updateDraft($draft);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->updateDraft($draft);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'updateDraft');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param Draft $draft        Required. The resource being updated.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           Draft resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $allowMissing
     *           If true, UpdateDraftRequest will create one resource if the target resource
     *           doesn't exist, this time, the field_mask will be ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDraft($draft, array $optionalArgs = [])
    {
        $request = new UpdateDraftRequest();
        $requestParamHeaders = [];
        $request->setDraft($draft);
        $requestParamHeaders['draft.name'] = $draft->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateDraft', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single Processor.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $processor = new Processor();
     *     $operationResponse = $appPlatformClient->updateProcessor($processor);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $appPlatformClient->updateProcessor($processor);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $appPlatformClient->resumeOperation($operationName, 'updateProcessor');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param Processor $processor    Required. The resource being updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           Processor resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateProcessor($processor, array $optionalArgs = [])
    {
        $request = new UpdateProcessorRequest();
        $requestParamHeaders = [];
        $request->setProcessor($processor);
        $requestParamHeaders['processor.name'] = $processor->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateProcessor', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     $response = $appPlatformClient->getLocation();
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $appPlatformClient = new AppPlatformClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $appPlatformClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $appPlatformClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $appPlatformClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
