<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/warehouse.proto

namespace Google\Cloud\VisionAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Central configuration for a facet.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.FacetProperty</code>
 */
class FacetProperty extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the facets, which are the dimensions users want to use to refine
     * search results. `mapped_fields` will match UserSpecifiedDataSchema keys.
     * For example, user can add a bunch of UGAs with the same key, such as
     * player:adam, player:bob, player:charles. When multiple mapped_fields are
     * specified, will merge their value together as final facet value. E.g.
     * home_team: a, home_team:b, away_team:a, away_team:c, when facet_field =
     * [home_team, away_team], facet_value will be [a, b, c].
     * UNLESS this is a 1:1 facet dimension (mapped_fields.size() == 1) AND the
     * mapped_field equals the parent SearchConfig.name, the parent must
     * also contain a SearchCriteriaProperty that maps to the same fields.
     * mapped_fields must not be empty.
     *
     * Generated from protobuf field <code>repeated string mapped_fields = 1;</code>
     */
    private $mapped_fields;
    /**
     * Display name of the facet. To be used by UI for facet rendering.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * Maximum number of unique bucket to return for one facet. Bucket number can
     * be large for high-cardinality facet such as "player". We only return top-n
     * most related ones to user. If it's <= 0, the server will decide the
     * appropriate result_size.
     *
     * Generated from protobuf field <code>int64 result_size = 3;</code>
     */
    protected $result_size = 0;
    /**
     * Facet bucket type e.g. value, range.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetBucketType bucket_type = 4;</code>
     */
    protected $bucket_type = 0;
    protected $range_facet_config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\VisionAI\V1\FacetProperty\FixedRangeBucketSpec $fixed_range_bucket_spec
     *           Fixed range facet bucket config.
     *     @type \Google\Cloud\VisionAI\V1\FacetProperty\CustomRangeBucketSpec $custom_range_bucket_spec
     *           Custom range facet bucket config.
     *     @type \Google\Cloud\VisionAI\V1\FacetProperty\DateTimeBucketSpec $datetime_bucket_spec
     *           Datetime range facet bucket config.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $mapped_fields
     *           Name of the facets, which are the dimensions users want to use to refine
     *           search results. `mapped_fields` will match UserSpecifiedDataSchema keys.
     *           For example, user can add a bunch of UGAs with the same key, such as
     *           player:adam, player:bob, player:charles. When multiple mapped_fields are
     *           specified, will merge their value together as final facet value. E.g.
     *           home_team: a, home_team:b, away_team:a, away_team:c, when facet_field =
     *           [home_team, away_team], facet_value will be [a, b, c].
     *           UNLESS this is a 1:1 facet dimension (mapped_fields.size() == 1) AND the
     *           mapped_field equals the parent SearchConfig.name, the parent must
     *           also contain a SearchCriteriaProperty that maps to the same fields.
     *           mapped_fields must not be empty.
     *     @type string $display_name
     *           Display name of the facet. To be used by UI for facet rendering.
     *     @type int|string $result_size
     *           Maximum number of unique bucket to return for one facet. Bucket number can
     *           be large for high-cardinality facet such as "player". We only return top-n
     *           most related ones to user. If it's <= 0, the server will decide the
     *           appropriate result_size.
     *     @type int $bucket_type
     *           Facet bucket type e.g. value, range.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Warehouse::initOnce();
        parent::__construct($data);
    }

    /**
     * Fixed range facet bucket config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetProperty.FixedRangeBucketSpec fixed_range_bucket_spec = 5;</code>
     * @return \Google\Cloud\VisionAI\V1\FacetProperty\FixedRangeBucketSpec|null
     */
    public function getFixedRangeBucketSpec()
    {
        return $this->readOneof(5);
    }

    public function hasFixedRangeBucketSpec()
    {
        return $this->hasOneof(5);
    }

    /**
     * Fixed range facet bucket config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetProperty.FixedRangeBucketSpec fixed_range_bucket_spec = 5;</code>
     * @param \Google\Cloud\VisionAI\V1\FacetProperty\FixedRangeBucketSpec $var
     * @return $this
     */
    public function setFixedRangeBucketSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\FacetProperty\FixedRangeBucketSpec::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Custom range facet bucket config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetProperty.CustomRangeBucketSpec custom_range_bucket_spec = 6;</code>
     * @return \Google\Cloud\VisionAI\V1\FacetProperty\CustomRangeBucketSpec|null
     */
    public function getCustomRangeBucketSpec()
    {
        return $this->readOneof(6);
    }

    public function hasCustomRangeBucketSpec()
    {
        return $this->hasOneof(6);
    }

    /**
     * Custom range facet bucket config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetProperty.CustomRangeBucketSpec custom_range_bucket_spec = 6;</code>
     * @param \Google\Cloud\VisionAI\V1\FacetProperty\CustomRangeBucketSpec $var
     * @return $this
     */
    public function setCustomRangeBucketSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\FacetProperty\CustomRangeBucketSpec::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Datetime range facet bucket config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetProperty.DateTimeBucketSpec datetime_bucket_spec = 7;</code>
     * @return \Google\Cloud\VisionAI\V1\FacetProperty\DateTimeBucketSpec|null
     */
    public function getDatetimeBucketSpec()
    {
        return $this->readOneof(7);
    }

    public function hasDatetimeBucketSpec()
    {
        return $this->hasOneof(7);
    }

    /**
     * Datetime range facet bucket config.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetProperty.DateTimeBucketSpec datetime_bucket_spec = 7;</code>
     * @param \Google\Cloud\VisionAI\V1\FacetProperty\DateTimeBucketSpec $var
     * @return $this
     */
    public function setDatetimeBucketSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\FacetProperty\DateTimeBucketSpec::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Name of the facets, which are the dimensions users want to use to refine
     * search results. `mapped_fields` will match UserSpecifiedDataSchema keys.
     * For example, user can add a bunch of UGAs with the same key, such as
     * player:adam, player:bob, player:charles. When multiple mapped_fields are
     * specified, will merge their value together as final facet value. E.g.
     * home_team: a, home_team:b, away_team:a, away_team:c, when facet_field =
     * [home_team, away_team], facet_value will be [a, b, c].
     * UNLESS this is a 1:1 facet dimension (mapped_fields.size() == 1) AND the
     * mapped_field equals the parent SearchConfig.name, the parent must
     * also contain a SearchCriteriaProperty that maps to the same fields.
     * mapped_fields must not be empty.
     *
     * Generated from protobuf field <code>repeated string mapped_fields = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMappedFields()
    {
        return $this->mapped_fields;
    }

    /**
     * Name of the facets, which are the dimensions users want to use to refine
     * search results. `mapped_fields` will match UserSpecifiedDataSchema keys.
     * For example, user can add a bunch of UGAs with the same key, such as
     * player:adam, player:bob, player:charles. When multiple mapped_fields are
     * specified, will merge their value together as final facet value. E.g.
     * home_team: a, home_team:b, away_team:a, away_team:c, when facet_field =
     * [home_team, away_team], facet_value will be [a, b, c].
     * UNLESS this is a 1:1 facet dimension (mapped_fields.size() == 1) AND the
     * mapped_field equals the parent SearchConfig.name, the parent must
     * also contain a SearchCriteriaProperty that maps to the same fields.
     * mapped_fields must not be empty.
     *
     * Generated from protobuf field <code>repeated string mapped_fields = 1;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMappedFields($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->mapped_fields = $arr;

        return $this;
    }

    /**
     * Display name of the facet. To be used by UI for facet rendering.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Display name of the facet. To be used by UI for facet rendering.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Maximum number of unique bucket to return for one facet. Bucket number can
     * be large for high-cardinality facet such as "player". We only return top-n
     * most related ones to user. If it's <= 0, the server will decide the
     * appropriate result_size.
     *
     * Generated from protobuf field <code>int64 result_size = 3;</code>
     * @return int|string
     */
    public function getResultSize()
    {
        return $this->result_size;
    }

    /**
     * Maximum number of unique bucket to return for one facet. Bucket number can
     * be large for high-cardinality facet such as "player". We only return top-n
     * most related ones to user. If it's <= 0, the server will decide the
     * appropriate result_size.
     *
     * Generated from protobuf field <code>int64 result_size = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setResultSize($var)
    {
        GPBUtil::checkInt64($var);
        $this->result_size = $var;

        return $this;
    }

    /**
     * Facet bucket type e.g. value, range.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetBucketType bucket_type = 4;</code>
     * @return int
     */
    public function getBucketType()
    {
        return $this->bucket_type;
    }

    /**
     * Facet bucket type e.g. value, range.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.FacetBucketType bucket_type = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setBucketType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VisionAI\V1\FacetBucketType::class);
        $this->bucket_type = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getRangeFacetConfig()
    {
        return $this->whichOneof("range_facet_config");
    }

}

