<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/warehouse.proto

namespace Google\Cloud\VisionAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Corpus is a set of media contents for management.
 * Within a corpus, media shares the same data schema. Search is also restricted
 * within a single corpus.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.Corpus</code>
 */
class Corpus extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource name of the corpus.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The corpus name to shown in the UI. The name can be up to 32
     * characters long.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Optional. Description of the corpus. Can be up to 25000 characters long.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. The default TTL value for all assets under the corpus without a
     * asset level user-defined TTL. For STREAM_VIDEO type corpora, this is
     * required and the maximum allowed
     *   default_ttl is 10 years.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration default_ttl = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $default_ttl = null;
    /**
     * Optional. Type of the asset inside corpus.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Corpus.Type type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $type = 0;
    /**
     * Default search capability setting on corpus level.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.SearchCapabilitySetting search_capability_setting = 8;</code>
     */
    protected $search_capability_setting = null;
    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Separation enabled via an Org Policy constraint. It is set to true
     * when the corpus is a valid zone separated corpus and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = null;
    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Isolation enabled via an Org Policy constraint. It is set to true when
     * the corpus is a valid zone isolated corpus and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Resource name of the corpus.
     *           Format:
     *           `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     *     @type string $display_name
     *           Required. The corpus name to shown in the UI. The name can be up to 32
     *           characters long.
     *     @type string $description
     *           Optional. Description of the corpus. Can be up to 25000 characters long.
     *     @type \Google\Protobuf\Duration $default_ttl
     *           Optional. The default TTL value for all assets under the corpus without a
     *           asset level user-defined TTL. For STREAM_VIDEO type corpora, this is
     *           required and the maximum allowed
     *             default_ttl is 10 years.
     *     @type int $type
     *           Optional. Type of the asset inside corpus.
     *     @type \Google\Cloud\VisionAI\V1\SearchCapabilitySetting $search_capability_setting
     *           Default search capability setting on corpus level.
     *     @type bool $satisfies_pzs
     *           Output only. This boolean field is only set for projects that have Physical
     *           Zone Separation enabled via an Org Policy constraint. It is set to true
     *           when the corpus is a valid zone separated corpus and false if it isn't.
     *     @type bool $satisfies_pzi
     *           Output only. This boolean field is only set for projects that have Physical
     *           Zone Isolation enabled via an Org Policy constraint. It is set to true when
     *           the corpus is a valid zone isolated corpus and false if it isn't.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Warehouse::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name of the corpus.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Resource name of the corpus.
     * Format:
     * `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The corpus name to shown in the UI. The name can be up to 32
     * characters long.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The corpus name to shown in the UI. The name can be up to 32
     * characters long.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. Description of the corpus. Can be up to 25000 characters long.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. Description of the corpus. Can be up to 25000 characters long.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. The default TTL value for all assets under the corpus without a
     * asset level user-defined TTL. For STREAM_VIDEO type corpora, this is
     * required and the maximum allowed
     *   default_ttl is 10 years.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration default_ttl = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getDefaultTtl()
    {
        return $this->default_ttl;
    }

    public function hasDefaultTtl()
    {
        return isset($this->default_ttl);
    }

    public function clearDefaultTtl()
    {
        unset($this->default_ttl);
    }

    /**
     * Optional. The default TTL value for all assets under the corpus without a
     * asset level user-defined TTL. For STREAM_VIDEO type corpora, this is
     * required and the maximum allowed
     *   default_ttl is 10 years.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration default_ttl = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setDefaultTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->default_ttl = $var;

        return $this;
    }

    /**
     * Optional. Type of the asset inside corpus.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Corpus.Type type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Optional. Type of the asset inside corpus.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.Corpus.Type type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VisionAI\V1\Corpus\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Default search capability setting on corpus level.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.SearchCapabilitySetting search_capability_setting = 8;</code>
     * @return \Google\Cloud\VisionAI\V1\SearchCapabilitySetting|null
     */
    public function getSearchCapabilitySetting()
    {
        return $this->search_capability_setting;
    }

    public function hasSearchCapabilitySetting()
    {
        return isset($this->search_capability_setting);
    }

    public function clearSearchCapabilitySetting()
    {
        unset($this->search_capability_setting);
    }

    /**
     * Default search capability setting on corpus level.
     *
     * Generated from protobuf field <code>.google.cloud.visionai.v1.SearchCapabilitySetting search_capability_setting = 8;</code>
     * @param \Google\Cloud\VisionAI\V1\SearchCapabilitySetting $var
     * @return $this
     */
    public function setSearchCapabilitySetting($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VisionAI\V1\SearchCapabilitySetting::class);
        $this->search_capability_setting = $var;

        return $this;
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Separation enabled via an Org Policy constraint. It is set to true
     * when the corpus is a valid zone separated corpus and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Separation enabled via an Org Policy constraint. It is set to true
     * when the corpus is a valid zone separated corpus and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Isolation enabled via an Org Policy constraint. It is set to true when
     * the corpus is a valid zone isolated corpus and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return isset($this->satisfies_pzi) ? $this->satisfies_pzi : false;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Output only. This boolean field is only set for projects that have Physical
     * Zone Isolation enabled via an Org Policy constraint. It is set to true when
     * the corpus is a valid zone isolated corpus and false if it isn't.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

}

