<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/visionai/v1/platform.proto

namespace Google\Cloud\VisionAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message of configurations for BigQuery processor.
 *
 * Generated from protobuf message <code>google.cloud.visionai.v1.BigQueryConfig</code>
 */
class BigQueryConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * BigQuery table resource for Vision AI Platform to ingest annotations to.
     *
     * Generated from protobuf field <code>string table = 1;</code>
     */
    protected $table = '';
    /**
     * Data Schema
     * By default, Vision AI Application will try to write annotations to the
     * target BigQuery table using the following schema:
     * ingestion_time: TIMESTAMP, the ingestion time of the original data.
     * application: STRING, name of the application which produces the annotation.
     * instance: STRING, Id of the instance which produces the annotation.
     * node: STRING, name of the application graph node which produces the
     * annotation.
     * annotation: STRING or JSON, the actual annotation protobuf will be
     * converted to json string with bytes field as 64 encoded string. It can be
     * written to both String or Json type column.
     * To forward annotation data to an existing BigQuery table, customer needs to
     * make sure the compatibility of the schema.
     * The map maps application node name to its corresponding cloud function
     * endpoint to transform the annotations directly to the
     * google.cloud.bigquery.storage.v1.AppendRowsRequest (only avro_rows or
     * proto_rows should be set). If configured, annotations produced by
     * corresponding application node will sent to the Cloud Function at first
     * before be forwarded to BigQuery.
     * If the default table schema doesn't fit, customer is able to transform the
     * annotation output from Vision AI Application to arbitrary BigQuery table
     * schema with CloudFunction.
     * * The cloud function will receive AppPlatformCloudFunctionRequest where
     * the annotations field will be the json format of Vision AI annotation.
     * * The cloud function should return AppPlatformCloudFunctionResponse with
     * AppendRowsRequest stored in the annotations field.
     * * To drop the annotation, simply clear the annotations field in the
     * returned AppPlatformCloudFunctionResponse.
     *
     * Generated from protobuf field <code>map<string, string> cloud_function_mapping = 2;</code>
     */
    private $cloud_function_mapping;
    /**
     * If true, App Platform will create the BigQuery DataSet and the
     * BigQuery Table with default schema if the specified table doesn't exist.
     * This doesn't work if any cloud function customized schema is specified
     * since the system doesn't know your desired schema.
     * JSON column will be used in the default table created by App Platform.
     *
     * Generated from protobuf field <code>bool create_default_table_if_not_exists = 3;</code>
     */
    protected $create_default_table_if_not_exists = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $table
     *           BigQuery table resource for Vision AI Platform to ingest annotations to.
     *     @type array|\Google\Protobuf\Internal\MapField $cloud_function_mapping
     *           Data Schema
     *           By default, Vision AI Application will try to write annotations to the
     *           target BigQuery table using the following schema:
     *           ingestion_time: TIMESTAMP, the ingestion time of the original data.
     *           application: STRING, name of the application which produces the annotation.
     *           instance: STRING, Id of the instance which produces the annotation.
     *           node: STRING, name of the application graph node which produces the
     *           annotation.
     *           annotation: STRING or JSON, the actual annotation protobuf will be
     *           converted to json string with bytes field as 64 encoded string. It can be
     *           written to both String or Json type column.
     *           To forward annotation data to an existing BigQuery table, customer needs to
     *           make sure the compatibility of the schema.
     *           The map maps application node name to its corresponding cloud function
     *           endpoint to transform the annotations directly to the
     *           google.cloud.bigquery.storage.v1.AppendRowsRequest (only avro_rows or
     *           proto_rows should be set). If configured, annotations produced by
     *           corresponding application node will sent to the Cloud Function at first
     *           before be forwarded to BigQuery.
     *           If the default table schema doesn't fit, customer is able to transform the
     *           annotation output from Vision AI Application to arbitrary BigQuery table
     *           schema with CloudFunction.
     *           * The cloud function will receive AppPlatformCloudFunctionRequest where
     *           the annotations field will be the json format of Vision AI annotation.
     *           * The cloud function should return AppPlatformCloudFunctionResponse with
     *           AppendRowsRequest stored in the annotations field.
     *           * To drop the annotation, simply clear the annotations field in the
     *           returned AppPlatformCloudFunctionResponse.
     *     @type bool $create_default_table_if_not_exists
     *           If true, App Platform will create the BigQuery DataSet and the
     *           BigQuery Table with default schema if the specified table doesn't exist.
     *           This doesn't work if any cloud function customized schema is specified
     *           since the system doesn't know your desired schema.
     *           JSON column will be used in the default table created by App Platform.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Visionai\V1\Platform::initOnce();
        parent::__construct($data);
    }

    /**
     * BigQuery table resource for Vision AI Platform to ingest annotations to.
     *
     * Generated from protobuf field <code>string table = 1;</code>
     * @return string
     */
    public function getTable()
    {
        return $this->table;
    }

    /**
     * BigQuery table resource for Vision AI Platform to ingest annotations to.
     *
     * Generated from protobuf field <code>string table = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setTable($var)
    {
        GPBUtil::checkString($var, True);
        $this->table = $var;

        return $this;
    }

    /**
     * Data Schema
     * By default, Vision AI Application will try to write annotations to the
     * target BigQuery table using the following schema:
     * ingestion_time: TIMESTAMP, the ingestion time of the original data.
     * application: STRING, name of the application which produces the annotation.
     * instance: STRING, Id of the instance which produces the annotation.
     * node: STRING, name of the application graph node which produces the
     * annotation.
     * annotation: STRING or JSON, the actual annotation protobuf will be
     * converted to json string with bytes field as 64 encoded string. It can be
     * written to both String or Json type column.
     * To forward annotation data to an existing BigQuery table, customer needs to
     * make sure the compatibility of the schema.
     * The map maps application node name to its corresponding cloud function
     * endpoint to transform the annotations directly to the
     * google.cloud.bigquery.storage.v1.AppendRowsRequest (only avro_rows or
     * proto_rows should be set). If configured, annotations produced by
     * corresponding application node will sent to the Cloud Function at first
     * before be forwarded to BigQuery.
     * If the default table schema doesn't fit, customer is able to transform the
     * annotation output from Vision AI Application to arbitrary BigQuery table
     * schema with CloudFunction.
     * * The cloud function will receive AppPlatformCloudFunctionRequest where
     * the annotations field will be the json format of Vision AI annotation.
     * * The cloud function should return AppPlatformCloudFunctionResponse with
     * AppendRowsRequest stored in the annotations field.
     * * To drop the annotation, simply clear the annotations field in the
     * returned AppPlatformCloudFunctionResponse.
     *
     * Generated from protobuf field <code>map<string, string> cloud_function_mapping = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getCloudFunctionMapping()
    {
        return $this->cloud_function_mapping;
    }

    /**
     * Data Schema
     * By default, Vision AI Application will try to write annotations to the
     * target BigQuery table using the following schema:
     * ingestion_time: TIMESTAMP, the ingestion time of the original data.
     * application: STRING, name of the application which produces the annotation.
     * instance: STRING, Id of the instance which produces the annotation.
     * node: STRING, name of the application graph node which produces the
     * annotation.
     * annotation: STRING or JSON, the actual annotation protobuf will be
     * converted to json string with bytes field as 64 encoded string. It can be
     * written to both String or Json type column.
     * To forward annotation data to an existing BigQuery table, customer needs to
     * make sure the compatibility of the schema.
     * The map maps application node name to its corresponding cloud function
     * endpoint to transform the annotations directly to the
     * google.cloud.bigquery.storage.v1.AppendRowsRequest (only avro_rows or
     * proto_rows should be set). If configured, annotations produced by
     * corresponding application node will sent to the Cloud Function at first
     * before be forwarded to BigQuery.
     * If the default table schema doesn't fit, customer is able to transform the
     * annotation output from Vision AI Application to arbitrary BigQuery table
     * schema with CloudFunction.
     * * The cloud function will receive AppPlatformCloudFunctionRequest where
     * the annotations field will be the json format of Vision AI annotation.
     * * The cloud function should return AppPlatformCloudFunctionResponse with
     * AppendRowsRequest stored in the annotations field.
     * * To drop the annotation, simply clear the annotations field in the
     * returned AppPlatformCloudFunctionResponse.
     *
     * Generated from protobuf field <code>map<string, string> cloud_function_mapping = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setCloudFunctionMapping($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->cloud_function_mapping = $arr;

        return $this;
    }

    /**
     * If true, App Platform will create the BigQuery DataSet and the
     * BigQuery Table with default schema if the specified table doesn't exist.
     * This doesn't work if any cloud function customized schema is specified
     * since the system doesn't know your desired schema.
     * JSON column will be used in the default table created by App Platform.
     *
     * Generated from protobuf field <code>bool create_default_table_if_not_exists = 3;</code>
     * @return bool
     */
    public function getCreateDefaultTableIfNotExists()
    {
        return $this->create_default_table_if_not_exists;
    }

    /**
     * If true, App Platform will create the BigQuery DataSet and the
     * BigQuery Table with default schema if the specified table doesn't exist.
     * This doesn't work if any cloud function customized schema is specified
     * since the system doesn't know your desired schema.
     * JSON column will be used in the default table created by App Platform.
     *
     * Generated from protobuf field <code>bool create_default_table_if_not_exists = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setCreateDefaultTableIfNotExists($var)
    {
        GPBUtil::checkBool($var);
        $this->create_default_table_if_not_exists = $var;

        return $this;
    }

}

