<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vectorsearch/v1/data_object_search_service.proto

namespace Google\Cloud\VectorSearch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines a search operation using a query vector.
 *
 * Generated from protobuf message <code>google.cloud.vectorsearch.v1.VectorSearch</code>
 */
class VectorSearch extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The vector field to search.
     *
     * Generated from protobuf field <code>string search_field = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $search_field = '';
    /**
     * Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
     * represented as a google.protobuf.Struct.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $filter = null;
    /**
     * Optional. The number of nearest neighbors to return.
     *
     * Generated from protobuf field <code>optional int32 top_k = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $top_k = null;
    /**
     * Optional. Mask specifying which fields to return.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.OutputFields output_fields = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $output_fields = null;
    /**
     * Optional. Sets the search hint. If no strategy is specified, the service
     * will use an index if one is available, and fall back to the default KNN
     * search otherwise.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.SearchHint search_hint = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $search_hint = null;
    /**
     * Optional. The distance metric to use for the KNN search. If not specified,
     * DOT_PRODUCT will be used as the default.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DistanceMetric distance_metric = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $distance_metric = 0;
    protected $vector_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\VectorSearch\V1\DenseVector $vector
     *           A dense vector for the query.
     *     @type \Google\Cloud\VectorSearch\V1\SparseVector $sparse_vector
     *           A sparse vector for the query.
     *     @type string $search_field
     *           Required. The vector field to search.
     *     @type \Google\Protobuf\Struct $filter
     *           Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
     *           represented as a google.protobuf.Struct.
     *     @type int $top_k
     *           Optional. The number of nearest neighbors to return.
     *     @type \Google\Cloud\VectorSearch\V1\OutputFields $output_fields
     *           Optional. Mask specifying which fields to return.
     *     @type \Google\Cloud\VectorSearch\V1\SearchHint $search_hint
     *           Optional. Sets the search hint. If no strategy is specified, the service
     *           will use an index if one is available, and fall back to the default KNN
     *           search otherwise.
     *     @type int $distance_metric
     *           Optional. The distance metric to use for the KNN search. If not specified,
     *           DOT_PRODUCT will be used as the default.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vectorsearch\V1\DataObjectSearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * A dense vector for the query.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DenseVector vector = 1;</code>
     * @return \Google\Cloud\VectorSearch\V1\DenseVector|null
     */
    public function getVector()
    {
        return $this->readOneof(1);
    }

    public function hasVector()
    {
        return $this->hasOneof(1);
    }

    /**
     * A dense vector for the query.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DenseVector vector = 1;</code>
     * @param \Google\Cloud\VectorSearch\V1\DenseVector $var
     * @return $this
     */
    public function setVector($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VectorSearch\V1\DenseVector::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * A sparse vector for the query.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.SparseVector sparse_vector = 2;</code>
     * @return \Google\Cloud\VectorSearch\V1\SparseVector|null
     */
    public function getSparseVector()
    {
        return $this->readOneof(2);
    }

    public function hasSparseVector()
    {
        return $this->hasOneof(2);
    }

    /**
     * A sparse vector for the query.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.SparseVector sparse_vector = 2;</code>
     * @param \Google\Cloud\VectorSearch\V1\SparseVector $var
     * @return $this
     */
    public function setSparseVector($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VectorSearch\V1\SparseVector::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Required. The vector field to search.
     *
     * Generated from protobuf field <code>string search_field = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSearchField()
    {
        return $this->search_field;
    }

    /**
     * Required. The vector field to search.
     *
     * Generated from protobuf field <code>string search_field = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSearchField($var)
    {
        GPBUtil::checkString($var, True);
        $this->search_field = $var;

        return $this;
    }

    /**
     * Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
     * represented as a google.protobuf.Struct.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getFilter()
    {
        return $this->filter;
    }

    public function hasFilter()
    {
        return isset($this->filter);
    }

    public function clearFilter()
    {
        unset($this->filter);
    }

    /**
     * Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
     * represented as a google.protobuf.Struct.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->filter = $var;

        return $this;
    }

    /**
     * Optional. The number of nearest neighbors to return.
     *
     * Generated from protobuf field <code>optional int32 top_k = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getTopK()
    {
        return isset($this->top_k) ? $this->top_k : 0;
    }

    public function hasTopK()
    {
        return isset($this->top_k);
    }

    public function clearTopK()
    {
        unset($this->top_k);
    }

    /**
     * Optional. The number of nearest neighbors to return.
     *
     * Generated from protobuf field <code>optional int32 top_k = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setTopK($var)
    {
        GPBUtil::checkInt32($var);
        $this->top_k = $var;

        return $this;
    }

    /**
     * Optional. Mask specifying which fields to return.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.OutputFields output_fields = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\VectorSearch\V1\OutputFields|null
     */
    public function getOutputFields()
    {
        return $this->output_fields;
    }

    public function hasOutputFields()
    {
        return isset($this->output_fields);
    }

    public function clearOutputFields()
    {
        unset($this->output_fields);
    }

    /**
     * Optional. Mask specifying which fields to return.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.OutputFields output_fields = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\VectorSearch\V1\OutputFields $var
     * @return $this
     */
    public function setOutputFields($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VectorSearch\V1\OutputFields::class);
        $this->output_fields = $var;

        return $this;
    }

    /**
     * Optional. Sets the search hint. If no strategy is specified, the service
     * will use an index if one is available, and fall back to the default KNN
     * search otherwise.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.SearchHint search_hint = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\VectorSearch\V1\SearchHint|null
     */
    public function getSearchHint()
    {
        return $this->search_hint;
    }

    public function hasSearchHint()
    {
        return isset($this->search_hint);
    }

    public function clearSearchHint()
    {
        unset($this->search_hint);
    }

    /**
     * Optional. Sets the search hint. If no strategy is specified, the service
     * will use an index if one is available, and fall back to the default KNN
     * search otherwise.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.SearchHint search_hint = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\VectorSearch\V1\SearchHint $var
     * @return $this
     */
    public function setSearchHint($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VectorSearch\V1\SearchHint::class);
        $this->search_hint = $var;

        return $this;
    }

    /**
     * Optional. The distance metric to use for the KNN search. If not specified,
     * DOT_PRODUCT will be used as the default.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DistanceMetric distance_metric = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDistanceMetric()
    {
        return $this->distance_metric;
    }

    /**
     * Optional. The distance metric to use for the KNN search. If not specified,
     * DOT_PRODUCT will be used as the default.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DistanceMetric distance_metric = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDistanceMetric($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VectorSearch\V1\DistanceMetric::class);
        $this->distance_metric = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getVectorType()
    {
        return $this->whichOneof("vector_type");
    }

}

