<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vectorsearch/v1/vectorsearch_service.proto

namespace Google\Cloud\VectorSearch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message for creating an Index.
 *
 * Generated from protobuf message <code>google.cloud.vectorsearch.v1.CreateIndexRequest</code>
 */
class CreateIndexRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Collection for which to create the
     * Index. Format:
     * `projects/{project}/locations/{location}/collections/{collection}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. ID of the Index to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string index_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $index_id = '';
    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.Index index = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $index = null;
    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     */
    protected $request_id = '';

    /**
     * @param string                              $parent  Required. The resource name of the Collection for which to create the
     *                                                     Index. Format:
     *                                                     `projects/{project}/locations/{location}/collections/{collection}`
     *                                                     Please see {@see VectorSearchServiceClient::collectionName()} for help formatting this field.
     * @param \Google\Cloud\VectorSearch\V1\Index $index   Required. The resource being created
     * @param string                              $indexId Required. ID of the Index to create.
     *                                                     The id must be 1-63 characters long, and comply with
     *                                                     [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     *                                                     Specifically, it must be 1-63 characters long and match the regular
     *                                                     expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * @return \Google\Cloud\VectorSearch\V1\CreateIndexRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\VectorSearch\V1\Index $index, string $indexId): self
    {
        return (new self())
            ->setParent($parent)
            ->setIndex($index)
            ->setIndexId($indexId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the Collection for which to create the
     *           Index. Format:
     *           `projects/{project}/locations/{location}/collections/{collection}`
     *     @type string $index_id
     *           Required. ID of the Index to create.
     *           The id must be 1-63 characters long, and comply with
     *           [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     *           Specifically, it must be 1-63 characters long and match the regular
     *           expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *     @type \Google\Cloud\VectorSearch\V1\Index $index
     *           Required. The resource being created
     *     @type string $request_id
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vectorsearch\V1\VectorsearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the Collection for which to create the
     * Index. Format:
     * `projects/{project}/locations/{location}/collections/{collection}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the Collection for which to create the
     * Index. Format:
     * `projects/{project}/locations/{location}/collections/{collection}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. ID of the Index to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string index_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getIndexId()
    {
        return $this->index_id;
    }

    /**
     * Required. ID of the Index to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string index_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setIndexId($var)
    {
        GPBUtil::checkString($var, True);
        $this->index_id = $var;

        return $this;
    }

    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.Index index = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\VectorSearch\V1\Index|null
     */
    public function getIndex()
    {
        return $this->index;
    }

    public function hasIndex()
    {
        return isset($this->index);
    }

    public function clearIndex()
    {
        unset($this->index);
    }

    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.Index index = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\VectorSearch\V1\Index $var
     * @return $this
     */
    public function setIndex($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VectorSearch\V1\Index::class);
        $this->index = $var;

        return $this;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

