<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vectorsearch/v1/data_object_service.proto

namespace Google\Cloud\VectorSearch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [DataObjectService.CreateDataObject][google.cloud.vectorsearch.v1.DataObjectService.CreateDataObject].
 *
 * Generated from protobuf message <code>google.cloud.vectorsearch.v1.CreateDataObjectRequest</code>
 */
class CreateDataObjectRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Collection to create the DataObject in.
     * Format: `projects/{project}/locations/{location}/collections/{collection}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The id of the dataObject to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string data_object_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $data_object_id = '';
    /**
     * Required. The DataObject to create.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DataObject data_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $data_object = null;

    /**
     * @param string                                   $parent       Required. The resource name of the Collection to create the DataObject in.
     *                                                               Format: `projects/{project}/locations/{location}/collections/{collection}`
     *                                                               Please see {@see DataObjectServiceClient::collectionName()} for help formatting this field.
     * @param \Google\Cloud\VectorSearch\V1\DataObject $dataObject   Required. The DataObject to create.
     * @param string                                   $dataObjectId Required. The id of the dataObject to create.
     *                                                               The id must be 1-63 characters long, and comply with
     *                                                               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     *                                                               Specifically, it must be 1-63 characters long and match the regular
     *                                                               expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * @return \Google\Cloud\VectorSearch\V1\CreateDataObjectRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\VectorSearch\V1\DataObject $dataObject, string $dataObjectId): self
    {
        return (new self())
            ->setParent($parent)
            ->setDataObject($dataObject)
            ->setDataObjectId($dataObjectId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the Collection to create the DataObject in.
     *           Format: `projects/{project}/locations/{location}/collections/{collection}`
     *     @type string $data_object_id
     *           Required. The id of the dataObject to create.
     *           The id must be 1-63 characters long, and comply with
     *           [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     *           Specifically, it must be 1-63 characters long and match the regular
     *           expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *     @type \Google\Cloud\VectorSearch\V1\DataObject $data_object
     *           Required. The DataObject to create.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vectorsearch\V1\DataObjectService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the Collection to create the DataObject in.
     * Format: `projects/{project}/locations/{location}/collections/{collection}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the Collection to create the DataObject in.
     * Format: `projects/{project}/locations/{location}/collections/{collection}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The id of the dataObject to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string data_object_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDataObjectId()
    {
        return $this->data_object_id;
    }

    /**
     * Required. The id of the dataObject to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string data_object_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDataObjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_object_id = $var;

        return $this;
    }

    /**
     * Required. The DataObject to create.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DataObject data_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\VectorSearch\V1\DataObject|null
     */
    public function getDataObject()
    {
        return $this->data_object;
    }

    public function hasDataObject()
    {
        return isset($this->data_object);
    }

    public function clearDataObject()
    {
        unset($this->data_object);
    }

    /**
     * Required. The DataObject to create.
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.DataObject data_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\VectorSearch\V1\DataObject $var
     * @return $this
     */
    public function setDataObject($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VectorSearch\V1\DataObject::class);
        $this->data_object = $var;

        return $this;
    }

}

