<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vectorsearch/v1/vectorsearch_service.proto

namespace Google\Cloud\VectorSearch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message for creating a Collection
 *
 * Generated from protobuf message <code>google.cloud.vectorsearch.v1.CreateCollectionRequest</code>
 */
class CreateCollectionRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Value for parent.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. ID of the Collection to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string collection_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $collection_id = '';
    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.Collection collection = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $collection = null;
    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     */
    protected $request_id = '';

    /**
     * @param string                                   $parent       Required. Value for parent. Please see
     *                                                               {@see VectorSearchServiceClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\VectorSearch\V1\Collection $collection   Required. The resource being created
     * @param string                                   $collectionId Required. ID of the Collection to create.
     *                                                               The id must be 1-63 characters long, and comply with
     *                                                               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     *                                                               Specifically, it must be 1-63 characters long and match the regular
     *                                                               expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * @return \Google\Cloud\VectorSearch\V1\CreateCollectionRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\VectorSearch\V1\Collection $collection, string $collectionId): self
    {
        return (new self())
            ->setParent($parent)
            ->setCollection($collection)
            ->setCollectionId($collectionId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. Value for parent.
     *     @type string $collection_id
     *           Required. ID of the Collection to create.
     *           The id must be 1-63 characters long, and comply with
     *           [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     *           Specifically, it must be 1-63 characters long and match the regular
     *           expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *     @type \Google\Cloud\VectorSearch\V1\Collection $collection
     *           Required. The resource being created
     *     @type string $request_id
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vectorsearch\V1\VectorsearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Value for parent.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. Value for parent.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. ID of the Collection to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string collection_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCollectionId()
    {
        return $this->collection_id;
    }

    /**
     * Required. ID of the Collection to create.
     * The id must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Specifically, it must be 1-63 characters long and match the regular
     * expression `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
     *
     * Generated from protobuf field <code>string collection_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCollectionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->collection_id = $var;

        return $this;
    }

    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.Collection collection = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\VectorSearch\V1\Collection|null
     */
    public function getCollection()
    {
        return $this->collection;
    }

    public function hasCollection()
    {
        return isset($this->collection);
    }

    public function clearCollection()
    {
        unset($this->collection);
    }

    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.vectorsearch.v1.Collection collection = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\VectorSearch\V1\Collection $var
     * @return $this
     */
    public function setCollection($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\VectorSearch\V1\Collection::class);
        $this->collection = $var;

        return $this;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

