<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/storageinsights/v1/storageinsights.proto

namespace Google\Cloud\StorageInsights\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message describing the dataset configuration properties. For more
 * information, see [Dataset configuration
 * properties](https://cloud.google.com/storage/docs/insights/datasets#dataset-config).
 *
 * Generated from protobuf message <code>google.cloud.storageinsights.v1.DatasetConfig</code>
 */
class DatasetConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. name of resource
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The UTC time at which the dataset configuration was created.
     * This is auto-populated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The UTC time at which the dataset configuration was last
     * updated. This is auto-populated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Output only. System generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Optional. Organization resource ID that the source projects should belong
     * to. Projects that do not belong to the provided organization are not
     * considered when creating the dataset.
     *
     * Generated from protobuf field <code>int64 organization_number = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $organization_number = 0;
    /**
     * If set to `true`, the request includes all the newly created buckets in the
     * dataset that meet the inclusion and exclusion rules.
     *
     * Generated from protobuf field <code>bool include_newly_created_buckets = 12;</code>
     */
    protected $include_newly_created_buckets = false;
    /**
     * Optional. If set to `false`, then all the permission checks must be
     * successful before the system can start ingesting data. This field can only
     * be updated before the system ingests data for the first time. Any attempt
     * to modify the field after data ingestion starts results in an error.
     *
     * Generated from protobuf field <code>bool skip_verification_and_ingest = 19 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @deprecated
     */
    protected $skip_verification_and_ingest = false;
    /**
     * Number of days of history that must be retained.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 14;</code>
     */
    protected $retention_period_days = 0;
    /**
     * Details of the linked dataset.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.Link link = 15;</code>
     */
    protected $link = null;
    /**
     * Identity used by this `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.Identity identity = 16;</code>
     */
    protected $identity = null;
    /**
     * Output only. Status of the `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $status = null;
    /**
     * Output only. State of the `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.ConfigState dataset_config_state = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $dataset_config_state = 0;
    /**
     * Optional. A user-provided description for the dataset configuration.
     * Maximum length: 256 characters.
     *
     * Generated from protobuf field <code>string description = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    protected $source_options;
    protected $cloud_storage_locations;
    protected $cloud_storage_buckets;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. name of resource
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The UTC time at which the dataset configuration was created.
     *           This is auto-populated.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The UTC time at which the dataset configuration was last
     *           updated. This is auto-populated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels as key value pairs
     *     @type string $uid
     *           Output only. System generated unique identifier for the resource.
     *     @type int|string $organization_number
     *           Optional. Organization resource ID that the source projects should belong
     *           to. Projects that do not belong to the provided organization are not
     *           considered when creating the dataset.
     *     @type \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceProjects $source_projects
     *           Defines the options for providing source projects for the dataset.
     *     @type \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceFolders $source_folders
     *           Defines the options for providing source folders for the dataset.
     *     @type bool $organization_scope
     *           Defines the options for providing a source organization for the dataset.
     *     @type string $cloud_storage_object_path
     *           Input only. Cloud Storage object path containing a list of
     *           project or folder numbers to include in the dataset;
     *           it cannot contain a mix of project and folders.
     *           The object must be a text file where each line has one of the following
     *           entries:
     *           - Project number, formatted as `projects/{project_number}`, for example,
     *           `projects/1234567890`.
     *           - Folder identifier, formatted as `folders/{folder_number}`, for example,
     *           `folders/9876543210`.
     *           Path must be in the format `gs://{bucket_name}/{object_name}`.
     *     @type \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations $include_cloud_storage_locations
     *     @type \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations $exclude_cloud_storage_locations
     *     @type \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets $include_cloud_storage_buckets
     *     @type \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets $exclude_cloud_storage_buckets
     *     @type bool $include_newly_created_buckets
     *           If set to `true`, the request includes all the newly created buckets in the
     *           dataset that meet the inclusion and exclusion rules.
     *     @type bool $skip_verification_and_ingest
     *           Optional. If set to `false`, then all the permission checks must be
     *           successful before the system can start ingesting data. This field can only
     *           be updated before the system ingests data for the first time. Any attempt
     *           to modify the field after data ingestion starts results in an error.
     *     @type int $retention_period_days
     *           Number of days of history that must be retained.
     *     @type \Google\Cloud\StorageInsights\V1\DatasetConfig\Link $link
     *           Details of the linked dataset.
     *     @type \Google\Cloud\StorageInsights\V1\Identity $identity
     *           Identity used by this `datasetConfig`.
     *     @type \Google\Rpc\Status $status
     *           Output only. Status of the `datasetConfig`.
     *     @type int $dataset_config_state
     *           Output only. State of the `datasetConfig`.
     *     @type string $description
     *           Optional. A user-provided description for the dataset configuration.
     *           Maximum length: 256 characters.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Storageinsights\V1\Storageinsights::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. name of resource
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. name of resource
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The UTC time at which the dataset configuration was created.
     * This is auto-populated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The UTC time at which the dataset configuration was created.
     * This is auto-populated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The UTC time at which the dataset configuration was last
     * updated. This is auto-populated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The UTC time at which the dataset configuration was last
     * updated. This is auto-populated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. System generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. System generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Optional. Organization resource ID that the source projects should belong
     * to. Projects that do not belong to the provided organization are not
     * considered when creating the dataset.
     *
     * Generated from protobuf field <code>int64 organization_number = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getOrganizationNumber()
    {
        return $this->organization_number;
    }

    /**
     * Optional. Organization resource ID that the source projects should belong
     * to. Projects that do not belong to the provided organization are not
     * considered when creating the dataset.
     *
     * Generated from protobuf field <code>int64 organization_number = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setOrganizationNumber($var)
    {
        GPBUtil::checkInt64($var);
        $this->organization_number = $var;

        return $this;
    }

    /**
     * Defines the options for providing source projects for the dataset.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.SourceProjects source_projects = 7;</code>
     * @return \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceProjects|null
     */
    public function getSourceProjects()
    {
        return $this->readOneof(7);
    }

    public function hasSourceProjects()
    {
        return $this->hasOneof(7);
    }

    /**
     * Defines the options for providing source projects for the dataset.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.SourceProjects source_projects = 7;</code>
     * @param \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceProjects $var
     * @return $this
     */
    public function setSourceProjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceProjects::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Defines the options for providing source folders for the dataset.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.SourceFolders source_folders = 24;</code>
     * @return \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceFolders|null
     */
    public function getSourceFolders()
    {
        return $this->readOneof(24);
    }

    public function hasSourceFolders()
    {
        return $this->hasOneof(24);
    }

    /**
     * Defines the options for providing source folders for the dataset.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.SourceFolders source_folders = 24;</code>
     * @param \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceFolders $var
     * @return $this
     */
    public function setSourceFolders($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\SourceFolders::class);
        $this->writeOneof(24, $var);

        return $this;
    }

    /**
     * Defines the options for providing a source organization for the dataset.
     *
     * Generated from protobuf field <code>bool organization_scope = 25;</code>
     * @return bool
     */
    public function getOrganizationScope()
    {
        return $this->readOneof(25);
    }

    public function hasOrganizationScope()
    {
        return $this->hasOneof(25);
    }

    /**
     * Defines the options for providing a source organization for the dataset.
     *
     * Generated from protobuf field <code>bool organization_scope = 25;</code>
     * @param bool $var
     * @return $this
     */
    public function setOrganizationScope($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(25, $var);

        return $this;
    }

    /**
     * Input only. Cloud Storage object path containing a list of
     * project or folder numbers to include in the dataset;
     * it cannot contain a mix of project and folders.
     * The object must be a text file where each line has one of the following
     * entries:
     * - Project number, formatted as `projects/{project_number}`, for example,
     * `projects/1234567890`.
     * - Folder identifier, formatted as `folders/{folder_number}`, for example,
     * `folders/9876543210`.
     * Path must be in the format `gs://{bucket_name}/{object_name}`.
     *
     * Generated from protobuf field <code>string cloud_storage_object_path = 21 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getCloudStorageObjectPath()
    {
        return $this->readOneof(21);
    }

    public function hasCloudStorageObjectPath()
    {
        return $this->hasOneof(21);
    }

    /**
     * Input only. Cloud Storage object path containing a list of
     * project or folder numbers to include in the dataset;
     * it cannot contain a mix of project and folders.
     * The object must be a text file where each line has one of the following
     * entries:
     * - Project number, formatted as `projects/{project_number}`, for example,
     * `projects/1234567890`.
     * - Folder identifier, formatted as `folders/{folder_number}`, for example,
     * `folders/9876543210`.
     * Path must be in the format `gs://{bucket_name}/{object_name}`.
     *
     * Generated from protobuf field <code>string cloud_storage_object_path = 21 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCloudStorageObjectPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageLocations include_cloud_storage_locations = 8;</code>
     * @return \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations|null
     */
    public function getIncludeCloudStorageLocations()
    {
        return $this->readOneof(8);
    }

    public function hasIncludeCloudStorageLocations()
    {
        return $this->hasOneof(8);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageLocations include_cloud_storage_locations = 8;</code>
     * @param \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations $var
     * @return $this
     */
    public function setIncludeCloudStorageLocations($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageLocations exclude_cloud_storage_locations = 9;</code>
     * @return \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations|null
     */
    public function getExcludeCloudStorageLocations()
    {
        return $this->readOneof(9);
    }

    public function hasExcludeCloudStorageLocations()
    {
        return $this->hasOneof(9);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageLocations exclude_cloud_storage_locations = 9;</code>
     * @param \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations $var
     * @return $this
     */
    public function setExcludeCloudStorageLocations($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageLocations::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageBuckets include_cloud_storage_buckets = 10;</code>
     * @return \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets|null
     */
    public function getIncludeCloudStorageBuckets()
    {
        return $this->readOneof(10);
    }

    public function hasIncludeCloudStorageBuckets()
    {
        return $this->hasOneof(10);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageBuckets include_cloud_storage_buckets = 10;</code>
     * @param \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets $var
     * @return $this
     */
    public function setIncludeCloudStorageBuckets($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageBuckets exclude_cloud_storage_buckets = 11;</code>
     * @return \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets|null
     */
    public function getExcludeCloudStorageBuckets()
    {
        return $this->readOneof(11);
    }

    public function hasExcludeCloudStorageBuckets()
    {
        return $this->hasOneof(11);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.CloudStorageBuckets exclude_cloud_storage_buckets = 11;</code>
     * @param \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets $var
     * @return $this
     */
    public function setExcludeCloudStorageBuckets($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\CloudStorageBuckets::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * If set to `true`, the request includes all the newly created buckets in the
     * dataset that meet the inclusion and exclusion rules.
     *
     * Generated from protobuf field <code>bool include_newly_created_buckets = 12;</code>
     * @return bool
     */
    public function getIncludeNewlyCreatedBuckets()
    {
        return $this->include_newly_created_buckets;
    }

    /**
     * If set to `true`, the request includes all the newly created buckets in the
     * dataset that meet the inclusion and exclusion rules.
     *
     * Generated from protobuf field <code>bool include_newly_created_buckets = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setIncludeNewlyCreatedBuckets($var)
    {
        GPBUtil::checkBool($var);
        $this->include_newly_created_buckets = $var;

        return $this;
    }

    /**
     * Optional. If set to `false`, then all the permission checks must be
     * successful before the system can start ingesting data. This field can only
     * be updated before the system ingests data for the first time. Any attempt
     * to modify the field after data ingestion starts results in an error.
     *
     * Generated from protobuf field <code>bool skip_verification_and_ingest = 19 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     * @deprecated
     */
    public function getSkipVerificationAndIngest()
    {
        if ($this->skip_verification_and_ingest !== false) {
            @trigger_error('skip_verification_and_ingest is deprecated.', E_USER_DEPRECATED);
        }
        return $this->skip_verification_and_ingest;
    }

    /**
     * Optional. If set to `false`, then all the permission checks must be
     * successful before the system can start ingesting data. This field can only
     * be updated before the system ingests data for the first time. Any attempt
     * to modify the field after data ingestion starts results in an error.
     *
     * Generated from protobuf field <code>bool skip_verification_and_ingest = 19 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setSkipVerificationAndIngest($var)
    {
        @trigger_error('skip_verification_and_ingest is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->skip_verification_and_ingest = $var;

        return $this;
    }

    /**
     * Number of days of history that must be retained.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 14;</code>
     * @return int
     */
    public function getRetentionPeriodDays()
    {
        return $this->retention_period_days;
    }

    /**
     * Number of days of history that must be retained.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 14;</code>
     * @param int $var
     * @return $this
     */
    public function setRetentionPeriodDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->retention_period_days = $var;

        return $this;
    }

    /**
     * Details of the linked dataset.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.Link link = 15;</code>
     * @return \Google\Cloud\StorageInsights\V1\DatasetConfig\Link|null
     */
    public function getLink()
    {
        return $this->link;
    }

    public function hasLink()
    {
        return isset($this->link);
    }

    public function clearLink()
    {
        unset($this->link);
    }

    /**
     * Details of the linked dataset.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.Link link = 15;</code>
     * @param \Google\Cloud\StorageInsights\V1\DatasetConfig\Link $var
     * @return $this
     */
    public function setLink($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\Link::class);
        $this->link = $var;

        return $this;
    }

    /**
     * Identity used by this `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.Identity identity = 16;</code>
     * @return \Google\Cloud\StorageInsights\V1\Identity|null
     */
    public function getIdentity()
    {
        return $this->identity;
    }

    public function hasIdentity()
    {
        return isset($this->identity);
    }

    public function clearIdentity()
    {
        unset($this->identity);
    }

    /**
     * Identity used by this `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.Identity identity = 16;</code>
     * @param \Google\Cloud\StorageInsights\V1\Identity $var
     * @return $this
     */
    public function setIdentity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageInsights\V1\Identity::class);
        $this->identity = $var;

        return $this;
    }

    /**
     * Output only. Status of the `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * Output only. Status of the `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Output only. State of the `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.ConfigState dataset_config_state = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDatasetConfigState()
    {
        return $this->dataset_config_state;
    }

    /**
     * Output only. State of the `datasetConfig`.
     *
     * Generated from protobuf field <code>.google.cloud.storageinsights.v1.DatasetConfig.ConfigState dataset_config_state = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDatasetConfigState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\StorageInsights\V1\DatasetConfig\ConfigState::class);
        $this->dataset_config_state = $var;

        return $this;
    }

    /**
     * Optional. A user-provided description for the dataset configuration.
     * Maximum length: 256 characters.
     *
     * Generated from protobuf field <code>string description = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A user-provided description for the dataset configuration.
     * Maximum length: 256 characters.
     *
     * Generated from protobuf field <code>string description = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSourceOptions()
    {
        return $this->whichOneof("source_options");
    }

    /**
     * @return string
     */
    public function getCloudStorageLocations()
    {
        return $this->whichOneof("cloud_storage_locations");
    }

    /**
     * @return string
     */
    public function getCloudStorageBuckets()
    {
        return $this->whichOneof("cloud_storage_buckets");
    }

}

