<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/storagebatchoperations/v1/storage_batch_operations_types.proto

namespace Google\Cloud\StorageBatchOperations\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The Storage Batch Operations Job description.
 *
 * Generated from protobuf message <code>google.cloud.storagebatchoperations.v1.Job</code>
 */
class Job extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the Job. job_id is unique
     * within the project, that is either set by the customer or
     * defined by the service. Format:
     * projects/{project}/locations/global/jobs/{job_id} .
     * For example: "projects/123456/locations/global/jobs/job01".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. A description provided by the user for the job. Its max length is
     * 1024 bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. Logging configuration.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.LoggingConfig logging_config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $logging_config = null;
    /**
     * Output only. The time that the job was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time that the job was scheduled.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp schedule_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $schedule_time = null;
    /**
     * Output only. The time that the job was completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $complete_time = null;
    /**
     * Output only. Information about the progress of the job.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.Counters counters = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $counters = null;
    /**
     * Output only. Summarizes errors encountered with sample error log entries.
     *
     * Generated from protobuf field <code>repeated .google.cloud.storagebatchoperations.v1.ErrorSummary error_summaries = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error_summaries;
    /**
     * Output only. State of the job.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.Job.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Optional. If true, the job will run in dry run mode, returning the total
     * object count and, if the object configuration is a prefix list, the bytes
     * found from source. No transformations will be performed.
     *
     * Generated from protobuf field <code>bool dry_run = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $dry_run = false;
    /**
     * Output only. If true, this Job operates on multiple buckets. Multibucket
     * jobs are subject to different quota limits than single-bucket jobs.
     *
     * Generated from protobuf field <code>bool is_multi_bucket_job = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_multi_bucket_job = false;
    protected $source;
    protected $transformation;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the Job. job_id is unique
     *           within the project, that is either set by the customer or
     *           defined by the service. Format:
     *           projects/{project}/locations/global/jobs/{job_id} .
     *           For example: "projects/123456/locations/global/jobs/job01".
     *     @type string $description
     *           Optional. A description provided by the user for the job. Its max length is
     *           1024 bytes when Unicode-encoded.
     *     @type \Google\Cloud\StorageBatchOperations\V1\BucketList $bucket_list
     *           Specifies a list of buckets and their objects to be transformed.
     *     @type \Google\Cloud\StorageBatchOperations\V1\PutObjectHold $put_object_hold
     *           Changes object hold status.
     *     @type \Google\Cloud\StorageBatchOperations\V1\DeleteObject $delete_object
     *           Delete objects.
     *     @type \Google\Cloud\StorageBatchOperations\V1\PutMetadata $put_metadata
     *           Updates object metadata. Allows updating fixed-key and custom metadata
     *           and fixed-key metadata i.e. Cache-Control, Content-Disposition,
     *           Content-Encoding, Content-Language, Content-Type, Custom-Time.
     *     @type \Google\Cloud\StorageBatchOperations\V1\RewriteObject $rewrite_object
     *           Rewrite the object and updates metadata like KMS key.
     *     @type \Google\Cloud\StorageBatchOperations\V1\LoggingConfig $logging_config
     *           Optional. Logging configuration.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time that the job was created.
     *     @type \Google\Protobuf\Timestamp $schedule_time
     *           Output only. The time that the job was scheduled.
     *     @type \Google\Protobuf\Timestamp $complete_time
     *           Output only. The time that the job was completed.
     *     @type \Google\Cloud\StorageBatchOperations\V1\Counters $counters
     *           Output only. Information about the progress of the job.
     *     @type array<\Google\Cloud\StorageBatchOperations\V1\ErrorSummary>|\Google\Protobuf\Internal\RepeatedField $error_summaries
     *           Output only. Summarizes errors encountered with sample error log entries.
     *     @type int $state
     *           Output only. State of the job.
     *     @type bool $dry_run
     *           Optional. If true, the job will run in dry run mode, returning the total
     *           object count and, if the object configuration is a prefix list, the bytes
     *           found from source. No transformations will be performed.
     *     @type bool $is_multi_bucket_job
     *           Output only. If true, this Job operates on multiple buckets. Multibucket
     *           jobs are subject to different quota limits than single-bucket jobs.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Storagebatchoperations\V1\StorageBatchOperationsTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the Job. job_id is unique
     * within the project, that is either set by the customer or
     * defined by the service. Format:
     * projects/{project}/locations/global/jobs/{job_id} .
     * For example: "projects/123456/locations/global/jobs/job01".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the Job. job_id is unique
     * within the project, that is either set by the customer or
     * defined by the service. Format:
     * projects/{project}/locations/global/jobs/{job_id} .
     * For example: "projects/123456/locations/global/jobs/job01".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. A description provided by the user for the job. Its max length is
     * 1024 bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A description provided by the user for the job. Its max length is
     * 1024 bytes when Unicode-encoded.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Specifies a list of buckets and their objects to be transformed.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.BucketList bucket_list = 19;</code>
     * @return \Google\Cloud\StorageBatchOperations\V1\BucketList|null
     */
    public function getBucketList()
    {
        return $this->readOneof(19);
    }

    public function hasBucketList()
    {
        return $this->hasOneof(19);
    }

    /**
     * Specifies a list of buckets and their objects to be transformed.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.BucketList bucket_list = 19;</code>
     * @param \Google\Cloud\StorageBatchOperations\V1\BucketList $var
     * @return $this
     */
    public function setBucketList($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageBatchOperations\V1\BucketList::class);
        $this->writeOneof(19, $var);

        return $this;
    }

    /**
     * Changes object hold status.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.PutObjectHold put_object_hold = 5;</code>
     * @return \Google\Cloud\StorageBatchOperations\V1\PutObjectHold|null
     */
    public function getPutObjectHold()
    {
        return $this->readOneof(5);
    }

    public function hasPutObjectHold()
    {
        return $this->hasOneof(5);
    }

    /**
     * Changes object hold status.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.PutObjectHold put_object_hold = 5;</code>
     * @param \Google\Cloud\StorageBatchOperations\V1\PutObjectHold $var
     * @return $this
     */
    public function setPutObjectHold($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageBatchOperations\V1\PutObjectHold::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Delete objects.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.DeleteObject delete_object = 6;</code>
     * @return \Google\Cloud\StorageBatchOperations\V1\DeleteObject|null
     */
    public function getDeleteObject()
    {
        return $this->readOneof(6);
    }

    public function hasDeleteObject()
    {
        return $this->hasOneof(6);
    }

    /**
     * Delete objects.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.DeleteObject delete_object = 6;</code>
     * @param \Google\Cloud\StorageBatchOperations\V1\DeleteObject $var
     * @return $this
     */
    public function setDeleteObject($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageBatchOperations\V1\DeleteObject::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Updates object metadata. Allows updating fixed-key and custom metadata
     * and fixed-key metadata i.e. Cache-Control, Content-Disposition,
     * Content-Encoding, Content-Language, Content-Type, Custom-Time.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.PutMetadata put_metadata = 8;</code>
     * @return \Google\Cloud\StorageBatchOperations\V1\PutMetadata|null
     */
    public function getPutMetadata()
    {
        return $this->readOneof(8);
    }

    public function hasPutMetadata()
    {
        return $this->hasOneof(8);
    }

    /**
     * Updates object metadata. Allows updating fixed-key and custom metadata
     * and fixed-key metadata i.e. Cache-Control, Content-Disposition,
     * Content-Encoding, Content-Language, Content-Type, Custom-Time.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.PutMetadata put_metadata = 8;</code>
     * @param \Google\Cloud\StorageBatchOperations\V1\PutMetadata $var
     * @return $this
     */
    public function setPutMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageBatchOperations\V1\PutMetadata::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Rewrite the object and updates metadata like KMS key.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.RewriteObject rewrite_object = 20;</code>
     * @return \Google\Cloud\StorageBatchOperations\V1\RewriteObject|null
     */
    public function getRewriteObject()
    {
        return $this->readOneof(20);
    }

    public function hasRewriteObject()
    {
        return $this->hasOneof(20);
    }

    /**
     * Rewrite the object and updates metadata like KMS key.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.RewriteObject rewrite_object = 20;</code>
     * @param \Google\Cloud\StorageBatchOperations\V1\RewriteObject $var
     * @return $this
     */
    public function setRewriteObject($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageBatchOperations\V1\RewriteObject::class);
        $this->writeOneof(20, $var);

        return $this;
    }

    /**
     * Optional. Logging configuration.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.LoggingConfig logging_config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\StorageBatchOperations\V1\LoggingConfig|null
     */
    public function getLoggingConfig()
    {
        return $this->logging_config;
    }

    public function hasLoggingConfig()
    {
        return isset($this->logging_config);
    }

    public function clearLoggingConfig()
    {
        unset($this->logging_config);
    }

    /**
     * Optional. Logging configuration.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.LoggingConfig logging_config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\StorageBatchOperations\V1\LoggingConfig $var
     * @return $this
     */
    public function setLoggingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageBatchOperations\V1\LoggingConfig::class);
        $this->logging_config = $var;

        return $this;
    }

    /**
     * Output only. The time that the job was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time that the job was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time that the job was scheduled.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp schedule_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getScheduleTime()
    {
        return $this->schedule_time;
    }

    public function hasScheduleTime()
    {
        return isset($this->schedule_time);
    }

    public function clearScheduleTime()
    {
        unset($this->schedule_time);
    }

    /**
     * Output only. The time that the job was scheduled.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp schedule_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setScheduleTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->schedule_time = $var;

        return $this;
    }

    /**
     * Output only. The time that the job was completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCompleteTime()
    {
        return $this->complete_time;
    }

    public function hasCompleteTime()
    {
        return isset($this->complete_time);
    }

    public function clearCompleteTime()
    {
        unset($this->complete_time);
    }

    /**
     * Output only. The time that the job was completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp complete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCompleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->complete_time = $var;

        return $this;
    }

    /**
     * Output only. Information about the progress of the job.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.Counters counters = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\StorageBatchOperations\V1\Counters|null
     */
    public function getCounters()
    {
        return $this->counters;
    }

    public function hasCounters()
    {
        return isset($this->counters);
    }

    public function clearCounters()
    {
        unset($this->counters);
    }

    /**
     * Output only. Information about the progress of the job.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.Counters counters = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\StorageBatchOperations\V1\Counters $var
     * @return $this
     */
    public function setCounters($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageBatchOperations\V1\Counters::class);
        $this->counters = $var;

        return $this;
    }

    /**
     * Output only. Summarizes errors encountered with sample error log entries.
     *
     * Generated from protobuf field <code>repeated .google.cloud.storagebatchoperations.v1.ErrorSummary error_summaries = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getErrorSummaries()
    {
        return $this->error_summaries;
    }

    /**
     * Output only. Summarizes errors encountered with sample error log entries.
     *
     * Generated from protobuf field <code>repeated .google.cloud.storagebatchoperations.v1.ErrorSummary error_summaries = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\StorageBatchOperations\V1\ErrorSummary>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setErrorSummaries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\StorageBatchOperations\V1\ErrorSummary::class);
        $this->error_summaries = $arr;

        return $this;
    }

    /**
     * Output only. State of the job.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.Job.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the job.
     *
     * Generated from protobuf field <code>.google.cloud.storagebatchoperations.v1.Job.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\StorageBatchOperations\V1\Job\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. If true, the job will run in dry run mode, returning the total
     * object count and, if the object configuration is a prefix list, the bytes
     * found from source. No transformations will be performed.
     *
     * Generated from protobuf field <code>bool dry_run = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDryRun()
    {
        return $this->dry_run;
    }

    /**
     * Optional. If true, the job will run in dry run mode, returning the total
     * object count and, if the object configuration is a prefix list, the bytes
     * found from source. No transformations will be performed.
     *
     * Generated from protobuf field <code>bool dry_run = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDryRun($var)
    {
        GPBUtil::checkBool($var);
        $this->dry_run = $var;

        return $this;
    }

    /**
     * Output only. If true, this Job operates on multiple buckets. Multibucket
     * jobs are subject to different quota limits than single-bucket jobs.
     *
     * Generated from protobuf field <code>bool is_multi_bucket_job = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsMultiBucketJob()
    {
        return $this->is_multi_bucket_job;
    }

    /**
     * Output only. If true, this Job operates on multiple buckets. Multibucket
     * jobs are subject to different quota limits than single-bucket jobs.
     *
     * Generated from protobuf field <code>bool is_multi_bucket_job = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsMultiBucketJob($var)
    {
        GPBUtil::checkBool($var);
        $this->is_multi_bucket_job = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

    /**
     * @return string
     */
    public function getTransformation()
    {
        return $this->whichOneof("transformation");
    }

}

