<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/lfp/v1/lfpinventory.proto

namespace Google\Shopping\Merchant\Lfp\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Local Inventory for the merchant.
 *
 * Generated from protobuf message <code>google.shopping.merchant.lfp.v1.LfpInventory</code>
 */
class LfpInventory extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. The name for the `LfpInventory` resource.
     * Format:
     * `accounts/{account}/lfpInventories/{target_merchant}~{store_code}~{offer}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The Merchant Center ID of the merchant to submit the inventory
     * for.
     *
     * Generated from protobuf field <code>int64 target_account = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_account = 0;
    /**
     * Required. The identifier of the merchant's store. Either the store code
     * inserted through `InsertLfpStore` or the store code in the Business
     * Profile.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $store_code = '';
    /**
     * Required. Immutable. A unique identifier for the product. If both
     * inventories and sales are submitted for a merchant, this id should match
     * for the same product.
     * **Note**: if the merchant sells the same product new and used, they should
     * have different IDs.
     *
     * Generated from protobuf field <code>string offer_id = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $offer_id = '';
    /**
     * Required. The [CLDR territory
     * code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
     * for the country where the product is sold.
     *
     * Generated from protobuf field <code>string region_code = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $region_code = '';
    /**
     * Required. The two-letter ISO 639-1 language code for the item.
     *
     * Generated from protobuf field <code>string content_language = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $content_language = '';
    /**
     * Optional. The Global Trade Item Number of the product.
     *
     * Generated from protobuf field <code>optional string gtin = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $gtin = null;
    /**
     * Optional. The current price of the product.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $price = null;
    /**
     * Required. Availability of the product at this store.
     * For accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>string availability = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $availability = '';
    /**
     * Optional. Quantity of the product available at this store. Must be greater
     * than or equal to zero.
     *
     * Generated from protobuf field <code>optional int64 quantity = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $quantity = null;
    /**
     * Optional. The time when the inventory is collected. If not set, it will be
     * set to the time when the inventory is submitted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp collection_time = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $collection_time = null;
    /**
     * Optional. Supported pickup method for this offer. Unless the value is "not
     * supported", this field must be submitted together with `pickupSla`. For
     * accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342).
     *
     * Generated from protobuf field <code>optional string pickup_method = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $pickup_method = null;
    /**
     * Optional. Expected date that an order will be ready for pickup relative to
     * the order date. Must be submitted together with `pickupMethod`. For
     * accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342).
     *
     * Generated from protobuf field <code>optional string pickup_sla = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $pickup_sla = null;
    /**
     * Optional. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the product. If this is not set, it will default to `regionCode`.
     *
     * Generated from protobuf field <code>optional string feed_label = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $feed_label = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Identifier. The name for the `LfpInventory` resource.
     *           Format:
     *           `accounts/{account}/lfpInventories/{target_merchant}~{store_code}~{offer}`
     *     @type int|string $target_account
     *           Required. The Merchant Center ID of the merchant to submit the inventory
     *           for.
     *     @type string $store_code
     *           Required. The identifier of the merchant's store. Either the store code
     *           inserted through `InsertLfpStore` or the store code in the Business
     *           Profile.
     *     @type string $offer_id
     *           Required. Immutable. A unique identifier for the product. If both
     *           inventories and sales are submitted for a merchant, this id should match
     *           for the same product.
     *           **Note**: if the merchant sells the same product new and used, they should
     *           have different IDs.
     *     @type string $region_code
     *           Required. The [CLDR territory
     *           code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
     *           for the country where the product is sold.
     *     @type string $content_language
     *           Required. The two-letter ISO 639-1 language code for the item.
     *     @type string $gtin
     *           Optional. The Global Trade Item Number of the product.
     *     @type \Google\Shopping\Type\Price $price
     *           Optional. The current price of the product.
     *     @type string $availability
     *           Required. Availability of the product at this store.
     *           For accepted attribute values, see the [local product inventory data
     *           specification](https://support.google.com/merchants/answer/3061342)
     *     @type int|string $quantity
     *           Optional. Quantity of the product available at this store. Must be greater
     *           than or equal to zero.
     *     @type \Google\Protobuf\Timestamp $collection_time
     *           Optional. The time when the inventory is collected. If not set, it will be
     *           set to the time when the inventory is submitted.
     *     @type string $pickup_method
     *           Optional. Supported pickup method for this offer. Unless the value is "not
     *           supported", this field must be submitted together with `pickupSla`. For
     *           accepted attribute values, see the [local product inventory data
     *           specification](https://support.google.com/merchants/answer/3061342).
     *     @type string $pickup_sla
     *           Optional. Expected date that an order will be ready for pickup relative to
     *           the order date. Must be submitted together with `pickupMethod`. For
     *           accepted attribute values, see the [local product inventory data
     *           specification](https://support.google.com/merchants/answer/3061342).
     *     @type string $feed_label
     *           Optional. The [feed
     *           label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     *           for the product. If this is not set, it will default to `regionCode`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Lfp\V1\Lfpinventory::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Identifier. The name for the `LfpInventory` resource.
     * Format:
     * `accounts/{account}/lfpInventories/{target_merchant}~{store_code}~{offer}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. The name for the `LfpInventory` resource.
     * Format:
     * `accounts/{account}/lfpInventories/{target_merchant}~{store_code}~{offer}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The Merchant Center ID of the merchant to submit the inventory
     * for.
     *
     * Generated from protobuf field <code>int64 target_account = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int|string
     */
    public function getTargetAccount()
    {
        return $this->target_account;
    }

    /**
     * Required. The Merchant Center ID of the merchant to submit the inventory
     * for.
     *
     * Generated from protobuf field <code>int64 target_account = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTargetAccount($var)
    {
        GPBUtil::checkInt64($var);
        $this->target_account = $var;

        return $this;
    }

    /**
     * Required. The identifier of the merchant's store. Either the store code
     * inserted through `InsertLfpStore` or the store code in the Business
     * Profile.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getStoreCode()
    {
        return $this->store_code;
    }

    /**
     * Required. The identifier of the merchant's store. Either the store code
     * inserted through `InsertLfpStore` or the store code in the Business
     * Profile.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setStoreCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->store_code = $var;

        return $this;
    }

    /**
     * Required. Immutable. A unique identifier for the product. If both
     * inventories and sales are submitted for a merchant, this id should match
     * for the same product.
     * **Note**: if the merchant sells the same product new and used, they should
     * have different IDs.
     *
     * Generated from protobuf field <code>string offer_id = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getOfferId()
    {
        return $this->offer_id;
    }

    /**
     * Required. Immutable. A unique identifier for the product. If both
     * inventories and sales are submitted for a merchant, this id should match
     * for the same product.
     * **Note**: if the merchant sells the same product new and used, they should
     * have different IDs.
     *
     * Generated from protobuf field <code>string offer_id = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setOfferId($var)
    {
        GPBUtil::checkString($var, True);
        $this->offer_id = $var;

        return $this;
    }

    /**
     * Required. The [CLDR territory
     * code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
     * for the country where the product is sold.
     *
     * Generated from protobuf field <code>string region_code = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getRegionCode()
    {
        return $this->region_code;
    }

    /**
     * Required. The [CLDR territory
     * code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
     * for the country where the product is sold.
     *
     * Generated from protobuf field <code>string region_code = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setRegionCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->region_code = $var;

        return $this;
    }

    /**
     * Required. The two-letter ISO 639-1 language code for the item.
     *
     * Generated from protobuf field <code>string content_language = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getContentLanguage()
    {
        return $this->content_language;
    }

    /**
     * Required. The two-letter ISO 639-1 language code for the item.
     *
     * Generated from protobuf field <code>string content_language = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setContentLanguage($var)
    {
        GPBUtil::checkString($var, True);
        $this->content_language = $var;

        return $this;
    }

    /**
     * Optional. The Global Trade Item Number of the product.
     *
     * Generated from protobuf field <code>optional string gtin = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getGtin()
    {
        return isset($this->gtin) ? $this->gtin : '';
    }

    public function hasGtin()
    {
        return isset($this->gtin);
    }

    public function clearGtin()
    {
        unset($this->gtin);
    }

    /**
     * Optional. The Global Trade Item Number of the product.
     *
     * Generated from protobuf field <code>optional string gtin = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setGtin($var)
    {
        GPBUtil::checkString($var, True);
        $this->gtin = $var;

        return $this;
    }

    /**
     * Optional. The current price of the product.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function hasPrice()
    {
        return isset($this->price);
    }

    public function clearPrice()
    {
        unset($this->price);
    }

    /**
     * Optional. The current price of the product.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->price = $var;

        return $this;
    }

    /**
     * Required. Availability of the product at this store.
     * For accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>string availability = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getAvailability()
    {
        return $this->availability;
    }

    /**
     * Required. Availability of the product at this store.
     * For accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>string availability = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setAvailability($var)
    {
        GPBUtil::checkString($var, True);
        $this->availability = $var;

        return $this;
    }

    /**
     * Optional. Quantity of the product available at this store. Must be greater
     * than or equal to zero.
     *
     * Generated from protobuf field <code>optional int64 quantity = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getQuantity()
    {
        return isset($this->quantity) ? $this->quantity : 0;
    }

    public function hasQuantity()
    {
        return isset($this->quantity);
    }

    public function clearQuantity()
    {
        unset($this->quantity);
    }

    /**
     * Optional. Quantity of the product available at this store. Must be greater
     * than or equal to zero.
     *
     * Generated from protobuf field <code>optional int64 quantity = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setQuantity($var)
    {
        GPBUtil::checkInt64($var);
        $this->quantity = $var;

        return $this;
    }

    /**
     * Optional. The time when the inventory is collected. If not set, it will be
     * set to the time when the inventory is submitted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp collection_time = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCollectionTime()
    {
        return $this->collection_time;
    }

    public function hasCollectionTime()
    {
        return isset($this->collection_time);
    }

    public function clearCollectionTime()
    {
        unset($this->collection_time);
    }

    /**
     * Optional. The time when the inventory is collected. If not set, it will be
     * set to the time when the inventory is submitted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp collection_time = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCollectionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->collection_time = $var;

        return $this;
    }

    /**
     * Optional. Supported pickup method for this offer. Unless the value is "not
     * supported", this field must be submitted together with `pickupSla`. For
     * accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342).
     *
     * Generated from protobuf field <code>optional string pickup_method = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPickupMethod()
    {
        return isset($this->pickup_method) ? $this->pickup_method : '';
    }

    public function hasPickupMethod()
    {
        return isset($this->pickup_method);
    }

    public function clearPickupMethod()
    {
        unset($this->pickup_method);
    }

    /**
     * Optional. Supported pickup method for this offer. Unless the value is "not
     * supported", this field must be submitted together with `pickupSla`. For
     * accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342).
     *
     * Generated from protobuf field <code>optional string pickup_method = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPickupMethod($var)
    {
        GPBUtil::checkString($var, True);
        $this->pickup_method = $var;

        return $this;
    }

    /**
     * Optional. Expected date that an order will be ready for pickup relative to
     * the order date. Must be submitted together with `pickupMethod`. For
     * accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342).
     *
     * Generated from protobuf field <code>optional string pickup_sla = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPickupSla()
    {
        return isset($this->pickup_sla) ? $this->pickup_sla : '';
    }

    public function hasPickupSla()
    {
        return isset($this->pickup_sla);
    }

    public function clearPickupSla()
    {
        unset($this->pickup_sla);
    }

    /**
     * Optional. Expected date that an order will be ready for pickup relative to
     * the order date. Must be submitted together with `pickupMethod`. For
     * accepted attribute values, see the [local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342).
     *
     * Generated from protobuf field <code>optional string pickup_sla = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPickupSla($var)
    {
        GPBUtil::checkString($var, True);
        $this->pickup_sla = $var;

        return $this;
    }

    /**
     * Optional. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the product. If this is not set, it will default to `regionCode`.
     *
     * Generated from protobuf field <code>optional string feed_label = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFeedLabel()
    {
        return isset($this->feed_label) ? $this->feed_label : '';
    }

    public function hasFeedLabel()
    {
        return isset($this->feed_label);
    }

    public function clearFeedLabel()
    {
        unset($this->feed_label);
    }

    /**
     * Optional. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the product. If this is not set, it will default to `regionCode`.
     *
     * Generated from protobuf field <code>optional string feed_label = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFeedLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->feed_label = $var;

        return $this;
    }

}

