<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/termsofservice.proto

namespace Google\Shopping\Merchant\Accounts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `TermsOfService` message represents a specific version of the terms of
 * service that merchants must accept to access certain features or services.
 * For more information, see [Terms of
 * Service](https://support.google.com/merchants/answer/160173).
 * This message is important for the onboarding process, ensuring that merchants
 * agree to the necessary legal agreements for using the service. Merchants can
 * retrieve the latest terms of service for a given `kind` and `region` through
 * `RetrieveLatestTermsOfService`, and accept them as required through
 * `AcceptTermsOfService`.
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.TermsOfService</code>
 */
class TermsOfService extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the terms of service version.
     * Format: `termsOfService/{version}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.resource_reference) = {</code>
     */
    protected $name = '';
    /**
     * Region code as defined by [CLDR](https://cldr.unicode.org/). This is either
     * a country where the ToS applies specifically to that country or `001` when
     * the same `TermsOfService` can be signed in any country. However note that
     * when signing a ToS that applies globally we still expect that a specific
     * country is provided  (this should be merchant business country or program
     * country of participation).
     *
     * Generated from protobuf field <code>string region_code = 2;</code>
     */
    protected $region_code = '';
    /**
     * The Kind this terms of service version applies to.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.TermsOfServiceKind kind = 3;</code>
     */
    protected $kind = 0;
    /**
     * URI for terms of service file that needs to be displayed to signing users.
     *
     * Generated from protobuf field <code>optional string file_uri = 4;</code>
     */
    protected $file_uri = null;
    /**
     * Whether this terms of service version is external. External terms of
     * service versions can only be agreed through external processes and not
     * directly by the merchant through UI or API.
     *
     * Generated from protobuf field <code>bool external = 5;</code>
     */
    protected $external = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the terms of service version.
     *           Format: `termsOfService/{version}`
     *     @type string $region_code
     *           Region code as defined by [CLDR](https://cldr.unicode.org/). This is either
     *           a country where the ToS applies specifically to that country or `001` when
     *           the same `TermsOfService` can be signed in any country. However note that
     *           when signing a ToS that applies globally we still expect that a specific
     *           country is provided  (this should be merchant business country or program
     *           country of participation).
     *     @type int $kind
     *           The Kind this terms of service version applies to.
     *     @type string $file_uri
     *           URI for terms of service file that needs to be displayed to signing users.
     *     @type bool $external
     *           Whether this terms of service version is external. External terms of
     *           service versions can only be agreed through external processes and not
     *           directly by the merchant through UI or API.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Termsofservice::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the terms of service version.
     * Format: `termsOfService/{version}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the terms of service version.
     * Format: `termsOfService/{version}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Region code as defined by [CLDR](https://cldr.unicode.org/). This is either
     * a country where the ToS applies specifically to that country or `001` when
     * the same `TermsOfService` can be signed in any country. However note that
     * when signing a ToS that applies globally we still expect that a specific
     * country is provided  (this should be merchant business country or program
     * country of participation).
     *
     * Generated from protobuf field <code>string region_code = 2;</code>
     * @return string
     */
    public function getRegionCode()
    {
        return $this->region_code;
    }

    /**
     * Region code as defined by [CLDR](https://cldr.unicode.org/). This is either
     * a country where the ToS applies specifically to that country or `001` when
     * the same `TermsOfService` can be signed in any country. However note that
     * when signing a ToS that applies globally we still expect that a specific
     * country is provided  (this should be merchant business country or program
     * country of participation).
     *
     * Generated from protobuf field <code>string region_code = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRegionCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->region_code = $var;

        return $this;
    }

    /**
     * The Kind this terms of service version applies to.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.TermsOfServiceKind kind = 3;</code>
     * @return int
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * The Kind this terms of service version applies to.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1.TermsOfServiceKind kind = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Accounts\V1\TermsOfServiceKind::class);
        $this->kind = $var;

        return $this;
    }

    /**
     * URI for terms of service file that needs to be displayed to signing users.
     *
     * Generated from protobuf field <code>optional string file_uri = 4;</code>
     * @return string
     */
    public function getFileUri()
    {
        return isset($this->file_uri) ? $this->file_uri : '';
    }

    public function hasFileUri()
    {
        return isset($this->file_uri);
    }

    public function clearFileUri()
    {
        unset($this->file_uri);
    }

    /**
     * URI for terms of service file that needs to be displayed to signing users.
     *
     * Generated from protobuf field <code>optional string file_uri = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setFileUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->file_uri = $var;

        return $this;
    }

    /**
     * Whether this terms of service version is external. External terms of
     * service versions can only be agreed through external processes and not
     * directly by the merchant through UI or API.
     *
     * Generated from protobuf field <code>bool external = 5;</code>
     * @return bool
     */
    public function getExternal()
    {
        return $this->external;
    }

    /**
     * Whether this terms of service version is external. External terms of
     * service versions can only be agreed through external processes and not
     * directly by the merchant through UI or API.
     *
     * Generated from protobuf field <code>bool external = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setExternal($var)
    {
        GPBUtil::checkBool($var);
        $this->external = $var;

        return $this;
    }

}

