<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

namespace Google\Cloud\RecaptchaEnterprise\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings specific to keys that can be used by websites.
 *
 * Generated from protobuf message <code>google.cloud.recaptchaenterprise.v1.WebKeySettings</code>
 */
class WebKeySettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. If set to true, it means allowed_domains are not enforced.
     *
     * Generated from protobuf field <code>bool allow_all_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $allow_all_domains = false;
    /**
     * Optional. Domains or subdomains of websites allowed to use the key. All
     * subdomains of an allowed domain are automatically allowed. A valid domain
     * requires a host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * Each key supports a maximum of 250 domains. To use a key on more domains,
     * set `allow_all_domains` to true. When this is set, you are responsible for
     * validating the hostname by checking the `token_properties.hostname` field
     * in each assessment response against your list of allowed domains.
     *
     * Generated from protobuf field <code>repeated string allowed_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_domains;
    /**
     * Optional. If set to true, the key can be used on AMP (Accelerated Mobile
     * Pages) websites. This is supported only for the SCORE integration type.
     *
     * Generated from protobuf field <code>bool allow_amp_traffic = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $allow_amp_traffic = false;
    /**
     * Required. Describes how this key is integrated with the website.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $integration_type = 0;
    /**
     * Optional. Settings for the frequency and difficulty at which this key
     * triggers captcha challenges. This should only be specified for
     * `IntegrationType` CHECKBOX, INVISIBLE or POLICY_BASED_CHALLENGE.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $challenge_security_preference = 0;
    /**
     * Optional. Challenge settings.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSettings challenge_settings = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $challenge_settings = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $allow_all_domains
     *           Optional. If set to true, it means allowed_domains are not enforced.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_domains
     *           Optional. Domains or subdomains of websites allowed to use the key. All
     *           subdomains of an allowed domain are automatically allowed. A valid domain
     *           requires a host and must not include any path, port, query or fragment.
     *           Examples: 'example.com' or 'subdomain.example.com'
     *           Each key supports a maximum of 250 domains. To use a key on more domains,
     *           set `allow_all_domains` to true. When this is set, you are responsible for
     *           validating the hostname by checking the `token_properties.hostname` field
     *           in each assessment response against your list of allowed domains.
     *     @type bool $allow_amp_traffic
     *           Optional. If set to true, the key can be used on AMP (Accelerated Mobile
     *           Pages) websites. This is supported only for the SCORE integration type.
     *     @type int $integration_type
     *           Required. Describes how this key is integrated with the website.
     *     @type int $challenge_security_preference
     *           Optional. Settings for the frequency and difficulty at which this key
     *           triggers captcha challenges. This should only be specified for
     *           `IntegrationType` CHECKBOX, INVISIBLE or POLICY_BASED_CHALLENGE.
     *     @type \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings\ChallengeSettings $challenge_settings
     *           Optional. Challenge settings.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Recaptchaenterprise\V1\Recaptchaenterprise::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. If set to true, it means allowed_domains are not enforced.
     *
     * Generated from protobuf field <code>bool allow_all_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAllowAllDomains()
    {
        return $this->allow_all_domains;
    }

    /**
     * Optional. If set to true, it means allowed_domains are not enforced.
     *
     * Generated from protobuf field <code>bool allow_all_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowAllDomains($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_all_domains = $var;

        return $this;
    }

    /**
     * Optional. Domains or subdomains of websites allowed to use the key. All
     * subdomains of an allowed domain are automatically allowed. A valid domain
     * requires a host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * Each key supports a maximum of 250 domains. To use a key on more domains,
     * set `allow_all_domains` to true. When this is set, you are responsible for
     * validating the hostname by checking the `token_properties.hostname` field
     * in each assessment response against your list of allowed domains.
     *
     * Generated from protobuf field <code>repeated string allowed_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedDomains()
    {
        return $this->allowed_domains;
    }

    /**
     * Optional. Domains or subdomains of websites allowed to use the key. All
     * subdomains of an allowed domain are automatically allowed. A valid domain
     * requires a host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     * Each key supports a maximum of 250 domains. To use a key on more domains,
     * set `allow_all_domains` to true. When this is set, you are responsible for
     * validating the hostname by checking the `token_properties.hostname` field
     * in each assessment response against your list of allowed domains.
     *
     * Generated from protobuf field <code>repeated string allowed_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedDomains($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_domains = $arr;

        return $this;
    }

    /**
     * Optional. If set to true, the key can be used on AMP (Accelerated Mobile
     * Pages) websites. This is supported only for the SCORE integration type.
     *
     * Generated from protobuf field <code>bool allow_amp_traffic = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAllowAmpTraffic()
    {
        return $this->allow_amp_traffic;
    }

    /**
     * Optional. If set to true, the key can be used on AMP (Accelerated Mobile
     * Pages) websites. This is supported only for the SCORE integration type.
     *
     * Generated from protobuf field <code>bool allow_amp_traffic = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowAmpTraffic($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_amp_traffic = $var;

        return $this;
    }

    /**
     * Required. Describes how this key is integrated with the website.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getIntegrationType()
    {
        return $this->integration_type;
    }

    /**
     * Required. Describes how this key is integrated with the website.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setIntegrationType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings\IntegrationType::class);
        $this->integration_type = $var;

        return $this;
    }

    /**
     * Optional. Settings for the frequency and difficulty at which this key
     * triggers captcha challenges. This should only be specified for
     * `IntegrationType` CHECKBOX, INVISIBLE or POLICY_BASED_CHALLENGE.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getChallengeSecurityPreference()
    {
        return $this->challenge_security_preference;
    }

    /**
     * Optional. Settings for the frequency and difficulty at which this key
     * triggers captcha challenges. This should only be specified for
     * `IntegrationType` CHECKBOX, INVISIBLE or POLICY_BASED_CHALLENGE.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setChallengeSecurityPreference($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings\ChallengeSecurityPreference::class);
        $this->challenge_security_preference = $var;

        return $this;
    }

    /**
     * Optional. Challenge settings.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSettings challenge_settings = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings\ChallengeSettings|null
     */
    public function getChallengeSettings()
    {
        return $this->challenge_settings;
    }

    public function hasChallengeSettings()
    {
        return isset($this->challenge_settings);
    }

    public function clearChallengeSettings()
    {
        unset($this->challenge_settings);
    }

    /**
     * Optional. Challenge settings.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSettings challenge_settings = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings\ChallengeSettings $var
     * @return $this
     */
    public function setChallengeSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings\ChallengeSettings::class);
        $this->challenge_settings = $var;

        return $this;
    }

}

