<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/api/cloudquotas/v1beta/resources.proto

namespace Google\Cloud\CloudQuotas\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * QuotaInfo represents information about a particular quota for a given
 * project, folder or organization.
 *
 * Generated from protobuf message <code>google.api.cloudquotas.v1beta.QuotaInfo</code>
 */
class QuotaInfo extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * For example,
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The id of the quota, which is unique within the service.
     * For example, `CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string quota_id = 2;</code>
     */
    protected $quota_id = '';
    /**
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * For example, `compute.googleapis.com/cpus`
     *
     * Generated from protobuf field <code>string metric = 3;</code>
     */
    protected $metric = '';
    /**
     * The name of the service in which the quota is defined.
     * For example, `compute.googleapis.com`
     *
     * Generated from protobuf field <code>string service = 4;</code>
     */
    protected $service = '';
    /**
     * Whether this is a precise quota. A precise quota is tracked with absolute
     * precision. In contrast, an imprecise quota is not tracked with precision.
     *
     * Generated from protobuf field <code>bool is_precise = 5;</code>
     */
    protected $is_precise = false;
    /**
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * For example, "minute" for per minute, "day" for per day, or "10 seconds"
     * for every 10 seconds.
     *
     * Generated from protobuf field <code>string refresh_interval = 6;</code>
     */
    protected $refresh_interval = '';
    /**
     * The container type of the QuotaInfo.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaInfo.ContainerType container_type = 7;</code>
     */
    protected $container_type = 0;
    /**
     * The dimensions the quota is defined on.
     *
     * Generated from protobuf field <code>repeated string dimensions = 8;</code>
     */
    private $dimensions;
    /**
     * The display name of the quota metric
     *
     * Generated from protobuf field <code>string metric_display_name = 9;</code>
     */
    protected $metric_display_name = '';
    /**
     * The display name of the quota.
     *
     * Generated from protobuf field <code>string quota_display_name = 10;</code>
     */
    protected $quota_display_name = '';
    /**
     * The unit in which the metric value is reported, e.g., "MByte".
     *
     * Generated from protobuf field <code>string metric_unit = 11;</code>
     */
    protected $metric_unit = '';
    /**
     * Whether it is eligible to request a higher quota value for this quota.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaIncreaseEligibility quota_increase_eligibility = 12;</code>
     */
    protected $quota_increase_eligibility = null;
    /**
     * Whether the quota value is fixed or adjustable
     *
     * Generated from protobuf field <code>bool is_fixed = 13;</code>
     */
    protected $is_fixed = false;
    /**
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     *
     * Generated from protobuf field <code>repeated .google.api.cloudquotas.v1beta.DimensionsInfo dimensions_infos = 14;</code>
     */
    private $dimensions_infos;
    /**
     * Whether the quota is a concurrent quota. Concurrent quotas are enforced
     * on the total number of concurrent operations in flight at any given time.
     *
     * Generated from protobuf field <code>bool is_concurrent = 15;</code>
     */
    protected $is_concurrent = false;
    /**
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     *
     * Generated from protobuf field <code>string service_request_quota_uri = 17;</code>
     */
    protected $service_request_quota_uri = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Resource name of this QuotaInfo.
     *           The ID component following "locations/" must be "global".
     *           For example,
     *           `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     *     @type string $quota_id
     *           The id of the quota, which is unique within the service.
     *           For example, `CpusPerProjectPerRegion`
     *     @type string $metric
     *           The metric of the quota. It specifies the resources consumption the quota
     *           is defined for.
     *           For example, `compute.googleapis.com/cpus`
     *     @type string $service
     *           The name of the service in which the quota is defined.
     *           For example, `compute.googleapis.com`
     *     @type bool $is_precise
     *           Whether this is a precise quota. A precise quota is tracked with absolute
     *           precision. In contrast, an imprecise quota is not tracked with precision.
     *     @type string $refresh_interval
     *           The reset time interval for the quota. Refresh interval applies to rate
     *           quota only.
     *           For example, "minute" for per minute, "day" for per day, or "10 seconds"
     *           for every 10 seconds.
     *     @type int $container_type
     *           The container type of the QuotaInfo.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $dimensions
     *           The dimensions the quota is defined on.
     *     @type string $metric_display_name
     *           The display name of the quota metric
     *     @type string $quota_display_name
     *           The display name of the quota.
     *     @type string $metric_unit
     *           The unit in which the metric value is reported, e.g., "MByte".
     *     @type \Google\Cloud\CloudQuotas\V1beta\QuotaIncreaseEligibility $quota_increase_eligibility
     *           Whether it is eligible to request a higher quota value for this quota.
     *     @type bool $is_fixed
     *           Whether the quota value is fixed or adjustable
     *     @type array<\Google\Cloud\CloudQuotas\V1beta\DimensionsInfo>|\Google\Protobuf\Internal\RepeatedField $dimensions_infos
     *           The collection of dimensions info ordered by their dimensions from more
     *           specific ones to less specific ones.
     *     @type bool $is_concurrent
     *           Whether the quota is a concurrent quota. Concurrent quotas are enforced
     *           on the total number of concurrent operations in flight at any given time.
     *     @type string $service_request_quota_uri
     *           URI to the page where users can request more quota for the cloud
     *           service—for example,
     *           https://console.cloud.google.com/iam-admin/quotas.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Api\Cloudquotas\V1Beta\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * For example,
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * For example,
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The id of the quota, which is unique within the service.
     * For example, `CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string quota_id = 2;</code>
     * @return string
     */
    public function getQuotaId()
    {
        return $this->quota_id;
    }

    /**
     * The id of the quota, which is unique within the service.
     * For example, `CpusPerProjectPerRegion`
     *
     * Generated from protobuf field <code>string quota_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setQuotaId($var)
    {
        GPBUtil::checkString($var, True);
        $this->quota_id = $var;

        return $this;
    }

    /**
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * For example, `compute.googleapis.com/cpus`
     *
     * Generated from protobuf field <code>string metric = 3;</code>
     * @return string
     */
    public function getMetric()
    {
        return $this->metric;
    }

    /**
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * For example, `compute.googleapis.com/cpus`
     *
     * Generated from protobuf field <code>string metric = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setMetric($var)
    {
        GPBUtil::checkString($var, True);
        $this->metric = $var;

        return $this;
    }

    /**
     * The name of the service in which the quota is defined.
     * For example, `compute.googleapis.com`
     *
     * Generated from protobuf field <code>string service = 4;</code>
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * The name of the service in which the quota is defined.
     * For example, `compute.googleapis.com`
     *
     * Generated from protobuf field <code>string service = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setService($var)
    {
        GPBUtil::checkString($var, True);
        $this->service = $var;

        return $this;
    }

    /**
     * Whether this is a precise quota. A precise quota is tracked with absolute
     * precision. In contrast, an imprecise quota is not tracked with precision.
     *
     * Generated from protobuf field <code>bool is_precise = 5;</code>
     * @return bool
     */
    public function getIsPrecise()
    {
        return $this->is_precise;
    }

    /**
     * Whether this is a precise quota. A precise quota is tracked with absolute
     * precision. In contrast, an imprecise quota is not tracked with precision.
     *
     * Generated from protobuf field <code>bool is_precise = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsPrecise($var)
    {
        GPBUtil::checkBool($var);
        $this->is_precise = $var;

        return $this;
    }

    /**
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * For example, "minute" for per minute, "day" for per day, or "10 seconds"
     * for every 10 seconds.
     *
     * Generated from protobuf field <code>string refresh_interval = 6;</code>
     * @return string
     */
    public function getRefreshInterval()
    {
        return $this->refresh_interval;
    }

    /**
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * For example, "minute" for per minute, "day" for per day, or "10 seconds"
     * for every 10 seconds.
     *
     * Generated from protobuf field <code>string refresh_interval = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setRefreshInterval($var)
    {
        GPBUtil::checkString($var, True);
        $this->refresh_interval = $var;

        return $this;
    }

    /**
     * The container type of the QuotaInfo.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaInfo.ContainerType container_type = 7;</code>
     * @return int
     */
    public function getContainerType()
    {
        return $this->container_type;
    }

    /**
     * The container type of the QuotaInfo.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaInfo.ContainerType container_type = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setContainerType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudQuotas\V1beta\QuotaInfo\ContainerType::class);
        $this->container_type = $var;

        return $this;
    }

    /**
     * The dimensions the quota is defined on.
     *
     * Generated from protobuf field <code>repeated string dimensions = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDimensions()
    {
        return $this->dimensions;
    }

    /**
     * The dimensions the quota is defined on.
     *
     * Generated from protobuf field <code>repeated string dimensions = 8;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDimensions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->dimensions = $arr;

        return $this;
    }

    /**
     * The display name of the quota metric
     *
     * Generated from protobuf field <code>string metric_display_name = 9;</code>
     * @return string
     */
    public function getMetricDisplayName()
    {
        return $this->metric_display_name;
    }

    /**
     * The display name of the quota metric
     *
     * Generated from protobuf field <code>string metric_display_name = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setMetricDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->metric_display_name = $var;

        return $this;
    }

    /**
     * The display name of the quota.
     *
     * Generated from protobuf field <code>string quota_display_name = 10;</code>
     * @return string
     */
    public function getQuotaDisplayName()
    {
        return $this->quota_display_name;
    }

    /**
     * The display name of the quota.
     *
     * Generated from protobuf field <code>string quota_display_name = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setQuotaDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->quota_display_name = $var;

        return $this;
    }

    /**
     * The unit in which the metric value is reported, e.g., "MByte".
     *
     * Generated from protobuf field <code>string metric_unit = 11;</code>
     * @return string
     */
    public function getMetricUnit()
    {
        return $this->metric_unit;
    }

    /**
     * The unit in which the metric value is reported, e.g., "MByte".
     *
     * Generated from protobuf field <code>string metric_unit = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setMetricUnit($var)
    {
        GPBUtil::checkString($var, True);
        $this->metric_unit = $var;

        return $this;
    }

    /**
     * Whether it is eligible to request a higher quota value for this quota.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaIncreaseEligibility quota_increase_eligibility = 12;</code>
     * @return \Google\Cloud\CloudQuotas\V1beta\QuotaIncreaseEligibility|null
     */
    public function getQuotaIncreaseEligibility()
    {
        return $this->quota_increase_eligibility;
    }

    public function hasQuotaIncreaseEligibility()
    {
        return isset($this->quota_increase_eligibility);
    }

    public function clearQuotaIncreaseEligibility()
    {
        unset($this->quota_increase_eligibility);
    }

    /**
     * Whether it is eligible to request a higher quota value for this quota.
     *
     * Generated from protobuf field <code>.google.api.cloudquotas.v1beta.QuotaIncreaseEligibility quota_increase_eligibility = 12;</code>
     * @param \Google\Cloud\CloudQuotas\V1beta\QuotaIncreaseEligibility $var
     * @return $this
     */
    public function setQuotaIncreaseEligibility($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudQuotas\V1beta\QuotaIncreaseEligibility::class);
        $this->quota_increase_eligibility = $var;

        return $this;
    }

    /**
     * Whether the quota value is fixed or adjustable
     *
     * Generated from protobuf field <code>bool is_fixed = 13;</code>
     * @return bool
     */
    public function getIsFixed()
    {
        return $this->is_fixed;
    }

    /**
     * Whether the quota value is fixed or adjustable
     *
     * Generated from protobuf field <code>bool is_fixed = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsFixed($var)
    {
        GPBUtil::checkBool($var);
        $this->is_fixed = $var;

        return $this;
    }

    /**
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     *
     * Generated from protobuf field <code>repeated .google.api.cloudquotas.v1beta.DimensionsInfo dimensions_infos = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDimensionsInfos()
    {
        return $this->dimensions_infos;
    }

    /**
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     *
     * Generated from protobuf field <code>repeated .google.api.cloudquotas.v1beta.DimensionsInfo dimensions_infos = 14;</code>
     * @param array<\Google\Cloud\CloudQuotas\V1beta\DimensionsInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDimensionsInfos($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\CloudQuotas\V1beta\DimensionsInfo::class);
        $this->dimensions_infos = $arr;

        return $this;
    }

    /**
     * Whether the quota is a concurrent quota. Concurrent quotas are enforced
     * on the total number of concurrent operations in flight at any given time.
     *
     * Generated from protobuf field <code>bool is_concurrent = 15;</code>
     * @return bool
     */
    public function getIsConcurrent()
    {
        return $this->is_concurrent;
    }

    /**
     * Whether the quota is a concurrent quota. Concurrent quotas are enforced
     * on the total number of concurrent operations in flight at any given time.
     *
     * Generated from protobuf field <code>bool is_concurrent = 15;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsConcurrent($var)
    {
        GPBUtil::checkBool($var);
        $this->is_concurrent = $var;

        return $this;
    }

    /**
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     *
     * Generated from protobuf field <code>string service_request_quota_uri = 17;</code>
     * @return string
     */
    public function getServiceRequestQuotaUri()
    {
        return $this->service_request_quota_uri;
    }

    /**
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     *
     * Generated from protobuf field <code>string service_request_quota_uri = 17;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceRequestQuotaUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_request_quota_uri = $var;

        return $this;
    }

}

