<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/os_policy_assignments.proto

namespace Google\Cloud\OsConfig\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * OS policy assignment is an API resource that is used to
 * apply a set of OS policies to a dynamically targeted group of Compute Engine
 * VM instances.
 * An OS policy is used to define the desired state configuration for a
 * Compute Engine VM instance through a set of configuration resources that
 * provide capabilities such as installing or removing software packages, or
 * executing a script.
 * For more information, see [OS policy and OS policy
 * assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.OSPolicyAssignment</code>
 */
class OSPolicyAssignment extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource name.
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     * This field is ignored when you create an OS policy assignment.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    protected $description = '';
    /**
     * Required. List of OS policies to be applied to the VMs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $os_policies;
    /**
     * Required. Filter to select VMs.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $instance_filter = null;
    /**
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $rollout = null;
    /**
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     *
     * Generated from protobuf field <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_id = '';
    /**
     * Output only. The timestamp that the revision was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_create_time = null;
    /**
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     *
     * Generated from protobuf field <code>string etag = 8;</code>
     */
    protected $etag = '';
    /**
     * Output only. OS policy assignment rollout state
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $rollout_state = 0;
    /**
     * Output only. Indicates that this revision has been successfully rolled out
     * in this zone and new VMs will be assigned OS policies from this revision.
     * For a given OS policy assignment, there is only one revision with a value
     * of `true` for this field.
     *
     * Generated from protobuf field <code>bool baseline = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $baseline = false;
    /**
     * Output only. Indicates that this revision deletes the OS policy assignment.
     *
     * Generated from protobuf field <code>bool deleted = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deleted = false;
    /**
     * Output only. Indicates that reconciliation is in progress for the revision.
     * This value is `true` when the `rollout_state` is one of:
     * * IN_PROGRESS
     * * CANCELLING
     *
     * Generated from protobuf field <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Output only. Server generated unique id for the OS policy assignment
     * resource.
     *
     * Generated from protobuf field <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Resource name.
     *           Format:
     *           `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     *           This field is ignored when you create an OS policy assignment.
     *     @type string $description
     *           OS policy assignment description.
     *           Length of the description is limited to 1024 characters.
     *     @type array<\Google\Cloud\OsConfig\V1\OSPolicy>|\Google\Protobuf\Internal\RepeatedField $os_policies
     *           Required. List of OS policies to be applied to the VMs.
     *     @type \Google\Cloud\OsConfig\V1\OSPolicyAssignment\InstanceFilter $instance_filter
     *           Required. Filter to select VMs.
     *     @type \Google\Cloud\OsConfig\V1\OSPolicyAssignment\Rollout $rollout
     *           Required. Rollout to deploy the OS policy assignment.
     *           A rollout is triggered in the following situations:
     *           1) OSPolicyAssignment is created.
     *           2) OSPolicyAssignment is updated and the update contains changes to one of
     *           the following fields:
     *              - instance_filter
     *              - os_policies
     *           3) OSPolicyAssignment is deleted.
     *     @type string $revision_id
     *           Output only. The assignment revision ID
     *           A new revision is committed whenever a rollout is triggered for a OS policy
     *           assignment
     *     @type \Google\Protobuf\Timestamp $revision_create_time
     *           Output only. The timestamp that the revision was created.
     *     @type string $etag
     *           The etag for this OS policy assignment.
     *           If this is provided on update, it must match the server's etag.
     *     @type int $rollout_state
     *           Output only. OS policy assignment rollout state
     *     @type bool $baseline
     *           Output only. Indicates that this revision has been successfully rolled out
     *           in this zone and new VMs will be assigned OS policies from this revision.
     *           For a given OS policy assignment, there is only one revision with a value
     *           of `true` for this field.
     *     @type bool $deleted
     *           Output only. Indicates that this revision deletes the OS policy assignment.
     *     @type bool $reconciling
     *           Output only. Indicates that reconciliation is in progress for the revision.
     *           This value is `true` when the `rollout_state` is one of:
     *           * IN_PROGRESS
     *           * CANCELLING
     *     @type string $uid
     *           Output only. Server generated unique id for the OS policy assignment
     *           resource.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\OsPolicyAssignments::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name.
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     * This field is ignored when you create an OS policy assignment.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Resource name.
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     * This field is ignored when you create an OS policy assignment.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. List of OS policies to be applied to the VMs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOsPolicies()
    {
        return $this->os_policies;
    }

    /**
     * Required. List of OS policies to be applied to the VMs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\OsConfig\V1\OSPolicy>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOsPolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\OSPolicy::class);
        $this->os_policies = $arr;

        return $this;
    }

    /**
     * Required. Filter to select VMs.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\OsConfig\V1\OSPolicyAssignment\InstanceFilter|null
     */
    public function getInstanceFilter()
    {
        return $this->instance_filter;
    }

    public function hasInstanceFilter()
    {
        return isset($this->instance_filter);
    }

    public function clearInstanceFilter()
    {
        unset($this->instance_filter);
    }

    /**
     * Required. Filter to select VMs.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\OsConfig\V1\OSPolicyAssignment\InstanceFilter $var
     * @return $this
     */
    public function setInstanceFilter($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OsConfig\V1\OSPolicyAssignment\InstanceFilter::class);
        $this->instance_filter = $var;

        return $this;
    }

    /**
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\OsConfig\V1\OSPolicyAssignment\Rollout|null
     */
    public function getRollout()
    {
        return $this->rollout;
    }

    public function hasRollout()
    {
        return isset($this->rollout);
    }

    public function clearRollout()
    {
        unset($this->rollout);
    }

    /**
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\OsConfig\V1\OSPolicyAssignment\Rollout $var
     * @return $this
     */
    public function setRollout($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OsConfig\V1\OSPolicyAssignment\Rollout::class);
        $this->rollout = $var;

        return $this;
    }

    /**
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     *
     * Generated from protobuf field <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRevisionId()
    {
        return $this->revision_id;
    }

    /**
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     *
     * Generated from protobuf field <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRevisionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->revision_id = $var;

        return $this;
    }

    /**
     * Output only. The timestamp that the revision was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRevisionCreateTime()
    {
        return $this->revision_create_time;
    }

    public function hasRevisionCreateTime()
    {
        return isset($this->revision_create_time);
    }

    public function clearRevisionCreateTime()
    {
        unset($this->revision_create_time);
    }

    /**
     * Output only. The timestamp that the revision was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRevisionCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->revision_create_time = $var;

        return $this;
    }

    /**
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     *
     * Generated from protobuf field <code>string etag = 8;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     *
     * Generated from protobuf field <code>string etag = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. OS policy assignment rollout state
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRolloutState()
    {
        return $this->rollout_state;
    }

    /**
     * Output only. OS policy assignment rollout state
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRolloutState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OsConfig\V1\OSPolicyAssignment\RolloutState::class);
        $this->rollout_state = $var;

        return $this;
    }

    /**
     * Output only. Indicates that this revision has been successfully rolled out
     * in this zone and new VMs will be assigned OS policies from this revision.
     * For a given OS policy assignment, there is only one revision with a value
     * of `true` for this field.
     *
     * Generated from protobuf field <code>bool baseline = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getBaseline()
    {
        return $this->baseline;
    }

    /**
     * Output only. Indicates that this revision has been successfully rolled out
     * in this zone and new VMs will be assigned OS policies from this revision.
     * For a given OS policy assignment, there is only one revision with a value
     * of `true` for this field.
     *
     * Generated from protobuf field <code>bool baseline = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setBaseline($var)
    {
        GPBUtil::checkBool($var);
        $this->baseline = $var;

        return $this;
    }

    /**
     * Output only. Indicates that this revision deletes the OS policy assignment.
     *
     * Generated from protobuf field <code>bool deleted = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * Output only. Indicates that this revision deletes the OS policy assignment.
     *
     * Generated from protobuf field <code>bool deleted = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setDeleted($var)
    {
        GPBUtil::checkBool($var);
        $this->deleted = $var;

        return $this;
    }

    /**
     * Output only. Indicates that reconciliation is in progress for the revision.
     * This value is `true` when the `rollout_state` is one of:
     * * IN_PROGRESS
     * * CANCELLING
     *
     * Generated from protobuf field <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Indicates that reconciliation is in progress for the revision.
     * This value is `true` when the `rollout_state` is one of:
     * * IN_PROGRESS
     * * CANCELLING
     *
     * Generated from protobuf field <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Output only. Server generated unique id for the OS policy assignment
     * resource.
     *
     * Generated from protobuf field <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server generated unique id for the OS policy assignment
     * resource.
     *
     * Generated from protobuf field <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

}

