<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/database.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Backup Options for the Database.
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.DbBackupConfig</code>
 */
class DbBackupConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. If set to true, enables automatic backups on the database.
     *
     * Generated from protobuf field <code>bool auto_backup_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $auto_backup_enabled = false;
    /**
     * Optional. Details of the database backup destinations.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.DbBackupConfig.BackupDestinationDetails backup_destination_details = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $backup_destination_details;
    /**
     * Optional. The number of days an automatic backup is retained before being
     * automatically deleted. This value determines the earliest point in time to
     * which a database can be restored. Min: 1, Max: 60.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $retention_period_days = 0;
    /**
     * Optional. This defines when the backups will be deleted after Database
     * termination.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupDeletionPolicy backup_deletion_policy = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $backup_deletion_policy = 0;
    /**
     * Optional. The day of the week on which the full backup should be performed
     * on the database. If no value is provided, it will default to Sunday.
     *
     * Generated from protobuf field <code>.google.type.DayOfWeek auto_full_backup_day = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $auto_full_backup_day = 0;
    /**
     * Optional. The window in which the full backup should be performed on the
     * database. If no value is provided, the default is anytime.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupWindow auto_full_backup_window = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $auto_full_backup_window = 0;
    /**
     * Optional. The window in which the incremental backup should be performed on
     * the database. If no value is provided, the default is anytime except the
     * auto full backup day.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupWindow auto_incremental_backup_window = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $auto_incremental_backup_window = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $auto_backup_enabled
     *           Optional. If set to true, enables automatic backups on the database.
     *     @type array<\Google\Cloud\OracleDatabase\V1\DbBackupConfig\BackupDestinationDetails>|\Google\Protobuf\Internal\RepeatedField $backup_destination_details
     *           Optional. Details of the database backup destinations.
     *     @type int $retention_period_days
     *           Optional. The number of days an automatic backup is retained before being
     *           automatically deleted. This value determines the earliest point in time to
     *           which a database can be restored. Min: 1, Max: 60.
     *     @type int $backup_deletion_policy
     *           Optional. This defines when the backups will be deleted after Database
     *           termination.
     *     @type int $auto_full_backup_day
     *           Optional. The day of the week on which the full backup should be performed
     *           on the database. If no value is provided, it will default to Sunday.
     *     @type int $auto_full_backup_window
     *           Optional. The window in which the full backup should be performed on the
     *           database. If no value is provided, the default is anytime.
     *     @type int $auto_incremental_backup_window
     *           Optional. The window in which the incremental backup should be performed on
     *           the database. If no value is provided, the default is anytime except the
     *           auto full backup day.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\Database::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. If set to true, enables automatic backups on the database.
     *
     * Generated from protobuf field <code>bool auto_backup_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAutoBackupEnabled()
    {
        return $this->auto_backup_enabled;
    }

    /**
     * Optional. If set to true, enables automatic backups on the database.
     *
     * Generated from protobuf field <code>bool auto_backup_enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoBackupEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_backup_enabled = $var;

        return $this;
    }

    /**
     * Optional. Details of the database backup destinations.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.DbBackupConfig.BackupDestinationDetails backup_destination_details = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBackupDestinationDetails()
    {
        return $this->backup_destination_details;
    }

    /**
     * Optional. Details of the database backup destinations.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.DbBackupConfig.BackupDestinationDetails backup_destination_details = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\OracleDatabase\V1\DbBackupConfig\BackupDestinationDetails>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBackupDestinationDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OracleDatabase\V1\DbBackupConfig\BackupDestinationDetails::class);
        $this->backup_destination_details = $arr;

        return $this;
    }

    /**
     * Optional. The number of days an automatic backup is retained before being
     * automatically deleted. This value determines the earliest point in time to
     * which a database can be restored. Min: 1, Max: 60.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRetentionPeriodDays()
    {
        return $this->retention_period_days;
    }

    /**
     * Optional. The number of days an automatic backup is retained before being
     * automatically deleted. This value determines the earliest point in time to
     * which a database can be restored. Min: 1, Max: 60.
     *
     * Generated from protobuf field <code>int32 retention_period_days = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRetentionPeriodDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->retention_period_days = $var;

        return $this;
    }

    /**
     * Optional. This defines when the backups will be deleted after Database
     * termination.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupDeletionPolicy backup_deletion_policy = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getBackupDeletionPolicy()
    {
        return $this->backup_deletion_policy;
    }

    /**
     * Optional. This defines when the backups will be deleted after Database
     * termination.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupDeletionPolicy backup_deletion_policy = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setBackupDeletionPolicy($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DbBackupConfig\BackupDeletionPolicy::class);
        $this->backup_deletion_policy = $var;

        return $this;
    }

    /**
     * Optional. The day of the week on which the full backup should be performed
     * on the database. If no value is provided, it will default to Sunday.
     *
     * Generated from protobuf field <code>.google.type.DayOfWeek auto_full_backup_day = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAutoFullBackupDay()
    {
        return $this->auto_full_backup_day;
    }

    /**
     * Optional. The day of the week on which the full backup should be performed
     * on the database. If no value is provided, it will default to Sunday.
     *
     * Generated from protobuf field <code>.google.type.DayOfWeek auto_full_backup_day = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAutoFullBackupDay($var)
    {
        GPBUtil::checkEnum($var, \Google\Type\DayOfWeek::class);
        $this->auto_full_backup_day = $var;

        return $this;
    }

    /**
     * Optional. The window in which the full backup should be performed on the
     * database. If no value is provided, the default is anytime.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupWindow auto_full_backup_window = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAutoFullBackupWindow()
    {
        return $this->auto_full_backup_window;
    }

    /**
     * Optional. The window in which the full backup should be performed on the
     * database. If no value is provided, the default is anytime.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupWindow auto_full_backup_window = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAutoFullBackupWindow($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DbBackupConfig\BackupWindow::class);
        $this->auto_full_backup_window = $var;

        return $this;
    }

    /**
     * Optional. The window in which the incremental backup should be performed on
     * the database. If no value is provided, the default is anytime except the
     * auto full backup day.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupWindow auto_incremental_backup_window = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAutoIncrementalBackupWindow()
    {
        return $this->auto_incremental_backup_window;
    }

    /**
     * Optional. The window in which the incremental backup should be performed on
     * the database. If no value is provided, the default is anytime except the
     * auto full backup day.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DbBackupConfig.BackupWindow auto_incremental_backup_window = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAutoIncrementalBackupWindow($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DbBackupConfig\BackupWindow::class);
        $this->auto_incremental_backup_window = $var;

        return $this;
    }

}

