<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/dep.proto

namespace Google\Cloud\NetworkServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * `AuthzExtension` is a resource that allows traffic forwarding
 * to a callout backend service to make an authorization decision.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.AuthzExtension</code>
 */
class AuthzExtension extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Identifier. Name of the `AuthzExtension` resource in the
     * following format:
     * `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. A human-readable description of the resource.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. Set of labels associated with the `AuthzExtension`
     * resource.
     * The format must comply with [the requirements for
     * labels](/compute/docs/labeling-resources#requirements) for Google Cloud
     * resources.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Required. All backend services and forwarding rules referenced by this
     * extension must share the same load balancing scheme. Supported values:
     * `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more information, refer to
     * [Backend services
     * overview](https://cloud.google.com/load-balancing/docs/backend-service).
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.LoadBalancingScheme load_balancing_scheme = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $load_balancing_scheme = 0;
    /**
     * Required. The `:authority` header in the gRPC request sent from Envoy
     * to the extension service.
     *
     * Generated from protobuf field <code>string authority = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $authority = '';
    /**
     * Required. The reference to the service that runs the extension.
     * To configure a callout extension, `service` must be a fully-qualified
     * reference
     * to a [backend
     * service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices)
     * in the format:
     * `https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}`
     * or
     * `https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}`.
     *
     * Generated from protobuf field <code>string service = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $service = '';
    /**
     * Required. Specifies the timeout for each individual message on the stream.
     * The timeout must be between 10-10000 milliseconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $timeout = null;
    /**
     * Optional. Determines how the proxy behaves if the call to the extension
     * fails or times out.
     * When set to `TRUE`, request or response processing continues without
     * error. Any subsequent extensions in the extension chain are also
     * executed. When set to `FALSE` or the default setting of `FALSE` is used,
     * one of the following happens:
     * * If response headers have not been delivered to the downstream client,
     * a generic 500 error is returned to the client. The error response can be
     * tailored by configuring a custom error response in the load balancer.
     * * If response headers have been delivered, then the HTTP stream to the
     * downstream client is reset.
     *
     * Generated from protobuf field <code>bool fail_open = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $fail_open = false;
    /**
     * Optional. The metadata provided here is included as part of the
     * `metadata_context` (of type `google.protobuf.Struct`) in the
     * `ProcessingRequest` message sent to the extension
     * server. The metadata is available under the namespace
     * `com.google.authz_extension.<resource_name>`.
     * The following variables are supported in the metadata Struct:
     * `{forwarding_rule_id}` - substituted with the forwarding rule's fully
     *   qualified resource name.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct metadata = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $metadata = null;
    /**
     * Optional. List of the HTTP headers to forward to the extension
     * (from the client). If omitted, all headers are sent.
     * Each element is a string indicating the header name.
     *
     * Generated from protobuf field <code>repeated string forward_headers = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $forward_headers;
    /**
     * Optional. The format of communication supported by the callout extension.
     * If not specified, the default value `EXT_PROC_GRPC` is used.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.WireFormat wire_format = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $wire_format = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Identifier. Name of the `AuthzExtension` resource in the
     *           following format:
     *           `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the resource was updated.
     *     @type string $description
     *           Optional. A human-readable description of the resource.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Set of labels associated with the `AuthzExtension`
     *           resource.
     *           The format must comply with [the requirements for
     *           labels](/compute/docs/labeling-resources#requirements) for Google Cloud
     *           resources.
     *     @type int $load_balancing_scheme
     *           Required. All backend services and forwarding rules referenced by this
     *           extension must share the same load balancing scheme. Supported values:
     *           `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more information, refer to
     *           [Backend services
     *           overview](https://cloud.google.com/load-balancing/docs/backend-service).
     *     @type string $authority
     *           Required. The `:authority` header in the gRPC request sent from Envoy
     *           to the extension service.
     *     @type string $service
     *           Required. The reference to the service that runs the extension.
     *           To configure a callout extension, `service` must be a fully-qualified
     *           reference
     *           to a [backend
     *           service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices)
     *           in the format:
     *           `https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}`
     *           or
     *           `https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}`.
     *     @type \Google\Protobuf\Duration $timeout
     *           Required. Specifies the timeout for each individual message on the stream.
     *           The timeout must be between 10-10000 milliseconds.
     *     @type bool $fail_open
     *           Optional. Determines how the proxy behaves if the call to the extension
     *           fails or times out.
     *           When set to `TRUE`, request or response processing continues without
     *           error. Any subsequent extensions in the extension chain are also
     *           executed. When set to `FALSE` or the default setting of `FALSE` is used,
     *           one of the following happens:
     *           * If response headers have not been delivered to the downstream client,
     *           a generic 500 error is returned to the client. The error response can be
     *           tailored by configuring a custom error response in the load balancer.
     *           * If response headers have been delivered, then the HTTP stream to the
     *           downstream client is reset.
     *     @type \Google\Protobuf\Struct $metadata
     *           Optional. The metadata provided here is included as part of the
     *           `metadata_context` (of type `google.protobuf.Struct`) in the
     *           `ProcessingRequest` message sent to the extension
     *           server. The metadata is available under the namespace
     *           `com.google.authz_extension.<resource_name>`.
     *           The following variables are supported in the metadata Struct:
     *           `{forwarding_rule_id}` - substituted with the forwarding rule's fully
     *             qualified resource name.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $forward_headers
     *           Optional. List of the HTTP headers to forward to the extension
     *           (from the client). If omitted, all headers are sent.
     *           Each element is a string indicating the header name.
     *     @type int $wire_format
     *           Optional. The format of communication supported by the callout extension.
     *           If not specified, the default value `EXT_PROC_GRPC` is used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\Dep::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Identifier. Name of the `AuthzExtension` resource in the
     * following format:
     * `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Identifier. Name of the `AuthzExtension` resource in the
     * following format:
     * `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. A human-readable description of the resource.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A human-readable description of the resource.
     *
     * Generated from protobuf field <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. Set of labels associated with the `AuthzExtension`
     * resource.
     * The format must comply with [the requirements for
     * labels](/compute/docs/labeling-resources#requirements) for Google Cloud
     * resources.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Set of labels associated with the `AuthzExtension`
     * resource.
     * The format must comply with [the requirements for
     * labels](/compute/docs/labeling-resources#requirements) for Google Cloud
     * resources.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. All backend services and forwarding rules referenced by this
     * extension must share the same load balancing scheme. Supported values:
     * `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more information, refer to
     * [Backend services
     * overview](https://cloud.google.com/load-balancing/docs/backend-service).
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.LoadBalancingScheme load_balancing_scheme = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getLoadBalancingScheme()
    {
        return $this->load_balancing_scheme;
    }

    /**
     * Required. All backend services and forwarding rules referenced by this
     * extension must share the same load balancing scheme. Supported values:
     * `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more information, refer to
     * [Backend services
     * overview](https://cloud.google.com/load-balancing/docs/backend-service).
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.LoadBalancingScheme load_balancing_scheme = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setLoadBalancingScheme($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\LoadBalancingScheme::class);
        $this->load_balancing_scheme = $var;

        return $this;
    }

    /**
     * Required. The `:authority` header in the gRPC request sent from Envoy
     * to the extension service.
     *
     * Generated from protobuf field <code>string authority = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getAuthority()
    {
        return $this->authority;
    }

    /**
     * Required. The `:authority` header in the gRPC request sent from Envoy
     * to the extension service.
     *
     * Generated from protobuf field <code>string authority = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setAuthority($var)
    {
        GPBUtil::checkString($var, True);
        $this->authority = $var;

        return $this;
    }

    /**
     * Required. The reference to the service that runs the extension.
     * To configure a callout extension, `service` must be a fully-qualified
     * reference
     * to a [backend
     * service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices)
     * in the format:
     * `https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}`
     * or
     * `https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}`.
     *
     * Generated from protobuf field <code>string service = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * Required. The reference to the service that runs the extension.
     * To configure a callout extension, `service` must be a fully-qualified
     * reference
     * to a [backend
     * service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices)
     * in the format:
     * `https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}`
     * or
     * `https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}`.
     *
     * Generated from protobuf field <code>string service = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setService($var)
    {
        GPBUtil::checkString($var, True);
        $this->service = $var;

        return $this;
    }

    /**
     * Required. Specifies the timeout for each individual message on the stream.
     * The timeout must be between 10-10000 milliseconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * Required. Specifies the timeout for each individual message on the stream.
     * The timeout must be between 10-10000 milliseconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * Optional. Determines how the proxy behaves if the call to the extension
     * fails or times out.
     * When set to `TRUE`, request or response processing continues without
     * error. Any subsequent extensions in the extension chain are also
     * executed. When set to `FALSE` or the default setting of `FALSE` is used,
     * one of the following happens:
     * * If response headers have not been delivered to the downstream client,
     * a generic 500 error is returned to the client. The error response can be
     * tailored by configuring a custom error response in the load balancer.
     * * If response headers have been delivered, then the HTTP stream to the
     * downstream client is reset.
     *
     * Generated from protobuf field <code>bool fail_open = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getFailOpen()
    {
        return $this->fail_open;
    }

    /**
     * Optional. Determines how the proxy behaves if the call to the extension
     * fails or times out.
     * When set to `TRUE`, request or response processing continues without
     * error. Any subsequent extensions in the extension chain are also
     * executed. When set to `FALSE` or the default setting of `FALSE` is used,
     * one of the following happens:
     * * If response headers have not been delivered to the downstream client,
     * a generic 500 error is returned to the client. The error response can be
     * tailored by configuring a custom error response in the load balancer.
     * * If response headers have been delivered, then the HTTP stream to the
     * downstream client is reset.
     *
     * Generated from protobuf field <code>bool fail_open = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setFailOpen($var)
    {
        GPBUtil::checkBool($var);
        $this->fail_open = $var;

        return $this;
    }

    /**
     * Optional. The metadata provided here is included as part of the
     * `metadata_context` (of type `google.protobuf.Struct`) in the
     * `ProcessingRequest` message sent to the extension
     * server. The metadata is available under the namespace
     * `com.google.authz_extension.<resource_name>`.
     * The following variables are supported in the metadata Struct:
     * `{forwarding_rule_id}` - substituted with the forwarding rule's fully
     *   qualified resource name.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct metadata = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * Optional. The metadata provided here is included as part of the
     * `metadata_context` (of type `google.protobuf.Struct`) in the
     * `ProcessingRequest` message sent to the extension
     * server. The metadata is available under the namespace
     * `com.google.authz_extension.<resource_name>`.
     * The following variables are supported in the metadata Struct:
     * `{forwarding_rule_id}` - substituted with the forwarding rule's fully
     *   qualified resource name.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct metadata = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * Optional. List of the HTTP headers to forward to the extension
     * (from the client). If omitted, all headers are sent.
     * Each element is a string indicating the header name.
     *
     * Generated from protobuf field <code>repeated string forward_headers = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getForwardHeaders()
    {
        return $this->forward_headers;
    }

    /**
     * Optional. List of the HTTP headers to forward to the extension
     * (from the client). If omitted, all headers are sent.
     * Each element is a string indicating the header name.
     *
     * Generated from protobuf field <code>repeated string forward_headers = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setForwardHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->forward_headers = $arr;

        return $this;
    }

    /**
     * Optional. The format of communication supported by the callout extension.
     * If not specified, the default value `EXT_PROC_GRPC` is used.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.WireFormat wire_format = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getWireFormat()
    {
        return $this->wire_format;
    }

    /**
     * Optional. The format of communication supported by the callout extension.
     * If not specified, the default value `EXT_PROC_GRPC` is used.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.WireFormat wire_format = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setWireFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\WireFormat::class);
        $this->wire_format = $var;

        return $this;
    }

}

