<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkmanagement/v1/trace.proto

namespace Google\Cloud\NetworkManagement\V1\DropInfo;

use UnexpectedValueException;

/**
 * Drop cause types:
 *
 * Protobuf type <code>google.cloud.networkmanagement.v1.DropInfo.Cause</code>
 */
class Cause
{
    /**
     * Cause is unspecified.
     *
     * Generated from protobuf enum <code>CAUSE_UNSPECIFIED = 0;</code>
     */
    const CAUSE_UNSPECIFIED = 0;
    /**
     * Destination external address cannot be resolved to a known target. If
     * the address is used in a Google Cloud project, provide the project ID
     * as test input.
     *
     * Generated from protobuf enum <code>UNKNOWN_EXTERNAL_ADDRESS = 1;</code>
     */
    const UNKNOWN_EXTERNAL_ADDRESS = 1;
    /**
     * A Compute Engine instance can only send or receive a packet with a
     * foreign IP address if ip_forward is enabled.
     *
     * Generated from protobuf enum <code>FOREIGN_IP_DISALLOWED = 2;</code>
     */
    const FOREIGN_IP_DISALLOWED = 2;
    /**
     * Dropped due to a firewall rule, unless allowed due to connection
     * tracking.
     *
     * Generated from protobuf enum <code>FIREWALL_RULE = 3;</code>
     */
    const FIREWALL_RULE = 3;
    /**
     * Dropped due to no matching routes.
     *
     * Generated from protobuf enum <code>NO_ROUTE = 4;</code>
     */
    const NO_ROUTE = 4;
    /**
     * Dropped due to invalid route. Route's next hop is a blackhole.
     *
     * Generated from protobuf enum <code>ROUTE_BLACKHOLE = 5;</code>
     */
    const ROUTE_BLACKHOLE = 5;
    /**
     * Packet is sent to a wrong (unintended) network. Example: you trace a
     * packet from VM1:Network1 to VM2:Network2, however, the route configured
     * in Network1 sends the packet destined for VM2's IP address to Network3.
     *
     * Generated from protobuf enum <code>ROUTE_WRONG_NETWORK = 6;</code>
     */
    const ROUTE_WRONG_NETWORK = 6;
    /**
     * Route's next hop IP address cannot be resolved to a GCP resource.
     *
     * Generated from protobuf enum <code>ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED = 42;</code>
     */
    const ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED = 42;
    /**
     * Route's next hop resource is not found.
     *
     * Generated from protobuf enum <code>ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND = 43;</code>
     */
    const ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND = 43;
    /**
     * Route's next hop instance doesn't have a NIC in the route's network.
     *
     * Generated from protobuf enum <code>ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK = 49;</code>
     */
    const ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK = 49;
    /**
     * Route's next hop IP address is not a primary IP address of the next hop
     * instance.
     *
     * Generated from protobuf enum <code>ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP = 50;</code>
     */
    const ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP = 50;
    /**
     * Route's next hop forwarding rule doesn't match next hop IP address.
     *
     * Generated from protobuf enum <code>ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH = 51;</code>
     */
    const ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH = 51;
    /**
     * Route's next hop VPN tunnel is down (does not have valid IKE SAs).
     *
     * Generated from protobuf enum <code>ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED = 52;</code>
     */
    const ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED = 52;
    /**
     * Route's next hop forwarding rule type is invalid (it's not a forwarding
     * rule of the internal passthrough load balancer).
     *
     * Generated from protobuf enum <code>ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID = 53;</code>
     */
    const ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID = 53;
    /**
     * Packet is sent from the Internet to the private IPv6 address.
     *
     * Generated from protobuf enum <code>NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS = 44;</code>
     */
    const NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS = 44;
    /**
     * Packet is sent from the Internet to the private IPv4 address.
     *
     * Generated from protobuf enum <code>NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV4_ADDRESS = 109;</code>
     */
    const NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV4_ADDRESS = 109;
    /**
     * Packet is sent from the external IPv6 source address of an instance to
     * the private IPv6 address of an instance.
     *
     * Generated from protobuf enum <code>NO_ROUTE_FROM_EXTERNAL_IPV6_SOURCE_TO_PRIVATE_IPV6_ADDRESS = 98;</code>
     */
    const NO_ROUTE_FROM_EXTERNAL_IPV6_SOURCE_TO_PRIVATE_IPV6_ADDRESS = 98;
    /**
     * The packet does not match a policy-based VPN tunnel local selector.
     *
     * Generated from protobuf enum <code>VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH = 45;</code>
     */
    const VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH = 45;
    /**
     * The packet does not match a policy-based VPN tunnel remote selector.
     *
     * Generated from protobuf enum <code>VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH = 46;</code>
     */
    const VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH = 46;
    /**
     * Packet with internal destination address sent to the internet gateway.
     *
     * Generated from protobuf enum <code>PRIVATE_TRAFFIC_TO_INTERNET = 7;</code>
     */
    const PRIVATE_TRAFFIC_TO_INTERNET = 7;
    /**
     * Endpoint with only an internal IP address tries to access Google API and
     * services, but Private Google Access is not enabled in the subnet or is
     * not applicable.
     *
     * Generated from protobuf enum <code>PRIVATE_GOOGLE_ACCESS_DISALLOWED = 8;</code>
     */
    const PRIVATE_GOOGLE_ACCESS_DISALLOWED = 8;
    /**
     * Source endpoint tries to access Google API and services through the VPN
     * tunnel to another network, but Private Google Access needs to be enabled
     * in the source endpoint network.
     *
     * Generated from protobuf enum <code>PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED = 47;</code>
     */
    const PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED = 47;
    /**
     * Endpoint with only an internal IP address tries to access external hosts,
     * but there is no matching Cloud NAT gateway in the subnet.
     *
     * Generated from protobuf enum <code>NO_EXTERNAL_ADDRESS = 9;</code>
     */
    const NO_EXTERNAL_ADDRESS = 9;
    /**
     * Destination internal address cannot be resolved to a known target. If
     * this is a shared VPC scenario, verify if the service project ID is
     * provided as test input. Otherwise, verify if the IP address is being
     * used in the project.
     *
     * Generated from protobuf enum <code>UNKNOWN_INTERNAL_ADDRESS = 10;</code>
     */
    const UNKNOWN_INTERNAL_ADDRESS = 10;
    /**
     * Forwarding rule's protocol and ports do not match the packet header.
     *
     * Generated from protobuf enum <code>FORWARDING_RULE_MISMATCH = 11;</code>
     */
    const FORWARDING_RULE_MISMATCH = 11;
    /**
     * Forwarding rule does not have backends configured.
     *
     * Generated from protobuf enum <code>FORWARDING_RULE_NO_INSTANCES = 12;</code>
     */
    const FORWARDING_RULE_NO_INSTANCES = 12;
    /**
     * Firewalls block the health check probes to the backends and cause
     * the backends to be unavailable for traffic from the load balancer.
     * For more details, see [Health check firewall
     * rules](https://cloud.google.com/load-balancing/docs/health-checks#firewall_rules).
     *
     * Generated from protobuf enum <code>FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK = 13;</code>
     */
    const FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK = 13;
    /**
     * Matching ingress firewall rules by network tags for packets sent via
     * serverless VPC direct egress is unsupported. Behavior is undefined.
     * https://cloud.google.com/run/docs/configuring/vpc-direct-vpc#limitations
     *
     * Generated from protobuf enum <code>INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS = 85;</code>
     */
    const INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS = 85;
    /**
     * Packet is sent from or to a Compute Engine instance that is not in a
     * running state.
     *
     * Generated from protobuf enum <code>INSTANCE_NOT_RUNNING = 14;</code>
     */
    const INSTANCE_NOT_RUNNING = 14;
    /**
     * Packet sent from or to a GKE cluster that is not in running state.
     *
     * Generated from protobuf enum <code>GKE_CLUSTER_NOT_RUNNING = 27;</code>
     */
    const GKE_CLUSTER_NOT_RUNNING = 27;
    /**
     * Packet sent from or to a GKE Pod that is not in running state.
     *
     * Generated from protobuf enum <code>GKE_POD_NOT_RUNNING = 103;</code>
     */
    const GKE_POD_NOT_RUNNING = 103;
    /**
     * Packet sent from or to a Cloud SQL instance that is not in running state.
     *
     * Generated from protobuf enum <code>CLOUD_SQL_INSTANCE_NOT_RUNNING = 28;</code>
     */
    const CLOUD_SQL_INSTANCE_NOT_RUNNING = 28;
    /**
     * Packet sent from or to a Redis Instance that is not in running state.
     *
     * Generated from protobuf enum <code>REDIS_INSTANCE_NOT_RUNNING = 68;</code>
     */
    const REDIS_INSTANCE_NOT_RUNNING = 68;
    /**
     * Packet sent from or to a Redis Cluster that is not in running state.
     *
     * Generated from protobuf enum <code>REDIS_CLUSTER_NOT_RUNNING = 69;</code>
     */
    const REDIS_CLUSTER_NOT_RUNNING = 69;
    /**
     * The type of traffic is blocked and the user cannot configure a firewall
     * rule to enable it. See [Always blocked
     * traffic](https://cloud.google.com/vpc/docs/firewalls#blockedtraffic) for
     * more details.
     *
     * Generated from protobuf enum <code>TRAFFIC_TYPE_BLOCKED = 15;</code>
     */
    const TRAFFIC_TYPE_BLOCKED = 15;
    /**
     * Access to Google Kubernetes Engine cluster master's endpoint is not
     * authorized. See [Access to the cluster
     * endpoints](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters#access_to_the_cluster_endpoints)
     * for more details.
     *
     * Generated from protobuf enum <code>GKE_MASTER_UNAUTHORIZED_ACCESS = 16;</code>
     */
    const GKE_MASTER_UNAUTHORIZED_ACCESS = 16;
    /**
     * Access to the Cloud SQL instance endpoint is not authorized.
     * See [Authorizing with authorized
     * networks](https://cloud.google.com/sql/docs/mysql/authorize-networks) for
     * more details.
     *
     * Generated from protobuf enum <code>CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS = 17;</code>
     */
    const CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS = 17;
    /**
     * Packet was dropped inside Google Kubernetes Engine Service.
     *
     * Generated from protobuf enum <code>DROPPED_INSIDE_GKE_SERVICE = 18;</code>
     */
    const DROPPED_INSIDE_GKE_SERVICE = 18;
    /**
     * Packet was dropped inside Cloud SQL Service.
     *
     * Generated from protobuf enum <code>DROPPED_INSIDE_CLOUD_SQL_SERVICE = 19;</code>
     */
    const DROPPED_INSIDE_CLOUD_SQL_SERVICE = 19;
    /**
     * Packet was dropped because there is no peering between the originating
     * network and the Google Managed Services Network.
     *
     * Generated from protobuf enum <code>GOOGLE_MANAGED_SERVICE_NO_PEERING = 20;</code>
     */
    const GOOGLE_MANAGED_SERVICE_NO_PEERING = 20;
    /**
     * Packet was dropped because the Google-managed service uses Private
     * Service Connect (PSC), but the PSC endpoint is not found in the project.
     *
     * Generated from protobuf enum <code>GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT = 38;</code>
     */
    const GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT = 38;
    /**
     * Packet was dropped because the GKE cluster uses Private Service Connect
     * (PSC), but the PSC endpoint is not found in the project.
     *
     * Generated from protobuf enum <code>GKE_PSC_ENDPOINT_MISSING = 36;</code>
     */
    const GKE_PSC_ENDPOINT_MISSING = 36;
    /**
     * Packet was dropped because the Cloud SQL instance has neither a private
     * nor a public IP address.
     *
     * Generated from protobuf enum <code>CLOUD_SQL_INSTANCE_NO_IP_ADDRESS = 21;</code>
     */
    const CLOUD_SQL_INSTANCE_NO_IP_ADDRESS = 21;
    /**
     * Packet was dropped because a GKE cluster private endpoint is
     * unreachable from a region different from the cluster's region.
     *
     * Generated from protobuf enum <code>GKE_CONTROL_PLANE_REGION_MISMATCH = 30;</code>
     */
    const GKE_CONTROL_PLANE_REGION_MISMATCH = 30;
    /**
     * Packet sent from a public GKE cluster control plane to a private
     * IP address.
     *
     * Generated from protobuf enum <code>PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION = 31;</code>
     */
    const PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION = 31;
    /**
     * Packet was dropped because there is no route from a GKE cluster
     * control plane to a destination network.
     *
     * Generated from protobuf enum <code>GKE_CONTROL_PLANE_NO_ROUTE = 32;</code>
     */
    const GKE_CONTROL_PLANE_NO_ROUTE = 32;
    /**
     * Packet sent from a Cloud SQL instance to an external IP address is not
     * allowed. The Cloud SQL instance is not configured to send packets to
     * external IP addresses.
     *
     * Generated from protobuf enum <code>CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC = 33;</code>
     */
    const CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC = 33;
    /**
     * Packet sent from a Cloud SQL instance with only a public IP address to a
     * private IP address.
     *
     * Generated from protobuf enum <code>PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION = 34;</code>
     */
    const PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION = 34;
    /**
     * Packet was dropped because there is no route from a Cloud SQL
     * instance to a destination network.
     *
     * Generated from protobuf enum <code>CLOUD_SQL_INSTANCE_NO_ROUTE = 35;</code>
     */
    const CLOUD_SQL_INSTANCE_NO_ROUTE = 35;
    /**
     * Packet was dropped because the Cloud SQL instance requires all
     * connections to use Cloud SQL connectors and to target the Cloud SQL proxy
     * port (3307).
     *
     * Generated from protobuf enum <code>CLOUD_SQL_CONNECTOR_REQUIRED = 63;</code>
     */
    const CLOUD_SQL_CONNECTOR_REQUIRED = 63;
    /**
     * Packet could be dropped because the Cloud Function is not in an active
     * status.
     *
     * Generated from protobuf enum <code>CLOUD_FUNCTION_NOT_ACTIVE = 22;</code>
     */
    const CLOUD_FUNCTION_NOT_ACTIVE = 22;
    /**
     * Packet could be dropped because no VPC connector is set.
     *
     * Generated from protobuf enum <code>VPC_CONNECTOR_NOT_SET = 23;</code>
     */
    const VPC_CONNECTOR_NOT_SET = 23;
    /**
     * Packet could be dropped because the VPC connector is not in a running
     * state.
     *
     * Generated from protobuf enum <code>VPC_CONNECTOR_NOT_RUNNING = 24;</code>
     */
    const VPC_CONNECTOR_NOT_RUNNING = 24;
    /**
     * Packet could be dropped because the traffic from the serverless service
     * to the VPC connector is not allowed.
     *
     * Generated from protobuf enum <code>VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED = 60;</code>
     */
    const VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED = 60;
    /**
     * Packet could be dropped because the health check traffic to the VPC
     * connector is not allowed.
     *
     * Generated from protobuf enum <code>VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED = 61;</code>
     */
    const VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED = 61;
    /**
     * Packet could be dropped because it was sent from a different region
     * to a regional forwarding without global access.
     *
     * Generated from protobuf enum <code>FORWARDING_RULE_REGION_MISMATCH = 25;</code>
     */
    const FORWARDING_RULE_REGION_MISMATCH = 25;
    /**
     * The Private Service Connect endpoint is in a project that is not approved
     * to connect to the service.
     *
     * Generated from protobuf enum <code>PSC_CONNECTION_NOT_ACCEPTED = 26;</code>
     */
    const PSC_CONNECTION_NOT_ACCEPTED = 26;
    /**
     * The packet is sent to the Private Service Connect endpoint over the
     * peering, but [it's not
     * supported](https://cloud.google.com/vpc/docs/configure-private-service-connect-services#on-premises).
     *
     * Generated from protobuf enum <code>PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK = 41;</code>
     */
    const PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK = 41;
    /**
     * The packet is sent to the Private Service Connect backend (network
     * endpoint group), but the producer PSC forwarding rule does not have
     * global access enabled.
     *
     * Generated from protobuf enum <code>PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS = 48;</code>
     */
    const PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS = 48;
    /**
     * The packet is sent to the Private Service Connect backend (network
     * endpoint group), but the producer PSC forwarding rule has multiple ports
     * specified.
     *
     * Generated from protobuf enum <code>PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS = 54;</code>
     */
    const PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS = 54;
    /**
     * The packet is sent to the Private Service Connect backend (network
     * endpoint group) targeting a Cloud SQL service attachment, but this
     * configuration is not supported.
     *
     * Generated from protobuf enum <code>CLOUD_SQL_PSC_NEG_UNSUPPORTED = 58;</code>
     */
    const CLOUD_SQL_PSC_NEG_UNSUPPORTED = 58;
    /**
     * No NAT subnets are defined for the PSC service attachment.
     *
     * Generated from protobuf enum <code>NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT = 57;</code>
     */
    const NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT = 57;
    /**
     * PSC endpoint is accessed via NCC, but PSC transitivity configuration is
     * not yet propagated.
     *
     * Generated from protobuf enum <code>PSC_TRANSITIVITY_NOT_PROPAGATED = 64;</code>
     */
    const PSC_TRANSITIVITY_NOT_PROPAGATED = 64;
    /**
     * The packet sent from the hybrid NEG proxy matches a non-dynamic route,
     * but such a configuration is not supported.
     *
     * Generated from protobuf enum <code>HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED = 55;</code>
     */
    const HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED = 55;
    /**
     * The packet sent from the hybrid NEG proxy matches a dynamic route with a
     * next hop in a different region, but such a configuration is not
     * supported.
     *
     * Generated from protobuf enum <code>HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED = 56;</code>
     */
    const HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED = 56;
    /**
     * Packet sent from a Cloud Run revision that is not ready.
     *
     * Generated from protobuf enum <code>CLOUD_RUN_REVISION_NOT_READY = 29;</code>
     */
    const CLOUD_RUN_REVISION_NOT_READY = 29;
    /**
     * Packet was dropped inside Private Service Connect service producer.
     *
     * Generated from protobuf enum <code>DROPPED_INSIDE_PSC_SERVICE_PRODUCER = 37;</code>
     */
    const DROPPED_INSIDE_PSC_SERVICE_PRODUCER = 37;
    /**
     * Packet sent to a load balancer, which requires a proxy-only subnet and
     * the subnet is not found.
     *
     * Generated from protobuf enum <code>LOAD_BALANCER_HAS_NO_PROXY_SUBNET = 39;</code>
     */
    const LOAD_BALANCER_HAS_NO_PROXY_SUBNET = 39;
    /**
     * Packet sent to Cloud Nat without active NAT IPs.
     *
     * Generated from protobuf enum <code>CLOUD_NAT_NO_ADDRESSES = 40;</code>
     */
    const CLOUD_NAT_NO_ADDRESSES = 40;
    /**
     * Packet is stuck in a routing loop.
     *
     * Generated from protobuf enum <code>ROUTING_LOOP = 59;</code>
     */
    const ROUTING_LOOP = 59;
    /**
     * Packet is dropped inside a Google-managed service due to being delivered
     * in return trace to an endpoint that doesn't match the endpoint the packet
     * was sent from in forward trace. Used only for return traces.
     *
     * Generated from protobuf enum <code>DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE = 62;</code>
     */
    const DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE = 62;
    /**
     * Packet is dropped due to a load balancer backend instance not having a
     * network interface in the network expected by the load balancer.
     *
     * Generated from protobuf enum <code>LOAD_BALANCER_BACKEND_INVALID_NETWORK = 65;</code>
     */
    const LOAD_BALANCER_BACKEND_INVALID_NETWORK = 65;
    /**
     * Packet is dropped due to a backend service named port not being defined
     * on the instance group level.
     *
     * Generated from protobuf enum <code>BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED = 66;</code>
     */
    const BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED = 66;
    /**
     * Packet is dropped due to a destination IP range being part of a Private
     * NAT IP range.
     *
     * Generated from protobuf enum <code>DESTINATION_IS_PRIVATE_NAT_IP_RANGE = 67;</code>
     */
    const DESTINATION_IS_PRIVATE_NAT_IP_RANGE = 67;
    /**
     * Generic drop cause for a packet being dropped inside a Redis Instance
     * service project.
     *
     * Generated from protobuf enum <code>DROPPED_INSIDE_REDIS_INSTANCE_SERVICE = 70;</code>
     */
    const DROPPED_INSIDE_REDIS_INSTANCE_SERVICE = 70;
    /**
     * Packet is dropped due to an unsupported port being used to connect to a
     * Redis Instance. Port 6379 should be used to connect to a Redis Instance.
     *
     * Generated from protobuf enum <code>REDIS_INSTANCE_UNSUPPORTED_PORT = 71;</code>
     */
    const REDIS_INSTANCE_UNSUPPORTED_PORT = 71;
    /**
     * Packet is dropped due to connecting from PUPI address to a PSA based
     * Redis Instance.
     *
     * Generated from protobuf enum <code>REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS = 72;</code>
     */
    const REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS = 72;
    /**
     * Packet is dropped due to no route to the destination network.
     *
     * Generated from protobuf enum <code>REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK = 73;</code>
     */
    const REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK = 73;
    /**
     * Redis Instance does not have an external IP address.
     *
     * Generated from protobuf enum <code>REDIS_INSTANCE_NO_EXTERNAL_IP = 74;</code>
     */
    const REDIS_INSTANCE_NO_EXTERNAL_IP = 74;
    /**
     * Packet is dropped due to an unsupported protocol being used to connect to
     * a Redis Instance. Only TCP connections are accepted by a Redis Instance.
     *
     * Generated from protobuf enum <code>REDIS_INSTANCE_UNSUPPORTED_PROTOCOL = 78;</code>
     */
    const REDIS_INSTANCE_UNSUPPORTED_PROTOCOL = 78;
    /**
     * Generic drop cause for a packet being dropped inside a Redis Cluster
     * service project.
     *
     * Generated from protobuf enum <code>DROPPED_INSIDE_REDIS_CLUSTER_SERVICE = 75;</code>
     */
    const DROPPED_INSIDE_REDIS_CLUSTER_SERVICE = 75;
    /**
     * Packet is dropped due to an unsupported port being used to connect to a
     * Redis Cluster. Ports 6379 and 11000 to 13047 should be used to connect to
     * a Redis Cluster.
     *
     * Generated from protobuf enum <code>REDIS_CLUSTER_UNSUPPORTED_PORT = 76;</code>
     */
    const REDIS_CLUSTER_UNSUPPORTED_PORT = 76;
    /**
     * Redis Cluster does not have an external IP address.
     *
     * Generated from protobuf enum <code>REDIS_CLUSTER_NO_EXTERNAL_IP = 77;</code>
     */
    const REDIS_CLUSTER_NO_EXTERNAL_IP = 77;
    /**
     * Packet is dropped due to an unsupported protocol being used to connect to
     * a Redis Cluster. Only TCP connections are accepted by a Redis Cluster.
     *
     * Generated from protobuf enum <code>REDIS_CLUSTER_UNSUPPORTED_PROTOCOL = 79;</code>
     */
    const REDIS_CLUSTER_UNSUPPORTED_PROTOCOL = 79;
    /**
     * Packet from the non-GCP (on-prem) or unknown GCP network is dropped due
     * to the destination IP address not belonging to any IP prefix advertised
     * via BGP by the Cloud Router.
     *
     * Generated from protobuf enum <code>NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION = 80;</code>
     */
    const NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION = 80;
    /**
     * Packet from the non-GCP (on-prem) or unknown GCP network is dropped due
     * to the destination IP address not belonging to any IP prefix included to
     * the local traffic selector of the VPN tunnel.
     *
     * Generated from protobuf enum <code>NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION = 81;</code>
     */
    const NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION = 81;
    /**
     * Packet from the unknown peered network is dropped due to no known route
     * from the source network to the destination IP address.
     *
     * Generated from protobuf enum <code>NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION = 82;</code>
     */
    const NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION = 82;
    /**
     * Sending packets processed by the Private NAT Gateways to the Private
     * Service Connect endpoints is not supported.
     *
     * Generated from protobuf enum <code>PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED = 83;</code>
     */
    const PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED = 83;
    /**
     * Packet is sent to the PSC port mapping service, but its destination port
     * does not match any port mapping rules.
     *
     * Generated from protobuf enum <code>PSC_PORT_MAPPING_PORT_MISMATCH = 86;</code>
     */
    const PSC_PORT_MAPPING_PORT_MISMATCH = 86;
    /**
     * Sending packets directly to the PSC port mapping service without going
     * through the PSC connection is not supported.
     *
     * Generated from protobuf enum <code>PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED = 87;</code>
     */
    const PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED = 87;
    /**
     * Packet with destination IP address within the reserved NAT64 range is
     * dropped due to matching a route of an unsupported type.
     *
     * Generated from protobuf enum <code>UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION = 88;</code>
     */
    const UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION = 88;
    /**
     * Packet could be dropped because hybrid endpoint like a VPN gateway or
     * Interconnect is not allowed to send traffic to the Internet.
     *
     * Generated from protobuf enum <code>TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED = 89;</code>
     */
    const TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED = 89;
    /**
     * Packet with destination IP address within the reserved NAT64 range is
     * dropped due to no matching NAT gateway in the subnet.
     *
     * Generated from protobuf enum <code>NO_MATCHING_NAT64_GATEWAY = 90;</code>
     */
    const NO_MATCHING_NAT64_GATEWAY = 90;
    /**
     * Packet is dropped due to matching a Private NAT64 gateway with no rules
     * for source IPv6 addresses.
     *
     * Generated from protobuf enum <code>NO_CONFIGURED_PRIVATE_NAT64_RULE = 107;</code>
     */
    const NO_CONFIGURED_PRIVATE_NAT64_RULE = 107;
    /**
     * Packet is dropped due to being sent to a backend of a passthrough load
     * balancer that doesn't use the same IP version as the frontend.
     *
     * Generated from protobuf enum <code>LOAD_BALANCER_BACKEND_IP_VERSION_MISMATCH = 96;</code>
     */
    const LOAD_BALANCER_BACKEND_IP_VERSION_MISMATCH = 96;
    /**
     * Packet from the unknown NCC network is dropped due to no known route
     * from the source network to the destination IP address.
     *
     * Generated from protobuf enum <code>NO_KNOWN_ROUTE_FROM_NCC_NETWORK_TO_DESTINATION = 97;</code>
     */
    const NO_KNOWN_ROUTE_FROM_NCC_NETWORK_TO_DESTINATION = 97;
    /**
     * Packet is dropped by Cloud NAT due to using an unsupported protocol.
     *
     * Generated from protobuf enum <code>CLOUD_NAT_PROTOCOL_UNSUPPORTED = 99;</code>
     */
    const CLOUD_NAT_PROTOCOL_UNSUPPORTED = 99;
    /**
     * Packet is dropped due to using an unsupported protocol (any other than
     * UDP) for L2 Interconnect.
     *
     * Generated from protobuf enum <code>L2_INTERCONNECT_UNSUPPORTED_PROTOCOL = 100;</code>
     */
    const L2_INTERCONNECT_UNSUPPORTED_PROTOCOL = 100;
    /**
     * Packet is dropped due to using an unsupported port (any other than
     * 6081) for L2 Interconnect.
     *
     * Generated from protobuf enum <code>L2_INTERCONNECT_UNSUPPORTED_PORT = 101;</code>
     */
    const L2_INTERCONNECT_UNSUPPORTED_PORT = 101;
    /**
     * Packet is dropped due to destination IP not matching the appliance
     * mapping IPs configured on the L2 Interconnect attachment.
     *
     * Generated from protobuf enum <code>L2_INTERCONNECT_DESTINATION_IP_MISMATCH = 102;</code>
     */
    const L2_INTERCONNECT_DESTINATION_IP_MISMATCH = 102;
    /**
     * Packet could be dropped because it matches a route associated with an NCC
     * spoke in the hybrid subnet context, but such a configuration is not
     * supported.
     *
     * Generated from protobuf enum <code>NCC_ROUTE_WITHIN_HYBRID_SUBNET_UNSUPPORTED = 104;</code>
     */
    const NCC_ROUTE_WITHIN_HYBRID_SUBNET_UNSUPPORTED = 104;
    /**
     * Packet is dropped because the region of the hybrid subnet is different
     * from the region of the next hop of the route matched within this hybrid
     * subnet.
     *
     * Generated from protobuf enum <code>HYBRID_SUBNET_REGION_MISMATCH = 105;</code>
     */
    const HYBRID_SUBNET_REGION_MISMATCH = 105;
    /**
     * Packet is dropped because no matching route was found in the hybrid
     * subnet.
     *
     * Generated from protobuf enum <code>HYBRID_SUBNET_NO_ROUTE = 106;</code>
     */
    const HYBRID_SUBNET_NO_ROUTE = 106;

    private static $valueToName = [
        self::CAUSE_UNSPECIFIED => 'CAUSE_UNSPECIFIED',
        self::UNKNOWN_EXTERNAL_ADDRESS => 'UNKNOWN_EXTERNAL_ADDRESS',
        self::FOREIGN_IP_DISALLOWED => 'FOREIGN_IP_DISALLOWED',
        self::FIREWALL_RULE => 'FIREWALL_RULE',
        self::NO_ROUTE => 'NO_ROUTE',
        self::ROUTE_BLACKHOLE => 'ROUTE_BLACKHOLE',
        self::ROUTE_WRONG_NETWORK => 'ROUTE_WRONG_NETWORK',
        self::ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED => 'ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED',
        self::ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND => 'ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND',
        self::ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK => 'ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK',
        self::ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP => 'ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP',
        self::ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH => 'ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH',
        self::ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED => 'ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED',
        self::ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID => 'ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID',
        self::NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS => 'NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS',
        self::NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV4_ADDRESS => 'NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV4_ADDRESS',
        self::NO_ROUTE_FROM_EXTERNAL_IPV6_SOURCE_TO_PRIVATE_IPV6_ADDRESS => 'NO_ROUTE_FROM_EXTERNAL_IPV6_SOURCE_TO_PRIVATE_IPV6_ADDRESS',
        self::VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH => 'VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH',
        self::VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH => 'VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH',
        self::PRIVATE_TRAFFIC_TO_INTERNET => 'PRIVATE_TRAFFIC_TO_INTERNET',
        self::PRIVATE_GOOGLE_ACCESS_DISALLOWED => 'PRIVATE_GOOGLE_ACCESS_DISALLOWED',
        self::PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED => 'PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED',
        self::NO_EXTERNAL_ADDRESS => 'NO_EXTERNAL_ADDRESS',
        self::UNKNOWN_INTERNAL_ADDRESS => 'UNKNOWN_INTERNAL_ADDRESS',
        self::FORWARDING_RULE_MISMATCH => 'FORWARDING_RULE_MISMATCH',
        self::FORWARDING_RULE_NO_INSTANCES => 'FORWARDING_RULE_NO_INSTANCES',
        self::FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK => 'FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK',
        self::INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS => 'INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS',
        self::INSTANCE_NOT_RUNNING => 'INSTANCE_NOT_RUNNING',
        self::GKE_CLUSTER_NOT_RUNNING => 'GKE_CLUSTER_NOT_RUNNING',
        self::GKE_POD_NOT_RUNNING => 'GKE_POD_NOT_RUNNING',
        self::CLOUD_SQL_INSTANCE_NOT_RUNNING => 'CLOUD_SQL_INSTANCE_NOT_RUNNING',
        self::REDIS_INSTANCE_NOT_RUNNING => 'REDIS_INSTANCE_NOT_RUNNING',
        self::REDIS_CLUSTER_NOT_RUNNING => 'REDIS_CLUSTER_NOT_RUNNING',
        self::TRAFFIC_TYPE_BLOCKED => 'TRAFFIC_TYPE_BLOCKED',
        self::GKE_MASTER_UNAUTHORIZED_ACCESS => 'GKE_MASTER_UNAUTHORIZED_ACCESS',
        self::CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS => 'CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS',
        self::DROPPED_INSIDE_GKE_SERVICE => 'DROPPED_INSIDE_GKE_SERVICE',
        self::DROPPED_INSIDE_CLOUD_SQL_SERVICE => 'DROPPED_INSIDE_CLOUD_SQL_SERVICE',
        self::GOOGLE_MANAGED_SERVICE_NO_PEERING => 'GOOGLE_MANAGED_SERVICE_NO_PEERING',
        self::GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT => 'GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT',
        self::GKE_PSC_ENDPOINT_MISSING => 'GKE_PSC_ENDPOINT_MISSING',
        self::CLOUD_SQL_INSTANCE_NO_IP_ADDRESS => 'CLOUD_SQL_INSTANCE_NO_IP_ADDRESS',
        self::GKE_CONTROL_PLANE_REGION_MISMATCH => 'GKE_CONTROL_PLANE_REGION_MISMATCH',
        self::PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION => 'PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION',
        self::GKE_CONTROL_PLANE_NO_ROUTE => 'GKE_CONTROL_PLANE_NO_ROUTE',
        self::CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC => 'CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC',
        self::PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION => 'PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION',
        self::CLOUD_SQL_INSTANCE_NO_ROUTE => 'CLOUD_SQL_INSTANCE_NO_ROUTE',
        self::CLOUD_SQL_CONNECTOR_REQUIRED => 'CLOUD_SQL_CONNECTOR_REQUIRED',
        self::CLOUD_FUNCTION_NOT_ACTIVE => 'CLOUD_FUNCTION_NOT_ACTIVE',
        self::VPC_CONNECTOR_NOT_SET => 'VPC_CONNECTOR_NOT_SET',
        self::VPC_CONNECTOR_NOT_RUNNING => 'VPC_CONNECTOR_NOT_RUNNING',
        self::VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED => 'VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED',
        self::VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED => 'VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED',
        self::FORWARDING_RULE_REGION_MISMATCH => 'FORWARDING_RULE_REGION_MISMATCH',
        self::PSC_CONNECTION_NOT_ACCEPTED => 'PSC_CONNECTION_NOT_ACCEPTED',
        self::PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK => 'PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK',
        self::PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS => 'PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS',
        self::PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS => 'PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS',
        self::CLOUD_SQL_PSC_NEG_UNSUPPORTED => 'CLOUD_SQL_PSC_NEG_UNSUPPORTED',
        self::NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT => 'NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT',
        self::PSC_TRANSITIVITY_NOT_PROPAGATED => 'PSC_TRANSITIVITY_NOT_PROPAGATED',
        self::HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED => 'HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED',
        self::HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED => 'HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED',
        self::CLOUD_RUN_REVISION_NOT_READY => 'CLOUD_RUN_REVISION_NOT_READY',
        self::DROPPED_INSIDE_PSC_SERVICE_PRODUCER => 'DROPPED_INSIDE_PSC_SERVICE_PRODUCER',
        self::LOAD_BALANCER_HAS_NO_PROXY_SUBNET => 'LOAD_BALANCER_HAS_NO_PROXY_SUBNET',
        self::CLOUD_NAT_NO_ADDRESSES => 'CLOUD_NAT_NO_ADDRESSES',
        self::ROUTING_LOOP => 'ROUTING_LOOP',
        self::DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE => 'DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE',
        self::LOAD_BALANCER_BACKEND_INVALID_NETWORK => 'LOAD_BALANCER_BACKEND_INVALID_NETWORK',
        self::BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED => 'BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED',
        self::DESTINATION_IS_PRIVATE_NAT_IP_RANGE => 'DESTINATION_IS_PRIVATE_NAT_IP_RANGE',
        self::DROPPED_INSIDE_REDIS_INSTANCE_SERVICE => 'DROPPED_INSIDE_REDIS_INSTANCE_SERVICE',
        self::REDIS_INSTANCE_UNSUPPORTED_PORT => 'REDIS_INSTANCE_UNSUPPORTED_PORT',
        self::REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS => 'REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS',
        self::REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK => 'REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK',
        self::REDIS_INSTANCE_NO_EXTERNAL_IP => 'REDIS_INSTANCE_NO_EXTERNAL_IP',
        self::REDIS_INSTANCE_UNSUPPORTED_PROTOCOL => 'REDIS_INSTANCE_UNSUPPORTED_PROTOCOL',
        self::DROPPED_INSIDE_REDIS_CLUSTER_SERVICE => 'DROPPED_INSIDE_REDIS_CLUSTER_SERVICE',
        self::REDIS_CLUSTER_UNSUPPORTED_PORT => 'REDIS_CLUSTER_UNSUPPORTED_PORT',
        self::REDIS_CLUSTER_NO_EXTERNAL_IP => 'REDIS_CLUSTER_NO_EXTERNAL_IP',
        self::REDIS_CLUSTER_UNSUPPORTED_PROTOCOL => 'REDIS_CLUSTER_UNSUPPORTED_PROTOCOL',
        self::NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION => 'NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION',
        self::NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION => 'NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION',
        self::NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION => 'NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION',
        self::PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED => 'PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED',
        self::PSC_PORT_MAPPING_PORT_MISMATCH => 'PSC_PORT_MAPPING_PORT_MISMATCH',
        self::PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED => 'PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED',
        self::UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION => 'UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION',
        self::TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED => 'TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED',
        self::NO_MATCHING_NAT64_GATEWAY => 'NO_MATCHING_NAT64_GATEWAY',
        self::NO_CONFIGURED_PRIVATE_NAT64_RULE => 'NO_CONFIGURED_PRIVATE_NAT64_RULE',
        self::LOAD_BALANCER_BACKEND_IP_VERSION_MISMATCH => 'LOAD_BALANCER_BACKEND_IP_VERSION_MISMATCH',
        self::NO_KNOWN_ROUTE_FROM_NCC_NETWORK_TO_DESTINATION => 'NO_KNOWN_ROUTE_FROM_NCC_NETWORK_TO_DESTINATION',
        self::CLOUD_NAT_PROTOCOL_UNSUPPORTED => 'CLOUD_NAT_PROTOCOL_UNSUPPORTED',
        self::L2_INTERCONNECT_UNSUPPORTED_PROTOCOL => 'L2_INTERCONNECT_UNSUPPORTED_PROTOCOL',
        self::L2_INTERCONNECT_UNSUPPORTED_PORT => 'L2_INTERCONNECT_UNSUPPORTED_PORT',
        self::L2_INTERCONNECT_DESTINATION_IP_MISMATCH => 'L2_INTERCONNECT_DESTINATION_IP_MISMATCH',
        self::NCC_ROUTE_WITHIN_HYBRID_SUBNET_UNSUPPORTED => 'NCC_ROUTE_WITHIN_HYBRID_SUBNET_UNSUPPORTED',
        self::HYBRID_SUBNET_REGION_MISMATCH => 'HYBRID_SUBNET_REGION_MISMATCH',
        self::HYBRID_SUBNET_NO_ROUTE => 'HYBRID_SUBNET_NO_ROUTE',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


