<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/netapp/v1/storage_pool.proto

namespace Google\Cloud\NetApp\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * StoragePool is a container for volumes with a service level and capacity.
 * Volumes can be created in a pool of sufficient available capacity.
 * StoragePool capacity is what you are billed for.
 *
 * Generated from protobuf message <code>google.cloud.netapp.v1.StoragePool</code>
 */
class StoragePool extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Name of the storage pool
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Service level of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.ServiceLevel service_level = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $service_level = 0;
    /**
     * Required. Capacity in GIB of the pool
     *
     * Generated from protobuf field <code>int64 capacity_gib = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $capacity_gib = 0;
    /**
     * Output only. Allocated size of all volumes in GIB in the storage pool
     *
     * Generated from protobuf field <code>int64 volume_capacity_gib = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $volume_capacity_gib = 0;
    /**
     * Output only. Volume count of the storage pool
     *
     * Generated from protobuf field <code>int32 volume_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $volume_count = 0;
    /**
     * Output only. State of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.StoragePool.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. State details of the storage pool
     *
     * Generated from protobuf field <code>string state_details = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_details = '';
    /**
     * Output only. Create time of the storage pool
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Optional. Description of the storage pool
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Required. VPC Network name.
     * Format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 11 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $network = '';
    /**
     * Optional. Specifies the Active Directory to be used for creating a SMB
     * volume.
     *
     * Generated from protobuf field <code>string active_directory = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $active_directory = '';
    /**
     * Optional. Specifies the KMS config to be used for volume encryption.
     *
     * Generated from protobuf field <code>string kms_config = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $kms_config = '';
    /**
     * Optional. Flag indicating if the pool is NFS LDAP enabled or not.
     *
     * Generated from protobuf field <code>bool ldap_enabled = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ldap_enabled = false;
    /**
     * Optional. This field is not implemented. The values provided in this field
     * are ignored.
     *
     * Generated from protobuf field <code>string psa_range = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $psa_range = '';
    /**
     * Output only. Specifies the current pool encryption key source.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.EncryptionType encryption_type = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $encryption_type = 0;
    /**
     * Deprecated. Used to allow SO pool to access AD or DNS server from other
     * regions.
     *
     * Generated from protobuf field <code>optional bool global_access_allowed = 17 [deprecated = true];</code>
     * @deprecated
     */
    protected $global_access_allowed = null;
    /**
     * Optional. True if the storage pool supports Auto Tiering enabled volumes.
     * Default is false. Auto-tiering can be enabled after storage pool creation
     * but it can't be disabled once enabled.
     *
     * Generated from protobuf field <code>bool allow_auto_tiering = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $allow_auto_tiering = false;
    /**
     * Optional. Specifies the replica zone for regional storagePool.
     *
     * Generated from protobuf field <code>string replica_zone = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $replica_zone = '';
    /**
     * Optional. Specifies the active zone for regional storagePool.
     *
     * Generated from protobuf field <code>string zone = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $zone = '';
    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = false;
    /**
     * Optional. True if using Independent Scaling of capacity and performance
     * (Hyperdisk) By default set to false
     *
     * Generated from protobuf field <code>bool custom_performance_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $custom_performance_enabled = false;
    /**
     * Optional. Custom Performance Total Throughput of the pool (in MiBps)
     *
     * Generated from protobuf field <code>int64 total_throughput_mibps = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $total_throughput_mibps = 0;
    /**
     * Optional. Custom Performance Total IOPS of the pool
     * if not provided, it will be calculated based on the total_throughput_mibps
     *
     * Generated from protobuf field <code>int64 total_iops = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $total_iops = 0;
    /**
     * Optional. Total hot tier capacity for the Storage Pool. It is applicable
     * only to Flex service level. It should be less than the minimum storage pool
     * size and cannot be more than the current storage pool size. It cannot be
     * decreased once set.
     *
     * Generated from protobuf field <code>int64 hot_tier_size_gib = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $hot_tier_size_gib = 0;
    /**
     * Optional. Flag indicating that the hot-tier threshold will be
     * auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
     * The increment will kick in only if the new size after increment is
     * still less than or equal to storage pool size.
     *
     * Generated from protobuf field <code>optional bool enable_hot_tier_auto_resize = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_hot_tier_auto_resize = null;
    /**
     * Optional. QoS (Quality of Service) Type of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.QosType qos_type = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $qos_type = 0;
    /**
     * Output only. Available throughput of the storage pool (in MiB/s).
     *
     * Generated from protobuf field <code>double available_throughput_mibps = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $available_throughput_mibps = 0.0;
    /**
     * Output only. Total cold tier data rounded down to the nearest GiB used by
     * the storage pool.
     *
     * Generated from protobuf field <code>int64 cold_tier_size_used_gib = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $cold_tier_size_used_gib = 0;
    /**
     * Output only. Total hot tier data rounded down to the nearest GiB used by
     * the storage pool.
     *
     * Generated from protobuf field <code>int64 hot_tier_size_used_gib = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $hot_tier_size_used_gib = 0;
    /**
     * Optional. Type of the storage pool. This field is used to control whether
     * the pool supports `FILE` based volumes only or `UNIFIED` (both `FILE` and
     * `BLOCK`) volumes or `UNIFIED_LARGE_CAPACITY` (both `FILE` and `BLOCK`)
     * volumes with large capacity. If not specified during creation, it defaults
     * to `FILE`.
     *
     * Generated from protobuf field <code>optional .google.cloud.netapp.v1.StoragePoolType type = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $type = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. Name of the storage pool
     *     @type int $service_level
     *           Required. Service level of the storage pool
     *     @type int|string $capacity_gib
     *           Required. Capacity in GIB of the pool
     *     @type int|string $volume_capacity_gib
     *           Output only. Allocated size of all volumes in GIB in the storage pool
     *     @type int $volume_count
     *           Output only. Volume count of the storage pool
     *     @type int $state
     *           Output only. State of the storage pool
     *     @type string $state_details
     *           Output only. State details of the storage pool
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Create time of the storage pool
     *     @type string $description
     *           Optional. Description of the storage pool
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Labels as key value pairs
     *     @type string $network
     *           Required. VPC Network name.
     *           Format: projects/{project}/global/networks/{network}
     *     @type string $active_directory
     *           Optional. Specifies the Active Directory to be used for creating a SMB
     *           volume.
     *     @type string $kms_config
     *           Optional. Specifies the KMS config to be used for volume encryption.
     *     @type bool $ldap_enabled
     *           Optional. Flag indicating if the pool is NFS LDAP enabled or not.
     *     @type string $psa_range
     *           Optional. This field is not implemented. The values provided in this field
     *           are ignored.
     *     @type int $encryption_type
     *           Output only. Specifies the current pool encryption key source.
     *     @type bool $global_access_allowed
     *           Deprecated. Used to allow SO pool to access AD or DNS server from other
     *           regions.
     *     @type bool $allow_auto_tiering
     *           Optional. True if the storage pool supports Auto Tiering enabled volumes.
     *           Default is false. Auto-tiering can be enabled after storage pool creation
     *           but it can't be disabled once enabled.
     *     @type string $replica_zone
     *           Optional. Specifies the replica zone for regional storagePool.
     *     @type string $zone
     *           Optional. Specifies the active zone for regional storagePool.
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use
     *     @type bool $satisfies_pzi
     *           Output only. Reserved for future use
     *     @type bool $custom_performance_enabled
     *           Optional. True if using Independent Scaling of capacity and performance
     *           (Hyperdisk) By default set to false
     *     @type int|string $total_throughput_mibps
     *           Optional. Custom Performance Total Throughput of the pool (in MiBps)
     *     @type int|string $total_iops
     *           Optional. Custom Performance Total IOPS of the pool
     *           if not provided, it will be calculated based on the total_throughput_mibps
     *     @type int|string $hot_tier_size_gib
     *           Optional. Total hot tier capacity for the Storage Pool. It is applicable
     *           only to Flex service level. It should be less than the minimum storage pool
     *           size and cannot be more than the current storage pool size. It cannot be
     *           decreased once set.
     *     @type bool $enable_hot_tier_auto_resize
     *           Optional. Flag indicating that the hot-tier threshold will be
     *           auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
     *           The increment will kick in only if the new size after increment is
     *           still less than or equal to storage pool size.
     *     @type int $qos_type
     *           Optional. QoS (Quality of Service) Type of the storage pool
     *     @type float $available_throughput_mibps
     *           Output only. Available throughput of the storage pool (in MiB/s).
     *     @type int|string $cold_tier_size_used_gib
     *           Output only. Total cold tier data rounded down to the nearest GiB used by
     *           the storage pool.
     *     @type int|string $hot_tier_size_used_gib
     *           Output only. Total hot tier data rounded down to the nearest GiB used by
     *           the storage pool.
     *     @type int $type
     *           Optional. Type of the storage pool. This field is used to control whether
     *           the pool supports `FILE` based volumes only or `UNIFIED` (both `FILE` and
     *           `BLOCK`) volumes or `UNIFIED_LARGE_CAPACITY` (both `FILE` and `BLOCK`)
     *           volumes with large capacity. If not specified during creation, it defaults
     *           to `FILE`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Netapp\V1\StoragePool::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. Name of the storage pool
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Name of the storage pool
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Service level of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.ServiceLevel service_level = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getServiceLevel()
    {
        return $this->service_level;
    }

    /**
     * Required. Service level of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.ServiceLevel service_level = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setServiceLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\ServiceLevel::class);
        $this->service_level = $var;

        return $this;
    }

    /**
     * Required. Capacity in GIB of the pool
     *
     * Generated from protobuf field <code>int64 capacity_gib = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int|string
     */
    public function getCapacityGib()
    {
        return $this->capacity_gib;
    }

    /**
     * Required. Capacity in GIB of the pool
     *
     * Generated from protobuf field <code>int64 capacity_gib = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int|string $var
     * @return $this
     */
    public function setCapacityGib($var)
    {
        GPBUtil::checkInt64($var);
        $this->capacity_gib = $var;

        return $this;
    }

    /**
     * Output only. Allocated size of all volumes in GIB in the storage pool
     *
     * Generated from protobuf field <code>int64 volume_capacity_gib = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getVolumeCapacityGib()
    {
        return $this->volume_capacity_gib;
    }

    /**
     * Output only. Allocated size of all volumes in GIB in the storage pool
     *
     * Generated from protobuf field <code>int64 volume_capacity_gib = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setVolumeCapacityGib($var)
    {
        GPBUtil::checkInt64($var);
        $this->volume_capacity_gib = $var;

        return $this;
    }

    /**
     * Output only. Volume count of the storage pool
     *
     * Generated from protobuf field <code>int32 volume_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getVolumeCount()
    {
        return $this->volume_count;
    }

    /**
     * Output only. Volume count of the storage pool
     *
     * Generated from protobuf field <code>int32 volume_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setVolumeCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->volume_count = $var;

        return $this;
    }

    /**
     * Output only. State of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.StoragePool.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.StoragePool.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\StoragePool\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. State details of the storage pool
     *
     * Generated from protobuf field <code>string state_details = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStateDetails()
    {
        return $this->state_details;
    }

    /**
     * Output only. State details of the storage pool
     *
     * Generated from protobuf field <code>string state_details = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStateDetails($var)
    {
        GPBUtil::checkString($var, True);
        $this->state_details = $var;

        return $this;
    }

    /**
     * Output only. Create time of the storage pool
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Create time of the storage pool
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Optional. Description of the storage pool
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. Description of the storage pool
     *
     * Generated from protobuf field <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. VPC Network name.
     * Format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 11 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Required. VPC Network name.
     * Format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 11 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Optional. Specifies the Active Directory to be used for creating a SMB
     * volume.
     *
     * Generated from protobuf field <code>string active_directory = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getActiveDirectory()
    {
        return $this->active_directory;
    }

    /**
     * Optional. Specifies the Active Directory to be used for creating a SMB
     * volume.
     *
     * Generated from protobuf field <code>string active_directory = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setActiveDirectory($var)
    {
        GPBUtil::checkString($var, True);
        $this->active_directory = $var;

        return $this;
    }

    /**
     * Optional. Specifies the KMS config to be used for volume encryption.
     *
     * Generated from protobuf field <code>string kms_config = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsConfig()
    {
        return $this->kms_config;
    }

    /**
     * Optional. Specifies the KMS config to be used for volume encryption.
     *
     * Generated from protobuf field <code>string kms_config = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsConfig($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_config = $var;

        return $this;
    }

    /**
     * Optional. Flag indicating if the pool is NFS LDAP enabled or not.
     *
     * Generated from protobuf field <code>bool ldap_enabled = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getLdapEnabled()
    {
        return $this->ldap_enabled;
    }

    /**
     * Optional. Flag indicating if the pool is NFS LDAP enabled or not.
     *
     * Generated from protobuf field <code>bool ldap_enabled = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setLdapEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->ldap_enabled = $var;

        return $this;
    }

    /**
     * Optional. This field is not implemented. The values provided in this field
     * are ignored.
     *
     * Generated from protobuf field <code>string psa_range = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPsaRange()
    {
        return $this->psa_range;
    }

    /**
     * Optional. This field is not implemented. The values provided in this field
     * are ignored.
     *
     * Generated from protobuf field <code>string psa_range = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPsaRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->psa_range = $var;

        return $this;
    }

    /**
     * Output only. Specifies the current pool encryption key source.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.EncryptionType encryption_type = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getEncryptionType()
    {
        return $this->encryption_type;
    }

    /**
     * Output only. Specifies the current pool encryption key source.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.EncryptionType encryption_type = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setEncryptionType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\EncryptionType::class);
        $this->encryption_type = $var;

        return $this;
    }

    /**
     * Deprecated. Used to allow SO pool to access AD or DNS server from other
     * regions.
     *
     * Generated from protobuf field <code>optional bool global_access_allowed = 17 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getGlobalAccessAllowed()
    {
        if (isset($this->global_access_allowed)) {
            @trigger_error('global_access_allowed is deprecated.', E_USER_DEPRECATED);
        }
        return isset($this->global_access_allowed) ? $this->global_access_allowed : false;
    }

    public function hasGlobalAccessAllowed()
    {
        if (isset($this->global_access_allowed)) {
            @trigger_error('global_access_allowed is deprecated.', E_USER_DEPRECATED);
        }
        return isset($this->global_access_allowed);
    }

    public function clearGlobalAccessAllowed()
    {
        @trigger_error('global_access_allowed is deprecated.', E_USER_DEPRECATED);
        unset($this->global_access_allowed);
    }

    /**
     * Deprecated. Used to allow SO pool to access AD or DNS server from other
     * regions.
     *
     * Generated from protobuf field <code>optional bool global_access_allowed = 17 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setGlobalAccessAllowed($var)
    {
        @trigger_error('global_access_allowed is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->global_access_allowed = $var;

        return $this;
    }

    /**
     * Optional. True if the storage pool supports Auto Tiering enabled volumes.
     * Default is false. Auto-tiering can be enabled after storage pool creation
     * but it can't be disabled once enabled.
     *
     * Generated from protobuf field <code>bool allow_auto_tiering = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAllowAutoTiering()
    {
        return $this->allow_auto_tiering;
    }

    /**
     * Optional. True if the storage pool supports Auto Tiering enabled volumes.
     * Default is false. Auto-tiering can be enabled after storage pool creation
     * but it can't be disabled once enabled.
     *
     * Generated from protobuf field <code>bool allow_auto_tiering = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowAutoTiering($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_auto_tiering = $var;

        return $this;
    }

    /**
     * Optional. Specifies the replica zone for regional storagePool.
     *
     * Generated from protobuf field <code>string replica_zone = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReplicaZone()
    {
        return $this->replica_zone;
    }

    /**
     * Optional. Specifies the replica zone for regional storagePool.
     *
     * Generated from protobuf field <code>string replica_zone = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReplicaZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->replica_zone = $var;

        return $this;
    }

    /**
     * Optional. Specifies the active zone for regional storagePool.
     *
     * Generated from protobuf field <code>string zone = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * Optional. Specifies the active zone for regional storagePool.
     *
     * Generated from protobuf field <code>string zone = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return $this->satisfies_pzi;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * Optional. True if using Independent Scaling of capacity and performance
     * (Hyperdisk) By default set to false
     *
     * Generated from protobuf field <code>bool custom_performance_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getCustomPerformanceEnabled()
    {
        return $this->custom_performance_enabled;
    }

    /**
     * Optional. True if using Independent Scaling of capacity and performance
     * (Hyperdisk) By default set to false
     *
     * Generated from protobuf field <code>bool custom_performance_enabled = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setCustomPerformanceEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->custom_performance_enabled = $var;

        return $this;
    }

    /**
     * Optional. Custom Performance Total Throughput of the pool (in MiBps)
     *
     * Generated from protobuf field <code>int64 total_throughput_mibps = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getTotalThroughputMibps()
    {
        return $this->total_throughput_mibps;
    }

    /**
     * Optional. Custom Performance Total Throughput of the pool (in MiBps)
     *
     * Generated from protobuf field <code>int64 total_throughput_mibps = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalThroughputMibps($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_throughput_mibps = $var;

        return $this;
    }

    /**
     * Optional. Custom Performance Total IOPS of the pool
     * if not provided, it will be calculated based on the total_throughput_mibps
     *
     * Generated from protobuf field <code>int64 total_iops = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getTotalIops()
    {
        return $this->total_iops;
    }

    /**
     * Optional. Custom Performance Total IOPS of the pool
     * if not provided, it will be calculated based on the total_throughput_mibps
     *
     * Generated from protobuf field <code>int64 total_iops = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalIops($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_iops = $var;

        return $this;
    }

    /**
     * Optional. Total hot tier capacity for the Storage Pool. It is applicable
     * only to Flex service level. It should be less than the minimum storage pool
     * size and cannot be more than the current storage pool size. It cannot be
     * decreased once set.
     *
     * Generated from protobuf field <code>int64 hot_tier_size_gib = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getHotTierSizeGib()
    {
        return $this->hot_tier_size_gib;
    }

    /**
     * Optional. Total hot tier capacity for the Storage Pool. It is applicable
     * only to Flex service level. It should be less than the minimum storage pool
     * size and cannot be more than the current storage pool size. It cannot be
     * decreased once set.
     *
     * Generated from protobuf field <code>int64 hot_tier_size_gib = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setHotTierSizeGib($var)
    {
        GPBUtil::checkInt64($var);
        $this->hot_tier_size_gib = $var;

        return $this;
    }

    /**
     * Optional. Flag indicating that the hot-tier threshold will be
     * auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
     * The increment will kick in only if the new size after increment is
     * still less than or equal to storage pool size.
     *
     * Generated from protobuf field <code>optional bool enable_hot_tier_auto_resize = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableHotTierAutoResize()
    {
        return isset($this->enable_hot_tier_auto_resize) ? $this->enable_hot_tier_auto_resize : false;
    }

    public function hasEnableHotTierAutoResize()
    {
        return isset($this->enable_hot_tier_auto_resize);
    }

    public function clearEnableHotTierAutoResize()
    {
        unset($this->enable_hot_tier_auto_resize);
    }

    /**
     * Optional. Flag indicating that the hot-tier threshold will be
     * auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
     * The increment will kick in only if the new size after increment is
     * still less than or equal to storage pool size.
     *
     * Generated from protobuf field <code>optional bool enable_hot_tier_auto_resize = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableHotTierAutoResize($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_hot_tier_auto_resize = $var;

        return $this;
    }

    /**
     * Optional. QoS (Quality of Service) Type of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.QosType qos_type = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getQosType()
    {
        return $this->qos_type;
    }

    /**
     * Optional. QoS (Quality of Service) Type of the storage pool
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.QosType qos_type = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setQosType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\QosType::class);
        $this->qos_type = $var;

        return $this;
    }

    /**
     * Output only. Available throughput of the storage pool (in MiB/s).
     *
     * Generated from protobuf field <code>double available_throughput_mibps = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getAvailableThroughputMibps()
    {
        return $this->available_throughput_mibps;
    }

    /**
     * Output only. Available throughput of the storage pool (in MiB/s).
     *
     * Generated from protobuf field <code>double available_throughput_mibps = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setAvailableThroughputMibps($var)
    {
        GPBUtil::checkDouble($var);
        $this->available_throughput_mibps = $var;

        return $this;
    }

    /**
     * Output only. Total cold tier data rounded down to the nearest GiB used by
     * the storage pool.
     *
     * Generated from protobuf field <code>int64 cold_tier_size_used_gib = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getColdTierSizeUsedGib()
    {
        return $this->cold_tier_size_used_gib;
    }

    /**
     * Output only. Total cold tier data rounded down to the nearest GiB used by
     * the storage pool.
     *
     * Generated from protobuf field <code>int64 cold_tier_size_used_gib = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setColdTierSizeUsedGib($var)
    {
        GPBUtil::checkInt64($var);
        $this->cold_tier_size_used_gib = $var;

        return $this;
    }

    /**
     * Output only. Total hot tier data rounded down to the nearest GiB used by
     * the storage pool.
     *
     * Generated from protobuf field <code>int64 hot_tier_size_used_gib = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getHotTierSizeUsedGib()
    {
        return $this->hot_tier_size_used_gib;
    }

    /**
     * Output only. Total hot tier data rounded down to the nearest GiB used by
     * the storage pool.
     *
     * Generated from protobuf field <code>int64 hot_tier_size_used_gib = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setHotTierSizeUsedGib($var)
    {
        GPBUtil::checkInt64($var);
        $this->hot_tier_size_used_gib = $var;

        return $this;
    }

    /**
     * Optional. Type of the storage pool. This field is used to control whether
     * the pool supports `FILE` based volumes only or `UNIFIED` (both `FILE` and
     * `BLOCK`) volumes or `UNIFIED_LARGE_CAPACITY` (both `FILE` and `BLOCK`)
     * volumes with large capacity. If not specified during creation, it defaults
     * to `FILE`.
     *
     * Generated from protobuf field <code>optional .google.cloud.netapp.v1.StoragePoolType type = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getType()
    {
        return isset($this->type) ? $this->type : 0;
    }

    public function hasType()
    {
        return isset($this->type);
    }

    public function clearType()
    {
        unset($this->type);
    }

    /**
     * Optional. Type of the storage pool. This field is used to control whether
     * the pool supports `FILE` based volumes only or `UNIFIED` (both `FILE` and
     * `BLOCK`) volumes or `UNIFIED_LARGE_CAPACITY` (both `FILE` and `BLOCK`)
     * volumes with large capacity. If not specified during creation, it defaults
     * to `FILE`.
     *
     * Generated from protobuf field <code>optional .google.cloud.netapp.v1.StoragePoolType type = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\StoragePoolType::class);
        $this->type = $var;

        return $this;
    }

}

