<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/managedkafka/v1/managed_kafka_connect.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ManagedKafka\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\ManagedKafka\V1\ConnectCluster;
use Google\Cloud\ManagedKafka\V1\Connector;
use Google\Cloud\ManagedKafka\V1\CreateConnectClusterRequest;
use Google\Cloud\ManagedKafka\V1\CreateConnectorRequest;
use Google\Cloud\ManagedKafka\V1\DeleteConnectClusterRequest;
use Google\Cloud\ManagedKafka\V1\DeleteConnectorRequest;
use Google\Cloud\ManagedKafka\V1\GetConnectClusterRequest;
use Google\Cloud\ManagedKafka\V1\GetConnectorRequest;
use Google\Cloud\ManagedKafka\V1\ListConnectClustersRequest;
use Google\Cloud\ManagedKafka\V1\ListConnectorsRequest;
use Google\Cloud\ManagedKafka\V1\PauseConnectorRequest;
use Google\Cloud\ManagedKafka\V1\PauseConnectorResponse;
use Google\Cloud\ManagedKafka\V1\RestartConnectorRequest;
use Google\Cloud\ManagedKafka\V1\RestartConnectorResponse;
use Google\Cloud\ManagedKafka\V1\ResumeConnectorRequest;
use Google\Cloud\ManagedKafka\V1\ResumeConnectorResponse;
use Google\Cloud\ManagedKafka\V1\StopConnectorRequest;
use Google\Cloud\ManagedKafka\V1\StopConnectorResponse;
use Google\Cloud\ManagedKafka\V1\UpdateConnectClusterRequest;
use Google\Cloud\ManagedKafka\V1\UpdateConnectorRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The service that a client application uses to manage Apache Kafka Connect
 * clusters and connectors.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createConnectClusterAsync(CreateConnectClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Connector> createConnectorAsync(CreateConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteConnectClusterAsync(DeleteConnectClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteConnectorAsync(DeleteConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ConnectCluster> getConnectClusterAsync(GetConnectClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Connector> getConnectorAsync(GetConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listConnectClustersAsync(ListConnectClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listConnectorsAsync(ListConnectorsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PauseConnectorResponse> pauseConnectorAsync(PauseConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RestartConnectorResponse> restartConnectorAsync(RestartConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ResumeConnectorResponse> resumeConnectorAsync(ResumeConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StopConnectorResponse> stopConnectorAsync(StopConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateConnectClusterAsync(UpdateConnectClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Connector> updateConnectorAsync(UpdateConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ManagedKafkaConnectClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.managedkafka.v1.ManagedKafkaConnect';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'managedkafka.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'managedkafka.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/managed_kafka_connect_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/managed_kafka_connect_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/managed_kafka_connect_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/managed_kafka_connect_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * connect_cluster resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connectCluster
     *
     * @return string The formatted connect_cluster resource.
     */
    public static function connectClusterName(string $project, string $location, string $connectCluster): string
    {
        return self::getPathTemplate('connectCluster')->render([
            'project' => $project,
            'location' => $location,
            'connect_cluster' => $connectCluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a connector
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connectCluster
     * @param string $connector
     *
     * @return string The formatted connector resource.
     */
    public static function connectorName(
        string $project,
        string $location,
        string $connectCluster,
        string $connector
    ): string {
        return self::getPathTemplate('connector')->render([
            'project' => $project,
            'location' => $location,
            'connect_cluster' => $connectCluster,
            'connector' => $connector,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $secretVersion
     *
     * @return string The formatted secret_version resource.
     */
    public static function secretVersionName(string $project, string $secret, string $secretVersion): string
    {
        return self::getPathTemplate('secretVersion')->render([
            'project' => $project,
            'secret' => $secret,
            'secret_version' => $secretVersion,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - connectCluster: projects/{project}/locations/{location}/connectClusters/{connect_cluster}
     * - connector: projects/{project}/locations/{location}/connectClusters/{connect_cluster}/connectors/{connector}
     * - location: projects/{project}/locations/{location}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{secret_version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'managedkafka.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\ManagedKafka\V1\ManagedKafkaConnectClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ManagedKafkaConnectClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new Kafka Connect cluster in a given project and location.
     *
     * The async variant is
     * {@see ManagedKafkaConnectClient::createConnectClusterAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/create_connect_cluster.php
     *
     * @param CreateConnectClusterRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ConnectCluster>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConnectCluster(
        CreateConnectClusterRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateConnectCluster', $request, $callOptions)->wait();
    }

    /**
     * Creates a new connector in a given Connect cluster.
     *
     * The async variant is {@see ManagedKafkaConnectClient::createConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/create_connector.php
     *
     * @param CreateConnectorRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Connector
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConnector(CreateConnectorRequest $request, array $callOptions = []): Connector
    {
        return $this->startApiCall('CreateConnector', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Connect cluster.
     *
     * The async variant is
     * {@see ManagedKafkaConnectClient::deleteConnectClusterAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/delete_connect_cluster.php
     *
     * @param DeleteConnectClusterRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConnectCluster(
        DeleteConnectClusterRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteConnectCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a connector.
     *
     * The async variant is {@see ManagedKafkaConnectClient::deleteConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/delete_connector.php
     *
     * @param DeleteConnectorRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConnector(DeleteConnectorRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConnector', $request, $callOptions)->wait();
    }

    /**
     * Returns the properties of a single Kafka Connect cluster.
     *
     * The async variant is {@see ManagedKafkaConnectClient::getConnectClusterAsync()}
     * .
     *
     * @example samples/V1/ManagedKafkaConnectClient/get_connect_cluster.php
     *
     * @param GetConnectClusterRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConnectCluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConnectCluster(GetConnectClusterRequest $request, array $callOptions = []): ConnectCluster
    {
        return $this->startApiCall('GetConnectCluster', $request, $callOptions)->wait();
    }

    /**
     * Returns the properties of a single connector.
     *
     * The async variant is {@see ManagedKafkaConnectClient::getConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/get_connector.php
     *
     * @param GetConnectorRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Connector
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConnector(GetConnectorRequest $request, array $callOptions = []): Connector
    {
        return $this->startApiCall('GetConnector', $request, $callOptions)->wait();
    }

    /**
     * Lists the Kafka Connect clusters in a given project and location.
     *
     * The async variant is
     * {@see ManagedKafkaConnectClient::listConnectClustersAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/list_connect_clusters.php
     *
     * @param ListConnectClustersRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConnectClusters(ListConnectClustersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConnectClusters', $request, $callOptions);
    }

    /**
     * Lists the connectors in a given Connect cluster.
     *
     * The async variant is {@see ManagedKafkaConnectClient::listConnectorsAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/list_connectors.php
     *
     * @param ListConnectorsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConnectors(ListConnectorsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConnectors', $request, $callOptions);
    }

    /**
     * Pauses the connector and its tasks.
     *
     * The async variant is {@see ManagedKafkaConnectClient::pauseConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/pause_connector.php
     *
     * @param PauseConnectorRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PauseConnectorResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function pauseConnector(PauseConnectorRequest $request, array $callOptions = []): PauseConnectorResponse
    {
        return $this->startApiCall('PauseConnector', $request, $callOptions)->wait();
    }

    /**
     * Restarts the connector.
     *
     * The async variant is {@see ManagedKafkaConnectClient::restartConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/restart_connector.php
     *
     * @param RestartConnectorRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RestartConnectorResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restartConnector(
        RestartConnectorRequest $request,
        array $callOptions = []
    ): RestartConnectorResponse {
        return $this->startApiCall('RestartConnector', $request, $callOptions)->wait();
    }

    /**
     * Resumes the connector and its tasks.
     *
     * The async variant is {@see ManagedKafkaConnectClient::resumeConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/resume_connector.php
     *
     * @param ResumeConnectorRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ResumeConnectorResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resumeConnector(ResumeConnectorRequest $request, array $callOptions = []): ResumeConnectorResponse
    {
        return $this->startApiCall('ResumeConnector', $request, $callOptions)->wait();
    }

    /**
     * Stops the connector.
     *
     * The async variant is {@see ManagedKafkaConnectClient::stopConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/stop_connector.php
     *
     * @param StopConnectorRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StopConnectorResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopConnector(StopConnectorRequest $request, array $callOptions = []): StopConnectorResponse
    {
        return $this->startApiCall('StopConnector', $request, $callOptions)->wait();
    }

    /**
     * Updates the properties of a single Kafka Connect cluster.
     *
     * The async variant is
     * {@see ManagedKafkaConnectClient::updateConnectClusterAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/update_connect_cluster.php
     *
     * @param UpdateConnectClusterRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ConnectCluster>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConnectCluster(
        UpdateConnectClusterRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateConnectCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates the properties of a connector.
     *
     * The async variant is {@see ManagedKafkaConnectClient::updateConnectorAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/update_connector.php
     *
     * @param UpdateConnectorRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Connector
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConnector(UpdateConnectorRequest $request, array $callOptions = []): Connector
    {
        return $this->startApiCall('UpdateConnector', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ManagedKafkaConnectClient::getLocationAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ManagedKafkaConnectClient::listLocationsAsync()} .
     *
     * @example samples/V1/ManagedKafkaConnectClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
