<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/logging/v2/logging_config.proto

namespace Google\Cloud\Logging\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes a link connected to an analytics enabled bucket.
 *
 * Generated from protobuf message <code>google.logging.v2.Link</code>
 */
class Link extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     * For example:
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Describes this link.
     * The maximum length of the description is 8000 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * Output only. The creation timestamp of the link.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The resource lifecycle state.
     *
     * Generated from protobuf field <code>.google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $lifecycle_state = 0;
    /**
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     *
     * Generated from protobuf field <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    private $bigquery_dataset = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the link. The name can have up to 100 characters.
     *           A valid link id (at the end of the link name) must only have alphanumeric
     *           characters and underscores within it.
     *               "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *               "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *               "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *               "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *           For example:
     *             `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     *     @type string $description
     *           Describes this link.
     *           The maximum length of the description is 8000 characters.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp of the link.
     *     @type int $lifecycle_state
     *           Output only. The resource lifecycle state.
     *     @type \Google\Cloud\Logging\V2\BigQueryDataset $bigquery_dataset
     *           The information of a BigQuery Dataset. When a link is created, a BigQuery
     *           dataset is created along with it, in the same project as the LogBucket it's
     *           linked to. This dataset will also have BigQuery Views corresponding to the
     *           LogViews in the bucket.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Logging\V2\LoggingConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     * For example:
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     * For example:
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Describes this link.
     * The maximum length of the description is 8000 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Describes this link.
     * The maximum length of the description is 8000 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The creation timestamp of the link.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp of the link.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The resource lifecycle state.
     *
     * Generated from protobuf field <code>.google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getLifecycleState()
    {
        return $this->lifecycle_state;
    }

    /**
     * Output only. The resource lifecycle state.
     *
     * Generated from protobuf field <code>.google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setLifecycleState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Logging\V2\LifecycleState::class);
        $this->lifecycle_state = $var;

        return $this;
    }

    /**
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     *
     * Generated from protobuf field <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     * @return \Google\Cloud\Logging\V2\BigQueryDataset|null
     */
    public function getBigqueryDataset()
    {
        return $this->bigquery_dataset;
    }

    public function hasBigqueryDataset()
    {
        return isset($this->bigquery_dataset);
    }

    public function clearBigqueryDataset()
    {
        unset($this->bigquery_dataset);
    }

    /**
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     *
     * Generated from protobuf field <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     * @param \Google\Cloud\Logging\V2\BigQueryDataset $var
     * @return $this
     */
    public function setBigqueryDataset($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Logging\V2\BigQueryDataset::class);
        $this->bigquery_dataset = $var;

        return $this;
    }

}

