<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/kms/inventory/v1/key_tracking_service.proto

namespace Google\Cloud\Kms\Inventory\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources].
 *
 * Generated from protobuf message <code>google.cloud.kms.inventory.v1.SearchProtectedResourcesRequest</code>
 */
class SearchProtectedResourcesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. A scope can be an organization or a project. Resources protected
     * by the crypto key in provided scope will be returned.
     * The following values are allowed:
     * * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/12345678")
     * * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
     * * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
     *
     * Generated from protobuf field <code>string scope = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $scope = '';
    /**
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *
     * Generated from protobuf field <code>string crypto_key = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $crypto_key = '';
    /**
     * The maximum number of resources to return. The service may return fewer
     * than this value.
     * If unspecified, at most 500 resources will be returned.
     * The maximum value is 500; values above 500 will be coerced to 500.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     */
    protected $page_size = 0;
    /**
     * A page token, received from a previous
     * [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     * must match the call that provided the page token.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     */
    protected $page_token = '';
    /**
     * Optional. A list of resource types that this request searches for. If
     * empty, it will search all the [trackable resource
     * types](https://cloud.google.com/kms/docs/view-key-usage#tracked-resource-types).
     * Regular expressions are also supported. For example:
     * * `compute.googleapis.com.*` snapshots resources whose type starts
     * with `compute.googleapis.com`.
     * * `.*Image` snapshots resources whose type ends with `Image`.
     * * `.*Image.*` snapshots resources whose type contains `Image`.
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported resource type, an INVALID_ARGUMENT error will be returned.
     *
     * Generated from protobuf field <code>repeated string resource_types = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $resource_types;

    /**
     * @param string $scope     Required. A scope can be an organization or a project. Resources protected
     *                          by the crypto key in provided scope will be returned.
     *
     *                          The following values are allowed:
     *
     *                          * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/12345678")
     *                          * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
     *                          * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
     *                          Please see {@see KeyTrackingServiceClient::projectName()} for help formatting this field.
     * @param string $cryptoKey Required. The resource name of the
     *                          [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *
     * @return \Google\Cloud\Kms\Inventory\V1\SearchProtectedResourcesRequest
     *
     * @experimental
     */
    public static function build(string $scope, string $cryptoKey): self
    {
        return (new self())
            ->setScope($scope)
            ->setCryptoKey($cryptoKey);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $scope
     *           Required. A scope can be an organization or a project. Resources protected
     *           by the crypto key in provided scope will be returned.
     *           The following values are allowed:
     *           * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/12345678")
     *           * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
     *           * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
     *     @type string $crypto_key
     *           Required. The resource name of the
     *           [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *     @type int $page_size
     *           The maximum number of resources to return. The service may return fewer
     *           than this value.
     *           If unspecified, at most 500 resources will be returned.
     *           The maximum value is 500; values above 500 will be coerced to 500.
     *     @type string $page_token
     *           A page token, received from a previous
     *           [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     *           call. Provide this to retrieve the subsequent page.
     *           When paginating, all other parameters provided to
     *           [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     *           must match the call that provided the page token.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $resource_types
     *           Optional. A list of resource types that this request searches for. If
     *           empty, it will search all the [trackable resource
     *           types](https://cloud.google.com/kms/docs/view-key-usage#tracked-resource-types).
     *           Regular expressions are also supported. For example:
     *           * `compute.googleapis.com.*` snapshots resources whose type starts
     *           with `compute.googleapis.com`.
     *           * `.*Image` snapshots resources whose type ends with `Image`.
     *           * `.*Image.*` snapshots resources whose type contains `Image`.
     *           See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     *           regular expression syntax. If the regular expression does not match any
     *           supported resource type, an INVALID_ARGUMENT error will be returned.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Kms\Inventory\V1\KeyTrackingService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. A scope can be an organization or a project. Resources protected
     * by the crypto key in provided scope will be returned.
     * The following values are allowed:
     * * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/12345678")
     * * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
     * * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
     *
     * Generated from protobuf field <code>string scope = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Required. A scope can be an organization or a project. Resources protected
     * by the crypto key in provided scope will be returned.
     * The following values are allowed:
     * * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/12345678")
     * * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
     * * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
     *
     * Generated from protobuf field <code>string scope = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *
     * Generated from protobuf field <code>string crypto_key = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCryptoKey()
    {
        return $this->crypto_key;
    }

    /**
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     *
     * Generated from protobuf field <code>string crypto_key = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCryptoKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->crypto_key = $var;

        return $this;
    }

    /**
     * The maximum number of resources to return. The service may return fewer
     * than this value.
     * If unspecified, at most 500 resources will be returned.
     * The maximum value is 500; values above 500 will be coerced to 500.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of resources to return. The service may return fewer
     * than this value.
     * If unspecified, at most 500 resources will be returned.
     * The maximum value is 500; values above 500 will be coerced to 500.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A page token, received from a previous
     * [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     * must match the call that provided the page token.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A page token, received from a previous
     * [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [KeyTrackingService.SearchProtectedResources][google.cloud.kms.inventory.v1.KeyTrackingService.SearchProtectedResources]
     * must match the call that provided the page token.
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Optional. A list of resource types that this request searches for. If
     * empty, it will search all the [trackable resource
     * types](https://cloud.google.com/kms/docs/view-key-usage#tracked-resource-types).
     * Regular expressions are also supported. For example:
     * * `compute.googleapis.com.*` snapshots resources whose type starts
     * with `compute.googleapis.com`.
     * * `.*Image` snapshots resources whose type ends with `Image`.
     * * `.*Image.*` snapshots resources whose type contains `Image`.
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported resource type, an INVALID_ARGUMENT error will be returned.
     *
     * Generated from protobuf field <code>repeated string resource_types = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourceTypes()
    {
        return $this->resource_types;
    }

    /**
     * Optional. A list of resource types that this request searches for. If
     * empty, it will search all the [trackable resource
     * types](https://cloud.google.com/kms/docs/view-key-usage#tracked-resource-types).
     * Regular expressions are also supported. For example:
     * * `compute.googleapis.com.*` snapshots resources whose type starts
     * with `compute.googleapis.com`.
     * * `.*Image` snapshots resources whose type ends with `Image`.
     * * `.*Image.*` snapshots resources whose type contains `Image`.
     * See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     * regular expression syntax. If the regular expression does not match any
     * supported resource type, an INVALID_ARGUMENT error will be returned.
     *
     * Generated from protobuf field <code>repeated string resource_types = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourceTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_types = $arr;

        return $this;
    }

}

