<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/kms/inventory/v1/key_tracking_service.proto

namespace Google\Cloud\Kms\Inventory\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Aggregate information about the resources protected by a Cloud KMS key in the
 * same Cloud organization/project as the key.
 *
 * Generated from protobuf message <code>google.cloud.kms.inventory.v1.ProtectedResourcesSummary</code>
 */
class ProtectedResourcesSummary extends \Google\Protobuf\Internal\Message
{
    /**
     * The full name of the ProtectedResourcesSummary resource.
     * Example:
     * projects/test-project/locations/us/keyRings/test-keyring/cryptoKeys/test-key/protectedResourcesSummary
     *
     * Generated from protobuf field <code>string name = 5;</code>
     */
    protected $name = '';
    /**
     * The total number of protected resources in the same Cloud organization as
     * the key.
     *
     * Generated from protobuf field <code>int64 resource_count = 1;</code>
     */
    protected $resource_count = 0;
    /**
     * The number of distinct Cloud projects in the same Cloud organization as the
     * key that have resources protected by the key.
     *
     * Generated from protobuf field <code>int32 project_count = 2;</code>
     */
    protected $project_count = 0;
    /**
     * The number of resources protected by the key grouped by resource type.
     *
     * Generated from protobuf field <code>map<string, int64> resource_types = 3;</code>
     */
    private $resource_types;
    /**
     * The number of resources protected by the key grouped by Cloud product.
     *
     * Generated from protobuf field <code>map<string, int64> cloud_products = 6;</code>
     */
    private $cloud_products;
    /**
     * The number of resources protected by the key grouped by region.
     *
     * Generated from protobuf field <code>map<string, int64> locations = 4;</code>
     */
    private $locations;
    /**
     * Warning messages for the state of response
     * [ProtectedResourcesSummary][google.cloud.kms.inventory.v1.ProtectedResourcesSummary]
     * For example, if the organization service account is not configured,
     * INSUFFICIENT_PERMISSIONS_PARTIAL_DATA warning will be returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.kms.inventory.v1.Warning warnings = 7;</code>
     */
    private $warnings;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The full name of the ProtectedResourcesSummary resource.
     *           Example:
     *           projects/test-project/locations/us/keyRings/test-keyring/cryptoKeys/test-key/protectedResourcesSummary
     *     @type int|string $resource_count
     *           The total number of protected resources in the same Cloud organization as
     *           the key.
     *     @type int $project_count
     *           The number of distinct Cloud projects in the same Cloud organization as the
     *           key that have resources protected by the key.
     *     @type array|\Google\Protobuf\Internal\MapField $resource_types
     *           The number of resources protected by the key grouped by resource type.
     *     @type array|\Google\Protobuf\Internal\MapField $cloud_products
     *           The number of resources protected by the key grouped by Cloud product.
     *     @type array|\Google\Protobuf\Internal\MapField $locations
     *           The number of resources protected by the key grouped by region.
     *     @type array<\Google\Cloud\Kms\Inventory\V1\Warning>|\Google\Protobuf\Internal\RepeatedField $warnings
     *           Warning messages for the state of response
     *           [ProtectedResourcesSummary][google.cloud.kms.inventory.v1.ProtectedResourcesSummary]
     *           For example, if the organization service account is not configured,
     *           INSUFFICIENT_PERMISSIONS_PARTIAL_DATA warning will be returned.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Kms\Inventory\V1\KeyTrackingService::initOnce();
        parent::__construct($data);
    }

    /**
     * The full name of the ProtectedResourcesSummary resource.
     * Example:
     * projects/test-project/locations/us/keyRings/test-keyring/cryptoKeys/test-key/protectedResourcesSummary
     *
     * Generated from protobuf field <code>string name = 5;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The full name of the ProtectedResourcesSummary resource.
     * Example:
     * projects/test-project/locations/us/keyRings/test-keyring/cryptoKeys/test-key/protectedResourcesSummary
     *
     * Generated from protobuf field <code>string name = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The total number of protected resources in the same Cloud organization as
     * the key.
     *
     * Generated from protobuf field <code>int64 resource_count = 1;</code>
     * @return int|string
     */
    public function getResourceCount()
    {
        return $this->resource_count;
    }

    /**
     * The total number of protected resources in the same Cloud organization as
     * the key.
     *
     * Generated from protobuf field <code>int64 resource_count = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setResourceCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->resource_count = $var;

        return $this;
    }

    /**
     * The number of distinct Cloud projects in the same Cloud organization as the
     * key that have resources protected by the key.
     *
     * Generated from protobuf field <code>int32 project_count = 2;</code>
     * @return int
     */
    public function getProjectCount()
    {
        return $this->project_count;
    }

    /**
     * The number of distinct Cloud projects in the same Cloud organization as the
     * key that have resources protected by the key.
     *
     * Generated from protobuf field <code>int32 project_count = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setProjectCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->project_count = $var;

        return $this;
    }

    /**
     * The number of resources protected by the key grouped by resource type.
     *
     * Generated from protobuf field <code>map<string, int64> resource_types = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getResourceTypes()
    {
        return $this->resource_types;
    }

    /**
     * The number of resources protected by the key grouped by resource type.
     *
     * Generated from protobuf field <code>map<string, int64> resource_types = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setResourceTypes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::INT64);
        $this->resource_types = $arr;

        return $this;
    }

    /**
     * The number of resources protected by the key grouped by Cloud product.
     *
     * Generated from protobuf field <code>map<string, int64> cloud_products = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getCloudProducts()
    {
        return $this->cloud_products;
    }

    /**
     * The number of resources protected by the key grouped by Cloud product.
     *
     * Generated from protobuf field <code>map<string, int64> cloud_products = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setCloudProducts($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::INT64);
        $this->cloud_products = $arr;

        return $this;
    }

    /**
     * The number of resources protected by the key grouped by region.
     *
     * Generated from protobuf field <code>map<string, int64> locations = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLocations()
    {
        return $this->locations;
    }

    /**
     * The number of resources protected by the key grouped by region.
     *
     * Generated from protobuf field <code>map<string, int64> locations = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLocations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::INT64);
        $this->locations = $arr;

        return $this;
    }

    /**
     * Warning messages for the state of response
     * [ProtectedResourcesSummary][google.cloud.kms.inventory.v1.ProtectedResourcesSummary]
     * For example, if the organization service account is not configured,
     * INSUFFICIENT_PERMISSIONS_PARTIAL_DATA warning will be returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.kms.inventory.v1.Warning warnings = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWarnings()
    {
        return $this->warnings;
    }

    /**
     * Warning messages for the state of response
     * [ProtectedResourcesSummary][google.cloud.kms.inventory.v1.ProtectedResourcesSummary]
     * For example, if the organization service account is not configured,
     * INSUFFICIENT_PERMISSIONS_PARTIAL_DATA warning will be returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.kms.inventory.v1.Warning warnings = 7;</code>
     * @param array<\Google\Cloud\Kms\Inventory\V1\Warning>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWarnings($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Kms\Inventory\V1\Warning::class);
        $this->warnings = $arr;

        return $this;
    }

}

