<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/kms/v1/hsm_management.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Kms\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Kms\V1\ApproveSingleTenantHsmInstanceProposalRequest;
use Google\Cloud\Kms\V1\ApproveSingleTenantHsmInstanceProposalResponse;
use Google\Cloud\Kms\V1\CreateSingleTenantHsmInstanceProposalRequest;
use Google\Cloud\Kms\V1\CreateSingleTenantHsmInstanceRequest;
use Google\Cloud\Kms\V1\DeleteSingleTenantHsmInstanceProposalRequest;
use Google\Cloud\Kms\V1\ExecuteSingleTenantHsmInstanceProposalRequest;
use Google\Cloud\Kms\V1\ExecuteSingleTenantHsmInstanceProposalResponse;
use Google\Cloud\Kms\V1\GetSingleTenantHsmInstanceProposalRequest;
use Google\Cloud\Kms\V1\GetSingleTenantHsmInstanceRequest;
use Google\Cloud\Kms\V1\ListSingleTenantHsmInstanceProposalsRequest;
use Google\Cloud\Kms\V1\ListSingleTenantHsmInstancesRequest;
use Google\Cloud\Kms\V1\SingleTenantHsmInstance;
use Google\Cloud\Kms\V1\SingleTenantHsmInstanceProposal;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Google Cloud HSM Management Service
 *
 * Provides interfaces for managing HSM instances.
 *
 * Implements a REST model with the following objects:
 * * [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
 * * [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<ApproveSingleTenantHsmInstanceProposalResponse> approveSingleTenantHsmInstanceProposalAsync(ApproveSingleTenantHsmInstanceProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createSingleTenantHsmInstanceAsync(CreateSingleTenantHsmInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createSingleTenantHsmInstanceProposalAsync(CreateSingleTenantHsmInstanceProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSingleTenantHsmInstanceProposalAsync(DeleteSingleTenantHsmInstanceProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> executeSingleTenantHsmInstanceProposalAsync(ExecuteSingleTenantHsmInstanceProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SingleTenantHsmInstance> getSingleTenantHsmInstanceAsync(GetSingleTenantHsmInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SingleTenantHsmInstanceProposal> getSingleTenantHsmInstanceProposalAsync(GetSingleTenantHsmInstanceProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSingleTenantHsmInstanceProposalsAsync(ListSingleTenantHsmInstanceProposalsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSingleTenantHsmInstancesAsync(ListSingleTenantHsmInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class HsmManagementClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.kms.v1.HsmManagement';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'cloudkms.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'cloudkms.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloudkms',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/hsm_management_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/hsm_management_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/hsm_management_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/hsm_management_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * single_tenant_hsm_instance resource.
     *
     * @param string $project
     * @param string $location
     * @param string $singleTenantHsmInstance
     *
     * @return string The formatted single_tenant_hsm_instance resource.
     */
    public static function singleTenantHsmInstanceName(
        string $project,
        string $location,
        string $singleTenantHsmInstance
    ): string {
        return self::getPathTemplate('singleTenantHsmInstance')->render([
            'project' => $project,
            'location' => $location,
            'single_tenant_hsm_instance' => $singleTenantHsmInstance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * single_tenant_hsm_instance_proposal resource.
     *
     * @param string $project
     * @param string $location
     * @param string $singleTenantHsmInstance
     * @param string $proposal
     *
     * @return string The formatted single_tenant_hsm_instance_proposal resource.
     */
    public static function singleTenantHsmInstanceProposalName(
        string $project,
        string $location,
        string $singleTenantHsmInstance,
        string $proposal
    ): string {
        return self::getPathTemplate('singleTenantHsmInstanceProposal')->render([
            'project' => $project,
            'location' => $location,
            'single_tenant_hsm_instance' => $singleTenantHsmInstance,
            'proposal' => $proposal,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - singleTenantHsmInstance: projects/{project}/locations/{location}/singleTenantHsmInstances/{single_tenant_hsm_instance}
     * - singleTenantHsmInstanceProposal: projects/{project}/locations/{location}/singleTenantHsmInstances/{single_tenant_hsm_instance}/proposals/{proposal}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudkms.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Kms\V1\HsmManagementClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new HsmManagementClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Approves a
     * [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
     * for a given
     * [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
     * proposal must be in the
     * [PENDING][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State.PENDING]
     * state.
     *
     * The async variant is
     * {@see HsmManagementClient::approveSingleTenantHsmInstanceProposalAsync()} .
     *
     * @example samples/V1/HsmManagementClient/approve_single_tenant_hsm_instance_proposal.php
     *
     * @param ApproveSingleTenantHsmInstanceProposalRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApproveSingleTenantHsmInstanceProposalResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function approveSingleTenantHsmInstanceProposal(
        ApproveSingleTenantHsmInstanceProposalRequest $request,
        array $callOptions = []
    ): ApproveSingleTenantHsmInstanceProposalResponse {
        return $this->startApiCall('ApproveSingleTenantHsmInstanceProposal', $request, $callOptions)->wait();
    }

    /**
     * Creates a new
     * [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] in a
     * given Project and Location. User must create a RegisterTwoFactorAuthKeys
     * proposal with this single-tenant HSM instance to finish setup of the
     * instance.
     *
     * The async variant is
     * {@see HsmManagementClient::createSingleTenantHsmInstanceAsync()} .
     *
     * @example samples/V1/HsmManagementClient/create_single_tenant_hsm_instance.php
     *
     * @param CreateSingleTenantHsmInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<SingleTenantHsmInstance>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSingleTenantHsmInstance(
        CreateSingleTenantHsmInstanceRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateSingleTenantHsmInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a new
     * [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
     * for a given
     * [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
     *
     * The async variant is
     * {@see HsmManagementClient::createSingleTenantHsmInstanceProposalAsync()} .
     *
     * @example samples/V1/HsmManagementClient/create_single_tenant_hsm_instance_proposal.php
     *
     * @param CreateSingleTenantHsmInstanceProposalRequest $request     A request to house fields associated with the call.
     * @param array                                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<SingleTenantHsmInstanceProposal>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSingleTenantHsmInstanceProposal(
        CreateSingleTenantHsmInstanceProposalRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateSingleTenantHsmInstanceProposal', $request, $callOptions)->wait();
    }

    /**
     * Deletes a
     * [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
     *
     * The async variant is
     * {@see HsmManagementClient::deleteSingleTenantHsmInstanceProposalAsync()} .
     *
     * @example samples/V1/HsmManagementClient/delete_single_tenant_hsm_instance_proposal.php
     *
     * @param DeleteSingleTenantHsmInstanceProposalRequest $request     A request to house fields associated with the call.
     * @param array                                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSingleTenantHsmInstanceProposal(
        DeleteSingleTenantHsmInstanceProposalRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteSingleTenantHsmInstanceProposal', $request, $callOptions)->wait();
    }

    /**
     * Executes a
     * [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
     * for a given
     * [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
     * proposal must be in the
     * [APPROVED][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State.APPROVED]
     * state.
     *
     * The async variant is
     * {@see HsmManagementClient::executeSingleTenantHsmInstanceProposalAsync()} .
     *
     * @example samples/V1/HsmManagementClient/execute_single_tenant_hsm_instance_proposal.php
     *
     * @param ExecuteSingleTenantHsmInstanceProposalRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ExecuteSingleTenantHsmInstanceProposalResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function executeSingleTenantHsmInstanceProposal(
        ExecuteSingleTenantHsmInstanceProposalRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ExecuteSingleTenantHsmInstanceProposal', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for a given
     * [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
     *
     * The async variant is
     * {@see HsmManagementClient::getSingleTenantHsmInstanceAsync()} .
     *
     * @example samples/V1/HsmManagementClient/get_single_tenant_hsm_instance.php
     *
     * @param GetSingleTenantHsmInstanceRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SingleTenantHsmInstance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSingleTenantHsmInstance(
        GetSingleTenantHsmInstanceRequest $request,
        array $callOptions = []
    ): SingleTenantHsmInstance {
        return $this->startApiCall('GetSingleTenantHsmInstance', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for a given
     * [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
     *
     * The async variant is
     * {@see HsmManagementClient::getSingleTenantHsmInstanceProposalAsync()} .
     *
     * @example samples/V1/HsmManagementClient/get_single_tenant_hsm_instance_proposal.php
     *
     * @param GetSingleTenantHsmInstanceProposalRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SingleTenantHsmInstanceProposal
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSingleTenantHsmInstanceProposal(
        GetSingleTenantHsmInstanceProposalRequest $request,
        array $callOptions = []
    ): SingleTenantHsmInstanceProposal {
        return $this->startApiCall('GetSingleTenantHsmInstanceProposal', $request, $callOptions)->wait();
    }

    /**
     * Lists
     * [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
     *
     * The async variant is
     * {@see HsmManagementClient::listSingleTenantHsmInstanceProposalsAsync()} .
     *
     * @example samples/V1/HsmManagementClient/list_single_tenant_hsm_instance_proposals.php
     *
     * @param ListSingleTenantHsmInstanceProposalsRequest $request     A request to house fields associated with the call.
     * @param array                                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSingleTenantHsmInstanceProposals(
        ListSingleTenantHsmInstanceProposalsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListSingleTenantHsmInstanceProposals', $request, $callOptions);
    }

    /**
     * Lists
     * [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance].
     *
     * The async variant is
     * {@see HsmManagementClient::listSingleTenantHsmInstancesAsync()} .
     *
     * @example samples/V1/HsmManagementClient/list_single_tenant_hsm_instances.php
     *
     * @param ListSingleTenantHsmInstancesRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSingleTenantHsmInstances(
        ListSingleTenantHsmInstancesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListSingleTenantHsmInstances', $request, $callOptions);
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see HsmManagementClient::getLocationAsync()} .
     *
     * @example samples/V1/HsmManagementClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
    This method can be called in two ways:

    *   **List all public locations:** Use the path `GET /v1/locations`.
    *   **List project-visible locations:** Use the path
    `GET /v1/projects/{project_id}/locations`. This may include public
    locations as well as private or other locations specifically visible
    to the project.
     *
     * The async variant is {@see HsmManagementClient::listLocationsAsync()} .
     *
     * @example samples/V1/HsmManagementClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see HsmManagementClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/HsmManagementClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see HsmManagementClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/HsmManagementClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see HsmManagementClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/HsmManagementClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
