<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/kms/v1/autokey_admin.proto

namespace Google\Cloud\Kms\V1\AutokeyConfig;

use UnexpectedValueException;

/**
 * Defines the resolution mode enum for the key project.
 * The
 * [KeyProjectResolutionMode][google.cloud.kms.v1.AutokeyConfig.KeyProjectResolutionMode]
 * determines the mechanism by which
 * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] identifies a
 * [key_project][google.cloud.kms.v1.AutokeyConfig.key_project] at its
 * specific configuration node. This parameter also determines if Autokey can
 * be used within this project or folder.
 *
 * Protobuf type <code>google.cloud.kms.v1.AutokeyConfig.KeyProjectResolutionMode</code>
 */
class KeyProjectResolutionMode
{
    /**
     * Default value. KeyProjectResolutionMode when not specified will act as
     * `DEDICATED_KEY_PROJECT`.
     *
     * Generated from protobuf enum <code>KEY_PROJECT_RESOLUTION_MODE_UNSPECIFIED = 0;</code>
     */
    const KEY_PROJECT_RESOLUTION_MODE_UNSPECIFIED = 0;
    /**
     * Keys are created in a dedicated project specified by `key_project`.
     *
     * Generated from protobuf enum <code>DEDICATED_KEY_PROJECT = 1;</code>
     */
    const DEDICATED_KEY_PROJECT = 1;
    /**
     * Keys are created in the same project as the resource requesting the key.
     * The `key_project` must not be set when this mode is used.
     *
     * Generated from protobuf enum <code>RESOURCE_PROJECT = 2;</code>
     */
    const RESOURCE_PROJECT = 2;
    /**
     * Disables the AutokeyConfig. When this mode is set, any AutokeyConfig
     * from higher levels in the resource hierarchy are ignored for this
     * resource and its descendants. This setting can be overridden
     * by a more specific configuration at a lower level. For example,
     * if Autokey is disabled on a folder, it can be re-enabled on a sub-folder
     * or project within that folder by setting a different mode (e.g.,
     * DEDICATED_KEY_PROJECT or RESOURCE_PROJECT).
     *
     * Generated from protobuf enum <code>DISABLED = 3;</code>
     */
    const DISABLED = 3;

    private static $valueToName = [
        self::KEY_PROJECT_RESOLUTION_MODE_UNSPECIFIED => 'KEY_PROJECT_RESOLUTION_MODE_UNSPECIFIED',
        self::DEDICATED_KEY_PROJECT => 'DEDICATED_KEY_PROJECT',
        self::RESOURCE_PROJECT => 'RESOURCE_PROJECT',
        self::DISABLED => 'DISABLED',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


