<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/iam/v3/policy_binding_resources.proto

namespace Google\Cloud\Iam\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * IAM policy binding resource.
 *
 * Generated from protobuf message <code>google.iam.v3.PolicyBinding</code>
 */
class PolicyBinding extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the policy binding, in the format
     * `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`.
     * The binding parent is the closest Resource Manager resource (project,
     * folder, or organization) to the binding target.
     * Format:
     * * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The globally unique ID of the policy binding. Assigned when
     * the policy binding is created.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     */
    protected $uid = '';
    /**
     * Optional. The etag for the policy binding.
     * If this is provided on update, it must match the server's etag.
     *
     * Generated from protobuf field <code>string etag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    /**
     * Optional. The description of the policy binding. Must be less than or equal
     * to 63 characters.
     *
     * Generated from protobuf field <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Optional. User-defined annotations. See
     * https://google.aip.dev/148#annotations for more details such as format and
     * size limitations
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $annotations;
    /**
     * Required. Immutable. Target is the full resource name of the resource to
     * which the policy will be bound. Immutable once set.
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding.Target target = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target = null;
    /**
     * Immutable. The kind of the policy to attach in this binding. This field
     * must be one of the following:
     * - Left empty (will be automatically set to the policy kind)
     * - The input policy kind
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding.PolicyKind policy_kind = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $policy_kind = 0;
    /**
     * Required. Immutable. The resource name of the policy to be bound. The
     * binding parent and policy must belong to the same organization.
     *
     * Generated from protobuf field <code>string policy = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $policy = '';
    /**
     * Output only. The globally unique ID of the policy to be bound.
     *
     * Generated from protobuf field <code>string policy_uid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $policy_uid = '';
    /**
     * Optional. The condition to apply to the policy binding. When set, the
     * `expression` field in the `Expr` must include from 1 to 10 subexpressions,
     * joined by the
     * "||"(Logical OR), "&&"(Logical AND) or "!"(Logical NOT) operators and
     * cannot contain more than 250 characters.
     * The condition is currently only supported when bound to policies of kind
     * principal access boundary.
     * When the bound policy is a principal access boundary policy, the only
     * supported attributes in any subexpression are `principal.type` and
     * `principal.subject`. An example expression is: "principal.type ==
     * 'iam.googleapis.com/ServiceAccount'" or "principal.subject ==
     * 'bob&#64;example.com'".
     * Allowed operations for `principal.subject`:
     * - `principal.subject == <principal subject string>`
     * - `principal.subject != <principal subject string>`
     * - `principal.subject in [<list of principal subjects>]`
     * - `principal.subject.startsWith(<string>)`
     * - `principal.subject.endsWith(<string>)`
     * Allowed operations for `principal.type`:
     * - `principal.type == <principal type string>`
     * - `principal.type != <principal type string>`
     * - `principal.type in [<list of principal types>]`
     * Supported principal types are Workspace, Workforce Pool, Workload Pool and
     * Service Account. Allowed string must be one of:
     * - iam.googleapis.com/WorkspaceIdentity
     * - iam.googleapis.com/WorkforcePoolIdentity
     * - iam.googleapis.com/WorkloadPoolIdentity
     * - iam.googleapis.com/ServiceAccount
     *
     * Generated from protobuf field <code>.google.type.Expr condition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $condition = null;
    /**
     * Output only. The time when the policy binding was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the policy binding was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the policy binding, in the format
     *           `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`.
     *           The binding parent is the closest Resource Manager resource (project,
     *           folder, or organization) to the binding target.
     *           Format:
     *           * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
     *           * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
     *           * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
     *           * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
     *     @type string $uid
     *           Output only. The globally unique ID of the policy binding. Assigned when
     *           the policy binding is created.
     *     @type string $etag
     *           Optional. The etag for the policy binding.
     *           If this is provided on update, it must match the server's etag.
     *     @type string $display_name
     *           Optional. The description of the policy binding. Must be less than or equal
     *           to 63 characters.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Optional. User-defined annotations. See
     *           https://google.aip.dev/148#annotations for more details such as format and
     *           size limitations
     *     @type \Google\Cloud\Iam\V3\PolicyBinding\Target $target
     *           Required. Immutable. Target is the full resource name of the resource to
     *           which the policy will be bound. Immutable once set.
     *     @type int $policy_kind
     *           Immutable. The kind of the policy to attach in this binding. This field
     *           must be one of the following:
     *           - Left empty (will be automatically set to the policy kind)
     *           - The input policy kind
     *     @type string $policy
     *           Required. Immutable. The resource name of the policy to be bound. The
     *           binding parent and policy must belong to the same organization.
     *     @type string $policy_uid
     *           Output only. The globally unique ID of the policy to be bound.
     *     @type \Google\Type\Expr $condition
     *           Optional. The condition to apply to the policy binding. When set, the
     *           `expression` field in the `Expr` must include from 1 to 10 subexpressions,
     *           joined by the
     *           "||"(Logical OR), "&&"(Logical AND) or "!"(Logical NOT) operators and
     *           cannot contain more than 250 characters.
     *           The condition is currently only supported when bound to policies of kind
     *           principal access boundary.
     *           When the bound policy is a principal access boundary policy, the only
     *           supported attributes in any subexpression are `principal.type` and
     *           `principal.subject`. An example expression is: "principal.type ==
     *           'iam.googleapis.com/ServiceAccount'" or "principal.subject ==
     *           'bob&#64;example.com'".
     *           Allowed operations for `principal.subject`:
     *           - `principal.subject == <principal subject string>`
     *           - `principal.subject != <principal subject string>`
     *           - `principal.subject in [<list of principal subjects>]`
     *           - `principal.subject.startsWith(<string>)`
     *           - `principal.subject.endsWith(<string>)`
     *           Allowed operations for `principal.type`:
     *           - `principal.type == <principal type string>`
     *           - `principal.type != <principal type string>`
     *           - `principal.type in [<list of principal types>]`
     *           Supported principal types are Workspace, Workforce Pool, Workload Pool and
     *           Service Account. Allowed string must be one of:
     *           - iam.googleapis.com/WorkspaceIdentity
     *           - iam.googleapis.com/WorkforcePoolIdentity
     *           - iam.googleapis.com/WorkloadPoolIdentity
     *           - iam.googleapis.com/ServiceAccount
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the policy binding was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the policy binding was most recently updated.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Iam\V3\PolicyBindingResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the policy binding, in the format
     * `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`.
     * The binding parent is the closest Resource Manager resource (project,
     * folder, or organization) to the binding target.
     * Format:
     * * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the policy binding, in the format
     * `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`.
     * The binding parent is the closest Resource Manager resource (project,
     * folder, or organization) to the binding target.
     * Format:
     * * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
     * * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The globally unique ID of the policy binding. Assigned when
     * the policy binding is created.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. The globally unique ID of the policy binding. Assigned when
     * the policy binding is created.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Optional. The etag for the policy binding.
     * If this is provided on update, it must match the server's etag.
     *
     * Generated from protobuf field <code>string etag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. The etag for the policy binding.
     * If this is provided on update, it must match the server's etag.
     *
     * Generated from protobuf field <code>string etag = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Optional. The description of the policy binding. Must be less than or equal
     * to 63 characters.
     *
     * Generated from protobuf field <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. The description of the policy binding. Must be less than or equal
     * to 63 characters.
     *
     * Generated from protobuf field <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. User-defined annotations. See
     * https://google.aip.dev/148#annotations for more details such as format and
     * size limitations
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Optional. User-defined annotations. See
     * https://google.aip.dev/148#annotations for more details such as format and
     * size limitations
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Required. Immutable. Target is the full resource name of the resource to
     * which the policy will be bound. Immutable once set.
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding.Target target = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Iam\V3\PolicyBinding\Target|null
     */
    public function getTarget()
    {
        return $this->target;
    }

    public function hasTarget()
    {
        return isset($this->target);
    }

    public function clearTarget()
    {
        unset($this->target);
    }

    /**
     * Required. Immutable. Target is the full resource name of the resource to
     * which the policy will be bound. Immutable once set.
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding.Target target = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Iam\V3\PolicyBinding\Target $var
     * @return $this
     */
    public function setTarget($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Iam\V3\PolicyBinding\Target::class);
        $this->target = $var;

        return $this;
    }

    /**
     * Immutable. The kind of the policy to attach in this binding. This field
     * must be one of the following:
     * - Left empty (will be automatically set to the policy kind)
     * - The input policy kind
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding.PolicyKind policy_kind = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getPolicyKind()
    {
        return $this->policy_kind;
    }

    /**
     * Immutable. The kind of the policy to attach in this binding. This field
     * must be one of the following:
     * - Left empty (will be automatically set to the policy kind)
     * - The input policy kind
     *
     * Generated from protobuf field <code>.google.iam.v3.PolicyBinding.PolicyKind policy_kind = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setPolicyKind($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Iam\V3\PolicyBinding\PolicyKind::class);
        $this->policy_kind = $var;

        return $this;
    }

    /**
     * Required. Immutable. The resource name of the policy to be bound. The
     * binding parent and policy must belong to the same organization.
     *
     * Generated from protobuf field <code>string policy = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPolicy()
    {
        return $this->policy;
    }

    /**
     * Required. Immutable. The resource name of the policy to be bound. The
     * binding parent and policy must belong to the same organization.
     *
     * Generated from protobuf field <code>string policy = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->policy = $var;

        return $this;
    }

    /**
     * Output only. The globally unique ID of the policy to be bound.
     *
     * Generated from protobuf field <code>string policy_uid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPolicyUid()
    {
        return $this->policy_uid;
    }

    /**
     * Output only. The globally unique ID of the policy to be bound.
     *
     * Generated from protobuf field <code>string policy_uid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPolicyUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->policy_uid = $var;

        return $this;
    }

    /**
     * Optional. The condition to apply to the policy binding. When set, the
     * `expression` field in the `Expr` must include from 1 to 10 subexpressions,
     * joined by the
     * "||"(Logical OR), "&&"(Logical AND) or "!"(Logical NOT) operators and
     * cannot contain more than 250 characters.
     * The condition is currently only supported when bound to policies of kind
     * principal access boundary.
     * When the bound policy is a principal access boundary policy, the only
     * supported attributes in any subexpression are `principal.type` and
     * `principal.subject`. An example expression is: "principal.type ==
     * 'iam.googleapis.com/ServiceAccount'" or "principal.subject ==
     * 'bob&#64;example.com'".
     * Allowed operations for `principal.subject`:
     * - `principal.subject == <principal subject string>`
     * - `principal.subject != <principal subject string>`
     * - `principal.subject in [<list of principal subjects>]`
     * - `principal.subject.startsWith(<string>)`
     * - `principal.subject.endsWith(<string>)`
     * Allowed operations for `principal.type`:
     * - `principal.type == <principal type string>`
     * - `principal.type != <principal type string>`
     * - `principal.type in [<list of principal types>]`
     * Supported principal types are Workspace, Workforce Pool, Workload Pool and
     * Service Account. Allowed string must be one of:
     * - iam.googleapis.com/WorkspaceIdentity
     * - iam.googleapis.com/WorkforcePoolIdentity
     * - iam.googleapis.com/WorkloadPoolIdentity
     * - iam.googleapis.com/ServiceAccount
     *
     * Generated from protobuf field <code>.google.type.Expr condition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\Expr|null
     */
    public function getCondition()
    {
        return $this->condition;
    }

    public function hasCondition()
    {
        return isset($this->condition);
    }

    public function clearCondition()
    {
        unset($this->condition);
    }

    /**
     * Optional. The condition to apply to the policy binding. When set, the
     * `expression` field in the `Expr` must include from 1 to 10 subexpressions,
     * joined by the
     * "||"(Logical OR), "&&"(Logical AND) or "!"(Logical NOT) operators and
     * cannot contain more than 250 characters.
     * The condition is currently only supported when bound to policies of kind
     * principal access boundary.
     * When the bound policy is a principal access boundary policy, the only
     * supported attributes in any subexpression are `principal.type` and
     * `principal.subject`. An example expression is: "principal.type ==
     * 'iam.googleapis.com/ServiceAccount'" or "principal.subject ==
     * 'bob&#64;example.com'".
     * Allowed operations for `principal.subject`:
     * - `principal.subject == <principal subject string>`
     * - `principal.subject != <principal subject string>`
     * - `principal.subject in [<list of principal subjects>]`
     * - `principal.subject.startsWith(<string>)`
     * - `principal.subject.endsWith(<string>)`
     * Allowed operations for `principal.type`:
     * - `principal.type == <principal type string>`
     * - `principal.type != <principal type string>`
     * - `principal.type in [<list of principal types>]`
     * Supported principal types are Workspace, Workforce Pool, Workload Pool and
     * Service Account. Allowed string must be one of:
     * - iam.googleapis.com/WorkspaceIdentity
     * - iam.googleapis.com/WorkforcePoolIdentity
     * - iam.googleapis.com/WorkloadPoolIdentity
     * - iam.googleapis.com/ServiceAccount
     *
     * Generated from protobuf field <code>.google.type.Expr condition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\Expr $var
     * @return $this
     */
    public function setCondition($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Expr::class);
        $this->condition = $var;

        return $this;
    }

    /**
     * Output only. The time when the policy binding was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the policy binding was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the policy binding was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the policy binding was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

}

