<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/search_service.proto

namespace Google\Cloud\DiscoveryEngine\V1\SearchRequest;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specification for crowding. Crowding improves the diversity of search
 * results by limiting the number of results that share the same field value.
 * For example, crowding on the color field with a max_count of 3 and mode
 * DROP_CROWDED_RESULTS will return at most 3 results with the same color
 * across all pages.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.SearchRequest.CrowdingSpec</code>
 */
class CrowdingSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * The field to use for crowding. Documents can be crowded by a field in the
     * [Document][google.cloud.discoveryengine.v1.Document] object. Crowding
     * field is case sensitive.
     *
     * Generated from protobuf field <code>string field = 1;</code>
     */
    protected $field = '';
    /**
     * The maximum number of documents to keep per value of the field. Once
     * there are at least max_count previous results which contain the same
     * value for the given field (according to the order specified in
     * `order_by`), later results with the same value are "crowded away".
     * If not specified, the default value is 1.
     *
     * Generated from protobuf field <code>int32 max_count = 2;</code>
     */
    protected $max_count = 0;
    /**
     * Mode to use for documents that are crowded away.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.CrowdingSpec.Mode mode = 3;</code>
     */
    protected $mode = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $field
     *           The field to use for crowding. Documents can be crowded by a field in the
     *           [Document][google.cloud.discoveryengine.v1.Document] object. Crowding
     *           field is case sensitive.
     *     @type int $max_count
     *           The maximum number of documents to keep per value of the field. Once
     *           there are at least max_count previous results which contain the same
     *           value for the given field (according to the order specified in
     *           `order_by`), later results with the same value are "crowded away".
     *           If not specified, the default value is 1.
     *     @type int $mode
     *           Mode to use for documents that are crowded away.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * The field to use for crowding. Documents can be crowded by a field in the
     * [Document][google.cloud.discoveryengine.v1.Document] object. Crowding
     * field is case sensitive.
     *
     * Generated from protobuf field <code>string field = 1;</code>
     * @return string
     */
    public function getField()
    {
        return $this->field;
    }

    /**
     * The field to use for crowding. Documents can be crowded by a field in the
     * [Document][google.cloud.discoveryengine.v1.Document] object. Crowding
     * field is case sensitive.
     *
     * Generated from protobuf field <code>string field = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setField($var)
    {
        GPBUtil::checkString($var, True);
        $this->field = $var;

        return $this;
    }

    /**
     * The maximum number of documents to keep per value of the field. Once
     * there are at least max_count previous results which contain the same
     * value for the given field (according to the order specified in
     * `order_by`), later results with the same value are "crowded away".
     * If not specified, the default value is 1.
     *
     * Generated from protobuf field <code>int32 max_count = 2;</code>
     * @return int
     */
    public function getMaxCount()
    {
        return $this->max_count;
    }

    /**
     * The maximum number of documents to keep per value of the field. Once
     * there are at least max_count previous results which contain the same
     * value for the given field (according to the order specified in
     * `order_by`), later results with the same value are "crowded away".
     * If not specified, the default value is 1.
     *
     * Generated from protobuf field <code>int32 max_count = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_count = $var;

        return $this;
    }

    /**
     * Mode to use for documents that are crowded away.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.CrowdingSpec.Mode mode = 3;</code>
     * @return int
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * Mode to use for documents that are crowded away.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.CrowdingSpec.Mode mode = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\CrowdingSpec\Mode::class);
        $this->mode = $var;

        return $this;
    }

}


