<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/search_service.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
 * method.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.SearchRequest</code>
 */
class SearchRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     *
     * Generated from protobuf field <code>string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $serving_config = '';
    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     */
    protected $branch = '';
    /**
     * Raw search query.
     *
     * Generated from protobuf field <code>string query = 3;</code>
     */
    protected $query = '';
    /**
     * Optional. The categories associated with a category page. Must be set for
     * category navigation queries to achieve good search quality. The format
     * should be the same as
     * [PageInfo.page_category][google.cloud.discoveryengine.v1.PageInfo.page_category].
     * This field is the equivalent of the query for browse (navigation) queries.
     * It's used by the browse model when the query is empty.
     * If the field is empty, it will not be used by the browse model.
     * If the field contains more than one element, only the first element will
     * be used.
     * To represent full path of a category, use '>' character to separate
     * different hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * For example, `Graphics Cards > RTX>4090 > Founders Edition` where "RTX >
     * 4090" represents one level, can be rewritten as `Graphics Cards > RTX_4090
     * > Founders Edition`
     *
     * Generated from protobuf field <code>repeated string page_categories = 63 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $page_categories;
    /**
     * Raw image query.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.ImageQuery image_query = 19;</code>
     */
    protected $image_query = null;
    /**
     * Maximum number of [Document][google.cloud.discoveryengine.v1.Document]s to
     * return. The maximum allowed value depends on the data type. Values above
     * the maximum value are coerced to the maximum value.
     * * Websites with basic indexing: Default `10`, Maximum `25`.
     * * Websites with advanced indexing: Default `25`, Maximum `50`.
     * * Other: Default `50`, Maximum `100`.
     * If this field is negative, an  `INVALID_ARGUMENT` is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 4;</code>
     */
    protected $page_size = 0;
    /**
     * A page token received from a previous
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     *  `INVALID_ARGUMENT`  error is returned.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     */
    protected $page_token = '';
    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the
     * [Document][google.cloud.discoveryengine.v1.Document]s deemed by the API as
     * relevant) in search results. This field is only considered if
     * [page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token] is
     * unset.
     * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
     * A large offset may be capped to a reasonable threshold.
     *
     * Generated from protobuf field <code>int32 offset = 6;</code>
     */
    protected $offset = 0;
    /**
     * The maximum number of results to return for OneBox.
     * This applies to each OneBox type individually.
     * Default number is 10.
     *
     * Generated from protobuf field <code>int32 one_box_page_size = 47;</code>
     */
    protected $one_box_page_size = 0;
    /**
     * Specifications that define the specific
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]s to be searched,
     * along with configurations for those data stores. This is only considered
     * for [Engine][google.cloud.discoveryengine.v1.Engine]s with multiple data
     * stores. For engines with a single data store, the specs directly under
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] should be
     * used.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.DataStoreSpec data_store_specs = 32;</code>
     */
    private $data_store_specs;
    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered. Filter
     * expression is case-sensitive.
     * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
     * Filtering in Vertex AI Search is done by mapping the LHS filter key to a
     * key property defined in the Vertex AI Search backend -- this mapping is
     * defined by the customer in their schema. For example a media customer might
     * have a field 'name' in their schema. In this case the filter would look
     * like this: filter --> name:'ANY("king kong")'
     * For more information about filtering including syntax and filter
     * operators, see
     * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     *
     * Generated from protobuf field <code>string filter = 7;</code>
     */
    protected $filter = '';
    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
     *
     * Generated from protobuf field <code>string canonical_filter = 29;</code>
     */
    protected $canonical_filter = '';
    /**
     * The order in which documents are returned. Documents can be ordered by
     * a field in an [Document][google.cloud.discoveryengine.v1.Document] object.
     * Leave it unset if ordered by relevance. `order_by` expression is
     * case-sensitive.
     * For more information on ordering the website search results, see
     * [Order web search
     * results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
     * For more information on ordering the healthcare search results, see
     * [Order healthcare search
     * results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
     * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
     *
     * Generated from protobuf field <code>string order_by = 8;</code>
     */
    protected $order_by = '';
    /**
     * Information about the end user.
     * Highly recommended for analytics and personalization.
     * [UserInfo.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * is used to deduce `device_type` for analytics.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 21;</code>
     */
    protected $user_info = null;
    /**
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Standard
     * fields](https://cloud.google.com/apis/design/standard_fields). This field
     * helps to better interpret the query. If a value isn't specified, the query
     * language code is automatically detected, which may not be accurate.
     *
     * Generated from protobuf field <code>string language_code = 35;</code>
     */
    protected $language_code = '';
    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.FacetSpec facet_specs = 9;</code>
     */
    private $facet_specs;
    /**
     * Boost specification to boost certain documents.
     * For more information on boosting, see
     * [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.BoostSpec boost_spec = 10;</code>
     */
    protected $boost_spec = null;
    /**
     * Additional search parameters.
     * For public website search only, supported values are:
     * * `user_country_code`: string. Default empty. If set to non-empty, results
     *    are restricted or boosted based on the location provided.
     *    For example, `user_country_code: "au"`
     *    For available codes see [Country
     *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
     * * `search_type`: double. Default empty. Enables non-webpage searching
     *    depending on the value. The only valid non-default value is 1,
     *    which enables image searching.
     *    For example, `search_type: 1`
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> params = 11;</code>
     */
    private $params;
    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;</code>
     */
    protected $query_expansion_spec = null;
    /**
     * The spell correction specification that specifies the mode under
     * which spell correction takes effect.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;</code>
     */
    protected $spell_correction_spec = null;
    /**
     * Optional. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This field should NOT have a fixed value such as `unknown_visitor`.
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * and
     * [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1.CompleteQueryRequest.user_pseudo_id]
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
     *
     * Generated from protobuf field <code>string user_pseudo_id = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user_pseudo_id = '';
    /**
     * A specification for configuring the behavior of content search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec content_search_spec = 24;</code>
     */
    protected $content_search_spec = null;
    /**
     * Optional. The ranking expression controls the customized ranking on
     * retrieval documents. This overrides
     * [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1.ServingConfig.ranking_expression].
     * The syntax and supported features depend on the
     * `ranking_expression_backend` value. If `ranking_expression_backend` is not
     * provided, it defaults to `RANK_BY_EMBEDDING`.
     * If
     * [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     * is not provided or set to `RANK_BY_EMBEDDING`, it should be a single
     * function or multiple functions that are joined by "+".
     *   * ranking_expression = function, { " + ", function };
     * Supported functions:
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     * Function variables:
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between `embedding_field_path` and
     *   query embedding vector.
     *  Example ranking expression:
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * If
     * [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     * is set to `RANK_BY_FORMULA`, the following expression types (and
     * combinations of those chained using + or
     * * operators) are supported:
     *   * `double`
     *   * `signal`
     *   * `log(signal)`
     *   * `exp(signal)`
     *   * `rr(signal, double > 0)`  -- reciprocal rank transformation with second
     *   argument being a denominator constant.
     *   * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise.
     *   * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns
     *   signal2 | double, else returns signal1.
     *   Here are a few examples of ranking formulas that use the supported
     *   ranking expression types:
     *   - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)`
     *   -- mostly rank by the logarithm of `keyword_similarity_score` with slight
     *   `semantic_smilarity_score` adjustment.
     *   - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
     *   is_nan(keyword_similarity_score)` -- rank by the exponent of
     *   `semantic_similarity_score` filling the value with 0 if it's NaN, also
     *   add constant 0.3 adjustment to the final score if
     *   `semantic_similarity_score` is NaN.
     *   - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
     *   rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank
     *   of `keyword_similarity_score` with slight adjustment of reciprocal rank
     *   of `semantic_smilarity_score`.
     * The following signals are supported:
     *   * `semantic_similarity_score`: semantic similarity adjustment that is
     *   calculated using the embeddings generated by a proprietary Google model.
     *   This score determines how semantically similar a search query is to a
     *   document.
     *   * `keyword_similarity_score`: keyword match adjustment uses the Best
     *   Match 25 (BM25) ranking function. This score is calculated using a
     *   probabilistic model to estimate the probability that a document is
     *   relevant to a given query.
     *   * `relevance_score`: semantic relevance adjustment that uses a
     *   proprietary Google model to determine the meaning and intent behind a
     *   user's query in context with the content in the documents.
     *   * `pctr_rank`: predicted conversion rate adjustment as a rank use
     *   predicted Click-through rate (pCTR) to gauge the relevance and
     *   attractiveness of a search result from a user's perspective. A higher
     *   pCTR suggests that the result is more likely to satisfy the user's query
     *   and intent, making it a valuable signal for ranking.
     *   * `freshness_rank`: freshness adjustment as a rank
     *   * `document_age`: The time in hours elapsed since the document was last
     *   updated, a floating-point number (e.g., 0.25 means 15 minutes).
     *   * `topicality_rank`: topicality adjustment as a rank. Uses proprietary
     *   Google model to determine the keyword-based overlap between the query and
     *   the document.
     *   * `base_rank`: the default rank of the result
     *
     * Generated from protobuf field <code>string ranking_expression = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ranking_expression = '';
    /**
     * Optional. The backend to use for the ranking expression evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RankingExpressionBackend ranking_expression_backend = 53 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ranking_expression_backend = 0;
    /**
     * Whether to turn on safe search. This is only supported for
     * website search.
     *
     * Generated from protobuf field <code>bool safe_search = 20;</code>
     */
    protected $safe_search = false;
    /**
     * The user labels applied to a resource must meet the following requirements:
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 22;</code>
     */
    private $user_labels;
    /**
     * Optional. Config for natural language query understanding capabilities,
     * such as extracting structured field filters from the query. Refer to [this
     * documentation](https://cloud.google.com/generative-ai-app-builder/docs/natural-language-queries)
     * for more information.
     * If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
     * natural language query understanding will be done.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $natural_language_query_understanding_spec = null;
    /**
     * Search as you type configuration. Only supported for the
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SearchAsYouTypeSpec search_as_you_type_spec = 31;</code>
     */
    protected $search_as_you_type_spec = null;
    /**
     * Optional. Config for display feature, like match highlighting on search
     * results.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.DisplaySpec display_spec = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_spec = null;
    /**
     * Optional. Crowding specifications for improving result diversity.
     * If multiple CrowdingSpecs are specified, crowding will be evaluated on
     * each unique combination of the `field` values, and max_count will be the
     * maximum value of `max_count` across all CrowdingSpecs.
     * For example, if the first CrowdingSpec has `field` = "color" and
     * `max_count` = 3, and the second CrowdingSpec has `field` = "size" and
     * `max_count` = 2, then after 3 documents that share the same color AND size
     * have been returned, subsequent ones should be
     * removed or demoted.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.CrowdingSpec crowding_specs = 40 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $crowding_specs;
    /**
     * The session resource name. Optional.
     * Session allows users to do multi-turn /search API calls or coordination
     * between /search API calls and /answer API calls.
     * Example #1 (multi-turn /search API calls):
     *   Call /search API with the session ID generated in the first call.
     *   Here, the previous search query gets considered in query
     *   standing. I.e., if the first query is "How did Alphabet do in 2022?"
     *   and the current query is "How about 2023?", the current query will
     *   be interpreted as "How did Alphabet do in 2023?".
     * Example #2 (coordination between /search API calls and /answer API calls):
     *   Call /answer API with the session ID generated in the first call.
     *   Here, the answer generation happens in the context of the search
     *   results from the first search call.
     * Multi-turn Search feature is currently at private GA stage. Please use
     * v1alpha or v1beta version instead before we launch this feature to public
     * GA. Or ask for allowlisting through Google Support team.
     *
     * Generated from protobuf field <code>string session = 41 [(.google.api.resource_reference) = {</code>
     */
    protected $session = '';
    /**
     * Session specification.
     * Can be used only when `session` is set.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SessionSpec session_spec = 42;</code>
     */
    protected $session_spec = null;
    /**
     * The global relevance threshold of the search results.
     * Defaults to Google defined threshold, leveraging a balance of
     * precision and recall to deliver both highly accurate results and
     * comprehensive coverage of relevant information.
     * If more granular relevance filtering is required, use the
     * `relevance_filter_spec` instead.
     * This feature is not supported for healthcare search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RelevanceThreshold relevance_threshold = 44;</code>
     */
    protected $relevance_threshold = 0;
    /**
     * Optional. The specification for returning the relevance score.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RelevanceScoreSpec relevance_score_spec = 52 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $relevance_score_spec = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $serving_config
     *           Required. The resource name of the Search serving config, such as
     *           `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     *           or
     *           `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     *           This field is used to identify the serving configuration name, set
     *           of models used to make the search.
     *     @type string $branch
     *           The branch resource name, such as
     *           `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     *           Use `default_branch` as the branch ID or leave this field empty, to search
     *           documents under the default branch.
     *     @type string $query
     *           Raw search query.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $page_categories
     *           Optional. The categories associated with a category page. Must be set for
     *           category navigation queries to achieve good search quality. The format
     *           should be the same as
     *           [PageInfo.page_category][google.cloud.discoveryengine.v1.PageInfo.page_category].
     *           This field is the equivalent of the query for browse (navigation) queries.
     *           It's used by the browse model when the query is empty.
     *           If the field is empty, it will not be used by the browse model.
     *           If the field contains more than one element, only the first element will
     *           be used.
     *           To represent full path of a category, use '>' character to separate
     *           different hierarchies. If '>' is part of the category name, replace it with
     *           other character(s).
     *           For example, `Graphics Cards > RTX>4090 > Founders Edition` where "RTX >
     *           4090" represents one level, can be rewritten as `Graphics Cards > RTX_4090
     *           > Founders Edition`
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ImageQuery $image_query
     *           Raw image query.
     *     @type int $page_size
     *           Maximum number of [Document][google.cloud.discoveryengine.v1.Document]s to
     *           return. The maximum allowed value depends on the data type. Values above
     *           the maximum value are coerced to the maximum value.
     *           * Websites with basic indexing: Default `10`, Maximum `25`.
     *           * Websites with advanced indexing: Default `25`, Maximum `50`.
     *           * Other: Default `50`, Maximum `100`.
     *           If this field is negative, an  `INVALID_ARGUMENT` is returned.
     *     @type string $page_token
     *           A page token received from a previous
     *           [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     *           call. Provide this to retrieve the subsequent page.
     *           When paginating, all other parameters provided to
     *           [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     *           must match the call that provided the page token. Otherwise, an
     *            `INVALID_ARGUMENT`  error is returned.
     *     @type int $offset
     *           A 0-indexed integer that specifies the current offset (that is, starting
     *           result location, amongst the
     *           [Document][google.cloud.discoveryengine.v1.Document]s deemed by the API as
     *           relevant) in search results. This field is only considered if
     *           [page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token] is
     *           unset.
     *           If this field is negative, an  `INVALID_ARGUMENT`  is returned.
     *           A large offset may be capped to a reasonable threshold.
     *     @type int $one_box_page_size
     *           The maximum number of results to return for OneBox.
     *           This applies to each OneBox type individually.
     *           Default number is 10.
     *     @type array<\Google\Cloud\DiscoveryEngine\V1\SearchRequest\DataStoreSpec>|\Google\Protobuf\Internal\RepeatedField $data_store_specs
     *           Specifications that define the specific
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore]s to be searched,
     *           along with configurations for those data stores. This is only considered
     *           for [Engine][google.cloud.discoveryengine.v1.Engine]s with multiple data
     *           stores. For engines with a single data store, the specs directly under
     *           [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] should be
     *           used.
     *     @type string $filter
     *           The filter syntax consists of an expression language for constructing a
     *           predicate from one or more fields of the documents being filtered. Filter
     *           expression is case-sensitive.
     *           If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
     *           Filtering in Vertex AI Search is done by mapping the LHS filter key to a
     *           key property defined in the Vertex AI Search backend -- this mapping is
     *           defined by the customer in their schema. For example a media customer might
     *           have a field 'name' in their schema. In this case the filter would look
     *           like this: filter --> name:'ANY("king kong")'
     *           For more information about filtering including syntax and filter
     *           operators, see
     *           [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     *     @type string $canonical_filter
     *           The default filter that is applied when a user performs a search without
     *           checking any filters on the search page.
     *           The filter applied to every search request when quality improvement such as
     *           query expansion is needed. In the case a query does not have a sufficient
     *           amount of results this filter will be used to determine whether or not to
     *           enable the query expansion flow. The original filter will still be used for
     *           the query expanded search.
     *           This field is strongly recommended to achieve high search quality.
     *           For more information about filter syntax, see
     *           [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
     *     @type string $order_by
     *           The order in which documents are returned. Documents can be ordered by
     *           a field in an [Document][google.cloud.discoveryengine.v1.Document] object.
     *           Leave it unset if ordered by relevance. `order_by` expression is
     *           case-sensitive.
     *           For more information on ordering the website search results, see
     *           [Order web search
     *           results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
     *           For more information on ordering the healthcare search results, see
     *           [Order healthcare search
     *           results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
     *           If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
     *     @type \Google\Cloud\DiscoveryEngine\V1\UserInfo $user_info
     *           Information about the end user.
     *           Highly recommended for analytics and personalization.
     *           [UserInfo.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     *           is used to deduce `device_type` for analytics.
     *     @type string $language_code
     *           The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     *           information, see [Standard
     *           fields](https://cloud.google.com/apis/design/standard_fields). This field
     *           helps to better interpret the query. If a value isn't specified, the query
     *           language code is automatically detected, which may not be accurate.
     *     @type array<\Google\Cloud\DiscoveryEngine\V1\SearchRequest\FacetSpec>|\Google\Protobuf\Internal\RepeatedField $facet_specs
     *           Facet specifications for faceted search. If empty, no facets are returned.
     *           A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     *           error is returned.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\BoostSpec $boost_spec
     *           Boost specification to boost certain documents.
     *           For more information on boosting, see
     *           [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
     *     @type array|\Google\Protobuf\Internal\MapField $params
     *           Additional search parameters.
     *           For public website search only, supported values are:
     *           * `user_country_code`: string. Default empty. If set to non-empty, results
     *              are restricted or boosted based on the location provided.
     *              For example, `user_country_code: "au"`
     *              For available codes see [Country
     *              Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
     *           * `search_type`: double. Default empty. Enables non-webpage searching
     *              depending on the value. The only valid non-default value is 1,
     *              which enables image searching.
     *              For example, `search_type: 1`
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\QueryExpansionSpec $query_expansion_spec
     *           The query expansion specification that specifies the conditions under which
     *           query expansion occurs.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SpellCorrectionSpec $spell_correction_spec
     *           The spell correction specification that specifies the mode under
     *           which spell correction takes effect.
     *     @type string $user_pseudo_id
     *           Optional. A unique identifier for tracking visitors. For example, this
     *           could be implemented with an HTTP cookie, which should be able to uniquely
     *           identify a visitor on a single device. This unique identifier should not
     *           change if the visitor logs in or out of the website.
     *           This field should NOT have a fixed value such as `unknown_visitor`.
     *           This should be the same identifier as
     *           [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     *           and
     *           [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1.CompleteQueryRequest.user_pseudo_id]
     *           The field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ContentSearchSpec $content_search_spec
     *           A specification for configuring the behavior of content search.
     *     @type string $ranking_expression
     *           Optional. The ranking expression controls the customized ranking on
     *           retrieval documents. This overrides
     *           [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1.ServingConfig.ranking_expression].
     *           The syntax and supported features depend on the
     *           `ranking_expression_backend` value. If `ranking_expression_backend` is not
     *           provided, it defaults to `RANK_BY_EMBEDDING`.
     *           If
     *           [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     *           is not provided or set to `RANK_BY_EMBEDDING`, it should be a single
     *           function or multiple functions that are joined by "+".
     *             * ranking_expression = function, { " + ", function };
     *           Supported functions:
     *             * double * relevance_score
     *             * double * dotProduct(embedding_field_path)
     *           Function variables:
     *             * `relevance_score`: pre-defined keywords, used for measure relevance
     *             between query and document.
     *             * `embedding_field_path`: the document embedding field
     *             used with query embedding vector.
     *             * `dotProduct`: embedding function between `embedding_field_path` and
     *             query embedding vector.
     *            Example ranking expression:
     *              If document has an embedding field doc_embedding, the ranking expression
     *              could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     *           If
     *           [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     *           is set to `RANK_BY_FORMULA`, the following expression types (and
     *           combinations of those chained using + or
     *           * operators) are supported:
     *             * `double`
     *             * `signal`
     *             * `log(signal)`
     *             * `exp(signal)`
     *             * `rr(signal, double > 0)`  -- reciprocal rank transformation with second
     *             argument being a denominator constant.
     *             * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise.
     *             * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns
     *             signal2 | double, else returns signal1.
     *             Here are a few examples of ranking formulas that use the supported
     *             ranking expression types:
     *             - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)`
     *             -- mostly rank by the logarithm of `keyword_similarity_score` with slight
     *             `semantic_smilarity_score` adjustment.
     *             - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
     *             is_nan(keyword_similarity_score)` -- rank by the exponent of
     *             `semantic_similarity_score` filling the value with 0 if it's NaN, also
     *             add constant 0.3 adjustment to the final score if
     *             `semantic_similarity_score` is NaN.
     *             - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
     *             rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank
     *             of `keyword_similarity_score` with slight adjustment of reciprocal rank
     *             of `semantic_smilarity_score`.
     *           The following signals are supported:
     *             * `semantic_similarity_score`: semantic similarity adjustment that is
     *             calculated using the embeddings generated by a proprietary Google model.
     *             This score determines how semantically similar a search query is to a
     *             document.
     *             * `keyword_similarity_score`: keyword match adjustment uses the Best
     *             Match 25 (BM25) ranking function. This score is calculated using a
     *             probabilistic model to estimate the probability that a document is
     *             relevant to a given query.
     *             * `relevance_score`: semantic relevance adjustment that uses a
     *             proprietary Google model to determine the meaning and intent behind a
     *             user's query in context with the content in the documents.
     *             * `pctr_rank`: predicted conversion rate adjustment as a rank use
     *             predicted Click-through rate (pCTR) to gauge the relevance and
     *             attractiveness of a search result from a user's perspective. A higher
     *             pCTR suggests that the result is more likely to satisfy the user's query
     *             and intent, making it a valuable signal for ranking.
     *             * `freshness_rank`: freshness adjustment as a rank
     *             * `document_age`: The time in hours elapsed since the document was last
     *             updated, a floating-point number (e.g., 0.25 means 15 minutes).
     *             * `topicality_rank`: topicality adjustment as a rank. Uses proprietary
     *             Google model to determine the keyword-based overlap between the query and
     *             the document.
     *             * `base_rank`: the default rank of the result
     *     @type int $ranking_expression_backend
     *           Optional. The backend to use for the ranking expression evaluation.
     *     @type bool $safe_search
     *           Whether to turn on safe search. This is only supported for
     *           website search.
     *     @type array|\Google\Protobuf\Internal\MapField $user_labels
     *           The user labels applied to a resource must meet the following requirements:
     *           * Each resource can have multiple labels, up to a maximum of 64.
     *           * Each label must be a key-value pair.
     *           * Keys have a minimum length of 1 character and a maximum length of 63
     *             characters and cannot be empty. Values can be empty and have a maximum
     *             length of 63 characters.
     *           * Keys and values can contain only lowercase letters, numeric characters,
     *             underscores, and dashes. All characters must use UTF-8 encoding, and
     *             international characters are allowed.
     *           * The key portion of a label must be unique. However, you can use the same
     *             key with multiple resources.
     *           * Keys must start with a lowercase letter or international character.
     *           See [Google Cloud
     *           Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     *           for more details.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\NaturalLanguageQueryUnderstandingSpec $natural_language_query_understanding_spec
     *           Optional. Config for natural language query understanding capabilities,
     *           such as extracting structured field filters from the query. Refer to [this
     *           documentation](https://cloud.google.com/generative-ai-app-builder/docs/natural-language-queries)
     *           for more information.
     *           If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
     *           natural language query understanding will be done.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SearchAsYouTypeSpec $search_as_you_type_spec
     *           Search as you type configuration. Only supported for the
     *           [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     *           vertical.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\DisplaySpec $display_spec
     *           Optional. Config for display feature, like match highlighting on search
     *           results.
     *     @type array<\Google\Cloud\DiscoveryEngine\V1\SearchRequest\CrowdingSpec>|\Google\Protobuf\Internal\RepeatedField $crowding_specs
     *           Optional. Crowding specifications for improving result diversity.
     *           If multiple CrowdingSpecs are specified, crowding will be evaluated on
     *           each unique combination of the `field` values, and max_count will be the
     *           maximum value of `max_count` across all CrowdingSpecs.
     *           For example, if the first CrowdingSpec has `field` = "color" and
     *           `max_count` = 3, and the second CrowdingSpec has `field` = "size" and
     *           `max_count` = 2, then after 3 documents that share the same color AND size
     *           have been returned, subsequent ones should be
     *           removed or demoted.
     *     @type string $session
     *           The session resource name. Optional.
     *           Session allows users to do multi-turn /search API calls or coordination
     *           between /search API calls and /answer API calls.
     *           Example #1 (multi-turn /search API calls):
     *             Call /search API with the session ID generated in the first call.
     *             Here, the previous search query gets considered in query
     *             standing. I.e., if the first query is "How did Alphabet do in 2022?"
     *             and the current query is "How about 2023?", the current query will
     *             be interpreted as "How did Alphabet do in 2023?".
     *           Example #2 (coordination between /search API calls and /answer API calls):
     *             Call /answer API with the session ID generated in the first call.
     *             Here, the answer generation happens in the context of the search
     *             results from the first search call.
     *           Multi-turn Search feature is currently at private GA stage. Please use
     *           v1alpha or v1beta version instead before we launch this feature to public
     *           GA. Or ask for allowlisting through Google Support team.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SessionSpec $session_spec
     *           Session specification.
     *           Can be used only when `session` is set.
     *     @type int $relevance_threshold
     *           The global relevance threshold of the search results.
     *           Defaults to Google defined threshold, leveraging a balance of
     *           precision and recall to deliver both highly accurate results and
     *           comprehensive coverage of relevant information.
     *           If more granular relevance filtering is required, use the
     *           `relevance_filter_spec` instead.
     *           This feature is not supported for healthcare search.
     *     @type \Google\Cloud\DiscoveryEngine\V1\SearchRequest\RelevanceScoreSpec $relevance_score_spec
     *           Optional. The specification for returning the relevance score.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     *
     * Generated from protobuf field <code>string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServingConfig()
    {
        return $this->serving_config;
    }

    /**
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     *
     * Generated from protobuf field <code>string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServingConfig($var)
    {
        GPBUtil::checkString($var, True);
        $this->serving_config = $var;

        return $this;
    }

    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBranch()
    {
        return $this->branch;
    }

    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBranch($var)
    {
        GPBUtil::checkString($var, True);
        $this->branch = $var;

        return $this;
    }

    /**
     * Raw search query.
     *
     * Generated from protobuf field <code>string query = 3;</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Raw search query.
     *
     * Generated from protobuf field <code>string query = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Optional. The categories associated with a category page. Must be set for
     * category navigation queries to achieve good search quality. The format
     * should be the same as
     * [PageInfo.page_category][google.cloud.discoveryengine.v1.PageInfo.page_category].
     * This field is the equivalent of the query for browse (navigation) queries.
     * It's used by the browse model when the query is empty.
     * If the field is empty, it will not be used by the browse model.
     * If the field contains more than one element, only the first element will
     * be used.
     * To represent full path of a category, use '>' character to separate
     * different hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * For example, `Graphics Cards > RTX>4090 > Founders Edition` where "RTX >
     * 4090" represents one level, can be rewritten as `Graphics Cards > RTX_4090
     * > Founders Edition`
     *
     * Generated from protobuf field <code>repeated string page_categories = 63 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPageCategories()
    {
        return $this->page_categories;
    }

    /**
     * Optional. The categories associated with a category page. Must be set for
     * category navigation queries to achieve good search quality. The format
     * should be the same as
     * [PageInfo.page_category][google.cloud.discoveryengine.v1.PageInfo.page_category].
     * This field is the equivalent of the query for browse (navigation) queries.
     * It's used by the browse model when the query is empty.
     * If the field is empty, it will not be used by the browse model.
     * If the field contains more than one element, only the first element will
     * be used.
     * To represent full path of a category, use '>' character to separate
     * different hierarchies. If '>' is part of the category name, replace it with
     * other character(s).
     * For example, `Graphics Cards > RTX>4090 > Founders Edition` where "RTX >
     * 4090" represents one level, can be rewritten as `Graphics Cards > RTX_4090
     * > Founders Edition`
     *
     * Generated from protobuf field <code>repeated string page_categories = 63 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPageCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->page_categories = $arr;

        return $this;
    }

    /**
     * Raw image query.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.ImageQuery image_query = 19;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ImageQuery|null
     */
    public function getImageQuery()
    {
        return $this->image_query;
    }

    public function hasImageQuery()
    {
        return isset($this->image_query);
    }

    public function clearImageQuery()
    {
        unset($this->image_query);
    }

    /**
     * Raw image query.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.ImageQuery image_query = 19;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ImageQuery $var
     * @return $this
     */
    public function setImageQuery($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ImageQuery::class);
        $this->image_query = $var;

        return $this;
    }

    /**
     * Maximum number of [Document][google.cloud.discoveryengine.v1.Document]s to
     * return. The maximum allowed value depends on the data type. Values above
     * the maximum value are coerced to the maximum value.
     * * Websites with basic indexing: Default `10`, Maximum `25`.
     * * Websites with advanced indexing: Default `25`, Maximum `50`.
     * * Other: Default `50`, Maximum `100`.
     * If this field is negative, an  `INVALID_ARGUMENT` is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 4;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Maximum number of [Document][google.cloud.discoveryengine.v1.Document]s to
     * return. The maximum allowed value depends on the data type. Values above
     * the maximum value are coerced to the maximum value.
     * * Websites with basic indexing: Default `10`, Maximum `25`.
     * * Websites with advanced indexing: Default `25`, Maximum `50`.
     * * Other: Default `50`, Maximum `100`.
     * If this field is negative, an  `INVALID_ARGUMENT` is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A page token received from a previous
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     *  `INVALID_ARGUMENT`  error is returned.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A page token received from a previous
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     *  `INVALID_ARGUMENT`  error is returned.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the
     * [Document][google.cloud.discoveryengine.v1.Document]s deemed by the API as
     * relevant) in search results. This field is only considered if
     * [page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token] is
     * unset.
     * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
     * A large offset may be capped to a reasonable threshold.
     *
     * Generated from protobuf field <code>int32 offset = 6;</code>
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the
     * [Document][google.cloud.discoveryengine.v1.Document]s deemed by the API as
     * relevant) in search results. This field is only considered if
     * [page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token] is
     * unset.
     * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
     * A large offset may be capped to a reasonable threshold.
     *
     * Generated from protobuf field <code>int32 offset = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setOffset($var)
    {
        GPBUtil::checkInt32($var);
        $this->offset = $var;

        return $this;
    }

    /**
     * The maximum number of results to return for OneBox.
     * This applies to each OneBox type individually.
     * Default number is 10.
     *
     * Generated from protobuf field <code>int32 one_box_page_size = 47;</code>
     * @return int
     */
    public function getOneBoxPageSize()
    {
        return $this->one_box_page_size;
    }

    /**
     * The maximum number of results to return for OneBox.
     * This applies to each OneBox type individually.
     * Default number is 10.
     *
     * Generated from protobuf field <code>int32 one_box_page_size = 47;</code>
     * @param int $var
     * @return $this
     */
    public function setOneBoxPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->one_box_page_size = $var;

        return $this;
    }

    /**
     * Specifications that define the specific
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]s to be searched,
     * along with configurations for those data stores. This is only considered
     * for [Engine][google.cloud.discoveryengine.v1.Engine]s with multiple data
     * stores. For engines with a single data store, the specs directly under
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] should be
     * used.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.DataStoreSpec data_store_specs = 32;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDataStoreSpecs()
    {
        return $this->data_store_specs;
    }

    /**
     * Specifications that define the specific
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]s to be searched,
     * along with configurations for those data stores. This is only considered
     * for [Engine][google.cloud.discoveryengine.v1.Engine]s with multiple data
     * stores. For engines with a single data store, the specs directly under
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] should be
     * used.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.DataStoreSpec data_store_specs = 32;</code>
     * @param array<\Google\Cloud\DiscoveryEngine\V1\SearchRequest\DataStoreSpec>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDataStoreSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\DataStoreSpec::class);
        $this->data_store_specs = $arr;

        return $this;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered. Filter
     * expression is case-sensitive.
     * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
     * Filtering in Vertex AI Search is done by mapping the LHS filter key to a
     * key property defined in the Vertex AI Search backend -- this mapping is
     * defined by the customer in their schema. For example a media customer might
     * have a field 'name' in their schema. In this case the filter would look
     * like this: filter --> name:'ANY("king kong")'
     * For more information about filtering including syntax and filter
     * operators, see
     * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     *
     * Generated from protobuf field <code>string filter = 7;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered. Filter
     * expression is case-sensitive.
     * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
     * Filtering in Vertex AI Search is done by mapping the LHS filter key to a
     * key property defined in the Vertex AI Search backend -- this mapping is
     * defined by the customer in their schema. For example a media customer might
     * have a field 'name' in their schema. In this case the filter would look
     * like this: filter --> name:'ANY("king kong")'
     * For more information about filtering including syntax and filter
     * operators, see
     * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     *
     * Generated from protobuf field <code>string filter = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
     *
     * Generated from protobuf field <code>string canonical_filter = 29;</code>
     * @return string
     */
    public function getCanonicalFilter()
    {
        return $this->canonical_filter;
    }

    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter].
     *
     * Generated from protobuf field <code>string canonical_filter = 29;</code>
     * @param string $var
     * @return $this
     */
    public function setCanonicalFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->canonical_filter = $var;

        return $this;
    }

    /**
     * The order in which documents are returned. Documents can be ordered by
     * a field in an [Document][google.cloud.discoveryengine.v1.Document] object.
     * Leave it unset if ordered by relevance. `order_by` expression is
     * case-sensitive.
     * For more information on ordering the website search results, see
     * [Order web search
     * results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
     * For more information on ordering the healthcare search results, see
     * [Order healthcare search
     * results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
     * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
     *
     * Generated from protobuf field <code>string order_by = 8;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * The order in which documents are returned. Documents can be ordered by
     * a field in an [Document][google.cloud.discoveryengine.v1.Document] object.
     * Leave it unset if ordered by relevance. `order_by` expression is
     * case-sensitive.
     * For more information on ordering the website search results, see
     * [Order web search
     * results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
     * For more information on ordering the healthcare search results, see
     * [Order healthcare search
     * results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
     * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
     *
     * Generated from protobuf field <code>string order_by = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * Information about the end user.
     * Highly recommended for analytics and personalization.
     * [UserInfo.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * is used to deduce `device_type` for analytics.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 21;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->user_info;
    }

    public function hasUserInfo()
    {
        return isset($this->user_info);
    }

    public function clearUserInfo()
    {
        unset($this->user_info);
    }

    /**
     * Information about the end user.
     * Highly recommended for analytics and personalization.
     * [UserInfo.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * is used to deduce `device_type` for analytics.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 21;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\UserInfo $var
     * @return $this
     */
    public function setUserInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\UserInfo::class);
        $this->user_info = $var;

        return $this;
    }

    /**
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Standard
     * fields](https://cloud.google.com/apis/design/standard_fields). This field
     * helps to better interpret the query. If a value isn't specified, the query
     * language code is automatically detected, which may not be accurate.
     *
     * Generated from protobuf field <code>string language_code = 35;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Standard
     * fields](https://cloud.google.com/apis/design/standard_fields). This field
     * helps to better interpret the query. If a value isn't specified, the query
     * language code is automatically detected, which may not be accurate.
     *
     * Generated from protobuf field <code>string language_code = 35;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.FacetSpec facet_specs = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFacetSpecs()
    {
        return $this->facet_specs;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.FacetSpec facet_specs = 9;</code>
     * @param array<\Google\Cloud\DiscoveryEngine\V1\SearchRequest\FacetSpec>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFacetSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\FacetSpec::class);
        $this->facet_specs = $arr;

        return $this;
    }

    /**
     * Boost specification to boost certain documents.
     * For more information on boosting, see
     * [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.BoostSpec boost_spec = 10;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\BoostSpec|null
     */
    public function getBoostSpec()
    {
        return $this->boost_spec;
    }

    public function hasBoostSpec()
    {
        return isset($this->boost_spec);
    }

    public function clearBoostSpec()
    {
        unset($this->boost_spec);
    }

    /**
     * Boost specification to boost certain documents.
     * For more information on boosting, see
     * [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.BoostSpec boost_spec = 10;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\BoostSpec $var
     * @return $this
     */
    public function setBoostSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\BoostSpec::class);
        $this->boost_spec = $var;

        return $this;
    }

    /**
     * Additional search parameters.
     * For public website search only, supported values are:
     * * `user_country_code`: string. Default empty. If set to non-empty, results
     *    are restricted or boosted based on the location provided.
     *    For example, `user_country_code: "au"`
     *    For available codes see [Country
     *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
     * * `search_type`: double. Default empty. Enables non-webpage searching
     *    depending on the value. The only valid non-default value is 1,
     *    which enables image searching.
     *    For example, `search_type: 1`
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> params = 11;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * Additional search parameters.
     * For public website search only, supported values are:
     * * `user_country_code`: string. Default empty. If set to non-empty, results
     *    are restricted or boosted based on the location provided.
     *    For example, `user_country_code: "au"`
     *    For available codes see [Country
     *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
     * * `search_type`: double. Default empty. Enables non-webpage searching
     *    depending on the value. The only valid non-default value is 1,
     *    which enables image searching.
     *    For example, `search_type: 1`
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> params = 11;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParams($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Value::class);
        $this->params = $arr;

        return $this;
    }

    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\QueryExpansionSpec|null
     */
    public function getQueryExpansionSpec()
    {
        return $this->query_expansion_spec;
    }

    public function hasQueryExpansionSpec()
    {
        return isset($this->query_expansion_spec);
    }

    public function clearQueryExpansionSpec()
    {
        unset($this->query_expansion_spec);
    }

    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\QueryExpansionSpec $var
     * @return $this
     */
    public function setQueryExpansionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\QueryExpansionSpec::class);
        $this->query_expansion_spec = $var;

        return $this;
    }

    /**
     * The spell correction specification that specifies the mode under
     * which spell correction takes effect.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SpellCorrectionSpec|null
     */
    public function getSpellCorrectionSpec()
    {
        return $this->spell_correction_spec;
    }

    public function hasSpellCorrectionSpec()
    {
        return isset($this->spell_correction_spec);
    }

    public function clearSpellCorrectionSpec()
    {
        unset($this->spell_correction_spec);
    }

    /**
     * The spell correction specification that specifies the mode under
     * which spell correction takes effect.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SpellCorrectionSpec $var
     * @return $this
     */
    public function setSpellCorrectionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SpellCorrectionSpec::class);
        $this->spell_correction_spec = $var;

        return $this;
    }

    /**
     * Optional. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This field should NOT have a fixed value such as `unknown_visitor`.
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * and
     * [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1.CompleteQueryRequest.user_pseudo_id]
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
     *
     * Generated from protobuf field <code>string user_pseudo_id = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUserPseudoId()
    {
        return $this->user_pseudo_id;
    }

    /**
     * Optional. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This field should NOT have a fixed value such as `unknown_visitor`.
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * and
     * [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1.CompleteQueryRequest.user_pseudo_id]
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
     *
     * Generated from protobuf field <code>string user_pseudo_id = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUserPseudoId($var)
    {
        GPBUtil::checkString($var, True);
        $this->user_pseudo_id = $var;

        return $this;
    }

    /**
     * A specification for configuring the behavior of content search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec content_search_spec = 24;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ContentSearchSpec|null
     */
    public function getContentSearchSpec()
    {
        return $this->content_search_spec;
    }

    public function hasContentSearchSpec()
    {
        return isset($this->content_search_spec);
    }

    public function clearContentSearchSpec()
    {
        unset($this->content_search_spec);
    }

    /**
     * A specification for configuring the behavior of content search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec content_search_spec = 24;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ContentSearchSpec $var
     * @return $this
     */
    public function setContentSearchSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\ContentSearchSpec::class);
        $this->content_search_spec = $var;

        return $this;
    }

    /**
     * Optional. The ranking expression controls the customized ranking on
     * retrieval documents. This overrides
     * [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1.ServingConfig.ranking_expression].
     * The syntax and supported features depend on the
     * `ranking_expression_backend` value. If `ranking_expression_backend` is not
     * provided, it defaults to `RANK_BY_EMBEDDING`.
     * If
     * [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     * is not provided or set to `RANK_BY_EMBEDDING`, it should be a single
     * function or multiple functions that are joined by "+".
     *   * ranking_expression = function, { " + ", function };
     * Supported functions:
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     * Function variables:
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between `embedding_field_path` and
     *   query embedding vector.
     *  Example ranking expression:
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * If
     * [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     * is set to `RANK_BY_FORMULA`, the following expression types (and
     * combinations of those chained using + or
     * * operators) are supported:
     *   * `double`
     *   * `signal`
     *   * `log(signal)`
     *   * `exp(signal)`
     *   * `rr(signal, double > 0)`  -- reciprocal rank transformation with second
     *   argument being a denominator constant.
     *   * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise.
     *   * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns
     *   signal2 | double, else returns signal1.
     *   Here are a few examples of ranking formulas that use the supported
     *   ranking expression types:
     *   - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)`
     *   -- mostly rank by the logarithm of `keyword_similarity_score` with slight
     *   `semantic_smilarity_score` adjustment.
     *   - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
     *   is_nan(keyword_similarity_score)` -- rank by the exponent of
     *   `semantic_similarity_score` filling the value with 0 if it's NaN, also
     *   add constant 0.3 adjustment to the final score if
     *   `semantic_similarity_score` is NaN.
     *   - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
     *   rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank
     *   of `keyword_similarity_score` with slight adjustment of reciprocal rank
     *   of `semantic_smilarity_score`.
     * The following signals are supported:
     *   * `semantic_similarity_score`: semantic similarity adjustment that is
     *   calculated using the embeddings generated by a proprietary Google model.
     *   This score determines how semantically similar a search query is to a
     *   document.
     *   * `keyword_similarity_score`: keyword match adjustment uses the Best
     *   Match 25 (BM25) ranking function. This score is calculated using a
     *   probabilistic model to estimate the probability that a document is
     *   relevant to a given query.
     *   * `relevance_score`: semantic relevance adjustment that uses a
     *   proprietary Google model to determine the meaning and intent behind a
     *   user's query in context with the content in the documents.
     *   * `pctr_rank`: predicted conversion rate adjustment as a rank use
     *   predicted Click-through rate (pCTR) to gauge the relevance and
     *   attractiveness of a search result from a user's perspective. A higher
     *   pCTR suggests that the result is more likely to satisfy the user's query
     *   and intent, making it a valuable signal for ranking.
     *   * `freshness_rank`: freshness adjustment as a rank
     *   * `document_age`: The time in hours elapsed since the document was last
     *   updated, a floating-point number (e.g., 0.25 means 15 minutes).
     *   * `topicality_rank`: topicality adjustment as a rank. Uses proprietary
     *   Google model to determine the keyword-based overlap between the query and
     *   the document.
     *   * `base_rank`: the default rank of the result
     *
     * Generated from protobuf field <code>string ranking_expression = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRankingExpression()
    {
        return $this->ranking_expression;
    }

    /**
     * Optional. The ranking expression controls the customized ranking on
     * retrieval documents. This overrides
     * [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1.ServingConfig.ranking_expression].
     * The syntax and supported features depend on the
     * `ranking_expression_backend` value. If `ranking_expression_backend` is not
     * provided, it defaults to `RANK_BY_EMBEDDING`.
     * If
     * [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     * is not provided or set to `RANK_BY_EMBEDDING`, it should be a single
     * function or multiple functions that are joined by "+".
     *   * ranking_expression = function, { " + ", function };
     * Supported functions:
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     * Function variables:
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between `embedding_field_path` and
     *   query embedding vector.
     *  Example ranking expression:
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * If
     * [ranking_expression_backend][google.cloud.discoveryengine.v1.SearchRequest.ranking_expression_backend]
     * is set to `RANK_BY_FORMULA`, the following expression types (and
     * combinations of those chained using + or
     * * operators) are supported:
     *   * `double`
     *   * `signal`
     *   * `log(signal)`
     *   * `exp(signal)`
     *   * `rr(signal, double > 0)`  -- reciprocal rank transformation with second
     *   argument being a denominator constant.
     *   * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise.
     *   * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns
     *   signal2 | double, else returns signal1.
     *   Here are a few examples of ranking formulas that use the supported
     *   ranking expression types:
     *   - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)`
     *   -- mostly rank by the logarithm of `keyword_similarity_score` with slight
     *   `semantic_smilarity_score` adjustment.
     *   - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 *
     *   is_nan(keyword_similarity_score)` -- rank by the exponent of
     *   `semantic_similarity_score` filling the value with 0 if it's NaN, also
     *   add constant 0.3 adjustment to the final score if
     *   `semantic_similarity_score` is NaN.
     *   - `0.2 * rr(semantic_similarity_score, 16) + 0.8 *
     *   rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank
     *   of `keyword_similarity_score` with slight adjustment of reciprocal rank
     *   of `semantic_smilarity_score`.
     * The following signals are supported:
     *   * `semantic_similarity_score`: semantic similarity adjustment that is
     *   calculated using the embeddings generated by a proprietary Google model.
     *   This score determines how semantically similar a search query is to a
     *   document.
     *   * `keyword_similarity_score`: keyword match adjustment uses the Best
     *   Match 25 (BM25) ranking function. This score is calculated using a
     *   probabilistic model to estimate the probability that a document is
     *   relevant to a given query.
     *   * `relevance_score`: semantic relevance adjustment that uses a
     *   proprietary Google model to determine the meaning and intent behind a
     *   user's query in context with the content in the documents.
     *   * `pctr_rank`: predicted conversion rate adjustment as a rank use
     *   predicted Click-through rate (pCTR) to gauge the relevance and
     *   attractiveness of a search result from a user's perspective. A higher
     *   pCTR suggests that the result is more likely to satisfy the user's query
     *   and intent, making it a valuable signal for ranking.
     *   * `freshness_rank`: freshness adjustment as a rank
     *   * `document_age`: The time in hours elapsed since the document was last
     *   updated, a floating-point number (e.g., 0.25 means 15 minutes).
     *   * `topicality_rank`: topicality adjustment as a rank. Uses proprietary
     *   Google model to determine the keyword-based overlap between the query and
     *   the document.
     *   * `base_rank`: the default rank of the result
     *
     * Generated from protobuf field <code>string ranking_expression = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRankingExpression($var)
    {
        GPBUtil::checkString($var, True);
        $this->ranking_expression = $var;

        return $this;
    }

    /**
     * Optional. The backend to use for the ranking expression evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RankingExpressionBackend ranking_expression_backend = 53 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRankingExpressionBackend()
    {
        return $this->ranking_expression_backend;
    }

    /**
     * Optional. The backend to use for the ranking expression evaluation.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RankingExpressionBackend ranking_expression_backend = 53 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRankingExpressionBackend($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\RankingExpressionBackend::class);
        $this->ranking_expression_backend = $var;

        return $this;
    }

    /**
     * Whether to turn on safe search. This is only supported for
     * website search.
     *
     * Generated from protobuf field <code>bool safe_search = 20;</code>
     * @return bool
     */
    public function getSafeSearch()
    {
        return $this->safe_search;
    }

    /**
     * Whether to turn on safe search. This is only supported for
     * website search.
     *
     * Generated from protobuf field <code>bool safe_search = 20;</code>
     * @param bool $var
     * @return $this
     */
    public function setSafeSearch($var)
    {
        GPBUtil::checkBool($var);
        $this->safe_search = $var;

        return $this;
    }

    /**
     * The user labels applied to a resource must meet the following requirements:
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 22;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getUserLabels()
    {
        return $this->user_labels;
    }

    /**
     * The user labels applied to a resource must meet the following requirements:
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 22;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setUserLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->user_labels = $arr;

        return $this;
    }

    /**
     * Optional. Config for natural language query understanding capabilities,
     * such as extracting structured field filters from the query. Refer to [this
     * documentation](https://cloud.google.com/generative-ai-app-builder/docs/natural-language-queries)
     * for more information.
     * If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
     * natural language query understanding will be done.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\NaturalLanguageQueryUnderstandingSpec|null
     */
    public function getNaturalLanguageQueryUnderstandingSpec()
    {
        return $this->natural_language_query_understanding_spec;
    }

    public function hasNaturalLanguageQueryUnderstandingSpec()
    {
        return isset($this->natural_language_query_understanding_spec);
    }

    public function clearNaturalLanguageQueryUnderstandingSpec()
    {
        unset($this->natural_language_query_understanding_spec);
    }

    /**
     * Optional. Config for natural language query understanding capabilities,
     * such as extracting structured field filters from the query. Refer to [this
     * documentation](https://cloud.google.com/generative-ai-app-builder/docs/natural-language-queries)
     * for more information.
     * If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
     * natural language query understanding will be done.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\NaturalLanguageQueryUnderstandingSpec $var
     * @return $this
     */
    public function setNaturalLanguageQueryUnderstandingSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\NaturalLanguageQueryUnderstandingSpec::class);
        $this->natural_language_query_understanding_spec = $var;

        return $this;
    }

    /**
     * Search as you type configuration. Only supported for the
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SearchAsYouTypeSpec search_as_you_type_spec = 31;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SearchAsYouTypeSpec|null
     */
    public function getSearchAsYouTypeSpec()
    {
        return $this->search_as_you_type_spec;
    }

    public function hasSearchAsYouTypeSpec()
    {
        return isset($this->search_as_you_type_spec);
    }

    public function clearSearchAsYouTypeSpec()
    {
        unset($this->search_as_you_type_spec);
    }

    /**
     * Search as you type configuration. Only supported for the
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SearchAsYouTypeSpec search_as_you_type_spec = 31;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SearchAsYouTypeSpec $var
     * @return $this
     */
    public function setSearchAsYouTypeSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SearchAsYouTypeSpec::class);
        $this->search_as_you_type_spec = $var;

        return $this;
    }

    /**
     * Optional. Config for display feature, like match highlighting on search
     * results.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.DisplaySpec display_spec = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\DisplaySpec|null
     */
    public function getDisplaySpec()
    {
        return $this->display_spec;
    }

    public function hasDisplaySpec()
    {
        return isset($this->display_spec);
    }

    public function clearDisplaySpec()
    {
        unset($this->display_spec);
    }

    /**
     * Optional. Config for display feature, like match highlighting on search
     * results.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.DisplaySpec display_spec = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\DisplaySpec $var
     * @return $this
     */
    public function setDisplaySpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\DisplaySpec::class);
        $this->display_spec = $var;

        return $this;
    }

    /**
     * Optional. Crowding specifications for improving result diversity.
     * If multiple CrowdingSpecs are specified, crowding will be evaluated on
     * each unique combination of the `field` values, and max_count will be the
     * maximum value of `max_count` across all CrowdingSpecs.
     * For example, if the first CrowdingSpec has `field` = "color" and
     * `max_count` = 3, and the second CrowdingSpec has `field` = "size" and
     * `max_count` = 2, then after 3 documents that share the same color AND size
     * have been returned, subsequent ones should be
     * removed or demoted.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.CrowdingSpec crowding_specs = 40 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCrowdingSpecs()
    {
        return $this->crowding_specs;
    }

    /**
     * Optional. Crowding specifications for improving result diversity.
     * If multiple CrowdingSpecs are specified, crowding will be evaluated on
     * each unique combination of the `field` values, and max_count will be the
     * maximum value of `max_count` across all CrowdingSpecs.
     * For example, if the first CrowdingSpec has `field` = "color" and
     * `max_count` = 3, and the second CrowdingSpec has `field` = "size" and
     * `max_count` = 2, then after 3 documents that share the same color AND size
     * have been returned, subsequent ones should be
     * removed or demoted.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SearchRequest.CrowdingSpec crowding_specs = 40 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\DiscoveryEngine\V1\SearchRequest\CrowdingSpec>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCrowdingSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\CrowdingSpec::class);
        $this->crowding_specs = $arr;

        return $this;
    }

    /**
     * The session resource name. Optional.
     * Session allows users to do multi-turn /search API calls or coordination
     * between /search API calls and /answer API calls.
     * Example #1 (multi-turn /search API calls):
     *   Call /search API with the session ID generated in the first call.
     *   Here, the previous search query gets considered in query
     *   standing. I.e., if the first query is "How did Alphabet do in 2022?"
     *   and the current query is "How about 2023?", the current query will
     *   be interpreted as "How did Alphabet do in 2023?".
     * Example #2 (coordination between /search API calls and /answer API calls):
     *   Call /answer API with the session ID generated in the first call.
     *   Here, the answer generation happens in the context of the search
     *   results from the first search call.
     * Multi-turn Search feature is currently at private GA stage. Please use
     * v1alpha or v1beta version instead before we launch this feature to public
     * GA. Or ask for allowlisting through Google Support team.
     *
     * Generated from protobuf field <code>string session = 41 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * The session resource name. Optional.
     * Session allows users to do multi-turn /search API calls or coordination
     * between /search API calls and /answer API calls.
     * Example #1 (multi-turn /search API calls):
     *   Call /search API with the session ID generated in the first call.
     *   Here, the previous search query gets considered in query
     *   standing. I.e., if the first query is "How did Alphabet do in 2022?"
     *   and the current query is "How about 2023?", the current query will
     *   be interpreted as "How did Alphabet do in 2023?".
     * Example #2 (coordination between /search API calls and /answer API calls):
     *   Call /answer API with the session ID generated in the first call.
     *   Here, the answer generation happens in the context of the search
     *   results from the first search call.
     * Multi-turn Search feature is currently at private GA stage. Please use
     * v1alpha or v1beta version instead before we launch this feature to public
     * GA. Or ask for allowlisting through Google Support team.
     *
     * Generated from protobuf field <code>string session = 41 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSession($var)
    {
        GPBUtil::checkString($var, True);
        $this->session = $var;

        return $this;
    }

    /**
     * Session specification.
     * Can be used only when `session` is set.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SessionSpec session_spec = 42;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SessionSpec|null
     */
    public function getSessionSpec()
    {
        return $this->session_spec;
    }

    public function hasSessionSpec()
    {
        return isset($this->session_spec);
    }

    public function clearSessionSpec()
    {
        unset($this->session_spec);
    }

    /**
     * Session specification.
     * Can be used only when `session` is set.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.SessionSpec session_spec = 42;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SessionSpec $var
     * @return $this
     */
    public function setSessionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\SessionSpec::class);
        $this->session_spec = $var;

        return $this;
    }

    /**
     * The global relevance threshold of the search results.
     * Defaults to Google defined threshold, leveraging a balance of
     * precision and recall to deliver both highly accurate results and
     * comprehensive coverage of relevant information.
     * If more granular relevance filtering is required, use the
     * `relevance_filter_spec` instead.
     * This feature is not supported for healthcare search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RelevanceThreshold relevance_threshold = 44;</code>
     * @return int
     */
    public function getRelevanceThreshold()
    {
        return $this->relevance_threshold;
    }

    /**
     * The global relevance threshold of the search results.
     * Defaults to Google defined threshold, leveraging a balance of
     * precision and recall to deliver both highly accurate results and
     * comprehensive coverage of relevant information.
     * If more granular relevance filtering is required, use the
     * `relevance_filter_spec` instead.
     * This feature is not supported for healthcare search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RelevanceThreshold relevance_threshold = 44;</code>
     * @param int $var
     * @return $this
     */
    public function setRelevanceThreshold($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\RelevanceThreshold::class);
        $this->relevance_threshold = $var;

        return $this;
    }

    /**
     * Optional. The specification for returning the relevance score.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RelevanceScoreSpec relevance_score_spec = 52 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\SearchRequest\RelevanceScoreSpec|null
     */
    public function getRelevanceScoreSpec()
    {
        return $this->relevance_score_spec;
    }

    public function hasRelevanceScoreSpec()
    {
        return isset($this->relevance_score_spec);
    }

    public function clearRelevanceScoreSpec()
    {
        unset($this->relevance_score_spec);
    }

    /**
     * Optional. The specification for returning the relevance score.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.SearchRequest.RelevanceScoreSpec relevance_score_spec = 52 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\SearchRequest\RelevanceScoreSpec $var
     * @return $this
     */
    public function setRelevanceScoreSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\SearchRequest\RelevanceScoreSpec::class);
        $this->relevance_score_spec = $var;

        return $this;
    }

}

