<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/data_store.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * DataStore captures global settings and configs at the DataStore level.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.DataStore</code>
 */
class DataStore extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. Identifier. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The data store display name.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Immutable. The industry vertical that the data store registers.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $industry_vertical = 0;
    /**
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1.DataStore.industry_vertical]:
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SolutionType solution_types = 5;</code>
     */
    private $solution_types;
    /**
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1.Schema] associated to this data
     * store.
     *
     * Generated from protobuf field <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $default_schema_id = '';
    /**
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1.DataStore.ContentConfig.NO_CONTENT].
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $content_config = 0;
    /**
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] was created at.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Optional. Configuration for advanced site search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.AdvancedSiteSearchConfig advanced_site_search_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $advanced_site_search_config = null;
    /**
     * Optional. Configuration for Natural Language Query Understanding.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.NaturalLanguageQueryUnderstandingConfig natural_language_query_understanding_config = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $natural_language_query_understanding_config = null;
    /**
     * Input only. The KMS key to be used to protect this DataStore at creation
     * time.
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     * If this field is set and processed successfully, the DataStore will be
     * protected by the KMS key, as indicated in the cmek_config field.
     *
     * Generated from protobuf field <code>string kms_key_name = 32 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $kms_key_name = '';
    /**
     * Output only. CMEK-related information for the DataStore.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig cmek_config = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $cmek_config = null;
    /**
     * Output only. Data size estimation for billing.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore.BillingEstimation billing_estimation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $billing_estimation = null;
    /**
     * Immutable. Whether data in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] has ACL information.
     * If set to `true`, the source data must have ACL. ACL will be ingested when
     * data is ingested by
     * [DocumentService.ImportDocuments][google.cloud.discoveryengine.v1.DocumentService.ImportDocuments]
     * methods.
     * When ACL is enabled for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore],
     * [Document][google.cloud.discoveryengine.v1.Document] can't be accessed by
     * calling
     * [DocumentService.GetDocument][google.cloud.discoveryengine.v1.DocumentService.GetDocument]
     * or
     * [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments].
     * Currently ACL is only supported in `GENERIC` industry vertical with
     * non-`PUBLIC_WEBSITE` content config.
     *
     * Generated from protobuf field <code>bool acl_enabled = 24 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $acl_enabled = false;
    /**
     * Config to store data store type configuration for workspace data. This
     * must be set when
     * [DataStore.content_config][google.cloud.discoveryengine.v1.DataStore.content_config]
     * is set as
     * [DataStore.ContentConfig.GOOGLE_WORKSPACE][google.cloud.discoveryengine.v1.DataStore.ContentConfig.GOOGLE_WORKSPACE].
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.WorkspaceConfig workspace_config = 25;</code>
     */
    protected $workspace_config = null;
    /**
     * Configuration for Document understanding and enrichment.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DocumentProcessingConfig document_processing_config = 27;</code>
     */
    protected $document_processing_config = null;
    /**
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] when provisioning
     * it. If unset, a default vertical specialized schema will be used.
     * This field is only used by
     * [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     * API, and will be ignored if used in other APIs. This field will be omitted
     * from all API responses including
     * [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     * API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1.SchemaService.GetSchema]
     * API instead.
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Schema starting_schema = 28;</code>
     */
    protected $starting_schema = null;
    /**
     * Optional. Configuration for `HEALTHCARE_FHIR` vertical.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.HealthcareFhirConfig healthcare_fhir_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $healthcare_fhir_config = null;
    /**
     * Immutable. The fully qualified resource name of the associated
     * [IdentityMappingStore][google.cloud.discoveryengine.v1.IdentityMappingStore].
     * This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or
     * `GSUITE` IdP. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     *
     * Generated from protobuf field <code>string identity_mapping_store = 31 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $identity_mapping_store = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. Identifier. The full resource name of the data store.
     *           Format:
     *           `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *           This field must be a UTF-8 encoded string with a length limit of 1024
     *           characters.
     *     @type string $display_name
     *           Required. The data store display name.
     *           This field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type int $industry_vertical
     *           Immutable. The industry vertical that the data store registers.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $solution_types
     *           The solutions that the data store enrolls. Available solutions for each
     *           [industry_vertical][google.cloud.discoveryengine.v1.DataStore.industry_vertical]:
     *           * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     *           * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *             solutions cannot be enrolled.
     *     @type string $default_schema_id
     *           Output only. The id of the default
     *           [Schema][google.cloud.discoveryengine.v1.Schema] associated to this data
     *           store.
     *     @type int $content_config
     *           Immutable. The content config of the data store. If this field is unset,
     *           the server behavior defaults to
     *           [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1.DataStore.ContentConfig.NO_CONTENT].
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp the
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore] was created at.
     *     @type \Google\Cloud\DiscoveryEngine\V1\AdvancedSiteSearchConfig $advanced_site_search_config
     *           Optional. Configuration for advanced site search.
     *     @type \Google\Cloud\DiscoveryEngine\V1\NaturalLanguageQueryUnderstandingConfig $natural_language_query_understanding_config
     *           Optional. Configuration for Natural Language Query Understanding.
     *     @type string $kms_key_name
     *           Input only. The KMS key to be used to protect this DataStore at creation
     *           time.
     *           Must be set for requests that need to comply with CMEK Org Policy
     *           protections.
     *           If this field is set and processed successfully, the DataStore will be
     *           protected by the KMS key, as indicated in the cmek_config field.
     *     @type \Google\Cloud\DiscoveryEngine\V1\CmekConfig $cmek_config
     *           Output only. CMEK-related information for the DataStore.
     *     @type \Google\Cloud\DiscoveryEngine\V1\DataStore\BillingEstimation $billing_estimation
     *           Output only. Data size estimation for billing.
     *     @type bool $acl_enabled
     *           Immutable. Whether data in the
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore] has ACL information.
     *           If set to `true`, the source data must have ACL. ACL will be ingested when
     *           data is ingested by
     *           [DocumentService.ImportDocuments][google.cloud.discoveryengine.v1.DocumentService.ImportDocuments]
     *           methods.
     *           When ACL is enabled for the
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore],
     *           [Document][google.cloud.discoveryengine.v1.Document] can't be accessed by
     *           calling
     *           [DocumentService.GetDocument][google.cloud.discoveryengine.v1.DocumentService.GetDocument]
     *           or
     *           [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments].
     *           Currently ACL is only supported in `GENERIC` industry vertical with
     *           non-`PUBLIC_WEBSITE` content config.
     *     @type \Google\Cloud\DiscoveryEngine\V1\WorkspaceConfig $workspace_config
     *           Config to store data store type configuration for workspace data. This
     *           must be set when
     *           [DataStore.content_config][google.cloud.discoveryengine.v1.DataStore.content_config]
     *           is set as
     *           [DataStore.ContentConfig.GOOGLE_WORKSPACE][google.cloud.discoveryengine.v1.DataStore.ContentConfig.GOOGLE_WORKSPACE].
     *     @type \Google\Cloud\DiscoveryEngine\V1\DocumentProcessingConfig $document_processing_config
     *           Configuration for Document understanding and enrichment.
     *     @type \Google\Cloud\DiscoveryEngine\V1\Schema $starting_schema
     *           The start schema to use for this
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore] when provisioning
     *           it. If unset, a default vertical specialized schema will be used.
     *           This field is only used by
     *           [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     *           API, and will be ignored if used in other APIs. This field will be omitted
     *           from all API responses including
     *           [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     *           API. To retrieve a schema of a
     *           [DataStore][google.cloud.discoveryengine.v1.DataStore], use
     *           [SchemaService.GetSchema][google.cloud.discoveryengine.v1.SchemaService.GetSchema]
     *           API instead.
     *           The provided schema will be validated against certain rules on schema.
     *           Learn more from [this
     *           doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     *     @type \Google\Cloud\DiscoveryEngine\V1\HealthcareFhirConfig $healthcare_fhir_config
     *           Optional. Configuration for `HEALTHCARE_FHIR` vertical.
     *     @type string $identity_mapping_store
     *           Immutable. The fully qualified resource name of the associated
     *           [IdentityMappingStore][google.cloud.discoveryengine.v1.IdentityMappingStore].
     *           This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or
     *           `GSUITE` IdP. Format:
     *           `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\DataStore::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. Identifier. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. Identifier. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The data store display name.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The data store display name.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Immutable. The industry vertical that the data store registers.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getIndustryVertical()
    {
        return $this->industry_vertical;
    }

    /**
     * Immutable. The industry vertical that the data store registers.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setIndustryVertical($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\IndustryVertical::class);
        $this->industry_vertical = $var;

        return $this;
    }

    /**
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1.DataStore.industry_vertical]:
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SolutionType solution_types = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSolutionTypes()
    {
        return $this->solution_types;
    }

    /**
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1.DataStore.industry_vertical]:
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SolutionType solution_types = 5;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSolutionTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\DiscoveryEngine\V1\SolutionType::class);
        $this->solution_types = $arr;

        return $this;
    }

    /**
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1.Schema] associated to this data
     * store.
     *
     * Generated from protobuf field <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDefaultSchemaId()
    {
        return $this->default_schema_id;
    }

    /**
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1.Schema] associated to this data
     * store.
     *
     * Generated from protobuf field <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDefaultSchemaId($var)
    {
        GPBUtil::checkString($var, True);
        $this->default_schema_id = $var;

        return $this;
    }

    /**
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1.DataStore.ContentConfig.NO_CONTENT].
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getContentConfig()
    {
        return $this->content_config;
    }

    /**
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1.DataStore.ContentConfig.NO_CONTENT].
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setContentConfig($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\DataStore\ContentConfig::class);
        $this->content_config = $var;

        return $this;
    }

    /**
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] was created at.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] was created at.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Optional. Configuration for advanced site search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.AdvancedSiteSearchConfig advanced_site_search_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\AdvancedSiteSearchConfig|null
     */
    public function getAdvancedSiteSearchConfig()
    {
        return $this->advanced_site_search_config;
    }

    public function hasAdvancedSiteSearchConfig()
    {
        return isset($this->advanced_site_search_config);
    }

    public function clearAdvancedSiteSearchConfig()
    {
        unset($this->advanced_site_search_config);
    }

    /**
     * Optional. Configuration for advanced site search.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.AdvancedSiteSearchConfig advanced_site_search_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\AdvancedSiteSearchConfig $var
     * @return $this
     */
    public function setAdvancedSiteSearchConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\AdvancedSiteSearchConfig::class);
        $this->advanced_site_search_config = $var;

        return $this;
    }

    /**
     * Optional. Configuration for Natural Language Query Understanding.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.NaturalLanguageQueryUnderstandingConfig natural_language_query_understanding_config = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\NaturalLanguageQueryUnderstandingConfig|null
     */
    public function getNaturalLanguageQueryUnderstandingConfig()
    {
        return $this->natural_language_query_understanding_config;
    }

    public function hasNaturalLanguageQueryUnderstandingConfig()
    {
        return isset($this->natural_language_query_understanding_config);
    }

    public function clearNaturalLanguageQueryUnderstandingConfig()
    {
        unset($this->natural_language_query_understanding_config);
    }

    /**
     * Optional. Configuration for Natural Language Query Understanding.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.NaturalLanguageQueryUnderstandingConfig natural_language_query_understanding_config = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\NaturalLanguageQueryUnderstandingConfig $var
     * @return $this
     */
    public function setNaturalLanguageQueryUnderstandingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\NaturalLanguageQueryUnderstandingConfig::class);
        $this->natural_language_query_understanding_config = $var;

        return $this;
    }

    /**
     * Input only. The KMS key to be used to protect this DataStore at creation
     * time.
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     * If this field is set and processed successfully, the DataStore will be
     * protected by the KMS key, as indicated in the cmek_config field.
     *
     * Generated from protobuf field <code>string kms_key_name = 32 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * Input only. The KMS key to be used to protect this DataStore at creation
     * time.
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     * If this field is set and processed successfully, the DataStore will be
     * protected by the KMS key, as indicated in the cmek_config field.
     *
     * Generated from protobuf field <code>string kms_key_name = 32 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

    /**
     * Output only. CMEK-related information for the DataStore.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig cmek_config = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\CmekConfig|null
     */
    public function getCmekConfig()
    {
        return $this->cmek_config;
    }

    public function hasCmekConfig()
    {
        return isset($this->cmek_config);
    }

    public function clearCmekConfig()
    {
        unset($this->cmek_config);
    }

    /**
     * Output only. CMEK-related information for the DataStore.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig cmek_config = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\CmekConfig $var
     * @return $this
     */
    public function setCmekConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\CmekConfig::class);
        $this->cmek_config = $var;

        return $this;
    }

    /**
     * Output only. Data size estimation for billing.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore.BillingEstimation billing_estimation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\DataStore\BillingEstimation|null
     */
    public function getBillingEstimation()
    {
        return $this->billing_estimation;
    }

    public function hasBillingEstimation()
    {
        return isset($this->billing_estimation);
    }

    public function clearBillingEstimation()
    {
        unset($this->billing_estimation);
    }

    /**
     * Output only. Data size estimation for billing.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DataStore.BillingEstimation billing_estimation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\DataStore\BillingEstimation $var
     * @return $this
     */
    public function setBillingEstimation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\DataStore\BillingEstimation::class);
        $this->billing_estimation = $var;

        return $this;
    }

    /**
     * Immutable. Whether data in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] has ACL information.
     * If set to `true`, the source data must have ACL. ACL will be ingested when
     * data is ingested by
     * [DocumentService.ImportDocuments][google.cloud.discoveryengine.v1.DocumentService.ImportDocuments]
     * methods.
     * When ACL is enabled for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore],
     * [Document][google.cloud.discoveryengine.v1.Document] can't be accessed by
     * calling
     * [DocumentService.GetDocument][google.cloud.discoveryengine.v1.DocumentService.GetDocument]
     * or
     * [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments].
     * Currently ACL is only supported in `GENERIC` industry vertical with
     * non-`PUBLIC_WEBSITE` content config.
     *
     * Generated from protobuf field <code>bool acl_enabled = 24 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return bool
     */
    public function getAclEnabled()
    {
        return $this->acl_enabled;
    }

    /**
     * Immutable. Whether data in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] has ACL information.
     * If set to `true`, the source data must have ACL. ACL will be ingested when
     * data is ingested by
     * [DocumentService.ImportDocuments][google.cloud.discoveryengine.v1.DocumentService.ImportDocuments]
     * methods.
     * When ACL is enabled for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore],
     * [Document][google.cloud.discoveryengine.v1.Document] can't be accessed by
     * calling
     * [DocumentService.GetDocument][google.cloud.discoveryengine.v1.DocumentService.GetDocument]
     * or
     * [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments].
     * Currently ACL is only supported in `GENERIC` industry vertical with
     * non-`PUBLIC_WEBSITE` content config.
     *
     * Generated from protobuf field <code>bool acl_enabled = 24 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param bool $var
     * @return $this
     */
    public function setAclEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->acl_enabled = $var;

        return $this;
    }

    /**
     * Config to store data store type configuration for workspace data. This
     * must be set when
     * [DataStore.content_config][google.cloud.discoveryengine.v1.DataStore.content_config]
     * is set as
     * [DataStore.ContentConfig.GOOGLE_WORKSPACE][google.cloud.discoveryengine.v1.DataStore.ContentConfig.GOOGLE_WORKSPACE].
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.WorkspaceConfig workspace_config = 25;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\WorkspaceConfig|null
     */
    public function getWorkspaceConfig()
    {
        return $this->workspace_config;
    }

    public function hasWorkspaceConfig()
    {
        return isset($this->workspace_config);
    }

    public function clearWorkspaceConfig()
    {
        unset($this->workspace_config);
    }

    /**
     * Config to store data store type configuration for workspace data. This
     * must be set when
     * [DataStore.content_config][google.cloud.discoveryengine.v1.DataStore.content_config]
     * is set as
     * [DataStore.ContentConfig.GOOGLE_WORKSPACE][google.cloud.discoveryengine.v1.DataStore.ContentConfig.GOOGLE_WORKSPACE].
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.WorkspaceConfig workspace_config = 25;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\WorkspaceConfig $var
     * @return $this
     */
    public function setWorkspaceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\WorkspaceConfig::class);
        $this->workspace_config = $var;

        return $this;
    }

    /**
     * Configuration for Document understanding and enrichment.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DocumentProcessingConfig document_processing_config = 27;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\DocumentProcessingConfig|null
     */
    public function getDocumentProcessingConfig()
    {
        return $this->document_processing_config;
    }

    public function hasDocumentProcessingConfig()
    {
        return isset($this->document_processing_config);
    }

    public function clearDocumentProcessingConfig()
    {
        unset($this->document_processing_config);
    }

    /**
     * Configuration for Document understanding and enrichment.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.DocumentProcessingConfig document_processing_config = 27;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\DocumentProcessingConfig $var
     * @return $this
     */
    public function setDocumentProcessingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\DocumentProcessingConfig::class);
        $this->document_processing_config = $var;

        return $this;
    }

    /**
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] when provisioning
     * it. If unset, a default vertical specialized schema will be used.
     * This field is only used by
     * [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     * API, and will be ignored if used in other APIs. This field will be omitted
     * from all API responses including
     * [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     * API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1.SchemaService.GetSchema]
     * API instead.
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Schema starting_schema = 28;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\Schema|null
     */
    public function getStartingSchema()
    {
        return $this->starting_schema;
    }

    public function hasStartingSchema()
    {
        return isset($this->starting_schema);
    }

    public function clearStartingSchema()
    {
        unset($this->starting_schema);
    }

    /**
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1.DataStore] when provisioning
     * it. If unset, a default vertical specialized schema will be used.
     * This field is only used by
     * [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     * API, and will be ignored if used in other APIs. This field will be omitted
     * from all API responses including
     * [CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
     * API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1.SchemaService.GetSchema]
     * API instead.
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Schema starting_schema = 28;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\Schema $var
     * @return $this
     */
    public function setStartingSchema($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\Schema::class);
        $this->starting_schema = $var;

        return $this;
    }

    /**
     * Optional. Configuration for `HEALTHCARE_FHIR` vertical.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.HealthcareFhirConfig healthcare_fhir_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\HealthcareFhirConfig|null
     */
    public function getHealthcareFhirConfig()
    {
        return $this->healthcare_fhir_config;
    }

    public function hasHealthcareFhirConfig()
    {
        return isset($this->healthcare_fhir_config);
    }

    public function clearHealthcareFhirConfig()
    {
        unset($this->healthcare_fhir_config);
    }

    /**
     * Optional. Configuration for `HEALTHCARE_FHIR` vertical.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.HealthcareFhirConfig healthcare_fhir_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\HealthcareFhirConfig $var
     * @return $this
     */
    public function setHealthcareFhirConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\HealthcareFhirConfig::class);
        $this->healthcare_fhir_config = $var;

        return $this;
    }

    /**
     * Immutable. The fully qualified resource name of the associated
     * [IdentityMappingStore][google.cloud.discoveryengine.v1.IdentityMappingStore].
     * This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or
     * `GSUITE` IdP. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     *
     * Generated from protobuf field <code>string identity_mapping_store = 31 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getIdentityMappingStore()
    {
        return $this->identity_mapping_store;
    }

    /**
     * Immutable. The fully qualified resource name of the associated
     * [IdentityMappingStore][google.cloud.discoveryengine.v1.IdentityMappingStore].
     * This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or
     * `GSUITE` IdP. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     *
     * Generated from protobuf field <code>string identity_mapping_store = 31 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setIdentityMappingStore($var)
    {
        GPBUtil::checkString($var, True);
        $this->identity_mapping_store = $var;

        return $this;
    }

}

