<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/security_settings.proto

namespace Google\Cloud\Dialogflow\Cx\V3\SecuritySettings;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings for exporting audio.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings</code>
 */
class AudioExportSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Cloud Storage bucket to export audio record to.
     * Setting this field would grant the Storage Object Creator role to
     * the Dialogflow Service Agent.
     * API caller that tries to modify this field should have the permission of
     * storage.buckets.setIamPolicy.
     *
     * Generated from protobuf field <code>string gcs_bucket = 1;</code>
     */
    protected $gcs_bucket = '';
    /**
     * Filename pattern for exported audio.
     * {conversation} and {timestamp} are placeholders that will be replaced
     * with the conversation ID and epoch micros of the conversation.
     * For example, "{conversation}/recording_{timestamp}.mulaw".
     *
     * Generated from protobuf field <code>string audio_export_pattern = 2;</code>
     */
    protected $audio_export_pattern = '';
    /**
     * Enable audio redaction if it is true.
     * Note that this only redacts end-user audio data;
     * Synthesised audio from the virtual agent is not redacted.
     *
     * Generated from protobuf field <code>bool enable_audio_redaction = 3;</code>
     */
    protected $enable_audio_redaction = false;
    /**
     * File format for exported audio file. Currently only in telephony
     * recordings.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;</code>
     */
    protected $audio_format = 0;
    /**
     * Whether to store TTS audio. By default, TTS audio from the virtual agent
     * is not exported.
     *
     * Generated from protobuf field <code>bool store_tts_audio = 6;</code>
     */
    protected $store_tts_audio = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $gcs_bucket
     *           Cloud Storage bucket to export audio record to.
     *           Setting this field would grant the Storage Object Creator role to
     *           the Dialogflow Service Agent.
     *           API caller that tries to modify this field should have the permission of
     *           storage.buckets.setIamPolicy.
     *     @type string $audio_export_pattern
     *           Filename pattern for exported audio.
     *           {conversation} and {timestamp} are placeholders that will be replaced
     *           with the conversation ID and epoch micros of the conversation.
     *           For example, "{conversation}/recording_{timestamp}.mulaw".
     *     @type bool $enable_audio_redaction
     *           Enable audio redaction if it is true.
     *           Note that this only redacts end-user audio data;
     *           Synthesised audio from the virtual agent is not redacted.
     *     @type int $audio_format
     *           File format for exported audio file. Currently only in telephony
     *           recordings.
     *     @type bool $store_tts_audio
     *           Whether to store TTS audio. By default, TTS audio from the virtual agent
     *           is not exported.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\SecuritySettings::initOnce();
        parent::__construct($data);
    }

    /**
     * Cloud Storage bucket to export audio record to.
     * Setting this field would grant the Storage Object Creator role to
     * the Dialogflow Service Agent.
     * API caller that tries to modify this field should have the permission of
     * storage.buckets.setIamPolicy.
     *
     * Generated from protobuf field <code>string gcs_bucket = 1;</code>
     * @return string
     */
    public function getGcsBucket()
    {
        return $this->gcs_bucket;
    }

    /**
     * Cloud Storage bucket to export audio record to.
     * Setting this field would grant the Storage Object Creator role to
     * the Dialogflow Service Agent.
     * API caller that tries to modify this field should have the permission of
     * storage.buckets.setIamPolicy.
     *
     * Generated from protobuf field <code>string gcs_bucket = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsBucket($var)
    {
        GPBUtil::checkString($var, True);
        $this->gcs_bucket = $var;

        return $this;
    }

    /**
     * Filename pattern for exported audio.
     * {conversation} and {timestamp} are placeholders that will be replaced
     * with the conversation ID and epoch micros of the conversation.
     * For example, "{conversation}/recording_{timestamp}.mulaw".
     *
     * Generated from protobuf field <code>string audio_export_pattern = 2;</code>
     * @return string
     */
    public function getAudioExportPattern()
    {
        return $this->audio_export_pattern;
    }

    /**
     * Filename pattern for exported audio.
     * {conversation} and {timestamp} are placeholders that will be replaced
     * with the conversation ID and epoch micros of the conversation.
     * For example, "{conversation}/recording_{timestamp}.mulaw".
     *
     * Generated from protobuf field <code>string audio_export_pattern = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAudioExportPattern($var)
    {
        GPBUtil::checkString($var, True);
        $this->audio_export_pattern = $var;

        return $this;
    }

    /**
     * Enable audio redaction if it is true.
     * Note that this only redacts end-user audio data;
     * Synthesised audio from the virtual agent is not redacted.
     *
     * Generated from protobuf field <code>bool enable_audio_redaction = 3;</code>
     * @return bool
     */
    public function getEnableAudioRedaction()
    {
        return $this->enable_audio_redaction;
    }

    /**
     * Enable audio redaction if it is true.
     * Note that this only redacts end-user audio data;
     * Synthesised audio from the virtual agent is not redacted.
     *
     * Generated from protobuf field <code>bool enable_audio_redaction = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableAudioRedaction($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_audio_redaction = $var;

        return $this;
    }

    /**
     * File format for exported audio file. Currently only in telephony
     * recordings.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;</code>
     * @return int
     */
    public function getAudioFormat()
    {
        return $this->audio_format;
    }

    /**
     * File format for exported audio file. Currently only in telephony
     * recordings.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setAudioFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\SecuritySettings\AudioExportSettings\AudioFormat::class);
        $this->audio_format = $var;

        return $this;
    }

    /**
     * Whether to store TTS audio. By default, TTS audio from the virtual agent
     * is not exported.
     *
     * Generated from protobuf field <code>bool store_tts_audio = 6;</code>
     * @return bool
     */
    public function getStoreTtsAudio()
    {
        return $this->store_tts_audio;
    }

    /**
     * Whether to store TTS audio. By default, TTS audio from the virtual agent
     * is not exported.
     *
     * Generated from protobuf field <code>bool store_tts_audio = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setStoreTtsAudio($var)
    {
        GPBUtil::checkBool($var);
        $this->store_tts_audio = $var;

        return $this;
    }

}


