<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/playbook.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Playbook is the basic building block to instruct the LLM how to execute a
 * certain task.
 * A playbook consists of a goal to accomplish, an optional list of step by step
 * instructions (the step instruction may refers to name of the custom or
 * default plugin tools to use) to perform the task,
 * a list of contextual input data to be passed in at the beginning of the
 * invoked, and a list of output parameters to store the playbook result.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.Playbook</code>
 */
class Playbook extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique identifier of the playbook.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The human-readable name of the playbook, unique within an agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     *
     * Generated from protobuf field <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $goal = '';
    /**
     * Optional. Defined structured input parameters for this playbook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $input_parameter_definitions;
    /**
     * Optional. Defined structured output parameters for this playbook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $output_parameter_definitions;
    /**
     * Instruction to accomplish target goal.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Playbook.Instruction instruction = 17;</code>
     */
    protected $instruction = null;
    /**
     * Output only. Estimated number of tokes current playbook takes when sent to
     * the LLM.
     *
     * Generated from protobuf field <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $token_count = 0;
    /**
     * Output only. The timestamp of initial playbook creation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Last time the playbook version was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     *
     * Generated from protobuf field <code>repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $referenced_playbooks;
    /**
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     *
     * Generated from protobuf field <code>repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $referenced_flows;
    /**
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     *
     * Generated from protobuf field <code>repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $referenced_tools;
    /**
     * Optional. Output only. Names of inline actions scoped to this playbook.
     * These actions are in addition to those belonging to referenced tools, child
     * playbooks, and flows, e.g. actions that are defined in the playbook's code
     * block.
     *
     * Generated from protobuf field <code>repeated string inline_actions = 22 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $inline_actions;
    /**
     * Optional. The playbook's scoped code block, which may implement handlers
     * and actions.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.CodeBlock code_block = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $code_block = null;
    /**
     * Optional. Llm model settings for the playbook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $llm_model_settings = null;
    /**
     * Optional. A list of registered handlers to execuate based on the specified
     * triggers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $handlers;
    /**
     * Optional. Type of the playbook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Playbook.PlaybookType playbook_type = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $playbook_type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The unique identifier of the playbook.
     *           Format:
     *           `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
     *     @type string $display_name
     *           Required. The human-readable name of the playbook, unique within an agent.
     *     @type string $goal
     *           Required. High level description of the goal the playbook intend to
     *           accomplish. A goal should be concise since it's visible to other playbooks
     *           that may reference this playbook.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\ParameterDefinition>|\Google\Protobuf\Internal\RepeatedField $input_parameter_definitions
     *           Optional. Defined structured input parameters for this playbook.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\ParameterDefinition>|\Google\Protobuf\Internal\RepeatedField $output_parameter_definitions
     *           Optional. Defined structured output parameters for this playbook.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Playbook\Instruction $instruction
     *           Instruction to accomplish target goal.
     *     @type int|string $token_count
     *           Output only. Estimated number of tokes current playbook takes when sent to
     *           the LLM.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp of initial playbook creation.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Last time the playbook version was updated.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $referenced_playbooks
     *           Output only. The resource name of other playbooks referenced by the current
     *           playbook in the instructions.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $referenced_flows
     *           Output only. The resource name of flows referenced by the current playbook
     *           in the instructions.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $referenced_tools
     *           Optional. The resource name of tools referenced by the current playbook in
     *           the instructions. If not provided explicitly, they are will
     *           be implied using the tool being referenced in goal and steps.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $inline_actions
     *           Optional. Output only. Names of inline actions scoped to this playbook.
     *           These actions are in addition to those belonging to referenced tools, child
     *           playbooks, and flows, e.g. actions that are defined in the playbook's code
     *           block.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\CodeBlock $code_block
     *           Optional. The playbook's scoped code block, which may implement handlers
     *           and actions.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings $llm_model_settings
     *           Optional. Llm model settings for the playbook.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\Handler>|\Google\Protobuf\Internal\RepeatedField $handlers
     *           Optional. A list of registered handlers to execuate based on the specified
     *           triggers.
     *     @type int $playbook_type
     *           Optional. Type of the playbook.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Playbook::initOnce();
        parent::__construct($data);
    }

    /**
     * The unique identifier of the playbook.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The unique identifier of the playbook.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The human-readable name of the playbook, unique within an agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The human-readable name of the playbook, unique within an agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     *
     * Generated from protobuf field <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getGoal()
    {
        return $this->goal;
    }

    /**
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     *
     * Generated from protobuf field <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setGoal($var)
    {
        GPBUtil::checkString($var, True);
        $this->goal = $var;

        return $this;
    }

    /**
     * Optional. Defined structured input parameters for this playbook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInputParameterDefinitions()
    {
        return $this->input_parameter_definitions;
    }

    /**
     * Optional. Defined structured input parameters for this playbook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\ParameterDefinition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInputParameterDefinitions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\ParameterDefinition::class);
        $this->input_parameter_definitions = $arr;

        return $this;
    }

    /**
     * Optional. Defined structured output parameters for this playbook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOutputParameterDefinitions()
    {
        return $this->output_parameter_definitions;
    }

    /**
     * Optional. Defined structured output parameters for this playbook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\ParameterDefinition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOutputParameterDefinitions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\ParameterDefinition::class);
        $this->output_parameter_definitions = $arr;

        return $this;
    }

    /**
     * Instruction to accomplish target goal.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Playbook.Instruction instruction = 17;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Playbook\Instruction|null
     */
    public function getInstruction()
    {
        return $this->instruction;
    }

    public function hasInstruction()
    {
        return isset($this->instruction);
    }

    public function clearInstruction()
    {
        unset($this->instruction);
    }

    /**
     * Instruction to accomplish target goal.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Playbook.Instruction instruction = 17;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Playbook\Instruction $var
     * @return $this
     */
    public function setInstruction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Playbook\Instruction::class);
        $this->instruction = $var;

        return $this;
    }

    /**
     * Output only. Estimated number of tokes current playbook takes when sent to
     * the LLM.
     *
     * Generated from protobuf field <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getTokenCount()
    {
        return $this->token_count;
    }

    /**
     * Output only. Estimated number of tokes current playbook takes when sent to
     * the LLM.
     *
     * Generated from protobuf field <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTokenCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->token_count = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of initial playbook creation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp of initial playbook creation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Last time the playbook version was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Last time the playbook version was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     *
     * Generated from protobuf field <code>repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferencedPlaybooks()
    {
        return $this->referenced_playbooks;
    }

    /**
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     *
     * Generated from protobuf field <code>repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferencedPlaybooks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->referenced_playbooks = $arr;

        return $this;
    }

    /**
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     *
     * Generated from protobuf field <code>repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferencedFlows()
    {
        return $this->referenced_flows;
    }

    /**
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     *
     * Generated from protobuf field <code>repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferencedFlows($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->referenced_flows = $arr;

        return $this;
    }

    /**
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     *
     * Generated from protobuf field <code>repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferencedTools()
    {
        return $this->referenced_tools;
    }

    /**
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     *
     * Generated from protobuf field <code>repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferencedTools($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->referenced_tools = $arr;

        return $this;
    }

    /**
     * Optional. Output only. Names of inline actions scoped to this playbook.
     * These actions are in addition to those belonging to referenced tools, child
     * playbooks, and flows, e.g. actions that are defined in the playbook's code
     * block.
     *
     * Generated from protobuf field <code>repeated string inline_actions = 22 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInlineActions()
    {
        return $this->inline_actions;
    }

    /**
     * Optional. Output only. Names of inline actions scoped to this playbook.
     * These actions are in addition to those belonging to referenced tools, child
     * playbooks, and flows, e.g. actions that are defined in the playbook's code
     * block.
     *
     * Generated from protobuf field <code>repeated string inline_actions = 22 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInlineActions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->inline_actions = $arr;

        return $this;
    }

    /**
     * Optional. The playbook's scoped code block, which may implement handlers
     * and actions.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.CodeBlock code_block = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\CodeBlock|null
     */
    public function getCodeBlock()
    {
        return $this->code_block;
    }

    public function hasCodeBlock()
    {
        return isset($this->code_block);
    }

    public function clearCodeBlock()
    {
        unset($this->code_block);
    }

    /**
     * Optional. The playbook's scoped code block, which may implement handlers
     * and actions.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.CodeBlock code_block = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\CodeBlock $var
     * @return $this
     */
    public function setCodeBlock($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\CodeBlock::class);
        $this->code_block = $var;

        return $this;
    }

    /**
     * Optional. Llm model settings for the playbook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings|null
     */
    public function getLlmModelSettings()
    {
        return $this->llm_model_settings;
    }

    public function hasLlmModelSettings()
    {
        return isset($this->llm_model_settings);
    }

    public function clearLlmModelSettings()
    {
        unset($this->llm_model_settings);
    }

    /**
     * Optional. Llm model settings for the playbook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings $var
     * @return $this
     */
    public function setLlmModelSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings::class);
        $this->llm_model_settings = $var;

        return $this;
    }

    /**
     * Optional. A list of registered handlers to execuate based on the specified
     * triggers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHandlers()
    {
        return $this->handlers;
    }

    /**
     * Optional. A list of registered handlers to execuate based on the specified
     * triggers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\Handler>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHandlers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\Handler::class);
        $this->handlers = $arr;

        return $this;
    }

    /**
     * Optional. Type of the playbook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Playbook.PlaybookType playbook_type = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPlaybookType()
    {
        return $this->playbook_type;
    }

    /**
     * Optional. Type of the playbook.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Playbook.PlaybookType playbook_type = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPlaybookType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\Playbook\PlaybookType::class);
        $this->playbook_type = $var;

        return $this;
    }

}

