<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/cx/v3/tool.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\Cx\V3\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\Cx\V3\CreateToolRequest;
use Google\Cloud\Dialogflow\Cx\V3\CreateToolVersionRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeleteToolRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeleteToolVersionRequest;
use Google\Cloud\Dialogflow\Cx\V3\GetToolRequest;
use Google\Cloud\Dialogflow\Cx\V3\GetToolVersionRequest;
use Google\Cloud\Dialogflow\Cx\V3\ListToolVersionsRequest;
use Google\Cloud\Dialogflow\Cx\V3\ListToolsRequest;
use Google\Cloud\Dialogflow\Cx\V3\RestoreToolVersionRequest;
use Google\Cloud\Dialogflow\Cx\V3\RestoreToolVersionResponse;
use Google\Cloud\Dialogflow\Cx\V3\Tool;
use Google\Cloud\Dialogflow\Cx\V3\ToolVersion;
use Google\Cloud\Dialogflow\Cx\V3\UpdateToolRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service for managing [Tools][google.cloud.dialogflow.cx.v3.Tool].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Tool> createToolAsync(CreateToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ToolVersion> createToolVersionAsync(CreateToolVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteToolAsync(DeleteToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteToolVersionAsync(DeleteToolVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tool> getToolAsync(GetToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ToolVersion> getToolVersionAsync(GetToolVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listToolVersionsAsync(ListToolVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listToolsAsync(ListToolsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RestoreToolVersionResponse> restoreToolVersionAsync(RestoreToolVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tool> updateToolAsync(UpdateToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ToolsClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dialogflow.cx.v3.Tools';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dialogflow.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/tools_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/tools_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/tools_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/tools_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted agent resource.
     */
    public static function agentName(string $project, string $location, string $agent): string
    {
        return self::getPathTemplate('agent')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $version
     *
     * @return string The formatted secret_version resource.
     */
    public static function secretVersionName(string $project, string $secret, string $version): string
    {
        return self::getPathTemplate('secretVersion')->render([
            'project' => $project,
            'secret' => $secret,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $namespace
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName(string $project, string $location, string $namespace, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'location' => $location,
            'namespace' => $namespace,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $tool
     *
     * @return string The formatted tool resource.
     */
    public static function toolName(string $project, string $location, string $agent, string $tool): string
    {
        return self::getPathTemplate('tool')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'tool' => $tool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tool_version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $tool
     * @param string $version
     *
     * @return string The formatted tool_version resource.
     */
    public static function toolVersionName(
        string $project,
        string $location,
        string $agent,
        string $tool,
        string $version
    ): string {
        return self::getPathTemplate('toolVersion')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'tool' => $tool,
            'version' => $version,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/locations/{location}/agents/{agent}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{version}
     * - service: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}
     * - tool: projects/{project}/locations/{location}/agents/{agent}/tools/{tool}
     * - toolVersion: projects/{project}/locations/{location}/agents/{agent}/tools/{tool}/versions/{version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Dialogflow\Cx\V3\ToolsClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ToolsClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a [Tool][google.cloud.dialogflow.cx.v3.Tool] in the specified
     * agent.
     *
     * The async variant is {@see ToolsClient::createToolAsync()} .
     *
     * @example samples/V3/ToolsClient/create_tool.php
     *
     * @param CreateToolRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tool
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTool(CreateToolRequest $request, array $callOptions = []): Tool
    {
        return $this->startApiCall('CreateTool', $request, $callOptions)->wait();
    }

    /**
     * Creates a version for the specified
     * [Tool][google.cloud.dialogflow.cx.v3.Tool].
     *
     * The async variant is {@see ToolsClient::createToolVersionAsync()} .
     *
     * @example samples/V3/ToolsClient/create_tool_version.php
     *
     * @param CreateToolVersionRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ToolVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createToolVersion(CreateToolVersionRequest $request, array $callOptions = []): ToolVersion
    {
        return $this->startApiCall('CreateToolVersion', $request, $callOptions)->wait();
    }

    /**
     * Deletes a specified [Tool][google.cloud.dialogflow.cx.v3.Tool].
     *
     * The async variant is {@see ToolsClient::deleteToolAsync()} .
     *
     * @example samples/V3/ToolsClient/delete_tool.php
     *
     * @param DeleteToolRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTool(DeleteToolRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTool', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified version of the
     * [Tool][google.cloud.dialogflow.cx.v3.Tool].
     *
     * The async variant is {@see ToolsClient::deleteToolVersionAsync()} .
     *
     * @example samples/V3/ToolsClient/delete_tool_version.php
     *
     * @param DeleteToolVersionRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteToolVersion(DeleteToolVersionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteToolVersion', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the specified [Tool][google.cloud.dialogflow.cx.v3.Tool].
     *
     * The async variant is {@see ToolsClient::getToolAsync()} .
     *
     * @example samples/V3/ToolsClient/get_tool.php
     *
     * @param GetToolRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tool
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTool(GetToolRequest $request, array $callOptions = []): Tool
    {
        return $this->startApiCall('GetTool', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the specified version of the
     * [Tool][google.cloud.dialogflow.cx.v3.Tool].
     *
     * The async variant is {@see ToolsClient::getToolVersionAsync()} .
     *
     * @example samples/V3/ToolsClient/get_tool_version.php
     *
     * @param GetToolVersionRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ToolVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getToolVersion(GetToolVersionRequest $request, array $callOptions = []): ToolVersion
    {
        return $this->startApiCall('GetToolVersion', $request, $callOptions)->wait();
    }

    /**
     * List versions of the specified [Tool][google.cloud.dialogflow.cx.v3.Tool].
     *
     * The async variant is {@see ToolsClient::listToolVersionsAsync()} .
     *
     * @example samples/V3/ToolsClient/list_tool_versions.php
     *
     * @param ListToolVersionsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listToolVersions(ListToolVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListToolVersions', $request, $callOptions);
    }

    /**
     * Returns a list of [Tools][google.cloud.dialogflow.cx.v3.Tool] in the
     * specified agent.
     *
     * The async variant is {@see ToolsClient::listToolsAsync()} .
     *
     * @example samples/V3/ToolsClient/list_tools.php
     *
     * @param ListToolsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTools(ListToolsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTools', $request, $callOptions);
    }

    /**
     * Retrieves the specified version of the Tool and stores it as the
     * current tool draft, returning the tool with resources updated.
     *
     * The async variant is {@see ToolsClient::restoreToolVersionAsync()} .
     *
     * @example samples/V3/ToolsClient/restore_tool_version.php
     *
     * @param RestoreToolVersionRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RestoreToolVersionResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreToolVersion(
        RestoreToolVersionRequest $request,
        array $callOptions = []
    ): RestoreToolVersionResponse {
        return $this->startApiCall('RestoreToolVersion', $request, $callOptions)->wait();
    }

    /**
     * Update the specified [Tool][google.cloud.dialogflow.cx.v3.Tool].
     *
     * The async variant is {@see ToolsClient::updateToolAsync()} .
     *
     * @example samples/V3/ToolsClient/update_tool.php
     *
     * @param UpdateToolRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tool
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTool(UpdateToolRequest $request, array $callOptions = []): Tool
    {
        return $this->startApiCall('UpdateTool', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ToolsClient::getLocationAsync()} .
     *
     * @example samples/V3/ToolsClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ToolsClient::listLocationsAsync()} .
     *
     * @example samples/V3/ToolsClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
