<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/cx/v3/flow.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\Cx\V3\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\Cx\V3\CreateFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeleteFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\ExportFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\ExportFlowResponse;
use Google\Cloud\Dialogflow\Cx\V3\Flow;
use Google\Cloud\Dialogflow\Cx\V3\FlowValidationResult;
use Google\Cloud\Dialogflow\Cx\V3\GetFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\GetFlowValidationResultRequest;
use Google\Cloud\Dialogflow\Cx\V3\ImportFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\ImportFlowResponse;
use Google\Cloud\Dialogflow\Cx\V3\ListFlowsRequest;
use Google\Cloud\Dialogflow\Cx\V3\TrainFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\UpdateFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\ValidateFlowRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use Google\Protobuf\Struct;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service for managing [Flows][google.cloud.dialogflow.cx.v3.Flow].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Flow> createFlowAsync(CreateFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteFlowAsync(DeleteFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportFlowAsync(ExportFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Flow> getFlowAsync(GetFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FlowValidationResult> getFlowValidationResultAsync(GetFlowValidationResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importFlowAsync(ImportFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFlowsAsync(ListFlowsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> trainFlowAsync(TrainFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Flow> updateFlowAsync(UpdateFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FlowValidationResult> validateFlowAsync(ValidateFlowRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class FlowsClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dialogflow.cx.v3.Flows';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dialogflow.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/flows_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/flows_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/flows_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/flows_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted agent resource.
     */
    public static function agentName(string $project, string $location, string $agent): string
    {
        return self::getPathTemplate('agent')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a flow
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     *
     * @return string The formatted flow resource.
     */
    public static function flowName(string $project, string $location, string $agent, string $flow): string
    {
        return self::getPathTemplate('flow')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * flow_validation_result resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     *
     * @return string The formatted flow_validation_result resource.
     */
    public static function flowValidationResultName(
        string $project,
        string $location,
        string $agent,
        string $flow
    ): string {
        return self::getPathTemplate('flowValidationResult')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a generator
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $generator
     *
     * @return string The formatted generator resource.
     */
    public static function generatorName(string $project, string $location, string $agent, string $generator): string
    {
        return self::getPathTemplate('generator')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'generator' => $generator,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a intent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $intent
     *
     * @return string The formatted intent resource.
     */
    public static function intentName(string $project, string $location, string $agent, string $intent): string
    {
        return self::getPathTemplate('intent')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'intent' => $intent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a page
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     * @param string $page
     *
     * @return string The formatted page resource.
     */
    public static function pageName(
        string $project,
        string $location,
        string $agent,
        string $flow,
        string $page
    ): string {
        return self::getPathTemplate('page')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
            'page' => $page,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a playbook
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $playbook
     *
     * @return string The formatted playbook resource.
     */
    public static function playbookName(string $project, string $location, string $agent, string $playbook): string
    {
        return self::getPathTemplate('playbook')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'playbook' => $playbook,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_flow_transition_route_group resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     * @param string $transitionRouteGroup
     *
     * @return string The formatted project_location_agent_flow_transition_route_group resource.
     */
    public static function projectLocationAgentFlowTransitionRouteGroupName(
        string $project,
        string $location,
        string $agent,
        string $flow,
        string $transitionRouteGroup
    ): string {
        return self::getPathTemplate('projectLocationAgentFlowTransitionRouteGroup')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
            'transition_route_group' => $transitionRouteGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_transition_route_group resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $transitionRouteGroup
     *
     * @return string The formatted project_location_agent_transition_route_group resource.
     */
    public static function projectLocationAgentTransitionRouteGroupName(
        string $project,
        string $location,
        string $agent,
        string $transitionRouteGroup
    ): string {
        return self::getPathTemplate('projectLocationAgentTransitionRouteGroup')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'transition_route_group' => $transitionRouteGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $tool
     *
     * @return string The formatted tool resource.
     */
    public static function toolName(string $project, string $location, string $agent, string $tool): string
    {
        return self::getPathTemplate('tool')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'tool' => $tool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * transition_route_group resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     * @param string $transitionRouteGroup
     *
     * @return string The formatted transition_route_group resource.
     */
    public static function transitionRouteGroupName(
        string $project,
        string $location,
        string $agent,
        string $flow,
        string $transitionRouteGroup
    ): string {
        return self::getPathTemplate('transitionRouteGroup')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
            'transition_route_group' => $transitionRouteGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a webhook
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $webhook
     *
     * @return string The formatted webhook resource.
     */
    public static function webhookName(string $project, string $location, string $agent, string $webhook): string
    {
        return self::getPathTemplate('webhook')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'webhook' => $webhook,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/locations/{location}/agents/{agent}
     * - flow: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}
     * - flowValidationResult: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/validationResult
     * - generator: projects/{project}/locations/{location}/agents/{agent}/generators/{generator}
     * - intent: projects/{project}/locations/{location}/agents/{agent}/intents/{intent}
     * - page: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/pages/{page}
     * - playbook: projects/{project}/locations/{location}/agents/{agent}/playbooks/{playbook}
     * - projectLocationAgentFlowTransitionRouteGroup: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/transitionRouteGroups/{transition_route_group}
     * - projectLocationAgentTransitionRouteGroup: projects/{project}/locations/{location}/agents/{agent}/transitionRouteGroups/{transition_route_group}
     * - tool: projects/{project}/locations/{location}/agents/{agent}/tools/{tool}
     * - transitionRouteGroup: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/transitionRouteGroups/{transition_route_group}
     * - webhook: projects/{project}/locations/{location}/agents/{agent}/webhooks/{webhook}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Dialogflow\Cx\V3\FlowsClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new FlowsClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a flow in the specified agent.
     *
     * Note: You should always train a flow prior to sending it queries. See the
     * [training
     * documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
     *
     * The async variant is {@see FlowsClient::createFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/create_flow.php
     *
     * @param CreateFlowRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Flow
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFlow(CreateFlowRequest $request, array $callOptions = []): Flow
    {
        return $this->startApiCall('CreateFlow', $request, $callOptions)->wait();
    }

    /**
     * Deletes a specified flow.
     *
     * The async variant is {@see FlowsClient::deleteFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/delete_flow.php
     *
     * @param DeleteFlowRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFlow(DeleteFlowRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteFlow', $request, $callOptions)->wait();
    }

    /**
     * Exports the specified flow to a binary file.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: An empty [Struct
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
     * - `response`:
     * [ExportFlowResponse][google.cloud.dialogflow.cx.v3.ExportFlowResponse]
     *
     * Note that resources (e.g. intents, entities, webhooks) that the flow
     * references will also be exported.
     *
     * The async variant is {@see FlowsClient::exportFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/export_flow.php
     *
     * @param ExportFlowRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ExportFlowResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportFlow(ExportFlowRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportFlow', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the specified flow.
     *
     * The async variant is {@see FlowsClient::getFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/get_flow.php
     *
     * @param GetFlowRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Flow
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFlow(GetFlowRequest $request, array $callOptions = []): Flow
    {
        return $this->startApiCall('GetFlow', $request, $callOptions)->wait();
    }

    /**
     * Gets the latest flow validation result. Flow validation is performed
     * when ValidateFlow is called.
     *
     * The async variant is {@see FlowsClient::getFlowValidationResultAsync()} .
     *
     * @example samples/V3/FlowsClient/get_flow_validation_result.php
     *
     * @param GetFlowValidationResultRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FlowValidationResult
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFlowValidationResult(
        GetFlowValidationResultRequest $request,
        array $callOptions = []
    ): FlowValidationResult {
        return $this->startApiCall('GetFlowValidationResult', $request, $callOptions)->wait();
    }

    /**
     * Imports the specified flow to the specified agent from a binary file.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: An empty [Struct
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
     * - `response`:
     * [ImportFlowResponse][google.cloud.dialogflow.cx.v3.ImportFlowResponse]
     *
     * Note: You should always train a flow prior to sending it queries. See the
     * [training
     * documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
     *
     * The async variant is {@see FlowsClient::importFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/import_flow.php
     *
     * @param ImportFlowRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ImportFlowResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importFlow(ImportFlowRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportFlow', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of all flows in the specified agent.
     *
     * The async variant is {@see FlowsClient::listFlowsAsync()} .
     *
     * @example samples/V3/FlowsClient/list_flows.php
     *
     * @param ListFlowsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFlows(ListFlowsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFlows', $request, $callOptions);
    }

    /**
     * Trains the specified flow. Note that only the flow in 'draft' environment
     * is trained.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: An empty [Struct
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
     * - `response`: An [Empty
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
     *
     * Note: You should always train a flow prior to sending it queries. See the
     * [training
     * documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
     *
     * The async variant is {@see FlowsClient::trainFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/train_flow.php
     *
     * @param TrainFlowRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function trainFlow(TrainFlowRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('TrainFlow', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified flow.
     *
     * Note: You should always train a flow prior to sending it queries. See the
     * [training
     * documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
     *
     * The async variant is {@see FlowsClient::updateFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/update_flow.php
     *
     * @param UpdateFlowRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Flow
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFlow(UpdateFlowRequest $request, array $callOptions = []): Flow
    {
        return $this->startApiCall('UpdateFlow', $request, $callOptions)->wait();
    }

    /**
     * Validates the specified flow and creates or updates validation results.
     * Please call this API after the training is completed to get the complete
     * validation results.
     *
     * The async variant is {@see FlowsClient::validateFlowAsync()} .
     *
     * @example samples/V3/FlowsClient/validate_flow.php
     *
     * @param ValidateFlowRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FlowValidationResult
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function validateFlow(ValidateFlowRequest $request, array $callOptions = []): FlowValidationResult
    {
        return $this->startApiCall('ValidateFlow', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see FlowsClient::getLocationAsync()} .
     *
     * @example samples/V3/FlowsClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see FlowsClient::listLocationsAsync()} .
     *
     * @example samples/V3/FlowsClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
