<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/developerconnect/v1/developer_connect.proto

namespace Google\Cloud\DeveloperConnect\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines the configuration for connections to an HTTP service provider.
 *
 * Generated from protobuf message <code>google.cloud.developerconnect.v1.GenericHTTPEndpointConfig</code>
 */
class GenericHTTPEndpointConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Immutable. The service provider's https endpoint.
     *
     * Generated from protobuf field <code>string host_uri = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $host_uri = '';
    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a HTTP service provider. This should only be set if the Http service
     * provider is hosted on-premises and not reachable by public internet. If
     * this field is left empty, calls to the HTTP service provider will be made
     * over the public internet.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_directory_config = null;
    /**
     * Optional. The SSL certificate to use for requests to the HTTP service
     * provider.
     *
     * Generated from protobuf field <code>string ssl_ca_certificate = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ssl_ca_certificate = '';
    protected $authentication;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BasicAuthentication $basic_authentication
     *           Optional. Basic authentication with username and password.
     *     @type \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BearerTokenAuthentication $bearer_token_authentication
     *           Optional. Bearer token authentication with a token.
     *     @type string $host_uri
     *           Required. Immutable. The service provider's https endpoint.
     *     @type \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig $service_directory_config
     *           Optional. Configuration for using Service Directory to privately connect to
     *           a HTTP service provider. This should only be set if the Http service
     *           provider is hosted on-premises and not reachable by public internet. If
     *           this field is left empty, calls to the HTTP service provider will be made
     *           over the public internet.
     *     @type string $ssl_ca_certificate
     *           Optional. The SSL certificate to use for requests to the HTTP service
     *           provider.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Developerconnect\V1\DeveloperConnect::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Basic authentication with username and password.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GenericHTTPEndpointConfig.BasicAuthentication basic_authentication = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BasicAuthentication|null
     */
    public function getBasicAuthentication()
    {
        return $this->readOneof(1);
    }

    public function hasBasicAuthentication()
    {
        return $this->hasOneof(1);
    }

    /**
     * Optional. Basic authentication with username and password.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GenericHTTPEndpointConfig.BasicAuthentication basic_authentication = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BasicAuthentication $var
     * @return $this
     */
    public function setBasicAuthentication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BasicAuthentication::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Optional. Bearer token authentication with a token.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GenericHTTPEndpointConfig.BearerTokenAuthentication bearer_token_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BearerTokenAuthentication|null
     */
    public function getBearerTokenAuthentication()
    {
        return $this->readOneof(2);
    }

    public function hasBearerTokenAuthentication()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. Bearer token authentication with a token.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GenericHTTPEndpointConfig.BearerTokenAuthentication bearer_token_authentication = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BearerTokenAuthentication $var
     * @return $this
     */
    public function setBearerTokenAuthentication($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\GenericHTTPEndpointConfig\BearerTokenAuthentication::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Required. Immutable. The service provider's https endpoint.
     *
     * Generated from protobuf field <code>string host_uri = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getHostUri()
    {
        return $this->host_uri;
    }

    /**
     * Required. Immutable. The service provider's https endpoint.
     *
     * Generated from protobuf field <code>string host_uri = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setHostUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->host_uri = $var;

        return $this;
    }

    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a HTTP service provider. This should only be set if the Http service
     * provider is hosted on-premises and not reachable by public internet. If
     * this field is left empty, calls to the HTTP service provider will be made
     * over the public internet.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig|null
     */
    public function getServiceDirectoryConfig()
    {
        return $this->service_directory_config;
    }

    public function hasServiceDirectoryConfig()
    {
        return isset($this->service_directory_config);
    }

    public function clearServiceDirectoryConfig()
    {
        unset($this->service_directory_config);
    }

    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a HTTP service provider. This should only be set if the Http service
     * provider is hosted on-premises and not reachable by public internet. If
     * this field is left empty, calls to the HTTP service provider will be made
     * over the public internet.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig $var
     * @return $this
     */
    public function setServiceDirectoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig::class);
        $this->service_directory_config = $var;

        return $this;
    }

    /**
     * Optional. The SSL certificate to use for requests to the HTTP service
     * provider.
     *
     * Generated from protobuf field <code>string ssl_ca_certificate = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSslCaCertificate()
    {
        return $this->ssl_ca_certificate;
    }

    /**
     * Optional. The SSL certificate to use for requests to the HTTP service
     * provider.
     *
     * Generated from protobuf field <code>string ssl_ca_certificate = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSslCaCertificate($var)
    {
        GPBUtil::checkString($var, True);
        $this->ssl_ca_certificate = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getAuthentication()
    {
        return $this->whichOneof("authentication");
    }

}

