<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/developerconnect/v1/insights_config.proto

namespace Google\Cloud\DeveloperConnect\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The DeploymentEvent resource represents the deployment of the artifact within
 * the InsightsConfig resource.
 *
 * Generated from protobuf message <code>google.cloud.developerconnect.v1.DeploymentEvent</code>
 */
class DeploymentEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the DeploymentEvent. This name is provided by
     * Developer Connect insights. Format:
     * projects/{project}/locations/{location}/insightsConfigs/{insights_config}/deploymentEvents/{uuid}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The create time of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The update time of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The runtime configurations where the DeploymentEvent happened.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.RuntimeConfig runtime_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $runtime_config = null;
    /**
     * Output only. The runtime assigned URI of the DeploymentEvent.
     * For GKE, this is the fully qualified replica set uri.
     * e.g.
     * container.googleapis.com/projects/{project}/locations/{location}/clusters/{cluster}/k8s/namespaces/{namespace}/apps/replicasets/{replica-set-id}
     * For Cloud Run, this is the revision name.
     *
     * Generated from protobuf field <code>string runtime_deployment_uri = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $runtime_deployment_uri = '';
    /**
     * Output only. The state of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.DeploymentEvent.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The artifact deployments of the DeploymentEvent. Each artifact
     * deployment contains the artifact uri and the runtime configuration uri. For
     * GKE, this would be all the containers images that are deployed in the pod.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.ArtifactDeployment artifact_deployments = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $artifact_deployments;
    /**
     * Output only. The time at which the DeploymentEvent was deployed.
     * This would be the min of all ArtifactDeployment deploy_times.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deploy_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deploy_time = null;
    /**
     * Output only. The time at which the DeploymentEvent was undeployed, all
     * artifacts are considered undeployed once this time is set. This would be
     * the max of all ArtifactDeployment undeploy_times. If any ArtifactDeployment
     * is still active (i.e. does not have an undeploy_time), this field will be
     * empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp undeploy_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $undeploy_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the DeploymentEvent. This name is provided by
     *           Developer Connect insights. Format:
     *           projects/{project}/locations/{location}/insightsConfigs/{insights_config}/deploymentEvents/{uuid}
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The create time of the DeploymentEvent.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update time of the DeploymentEvent.
     *     @type \Google\Cloud\DeveloperConnect\V1\RuntimeConfig $runtime_config
     *           Output only. The runtime configurations where the DeploymentEvent happened.
     *     @type string $runtime_deployment_uri
     *           Output only. The runtime assigned URI of the DeploymentEvent.
     *           For GKE, this is the fully qualified replica set uri.
     *           e.g.
     *           container.googleapis.com/projects/{project}/locations/{location}/clusters/{cluster}/k8s/namespaces/{namespace}/apps/replicasets/{replica-set-id}
     *           For Cloud Run, this is the revision name.
     *     @type int $state
     *           Output only. The state of the DeploymentEvent.
     *     @type array<\Google\Cloud\DeveloperConnect\V1\ArtifactDeployment>|\Google\Protobuf\Internal\RepeatedField $artifact_deployments
     *           Output only. The artifact deployments of the DeploymentEvent. Each artifact
     *           deployment contains the artifact uri and the runtime configuration uri. For
     *           GKE, this would be all the containers images that are deployed in the pod.
     *     @type \Google\Protobuf\Timestamp $deploy_time
     *           Output only. The time at which the DeploymentEvent was deployed.
     *           This would be the min of all ArtifactDeployment deploy_times.
     *     @type \Google\Protobuf\Timestamp $undeploy_time
     *           Output only. The time at which the DeploymentEvent was undeployed, all
     *           artifacts are considered undeployed once this time is set. This would be
     *           the max of all ArtifactDeployment undeploy_times. If any ArtifactDeployment
     *           is still active (i.e. does not have an undeploy_time), this field will be
     *           empty.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Developerconnect\V1\InsightsConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the DeploymentEvent. This name is provided by
     * Developer Connect insights. Format:
     * projects/{project}/locations/{location}/insightsConfigs/{insights_config}/deploymentEvents/{uuid}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the DeploymentEvent. This name is provided by
     * Developer Connect insights. Format:
     * projects/{project}/locations/{location}/insightsConfigs/{insights_config}/deploymentEvents/{uuid}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The create time of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The create time of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update time of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update time of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The runtime configurations where the DeploymentEvent happened.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.RuntimeConfig runtime_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\RuntimeConfig|null
     */
    public function getRuntimeConfig()
    {
        return $this->runtime_config;
    }

    public function hasRuntimeConfig()
    {
        return isset($this->runtime_config);
    }

    public function clearRuntimeConfig()
    {
        unset($this->runtime_config);
    }

    /**
     * Output only. The runtime configurations where the DeploymentEvent happened.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.RuntimeConfig runtime_config = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\RuntimeConfig $var
     * @return $this
     */
    public function setRuntimeConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\RuntimeConfig::class);
        $this->runtime_config = $var;

        return $this;
    }

    /**
     * Output only. The runtime assigned URI of the DeploymentEvent.
     * For GKE, this is the fully qualified replica set uri.
     * e.g.
     * container.googleapis.com/projects/{project}/locations/{location}/clusters/{cluster}/k8s/namespaces/{namespace}/apps/replicasets/{replica-set-id}
     * For Cloud Run, this is the revision name.
     *
     * Generated from protobuf field <code>string runtime_deployment_uri = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRuntimeDeploymentUri()
    {
        return $this->runtime_deployment_uri;
    }

    /**
     * Output only. The runtime assigned URI of the DeploymentEvent.
     * For GKE, this is the fully qualified replica set uri.
     * e.g.
     * container.googleapis.com/projects/{project}/locations/{location}/clusters/{cluster}/k8s/namespaces/{namespace}/apps/replicasets/{replica-set-id}
     * For Cloud Run, this is the revision name.
     *
     * Generated from protobuf field <code>string runtime_deployment_uri = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRuntimeDeploymentUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime_deployment_uri = $var;

        return $this;
    }

    /**
     * Output only. The state of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.DeploymentEvent.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the DeploymentEvent.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.DeploymentEvent.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DeveloperConnect\V1\DeploymentEvent\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The artifact deployments of the DeploymentEvent. Each artifact
     * deployment contains the artifact uri and the runtime configuration uri. For
     * GKE, this would be all the containers images that are deployed in the pod.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.ArtifactDeployment artifact_deployments = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArtifactDeployments()
    {
        return $this->artifact_deployments;
    }

    /**
     * Output only. The artifact deployments of the DeploymentEvent. Each artifact
     * deployment contains the artifact uri and the runtime configuration uri. For
     * GKE, this would be all the containers images that are deployed in the pod.
     *
     * Generated from protobuf field <code>repeated .google.cloud.developerconnect.v1.ArtifactDeployment artifact_deployments = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\DeveloperConnect\V1\ArtifactDeployment>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArtifactDeployments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DeveloperConnect\V1\ArtifactDeployment::class);
        $this->artifact_deployments = $arr;

        return $this;
    }

    /**
     * Output only. The time at which the DeploymentEvent was deployed.
     * This would be the min of all ArtifactDeployment deploy_times.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deploy_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeployTime()
    {
        return $this->deploy_time;
    }

    public function hasDeployTime()
    {
        return isset($this->deploy_time);
    }

    public function clearDeployTime()
    {
        unset($this->deploy_time);
    }

    /**
     * Output only. The time at which the DeploymentEvent was deployed.
     * This would be the min of all ArtifactDeployment deploy_times.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp deploy_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeployTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->deploy_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the DeploymentEvent was undeployed, all
     * artifacts are considered undeployed once this time is set. This would be
     * the max of all ArtifactDeployment undeploy_times. If any ArtifactDeployment
     * is still active (i.e. does not have an undeploy_time), this field will be
     * empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp undeploy_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUndeployTime()
    {
        return $this->undeploy_time;
    }

    public function hasUndeployTime()
    {
        return isset($this->undeploy_time);
    }

    public function clearUndeployTime()
    {
        unset($this->undeploy_time);
    }

    /**
     * Output only. The time at which the DeploymentEvent was undeployed, all
     * artifacts are considered undeployed once this time is set. This would be
     * the max of all ArtifactDeployment undeploy_times. If any ArtifactDeployment
     * is still active (i.e. does not have an undeploy_time), this field will be
     * empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp undeploy_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUndeployTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->undeploy_time = $var;

        return $this;
    }

}

