<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/confidentialcomputing/v1/service.proto

namespace Google\Cloud\ConfidentialComputing\V1\TpmAttestation;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Information about Platform Control Registers (PCRs) including a signature
 * over their values, which can be used for remote validation.
 *
 * Generated from protobuf message <code>google.cloud.confidentialcomputing.v1.TpmAttestation.Quote</code>
 */
class Quote extends \Google\Protobuf\Internal\Message
{
    /**
     * The hash algorithm of the PCR bank being quoted, encoded as a TPM_ALG_ID
     *
     * Generated from protobuf field <code>int32 hash_algo = 1;</code>
     */
    protected $hash_algo = 0;
    /**
     * Raw binary values of each PCRs being quoted.
     *
     * Generated from protobuf field <code>map<int32, bytes> pcr_values = 2;</code>
     */
    private $pcr_values;
    /**
     * TPM2 quote, encoded as a TPMS_ATTEST
     *
     * Generated from protobuf field <code>bytes raw_quote = 3;</code>
     */
    protected $raw_quote = '';
    /**
     * TPM2 signature, encoded as a TPMT_SIGNATURE
     *
     * Generated from protobuf field <code>bytes raw_signature = 4;</code>
     */
    protected $raw_signature = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $hash_algo
     *           The hash algorithm of the PCR bank being quoted, encoded as a TPM_ALG_ID
     *     @type array|\Google\Protobuf\Internal\MapField $pcr_values
     *           Raw binary values of each PCRs being quoted.
     *     @type string $raw_quote
     *           TPM2 quote, encoded as a TPMS_ATTEST
     *     @type string $raw_signature
     *           TPM2 signature, encoded as a TPMT_SIGNATURE
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Confidentialcomputing\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * The hash algorithm of the PCR bank being quoted, encoded as a TPM_ALG_ID
     *
     * Generated from protobuf field <code>int32 hash_algo = 1;</code>
     * @return int
     */
    public function getHashAlgo()
    {
        return $this->hash_algo;
    }

    /**
     * The hash algorithm of the PCR bank being quoted, encoded as a TPM_ALG_ID
     *
     * Generated from protobuf field <code>int32 hash_algo = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setHashAlgo($var)
    {
        GPBUtil::checkInt32($var);
        $this->hash_algo = $var;

        return $this;
    }

    /**
     * Raw binary values of each PCRs being quoted.
     *
     * Generated from protobuf field <code>map<int32, bytes> pcr_values = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getPcrValues()
    {
        return $this->pcr_values;
    }

    /**
     * Raw binary values of each PCRs being quoted.
     *
     * Generated from protobuf field <code>map<int32, bytes> pcr_values = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setPcrValues($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::INT32, \Google\Protobuf\Internal\GPBType::BYTES);
        $this->pcr_values = $arr;

        return $this;
    }

    /**
     * TPM2 quote, encoded as a TPMS_ATTEST
     *
     * Generated from protobuf field <code>bytes raw_quote = 3;</code>
     * @return string
     */
    public function getRawQuote()
    {
        return $this->raw_quote;
    }

    /**
     * TPM2 quote, encoded as a TPMS_ATTEST
     *
     * Generated from protobuf field <code>bytes raw_quote = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRawQuote($var)
    {
        GPBUtil::checkString($var, False);
        $this->raw_quote = $var;

        return $this;
    }

    /**
     * TPM2 signature, encoded as a TPMT_SIGNATURE
     *
     * Generated from protobuf field <code>bytes raw_signature = 4;</code>
     * @return string
     */
    public function getRawSignature()
    {
        return $this->raw_signature;
    }

    /**
     * TPM2 signature, encoded as a TPMT_SIGNATURE
     *
     * Generated from protobuf field <code>bytes raw_signature = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setRawSignature($var)
    {
        GPBUtil::checkString($var, False);
        $this->raw_signature = $var;

        return $this;
    }

}


