<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Interconnect Attachment (VLAN) resource.
 * You can use Interconnect attachments (VLANS) to connect your Virtual Private
 * Cloud networks to your on-premises networks through an Interconnect.
 * For more information, read
 * Creating VLAN Attachments.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.InterconnectAttachment</code>
 */
class InterconnectAttachment extends \Google\Protobuf\Internal\Message
{
    /**
     * Determines whether this Attachment will carry packets.
     * Not present for PARTNER_PROVIDER.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     */
    protected $admin_enabled = null;
    /**
     * Output only. [Output Only] URL of the AttachmentGroup that includes this Attachment.
     *
     * Generated from protobuf field <code>optional string attachment_group = 63442019;</code>
     */
    protected $attachment_group = null;
    /**
     * Provisioned bandwidth capacity for the interconnect attachment. For
     * attachments of type DEDICATED, the user can set the bandwidth.
     * For attachments of type PARTNER, the Google Partner that is operating
     * the interconnect must set the bandwidth.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
     * and can take one of the following values:
     *    - BPS_50M: 50 Mbit/s
     *    - BPS_100M: 100 Mbit/s
     *    - BPS_200M: 200 Mbit/s
     *    - BPS_300M: 300 Mbit/s
     *    - BPS_400M: 400 Mbit/s
     *    - BPS_500M: 500 Mbit/s
     *    - BPS_1G: 1 Gbit/s
     *    - BPS_2G: 2 Gbit/s
     *    - BPS_5G: 5 Gbit/s
     *    - BPS_10G: 10 Gbit/s
     *    - BPS_20G: 20 Gbit/s
     *    - BPS_50G: 50 Gbit/s
     *    - BPS_100G: 100 Gbit/s
     *    - BPS_400G: 400 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string bandwidth = 181715121;</code>
     */
    protected $bandwidth = null;
    /**
     * Single IPv4 address + prefix length to be configured on the cloud router
     * interface for this interconnect attachment.
     *    - Both candidate_cloud_router_ip_address and
     *    candidate_customer_router_ip_address fields must be set or both must be
     *    unset.
     *    - Prefix length of both candidate_cloud_router_ip_address and
     *    candidate_customer_router_ip_address must be the same.
     *    - Max prefix length is 31.
     *
     * Generated from protobuf field <code>optional string candidate_cloud_router_ip_address = 311379276;</code>
     */
    protected $candidate_cloud_router_ip_address = null;
    /**
     * Single IPv6 address + prefix length to be configured on the cloud router
     * interface for this interconnect attachment.
     *    - Both candidate_cloud_router_ipv6_address and
     *    candidate_customer_router_ipv6_address fields must be set or both must be
     *    unset.
     *    - Prefix length of both candidate_cloud_router_ipv6_address and
     *    candidate_customer_router_ipv6_address must be the same.
     *    - Max prefix length is 126.
     *
     * Generated from protobuf field <code>optional string candidate_cloud_router_ipv6_address = 417499660;</code>
     */
    protected $candidate_cloud_router_ipv6_address = null;
    /**
     * Single IPv4 address + prefix length to be configured on the customer router
     * interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string candidate_customer_router_ip_address = 339113389;</code>
     */
    protected $candidate_customer_router_ip_address = null;
    /**
     * Single IPv6 address + prefix length to be configured on the customer router
     * interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string candidate_customer_router_ipv6_address = 226436653;</code>
     */
    protected $candidate_customer_router_ipv6_address = null;
    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     */
    private $candidate_ipv6_subnets;
    /**
     * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation
     * of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
     * All prefixes must be within link-local address space (169.254.0.0/16) and
     * must be /29 or shorter (/28, /27, etc). Google will attempt to select an
     * unused /29 from the supplied candidate prefix(es). The request will fail if
     * all possible /29s are in use on Google's edge. If not supplied, Google will
     * randomly select an unused /29 from all of link-local space.
     *
     * Generated from protobuf field <code>repeated string candidate_subnets = 237842938;</code>
     */
    private $candidate_subnets;
    /**
     * Output only. [Output Only] IPv4 address + prefix length to be configured on Cloud Router
     * Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string cloud_router_ip_address = 287392776;</code>
     */
    protected $cloud_router_ip_address = null;
    /**
     * Output only. [Output Only] IPv6 address + prefix length to be configured on Cloud
     * Router Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string cloud_router_ipv6_address = 451922376;</code>
     */
    protected $cloud_router_ipv6_address = null;
    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     */
    protected $cloud_router_ipv6_interface_id = null;
    /**
     * Output only. [Output Only] Constraints for this attachment, if any. The attachment does
     * not work if these constraints are not met.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;</code>
     */
    protected $configuration_constraints = null;
    /**
     * Output only. [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    protected $creation_timestamp = null;
    /**
     * Output only. [Output Only] IPv4 address + prefix length to be configured on the customer
     * router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string customer_router_ip_address = 332475761;</code>
     */
    protected $customer_router_ip_address = null;
    /**
     * Output only. [Output Only] IPv6 address + prefix length to be configured on the
     * customer router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string customer_router_ipv6_address = 290127089;</code>
     */
    protected $customer_router_ipv6_address = null;
    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     */
    protected $customer_router_ipv6_interface_id = null;
    /**
     * Output only. [Output Only] Dataplane version for this InterconnectAttachment. This
     * field is only present for Dataplane version 2 and higher. Absence of this
     * field in the API output indicates that the Dataplane is version 1.
     *
     * Generated from protobuf field <code>optional int32 dataplane_version = 34920075;</code>
     */
    protected $dataplane_version = null;
    /**
     * An optional description of this resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    protected $description = null;
    /**
     * Input only. Desired availability domain for the attachment. Only available for type
     * PARTNER, at creation time, and can take one of the following values:
     *    - AVAILABILITY_DOMAIN_ANY
     *    - AVAILABILITY_DOMAIN_1
     *    - AVAILABILITY_DOMAIN_2
     * For improved reliability, customers should configure a pair of attachments,
     * one per availability domain. The selected availability domain will be
     * provided to the Partner via the pairing key, so that the provisioned
     * circuit will lie in the specified domain. If not specified, the value will
     * default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string edge_availability_domain = 71289510;</code>
     */
    protected $edge_availability_domain = null;
    /**
     * Indicates the user-supplied encryption option of this VLAN attachment
     * (interconnectAttachment). Can only be specified at attachment creation
     * for PARTNER or DEDICATED attachments.
     * Possible values are:
     *    - NONE - This is the default value, which means that the
     *    VLAN attachment carries unencrypted traffic. VMs are able to send
     *    traffic to, or receive traffic from, such a VLAN attachment.
     *    - IPSEC - The VLAN attachment carries only encrypted
     *    traffic that is encrypted by an IPsec device, such as an HA VPN gateway or
     *    third-party IPsec VPN. VMs cannot directly send traffic to, or receive
     *    traffic from, such a VLAN attachment. To use *HA VPN over Cloud
     *    Interconnect*, the VLAN attachment must be created with this
     *    option.
     * Check the Encryption enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string encryption = 97980291;</code>
     */
    protected $encryption = null;
    /**
     * Output only. [Output Only] Google reference ID, to be used when raising support tickets
     * with Google or otherwise to debug backend connectivity issues.
     * [Deprecated] This field is not used.
     *
     * Generated from protobuf field <code>optional string google_reference_id = 534944469;</code>
     */
    protected $google_reference_id = null;
    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    protected $id = null;
    /**
     * URL of the underlying Interconnect object that this attachment's traffic
     * will traverse through.
     *
     * Generated from protobuf field <code>optional string interconnect = 224601230;</code>
     */
    protected $interconnect = null;
    /**
     * A list of URLs of addresses that have been reserved for the VLAN
     * attachment. Used only for the VLAN attachment that has the encryption
     * option as IPSEC. The addresses must be regional internal IP address ranges.
     * When creating an HA VPN gateway over the VLAN attachment, if the attachment
     * is configured to use a regional internal IP address, then the VPN gateway's
     * IP address is allocated from the IP address range specified here. For
     * example, if the HA VPN gateway's interface 0 is paired to this VLAN
     * attachment, then a regional internal IP address for the VPN gateway
     * interface 0 will be allocated from the IP address specified for this
     * VLAN attachment.
     * If this field is not specified when creating the VLAN attachment, then
     * later on when creating an HA VPN gateway on this VLAN attachment, the HA
     * VPN gateway's IP address is allocated from the regional external IP address
     * pool.
     *
     * Generated from protobuf field <code>repeated string ipsec_internal_addresses = 407648565;</code>
     */
    private $ipsec_internal_addresses;
    /**
     * Output only. [Output Only] Type of the resource. Alwayscompute#interconnectAttachment for interconnect attachments.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    protected $kind = null;
    /**
     * L2 Interconnect Attachment related config. This field is required if the
     * type is L2_DEDICATED.
     * The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad)
     * within L2 packets are mapped to the destination appliances IP addresses.
     * The packet is then encapsulated with the appliance IP address and sent to
     * the edge appliance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentL2Forwarding l2_forwarding = 84784022;</code>
     */
    protected $l2_forwarding = null;
    /**
     * A fingerprint for the labels being applied to this InterconnectAttachment,
     * which is essentially a hash of the labels set used for optimistic locking.
     * The fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels,
     * otherwise the request will fail with error412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to
     * retrieve an InterconnectAttachment.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     */
    protected $label_fingerprint = null;
    /**
     * Labels for this resource. These can only be added or modified by thesetLabels method. Each label key/value pair must comply withRFC1035.
     * Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     */
    private $labels;
    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this
     * interconnect attachment.
     * Valid values are 1440, 1460, 1500, and 8896. If not specified,
     * the value will default to 1440.
     *
     * Generated from protobuf field <code>optional int32 mtu = 108462;</code>
     */
    protected $mtu = null;
    /**
     * Name of the resource. Provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    protected $name = null;
    /**
     * Output only. [Output Only] The current status of whether or not this interconnect
     * attachment is functional, which can take one of the following values:
     *    - OS_ACTIVE: The attachment has been turned up and is ready to
     *    use.
     *    - OS_UNPROVISIONED: The attachment is not ready to use yet,
     *    because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string operational_status = 201070847;</code>
     */
    protected $operational_status = null;
    /**
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not
     * present for DEDICATED].
     * The opaque identifier of a PARTNER attachment used to initiate
     * provisioning with a selected partner.
     * Of the form "XXXXX/region/domain"
     *
     * Generated from protobuf field <code>optional string pairing_key = 439695464;</code>
     */
    protected $pairing_key = null;
    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentParams params = 78313862;</code>
     */
    protected $params = null;
    /**
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they
     * configured BGP on behalf of the customer.
     * Output only for PARTNER type, input only for PARTNER_PROVIDER, not
     * available for DEDICATED.
     *
     * Generated from protobuf field <code>optional int64 partner_asn = 438166149;</code>
     */
    protected $partner_asn = null;
    /**
     * Informational metadata about Partner attachments from Partners to display
     * to customers.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER, not
     * available for DEDICATED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;</code>
     */
    protected $partner_metadata = null;
    /**
     * Output only. [Output Only] Information specific to an InterconnectAttachment.
     * This property is populated if the interconnect that
     * this is attached to is of type DEDICATED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;</code>
     */
    protected $private_interconnect_info = null;
    /**
     * Output only. [Output Only] URL of the region where the regional interconnect attachment
     * resides.
     * You must specify this field as part of the HTTP request URL. It is
     * not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     */
    protected $region = null;
    /**
     * Output only. [Output Only]
     * If the attachment is on a Cross-Cloud Interconnect connection, this field
     * contains the interconnect's remote location service provider. Example
     * values: "Amazon Web Services" "Microsoft Azure".
     * The field is set only for attachments on Cross-Cloud Interconnect
     * connections. Its value is copied from the InterconnectRemoteLocation
     * remoteService field.
     *
     * Generated from protobuf field <code>optional string remote_service = 391954364;</code>
     */
    protected $remote_service = null;
    /**
     * URL of the Cloud Router to be used for dynamic routing. This router must be
     * in the same region as this InterconnectAttachment. The
     * InterconnectAttachment will automatically connect the Interconnect to the
     * network & region within which the Cloud Router is configured.
     *
     * Generated from protobuf field <code>optional string router = 148608841;</code>
     */
    protected $router = null;
    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     */
    protected $satisfies_pzs = null;
    /**
     * Output only. [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    protected $self_link = null;
    /**
     * The stack type for this interconnect attachment to identify whether the
     * IPv6 feature is enabled or not. If not specified, IPV4_ONLY
     * will be used.
     * This field can be both set at interconnect attachments creation and
     * update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string stack_type = 425908881;</code>
     */
    protected $stack_type = null;
    /**
     * Output only. [Output Only] The current state of this attachment's functionality.
     * Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE,
     * PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values
     * PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used
     * for only PARTNER and PARTNER_PROVIDER interconnect attachments.
     * This state can take one of the following values:
     *    - ACTIVE: The attachment has been turned up and is ready to use.
     *    - UNPROVISIONED: The attachment is not ready to use yet, because turnup
     *    is not complete.
     *    - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet
     *    been configured on the Partner side.
     *    - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of
     *    provisioning after a PARTNER_PROVIDER attachment was created that
     *    references it.
     *    - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER
     *    attachment that is waiting for a customer to activate it.
     *    - DEFUNCT:
     *    The attachment was deleted externally and is no longer functional. This
     *    could be because the associated Interconnect was removed, or because the
     *    other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string state = 109757585;</code>
     */
    protected $state = null;
    /**
     * Input only. Length of the IPv4 subnet mask.
     * Allowed values:
     *     - 29 (default)
     *     - 30
     * The default value is 29, except for Cross-Cloud Interconnect
     * connections that use an InterconnectRemoteLocation with a
     * constraints.subnetLengthRange.min equal to 30. For example,
     * connections that use an Azure remote location fall into this
     * category. In these cases, the default value is 30, and requesting
     * 29 returns an error.
     * Where both 29 and 30 are allowed, 29 is preferred, because it gives
     * Google Cloud Support more debugging visibility.
     *
     * Generated from protobuf field <code>optional int32 subnet_length = 279831048;</code>
     */
    protected $subnet_length = null;
    /**
     * The type of interconnect attachment this is, which can take one of the
     * following values:
     *    - DEDICATED: an attachment to a Dedicated Interconnect.
     *    - PARTNER: an attachment to a Partner Interconnect, created by the
     *    customer.
     *    - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by
     *    the partner.
     * - L2_DEDICATED: a L2 attachment to a Dedicated Interconnect.
     * Check the Type enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string type = 3575610;</code>
     */
    protected $type = null;
    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093.
     * Only specified at creation time.
     *
     * Generated from protobuf field <code>optional int32 vlan_tag8021q = 119927836;</code>
     */
    protected $vlan_tag8021q = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $admin_enabled
     *           Determines whether this Attachment will carry packets.
     *           Not present for PARTNER_PROVIDER.
     *     @type string $attachment_group
     *           Output only. [Output Only] URL of the AttachmentGroup that includes this Attachment.
     *     @type string $bandwidth
     *           Provisioned bandwidth capacity for the interconnect attachment. For
     *           attachments of type DEDICATED, the user can set the bandwidth.
     *           For attachments of type PARTNER, the Google Partner that is operating
     *           the interconnect must set the bandwidth.
     *           Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
     *           and can take one of the following values:
     *              - BPS_50M: 50 Mbit/s
     *              - BPS_100M: 100 Mbit/s
     *              - BPS_200M: 200 Mbit/s
     *              - BPS_300M: 300 Mbit/s
     *              - BPS_400M: 400 Mbit/s
     *              - BPS_500M: 500 Mbit/s
     *              - BPS_1G: 1 Gbit/s
     *              - BPS_2G: 2 Gbit/s
     *              - BPS_5G: 5 Gbit/s
     *              - BPS_10G: 10 Gbit/s
     *              - BPS_20G: 20 Gbit/s
     *              - BPS_50G: 50 Gbit/s
     *              - BPS_100G: 100 Gbit/s
     *              - BPS_400G: 400 Gbit/s
     *           Check the Bandwidth enum for the list of possible values.
     *     @type string $candidate_cloud_router_ip_address
     *           Single IPv4 address + prefix length to be configured on the cloud router
     *           interface for this interconnect attachment.
     *              - Both candidate_cloud_router_ip_address and
     *              candidate_customer_router_ip_address fields must be set or both must be
     *              unset.
     *              - Prefix length of both candidate_cloud_router_ip_address and
     *              candidate_customer_router_ip_address must be the same.
     *              - Max prefix length is 31.
     *     @type string $candidate_cloud_router_ipv6_address
     *           Single IPv6 address + prefix length to be configured on the cloud router
     *           interface for this interconnect attachment.
     *              - Both candidate_cloud_router_ipv6_address and
     *              candidate_customer_router_ipv6_address fields must be set or both must be
     *              unset.
     *              - Prefix length of both candidate_cloud_router_ipv6_address and
     *              candidate_customer_router_ipv6_address must be the same.
     *              - Max prefix length is 126.
     *     @type string $candidate_customer_router_ip_address
     *           Single IPv4 address + prefix length to be configured on the customer router
     *           interface for this interconnect attachment.
     *     @type string $candidate_customer_router_ipv6_address
     *           Single IPv6 address + prefix length to be configured on the customer router
     *           interface for this interconnect attachment.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $candidate_ipv6_subnets
     *           This field is not available.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $candidate_subnets
     *           Input only. Up to 16 candidate prefixes that can be used to restrict the allocation
     *           of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
     *           All prefixes must be within link-local address space (169.254.0.0/16) and
     *           must be /29 or shorter (/28, /27, etc). Google will attempt to select an
     *           unused /29 from the supplied candidate prefix(es). The request will fail if
     *           all possible /29s are in use on Google's edge. If not supplied, Google will
     *           randomly select an unused /29 from all of link-local space.
     *     @type string $cloud_router_ip_address
     *           Output only. [Output Only] IPv4 address + prefix length to be configured on Cloud Router
     *           Interface for this interconnect attachment.
     *     @type string $cloud_router_ipv6_address
     *           Output only. [Output Only] IPv6 address + prefix length to be configured on Cloud
     *           Router Interface for this interconnect attachment.
     *     @type string $cloud_router_ipv6_interface_id
     *           This field is not available.
     *     @type \Google\Cloud\Compute\V1\InterconnectAttachmentConfigurationConstraints $configuration_constraints
     *           Output only. [Output Only] Constraints for this attachment, if any. The attachment does
     *           not work if these constraints are not met.
     *     @type string $creation_timestamp
     *           Output only. [Output Only] Creation timestamp inRFC3339
     *           text format.
     *     @type string $customer_router_ip_address
     *           Output only. [Output Only] IPv4 address + prefix length to be configured on the customer
     *           router subinterface for this interconnect attachment.
     *     @type string $customer_router_ipv6_address
     *           Output only. [Output Only] IPv6 address + prefix length to be configured on the
     *           customer router subinterface for this interconnect attachment.
     *     @type string $customer_router_ipv6_interface_id
     *           This field is not available.
     *     @type int $dataplane_version
     *           Output only. [Output Only] Dataplane version for this InterconnectAttachment. This
     *           field is only present for Dataplane version 2 and higher. Absence of this
     *           field in the API output indicates that the Dataplane is version 1.
     *     @type string $description
     *           An optional description of this resource.
     *     @type string $edge_availability_domain
     *           Input only. Desired availability domain for the attachment. Only available for type
     *           PARTNER, at creation time, and can take one of the following values:
     *              - AVAILABILITY_DOMAIN_ANY
     *              - AVAILABILITY_DOMAIN_1
     *              - AVAILABILITY_DOMAIN_2
     *           For improved reliability, customers should configure a pair of attachments,
     *           one per availability domain. The selected availability domain will be
     *           provided to the Partner via the pairing key, so that the provisioned
     *           circuit will lie in the specified domain. If not specified, the value will
     *           default to AVAILABILITY_DOMAIN_ANY.
     *           Check the EdgeAvailabilityDomain enum for the list of possible values.
     *     @type string $encryption
     *           Indicates the user-supplied encryption option of this VLAN attachment
     *           (interconnectAttachment). Can only be specified at attachment creation
     *           for PARTNER or DEDICATED attachments.
     *           Possible values are:
     *              - NONE - This is the default value, which means that the
     *              VLAN attachment carries unencrypted traffic. VMs are able to send
     *              traffic to, or receive traffic from, such a VLAN attachment.
     *              - IPSEC - The VLAN attachment carries only encrypted
     *              traffic that is encrypted by an IPsec device, such as an HA VPN gateway or
     *              third-party IPsec VPN. VMs cannot directly send traffic to, or receive
     *              traffic from, such a VLAN attachment. To use *HA VPN over Cloud
     *              Interconnect*, the VLAN attachment must be created with this
     *              option.
     *           Check the Encryption enum for the list of possible values.
     *     @type string $google_reference_id
     *           Output only. [Output Only] Google reference ID, to be used when raising support tickets
     *           with Google or otherwise to debug backend connectivity issues.
     *           [Deprecated] This field is not used.
     *     @type int|string $id
     *           Output only. [Output Only] The unique identifier for the resource. This identifier is
     *           defined by the server.
     *     @type string $interconnect
     *           URL of the underlying Interconnect object that this attachment's traffic
     *           will traverse through.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ipsec_internal_addresses
     *           A list of URLs of addresses that have been reserved for the VLAN
     *           attachment. Used only for the VLAN attachment that has the encryption
     *           option as IPSEC. The addresses must be regional internal IP address ranges.
     *           When creating an HA VPN gateway over the VLAN attachment, if the attachment
     *           is configured to use a regional internal IP address, then the VPN gateway's
     *           IP address is allocated from the IP address range specified here. For
     *           example, if the HA VPN gateway's interface 0 is paired to this VLAN
     *           attachment, then a regional internal IP address for the VPN gateway
     *           interface 0 will be allocated from the IP address specified for this
     *           VLAN attachment.
     *           If this field is not specified when creating the VLAN attachment, then
     *           later on when creating an HA VPN gateway on this VLAN attachment, the HA
     *           VPN gateway's IP address is allocated from the regional external IP address
     *           pool.
     *     @type string $kind
     *           Output only. [Output Only] Type of the resource. Alwayscompute#interconnectAttachment for interconnect attachments.
     *     @type \Google\Cloud\Compute\V1\InterconnectAttachmentL2Forwarding $l2_forwarding
     *           L2 Interconnect Attachment related config. This field is required if the
     *           type is L2_DEDICATED.
     *           The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad)
     *           within L2 packets are mapped to the destination appliances IP addresses.
     *           The packet is then encapsulated with the appliance IP address and sent to
     *           the edge appliance.
     *     @type string $label_fingerprint
     *           A fingerprint for the labels being applied to this InterconnectAttachment,
     *           which is essentially a hash of the labels set used for optimistic locking.
     *           The fingerprint is initially generated by Compute Engine and changes after
     *           every request to modify or update labels. You must always provide an
     *           up-to-date fingerprint hash in order to update or change labels,
     *           otherwise the request will fail with error412 conditionNotMet.
     *           To see the latest fingerprint, make a get() request to
     *           retrieve an InterconnectAttachment.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels for this resource. These can only be added or modified by thesetLabels method. Each label key/value pair must comply withRFC1035.
     *           Label values may be empty.
     *     @type int $mtu
     *           Maximum Transmission Unit (MTU), in bytes, of packets passing through this
     *           interconnect attachment.
     *           Valid values are 1440, 1460, 1500, and 8896. If not specified,
     *           the value will default to 1440.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created.
     *           The name must be 1-63 characters long, and comply withRFC1035.
     *           Specifically, the name must be 1-63 characters long and match the regular
     *           expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     *           character must be a lowercase letter, and all following characters must
     *           be a dash, lowercase letter, or digit, except the last character, which
     *           cannot be a dash.
     *     @type string $operational_status
     *           Output only. [Output Only] The current status of whether or not this interconnect
     *           attachment is functional, which can take one of the following values:
     *              - OS_ACTIVE: The attachment has been turned up and is ready to
     *              use.
     *              - OS_UNPROVISIONED: The attachment is not ready to use yet,
     *              because turnup is not complete.
     *           Check the OperationalStatus enum for the list of possible values.
     *     @type string $pairing_key
     *           [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not
     *           present for DEDICATED].
     *           The opaque identifier of a PARTNER attachment used to initiate
     *           provisioning with a selected partner.
     *           Of the form "XXXXX/region/domain"
     *     @type \Google\Cloud\Compute\V1\InterconnectAttachmentParams $params
     *           Input only. [Input Only] Additional params passed with the request, but not persisted
     *           as part of resource payload.
     *     @type int|string $partner_asn
     *           Optional BGP ASN for the router supplied by a Layer 3 Partner if they
     *           configured BGP on behalf of the customer.
     *           Output only for PARTNER type, input only for PARTNER_PROVIDER, not
     *           available for DEDICATED.
     *     @type \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata $partner_metadata
     *           Informational metadata about Partner attachments from Partners to display
     *           to customers.
     *           Output only for PARTNER type, mutable for PARTNER_PROVIDER, not
     *           available for DEDICATED.
     *     @type \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo $private_interconnect_info
     *           Output only. [Output Only] Information specific to an InterconnectAttachment.
     *           This property is populated if the interconnect that
     *           this is attached to is of type DEDICATED.
     *     @type string $region
     *           Output only. [Output Only] URL of the region where the regional interconnect attachment
     *           resides.
     *           You must specify this field as part of the HTTP request URL. It is
     *           not settable as a field in the request body.
     *     @type string $remote_service
     *           Output only. [Output Only]
     *           If the attachment is on a Cross-Cloud Interconnect connection, this field
     *           contains the interconnect's remote location service provider. Example
     *           values: "Amazon Web Services" "Microsoft Azure".
     *           The field is set only for attachments on Cross-Cloud Interconnect
     *           connections. Its value is copied from the InterconnectRemoteLocation
     *           remoteService field.
     *     @type string $router
     *           URL of the Cloud Router to be used for dynamic routing. This router must be
     *           in the same region as this InterconnectAttachment. The
     *           InterconnectAttachment will automatically connect the Interconnect to the
     *           network & region within which the Cloud Router is configured.
     *     @type bool $satisfies_pzs
     *           Output only. [Output Only] Reserved for future use.
     *     @type string $self_link
     *           Output only. [Output Only] Server-defined URL for the resource.
     *     @type string $stack_type
     *           The stack type for this interconnect attachment to identify whether the
     *           IPv6 feature is enabled or not. If not specified, IPV4_ONLY
     *           will be used.
     *           This field can be both set at interconnect attachments creation and
     *           update interconnect attachment operations.
     *           Check the StackType enum for the list of possible values.
     *     @type string $state
     *           Output only. [Output Only] The current state of this attachment's functionality.
     *           Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE,
     *           PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values
     *           PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used
     *           for only PARTNER and PARTNER_PROVIDER interconnect attachments.
     *           This state can take one of the following values:
     *              - ACTIVE: The attachment has been turned up and is ready to use.
     *              - UNPROVISIONED: The attachment is not ready to use yet, because turnup
     *              is not complete.
     *              - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet
     *              been configured on the Partner side.
     *              - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of
     *              provisioning after a PARTNER_PROVIDER attachment was created that
     *              references it.
     *              - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER
     *              attachment that is waiting for a customer to activate it.
     *              - DEFUNCT:
     *              The attachment was deleted externally and is no longer functional. This
     *              could be because the associated Interconnect was removed, or because the
     *              other side of a Partner attachment was deleted.
     *           Check the State enum for the list of possible values.
     *     @type int $subnet_length
     *           Input only. Length of the IPv4 subnet mask.
     *           Allowed values:
     *               - 29 (default)
     *               - 30
     *           The default value is 29, except for Cross-Cloud Interconnect
     *           connections that use an InterconnectRemoteLocation with a
     *           constraints.subnetLengthRange.min equal to 30. For example,
     *           connections that use an Azure remote location fall into this
     *           category. In these cases, the default value is 30, and requesting
     *           29 returns an error.
     *           Where both 29 and 30 are allowed, 29 is preferred, because it gives
     *           Google Cloud Support more debugging visibility.
     *     @type string $type
     *           The type of interconnect attachment this is, which can take one of the
     *           following values:
     *              - DEDICATED: an attachment to a Dedicated Interconnect.
     *              - PARTNER: an attachment to a Partner Interconnect, created by the
     *              customer.
     *              - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by
     *              the partner.
     *           - L2_DEDICATED: a L2 attachment to a Dedicated Interconnect.
     *           Check the Type enum for the list of possible values.
     *     @type int $vlan_tag8021q
     *           The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093.
     *           Only specified at creation time.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Determines whether this Attachment will carry packets.
     * Not present for PARTNER_PROVIDER.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     * @return bool
     */
    public function getAdminEnabled()
    {
        return isset($this->admin_enabled) ? $this->admin_enabled : false;
    }

    public function hasAdminEnabled()
    {
        return isset($this->admin_enabled);
    }

    public function clearAdminEnabled()
    {
        unset($this->admin_enabled);
    }

    /**
     * Determines whether this Attachment will carry packets.
     * Not present for PARTNER_PROVIDER.
     *
     * Generated from protobuf field <code>optional bool admin_enabled = 445675089;</code>
     * @param bool $var
     * @return $this
     */
    public function setAdminEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->admin_enabled = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] URL of the AttachmentGroup that includes this Attachment.
     *
     * Generated from protobuf field <code>optional string attachment_group = 63442019;</code>
     * @return string
     */
    public function getAttachmentGroup()
    {
        return isset($this->attachment_group) ? $this->attachment_group : '';
    }

    public function hasAttachmentGroup()
    {
        return isset($this->attachment_group);
    }

    public function clearAttachmentGroup()
    {
        unset($this->attachment_group);
    }

    /**
     * Output only. [Output Only] URL of the AttachmentGroup that includes this Attachment.
     *
     * Generated from protobuf field <code>optional string attachment_group = 63442019;</code>
     * @param string $var
     * @return $this
     */
    public function setAttachmentGroup($var)
    {
        GPBUtil::checkString($var, True);
        $this->attachment_group = $var;

        return $this;
    }

    /**
     * Provisioned bandwidth capacity for the interconnect attachment. For
     * attachments of type DEDICATED, the user can set the bandwidth.
     * For attachments of type PARTNER, the Google Partner that is operating
     * the interconnect must set the bandwidth.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
     * and can take one of the following values:
     *    - BPS_50M: 50 Mbit/s
     *    - BPS_100M: 100 Mbit/s
     *    - BPS_200M: 200 Mbit/s
     *    - BPS_300M: 300 Mbit/s
     *    - BPS_400M: 400 Mbit/s
     *    - BPS_500M: 500 Mbit/s
     *    - BPS_1G: 1 Gbit/s
     *    - BPS_2G: 2 Gbit/s
     *    - BPS_5G: 5 Gbit/s
     *    - BPS_10G: 10 Gbit/s
     *    - BPS_20G: 20 Gbit/s
     *    - BPS_50G: 50 Gbit/s
     *    - BPS_100G: 100 Gbit/s
     *    - BPS_400G: 400 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string bandwidth = 181715121;</code>
     * @return string
     */
    public function getBandwidth()
    {
        return isset($this->bandwidth) ? $this->bandwidth : '';
    }

    public function hasBandwidth()
    {
        return isset($this->bandwidth);
    }

    public function clearBandwidth()
    {
        unset($this->bandwidth);
    }

    /**
     * Provisioned bandwidth capacity for the interconnect attachment. For
     * attachments of type DEDICATED, the user can set the bandwidth.
     * For attachments of type PARTNER, the Google Partner that is operating
     * the interconnect must set the bandwidth.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
     * and can take one of the following values:
     *    - BPS_50M: 50 Mbit/s
     *    - BPS_100M: 100 Mbit/s
     *    - BPS_200M: 200 Mbit/s
     *    - BPS_300M: 300 Mbit/s
     *    - BPS_400M: 400 Mbit/s
     *    - BPS_500M: 500 Mbit/s
     *    - BPS_1G: 1 Gbit/s
     *    - BPS_2G: 2 Gbit/s
     *    - BPS_5G: 5 Gbit/s
     *    - BPS_10G: 10 Gbit/s
     *    - BPS_20G: 20 Gbit/s
     *    - BPS_50G: 50 Gbit/s
     *    - BPS_100G: 100 Gbit/s
     *    - BPS_400G: 400 Gbit/s
     * Check the Bandwidth enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string bandwidth = 181715121;</code>
     * @param string $var
     * @return $this
     */
    public function setBandwidth($var)
    {
        GPBUtil::checkString($var, True);
        $this->bandwidth = $var;

        return $this;
    }

    /**
     * Single IPv4 address + prefix length to be configured on the cloud router
     * interface for this interconnect attachment.
     *    - Both candidate_cloud_router_ip_address and
     *    candidate_customer_router_ip_address fields must be set or both must be
     *    unset.
     *    - Prefix length of both candidate_cloud_router_ip_address and
     *    candidate_customer_router_ip_address must be the same.
     *    - Max prefix length is 31.
     *
     * Generated from protobuf field <code>optional string candidate_cloud_router_ip_address = 311379276;</code>
     * @return string
     */
    public function getCandidateCloudRouterIpAddress()
    {
        return isset($this->candidate_cloud_router_ip_address) ? $this->candidate_cloud_router_ip_address : '';
    }

    public function hasCandidateCloudRouterIpAddress()
    {
        return isset($this->candidate_cloud_router_ip_address);
    }

    public function clearCandidateCloudRouterIpAddress()
    {
        unset($this->candidate_cloud_router_ip_address);
    }

    /**
     * Single IPv4 address + prefix length to be configured on the cloud router
     * interface for this interconnect attachment.
     *    - Both candidate_cloud_router_ip_address and
     *    candidate_customer_router_ip_address fields must be set or both must be
     *    unset.
     *    - Prefix length of both candidate_cloud_router_ip_address and
     *    candidate_customer_router_ip_address must be the same.
     *    - Max prefix length is 31.
     *
     * Generated from protobuf field <code>optional string candidate_cloud_router_ip_address = 311379276;</code>
     * @param string $var
     * @return $this
     */
    public function setCandidateCloudRouterIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->candidate_cloud_router_ip_address = $var;

        return $this;
    }

    /**
     * Single IPv6 address + prefix length to be configured on the cloud router
     * interface for this interconnect attachment.
     *    - Both candidate_cloud_router_ipv6_address and
     *    candidate_customer_router_ipv6_address fields must be set or both must be
     *    unset.
     *    - Prefix length of both candidate_cloud_router_ipv6_address and
     *    candidate_customer_router_ipv6_address must be the same.
     *    - Max prefix length is 126.
     *
     * Generated from protobuf field <code>optional string candidate_cloud_router_ipv6_address = 417499660;</code>
     * @return string
     */
    public function getCandidateCloudRouterIpv6Address()
    {
        return isset($this->candidate_cloud_router_ipv6_address) ? $this->candidate_cloud_router_ipv6_address : '';
    }

    public function hasCandidateCloudRouterIpv6Address()
    {
        return isset($this->candidate_cloud_router_ipv6_address);
    }

    public function clearCandidateCloudRouterIpv6Address()
    {
        unset($this->candidate_cloud_router_ipv6_address);
    }

    /**
     * Single IPv6 address + prefix length to be configured on the cloud router
     * interface for this interconnect attachment.
     *    - Both candidate_cloud_router_ipv6_address and
     *    candidate_customer_router_ipv6_address fields must be set or both must be
     *    unset.
     *    - Prefix length of both candidate_cloud_router_ipv6_address and
     *    candidate_customer_router_ipv6_address must be the same.
     *    - Max prefix length is 126.
     *
     * Generated from protobuf field <code>optional string candidate_cloud_router_ipv6_address = 417499660;</code>
     * @param string $var
     * @return $this
     */
    public function setCandidateCloudRouterIpv6Address($var)
    {
        GPBUtil::checkString($var, True);
        $this->candidate_cloud_router_ipv6_address = $var;

        return $this;
    }

    /**
     * Single IPv4 address + prefix length to be configured on the customer router
     * interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string candidate_customer_router_ip_address = 339113389;</code>
     * @return string
     */
    public function getCandidateCustomerRouterIpAddress()
    {
        return isset($this->candidate_customer_router_ip_address) ? $this->candidate_customer_router_ip_address : '';
    }

    public function hasCandidateCustomerRouterIpAddress()
    {
        return isset($this->candidate_customer_router_ip_address);
    }

    public function clearCandidateCustomerRouterIpAddress()
    {
        unset($this->candidate_customer_router_ip_address);
    }

    /**
     * Single IPv4 address + prefix length to be configured on the customer router
     * interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string candidate_customer_router_ip_address = 339113389;</code>
     * @param string $var
     * @return $this
     */
    public function setCandidateCustomerRouterIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->candidate_customer_router_ip_address = $var;

        return $this;
    }

    /**
     * Single IPv6 address + prefix length to be configured on the customer router
     * interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string candidate_customer_router_ipv6_address = 226436653;</code>
     * @return string
     */
    public function getCandidateCustomerRouterIpv6Address()
    {
        return isset($this->candidate_customer_router_ipv6_address) ? $this->candidate_customer_router_ipv6_address : '';
    }

    public function hasCandidateCustomerRouterIpv6Address()
    {
        return isset($this->candidate_customer_router_ipv6_address);
    }

    public function clearCandidateCustomerRouterIpv6Address()
    {
        unset($this->candidate_customer_router_ipv6_address);
    }

    /**
     * Single IPv6 address + prefix length to be configured on the customer router
     * interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string candidate_customer_router_ipv6_address = 226436653;</code>
     * @param string $var
     * @return $this
     */
    public function setCandidateCustomerRouterIpv6Address($var)
    {
        GPBUtil::checkString($var, True);
        $this->candidate_customer_router_ipv6_address = $var;

        return $this;
    }

    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCandidateIpv6Subnets()
    {
        return $this->candidate_ipv6_subnets;
    }

    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>repeated string candidate_ipv6_subnets = 70682522;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCandidateIpv6Subnets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->candidate_ipv6_subnets = $arr;

        return $this;
    }

    /**
     * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation
     * of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
     * All prefixes must be within link-local address space (169.254.0.0/16) and
     * must be /29 or shorter (/28, /27, etc). Google will attempt to select an
     * unused /29 from the supplied candidate prefix(es). The request will fail if
     * all possible /29s are in use on Google's edge. If not supplied, Google will
     * randomly select an unused /29 from all of link-local space.
     *
     * Generated from protobuf field <code>repeated string candidate_subnets = 237842938;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCandidateSubnets()
    {
        return $this->candidate_subnets;
    }

    /**
     * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation
     * of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
     * All prefixes must be within link-local address space (169.254.0.0/16) and
     * must be /29 or shorter (/28, /27, etc). Google will attempt to select an
     * unused /29 from the supplied candidate prefix(es). The request will fail if
     * all possible /29s are in use on Google's edge. If not supplied, Google will
     * randomly select an unused /29 from all of link-local space.
     *
     * Generated from protobuf field <code>repeated string candidate_subnets = 237842938;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCandidateSubnets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->candidate_subnets = $arr;

        return $this;
    }

    /**
     * Output only. [Output Only] IPv4 address + prefix length to be configured on Cloud Router
     * Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string cloud_router_ip_address = 287392776;</code>
     * @return string
     */
    public function getCloudRouterIpAddress()
    {
        return isset($this->cloud_router_ip_address) ? $this->cloud_router_ip_address : '';
    }

    public function hasCloudRouterIpAddress()
    {
        return isset($this->cloud_router_ip_address);
    }

    public function clearCloudRouterIpAddress()
    {
        unset($this->cloud_router_ip_address);
    }

    /**
     * Output only. [Output Only] IPv4 address + prefix length to be configured on Cloud Router
     * Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string cloud_router_ip_address = 287392776;</code>
     * @param string $var
     * @return $this
     */
    public function setCloudRouterIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_router_ip_address = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] IPv6 address + prefix length to be configured on Cloud
     * Router Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string cloud_router_ipv6_address = 451922376;</code>
     * @return string
     */
    public function getCloudRouterIpv6Address()
    {
        return isset($this->cloud_router_ipv6_address) ? $this->cloud_router_ipv6_address : '';
    }

    public function hasCloudRouterIpv6Address()
    {
        return isset($this->cloud_router_ipv6_address);
    }

    public function clearCloudRouterIpv6Address()
    {
        unset($this->cloud_router_ipv6_address);
    }

    /**
     * Output only. [Output Only] IPv6 address + prefix length to be configured on Cloud
     * Router Interface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string cloud_router_ipv6_address = 451922376;</code>
     * @param string $var
     * @return $this
     */
    public function setCloudRouterIpv6Address($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_router_ipv6_address = $var;

        return $this;
    }

    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     * @return string
     */
    public function getCloudRouterIpv6InterfaceId()
    {
        return isset($this->cloud_router_ipv6_interface_id) ? $this->cloud_router_ipv6_interface_id : '';
    }

    public function hasCloudRouterIpv6InterfaceId()
    {
        return isset($this->cloud_router_ipv6_interface_id);
    }

    public function clearCloudRouterIpv6InterfaceId()
    {
        unset($this->cloud_router_ipv6_interface_id);
    }

    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
     * @param string $var
     * @return $this
     */
    public function setCloudRouterIpv6InterfaceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_router_ipv6_interface_id = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Constraints for this attachment, if any. The attachment does
     * not work if these constraints are not met.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectAttachmentConfigurationConstraints|null
     */
    public function getConfigurationConstraints()
    {
        return $this->configuration_constraints;
    }

    public function hasConfigurationConstraints()
    {
        return isset($this->configuration_constraints);
    }

    public function clearConfigurationConstraints()
    {
        unset($this->configuration_constraints);
    }

    /**
     * Output only. [Output Only] Constraints for this attachment, if any. The attachment does
     * not work if these constraints are not met.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectAttachmentConfigurationConstraints $var
     * @return $this
     */
    public function setConfigurationConstraints($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectAttachmentConfigurationConstraints::class);
        $this->configuration_constraints = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * Output only. [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] IPv4 address + prefix length to be configured on the customer
     * router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string customer_router_ip_address = 332475761;</code>
     * @return string
     */
    public function getCustomerRouterIpAddress()
    {
        return isset($this->customer_router_ip_address) ? $this->customer_router_ip_address : '';
    }

    public function hasCustomerRouterIpAddress()
    {
        return isset($this->customer_router_ip_address);
    }

    public function clearCustomerRouterIpAddress()
    {
        unset($this->customer_router_ip_address);
    }

    /**
     * Output only. [Output Only] IPv4 address + prefix length to be configured on the customer
     * router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string customer_router_ip_address = 332475761;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerRouterIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_router_ip_address = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] IPv6 address + prefix length to be configured on the
     * customer router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string customer_router_ipv6_address = 290127089;</code>
     * @return string
     */
    public function getCustomerRouterIpv6Address()
    {
        return isset($this->customer_router_ipv6_address) ? $this->customer_router_ipv6_address : '';
    }

    public function hasCustomerRouterIpv6Address()
    {
        return isset($this->customer_router_ipv6_address);
    }

    public function clearCustomerRouterIpv6Address()
    {
        unset($this->customer_router_ipv6_address);
    }

    /**
     * Output only. [Output Only] IPv6 address + prefix length to be configured on the
     * customer router subinterface for this interconnect attachment.
     *
     * Generated from protobuf field <code>optional string customer_router_ipv6_address = 290127089;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerRouterIpv6Address($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_router_ipv6_address = $var;

        return $this;
    }

    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     * @return string
     */
    public function getCustomerRouterIpv6InterfaceId()
    {
        return isset($this->customer_router_ipv6_interface_id) ? $this->customer_router_ipv6_interface_id : '';
    }

    public function hasCustomerRouterIpv6InterfaceId()
    {
        return isset($this->customer_router_ipv6_interface_id);
    }

    public function clearCustomerRouterIpv6InterfaceId()
    {
        unset($this->customer_router_ipv6_interface_id);
    }

    /**
     * This field is not available.
     *
     * Generated from protobuf field <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerRouterIpv6InterfaceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_router_ipv6_interface_id = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Dataplane version for this InterconnectAttachment. This
     * field is only present for Dataplane version 2 and higher. Absence of this
     * field in the API output indicates that the Dataplane is version 1.
     *
     * Generated from protobuf field <code>optional int32 dataplane_version = 34920075;</code>
     * @return int
     */
    public function getDataplaneVersion()
    {
        return isset($this->dataplane_version) ? $this->dataplane_version : 0;
    }

    public function hasDataplaneVersion()
    {
        return isset($this->dataplane_version);
    }

    public function clearDataplaneVersion()
    {
        unset($this->dataplane_version);
    }

    /**
     * Output only. [Output Only] Dataplane version for this InterconnectAttachment. This
     * field is only present for Dataplane version 2 and higher. Absence of this
     * field in the API output indicates that the Dataplane is version 1.
     *
     * Generated from protobuf field <code>optional int32 dataplane_version = 34920075;</code>
     * @param int $var
     * @return $this
     */
    public function setDataplaneVersion($var)
    {
        GPBUtil::checkInt32($var);
        $this->dataplane_version = $var;

        return $this;
    }

    /**
     * An optional description of this resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Input only. Desired availability domain for the attachment. Only available for type
     * PARTNER, at creation time, and can take one of the following values:
     *    - AVAILABILITY_DOMAIN_ANY
     *    - AVAILABILITY_DOMAIN_1
     *    - AVAILABILITY_DOMAIN_2
     * For improved reliability, customers should configure a pair of attachments,
     * one per availability domain. The selected availability domain will be
     * provided to the Partner via the pairing key, so that the provisioned
     * circuit will lie in the specified domain. If not specified, the value will
     * default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string edge_availability_domain = 71289510;</code>
     * @return string
     */
    public function getEdgeAvailabilityDomain()
    {
        return isset($this->edge_availability_domain) ? $this->edge_availability_domain : '';
    }

    public function hasEdgeAvailabilityDomain()
    {
        return isset($this->edge_availability_domain);
    }

    public function clearEdgeAvailabilityDomain()
    {
        unset($this->edge_availability_domain);
    }

    /**
     * Input only. Desired availability domain for the attachment. Only available for type
     * PARTNER, at creation time, and can take one of the following values:
     *    - AVAILABILITY_DOMAIN_ANY
     *    - AVAILABILITY_DOMAIN_1
     *    - AVAILABILITY_DOMAIN_2
     * For improved reliability, customers should configure a pair of attachments,
     * one per availability domain. The selected availability domain will be
     * provided to the Partner via the pairing key, so that the provisioned
     * circuit will lie in the specified domain. If not specified, the value will
     * default to AVAILABILITY_DOMAIN_ANY.
     * Check the EdgeAvailabilityDomain enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string edge_availability_domain = 71289510;</code>
     * @param string $var
     * @return $this
     */
    public function setEdgeAvailabilityDomain($var)
    {
        GPBUtil::checkString($var, True);
        $this->edge_availability_domain = $var;

        return $this;
    }

    /**
     * Indicates the user-supplied encryption option of this VLAN attachment
     * (interconnectAttachment). Can only be specified at attachment creation
     * for PARTNER or DEDICATED attachments.
     * Possible values are:
     *    - NONE - This is the default value, which means that the
     *    VLAN attachment carries unencrypted traffic. VMs are able to send
     *    traffic to, or receive traffic from, such a VLAN attachment.
     *    - IPSEC - The VLAN attachment carries only encrypted
     *    traffic that is encrypted by an IPsec device, such as an HA VPN gateway or
     *    third-party IPsec VPN. VMs cannot directly send traffic to, or receive
     *    traffic from, such a VLAN attachment. To use *HA VPN over Cloud
     *    Interconnect*, the VLAN attachment must be created with this
     *    option.
     * Check the Encryption enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string encryption = 97980291;</code>
     * @return string
     */
    public function getEncryption()
    {
        return isset($this->encryption) ? $this->encryption : '';
    }

    public function hasEncryption()
    {
        return isset($this->encryption);
    }

    public function clearEncryption()
    {
        unset($this->encryption);
    }

    /**
     * Indicates the user-supplied encryption option of this VLAN attachment
     * (interconnectAttachment). Can only be specified at attachment creation
     * for PARTNER or DEDICATED attachments.
     * Possible values are:
     *    - NONE - This is the default value, which means that the
     *    VLAN attachment carries unencrypted traffic. VMs are able to send
     *    traffic to, or receive traffic from, such a VLAN attachment.
     *    - IPSEC - The VLAN attachment carries only encrypted
     *    traffic that is encrypted by an IPsec device, such as an HA VPN gateway or
     *    third-party IPsec VPN. VMs cannot directly send traffic to, or receive
     *    traffic from, such a VLAN attachment. To use *HA VPN over Cloud
     *    Interconnect*, the VLAN attachment must be created with this
     *    option.
     * Check the Encryption enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string encryption = 97980291;</code>
     * @param string $var
     * @return $this
     */
    public function setEncryption($var)
    {
        GPBUtil::checkString($var, True);
        $this->encryption = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Google reference ID, to be used when raising support tickets
     * with Google or otherwise to debug backend connectivity issues.
     * [Deprecated] This field is not used.
     *
     * Generated from protobuf field <code>optional string google_reference_id = 534944469;</code>
     * @return string
     */
    public function getGoogleReferenceId()
    {
        return isset($this->google_reference_id) ? $this->google_reference_id : '';
    }

    public function hasGoogleReferenceId()
    {
        return isset($this->google_reference_id);
    }

    public function clearGoogleReferenceId()
    {
        unset($this->google_reference_id);
    }

    /**
     * Output only. [Output Only] Google reference ID, to be used when raising support tickets
     * with Google or otherwise to debug backend connectivity issues.
     * [Deprecated] This field is not used.
     *
     * Generated from protobuf field <code>optional string google_reference_id = 534944469;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleReferenceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_reference_id = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * URL of the underlying Interconnect object that this attachment's traffic
     * will traverse through.
     *
     * Generated from protobuf field <code>optional string interconnect = 224601230;</code>
     * @return string
     */
    public function getInterconnect()
    {
        return isset($this->interconnect) ? $this->interconnect : '';
    }

    public function hasInterconnect()
    {
        return isset($this->interconnect);
    }

    public function clearInterconnect()
    {
        unset($this->interconnect);
    }

    /**
     * URL of the underlying Interconnect object that this attachment's traffic
     * will traverse through.
     *
     * Generated from protobuf field <code>optional string interconnect = 224601230;</code>
     * @param string $var
     * @return $this
     */
    public function setInterconnect($var)
    {
        GPBUtil::checkString($var, True);
        $this->interconnect = $var;

        return $this;
    }

    /**
     * A list of URLs of addresses that have been reserved for the VLAN
     * attachment. Used only for the VLAN attachment that has the encryption
     * option as IPSEC. The addresses must be regional internal IP address ranges.
     * When creating an HA VPN gateway over the VLAN attachment, if the attachment
     * is configured to use a regional internal IP address, then the VPN gateway's
     * IP address is allocated from the IP address range specified here. For
     * example, if the HA VPN gateway's interface 0 is paired to this VLAN
     * attachment, then a regional internal IP address for the VPN gateway
     * interface 0 will be allocated from the IP address specified for this
     * VLAN attachment.
     * If this field is not specified when creating the VLAN attachment, then
     * later on when creating an HA VPN gateway on this VLAN attachment, the HA
     * VPN gateway's IP address is allocated from the regional external IP address
     * pool.
     *
     * Generated from protobuf field <code>repeated string ipsec_internal_addresses = 407648565;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIpsecInternalAddresses()
    {
        return $this->ipsec_internal_addresses;
    }

    /**
     * A list of URLs of addresses that have been reserved for the VLAN
     * attachment. Used only for the VLAN attachment that has the encryption
     * option as IPSEC. The addresses must be regional internal IP address ranges.
     * When creating an HA VPN gateway over the VLAN attachment, if the attachment
     * is configured to use a regional internal IP address, then the VPN gateway's
     * IP address is allocated from the IP address range specified here. For
     * example, if the HA VPN gateway's interface 0 is paired to this VLAN
     * attachment, then a regional internal IP address for the VPN gateway
     * interface 0 will be allocated from the IP address specified for this
     * VLAN attachment.
     * If this field is not specified when creating the VLAN attachment, then
     * later on when creating an HA VPN gateway on this VLAN attachment, the HA
     * VPN gateway's IP address is allocated from the regional external IP address
     * pool.
     *
     * Generated from protobuf field <code>repeated string ipsec_internal_addresses = 407648565;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIpsecInternalAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ipsec_internal_addresses = $arr;

        return $this;
    }

    /**
     * Output only. [Output Only] Type of the resource. Alwayscompute#interconnectAttachment for interconnect attachments.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * Output only. [Output Only] Type of the resource. Alwayscompute#interconnectAttachment for interconnect attachments.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * L2 Interconnect Attachment related config. This field is required if the
     * type is L2_DEDICATED.
     * The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad)
     * within L2 packets are mapped to the destination appliances IP addresses.
     * The packet is then encapsulated with the appliance IP address and sent to
     * the edge appliance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentL2Forwarding l2_forwarding = 84784022;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectAttachmentL2Forwarding|null
     */
    public function getL2Forwarding()
    {
        return $this->l2_forwarding;
    }

    public function hasL2Forwarding()
    {
        return isset($this->l2_forwarding);
    }

    public function clearL2Forwarding()
    {
        unset($this->l2_forwarding);
    }

    /**
     * L2 Interconnect Attachment related config. This field is required if the
     * type is L2_DEDICATED.
     * The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad)
     * within L2 packets are mapped to the destination appliances IP addresses.
     * The packet is then encapsulated with the appliance IP address and sent to
     * the edge appliance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentL2Forwarding l2_forwarding = 84784022;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectAttachmentL2Forwarding $var
     * @return $this
     */
    public function setL2Forwarding($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectAttachmentL2Forwarding::class);
        $this->l2_forwarding = $var;

        return $this;
    }

    /**
     * A fingerprint for the labels being applied to this InterconnectAttachment,
     * which is essentially a hash of the labels set used for optimistic locking.
     * The fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels,
     * otherwise the request will fail with error412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to
     * retrieve an InterconnectAttachment.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return isset($this->label_fingerprint) ? $this->label_fingerprint : '';
    }

    public function hasLabelFingerprint()
    {
        return isset($this->label_fingerprint);
    }

    public function clearLabelFingerprint()
    {
        unset($this->label_fingerprint);
    }

    /**
     * A fingerprint for the labels being applied to this InterconnectAttachment,
     * which is essentially a hash of the labels set used for optimistic locking.
     * The fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels,
     * otherwise the request will fail with error412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to
     * retrieve an InterconnectAttachment.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels for this resource. These can only be added or modified by thesetLabels method. Each label key/value pair must comply withRFC1035.
     * Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels for this resource. These can only be added or modified by thesetLabels method. Each label key/value pair must comply withRFC1035.
     * Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this
     * interconnect attachment.
     * Valid values are 1440, 1460, 1500, and 8896. If not specified,
     * the value will default to 1440.
     *
     * Generated from protobuf field <code>optional int32 mtu = 108462;</code>
     * @return int
     */
    public function getMtu()
    {
        return isset($this->mtu) ? $this->mtu : 0;
    }

    public function hasMtu()
    {
        return isset($this->mtu);
    }

    public function clearMtu()
    {
        unset($this->mtu);
    }

    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this
     * interconnect attachment.
     * Valid values are 1440, 1460, 1500, and 8896. If not specified,
     * the value will default to 1440.
     *
     * Generated from protobuf field <code>optional int32 mtu = 108462;</code>
     * @param int $var
     * @return $this
     */
    public function setMtu($var)
    {
        GPBUtil::checkInt32($var);
        $this->mtu = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. Provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit, except the last character, which
     * cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] The current status of whether or not this interconnect
     * attachment is functional, which can take one of the following values:
     *    - OS_ACTIVE: The attachment has been turned up and is ready to
     *    use.
     *    - OS_UNPROVISIONED: The attachment is not ready to use yet,
     *    because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string operational_status = 201070847;</code>
     * @return string
     */
    public function getOperationalStatus()
    {
        return isset($this->operational_status) ? $this->operational_status : '';
    }

    public function hasOperationalStatus()
    {
        return isset($this->operational_status);
    }

    public function clearOperationalStatus()
    {
        unset($this->operational_status);
    }

    /**
     * Output only. [Output Only] The current status of whether or not this interconnect
     * attachment is functional, which can take one of the following values:
     *    - OS_ACTIVE: The attachment has been turned up and is ready to
     *    use.
     *    - OS_UNPROVISIONED: The attachment is not ready to use yet,
     *    because turnup is not complete.
     * Check the OperationalStatus enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string operational_status = 201070847;</code>
     * @param string $var
     * @return $this
     */
    public function setOperationalStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->operational_status = $var;

        return $this;
    }

    /**
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not
     * present for DEDICATED].
     * The opaque identifier of a PARTNER attachment used to initiate
     * provisioning with a selected partner.
     * Of the form "XXXXX/region/domain"
     *
     * Generated from protobuf field <code>optional string pairing_key = 439695464;</code>
     * @return string
     */
    public function getPairingKey()
    {
        return isset($this->pairing_key) ? $this->pairing_key : '';
    }

    public function hasPairingKey()
    {
        return isset($this->pairing_key);
    }

    public function clearPairingKey()
    {
        unset($this->pairing_key);
    }

    /**
     * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not
     * present for DEDICATED].
     * The opaque identifier of a PARTNER attachment used to initiate
     * provisioning with a selected partner.
     * Of the form "XXXXX/region/domain"
     *
     * Generated from protobuf field <code>optional string pairing_key = 439695464;</code>
     * @param string $var
     * @return $this
     */
    public function setPairingKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->pairing_key = $var;

        return $this;
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentParams params = 78313862;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectAttachmentParams|null
     */
    public function getParams()
    {
        return $this->params;
    }

    public function hasParams()
    {
        return isset($this->params);
    }

    public function clearParams()
    {
        unset($this->params);
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentParams params = 78313862;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectAttachmentParams $var
     * @return $this
     */
    public function setParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectAttachmentParams::class);
        $this->params = $var;

        return $this;
    }

    /**
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they
     * configured BGP on behalf of the customer.
     * Output only for PARTNER type, input only for PARTNER_PROVIDER, not
     * available for DEDICATED.
     *
     * Generated from protobuf field <code>optional int64 partner_asn = 438166149;</code>
     * @return int|string
     */
    public function getPartnerAsn()
    {
        return isset($this->partner_asn) ? $this->partner_asn : 0;
    }

    public function hasPartnerAsn()
    {
        return isset($this->partner_asn);
    }

    public function clearPartnerAsn()
    {
        unset($this->partner_asn);
    }

    /**
     * Optional BGP ASN for the router supplied by a Layer 3 Partner if they
     * configured BGP on behalf of the customer.
     * Output only for PARTNER type, input only for PARTNER_PROVIDER, not
     * available for DEDICATED.
     *
     * Generated from protobuf field <code>optional int64 partner_asn = 438166149;</code>
     * @param int|string $var
     * @return $this
     */
    public function setPartnerAsn($var)
    {
        GPBUtil::checkInt64($var);
        $this->partner_asn = $var;

        return $this;
    }

    /**
     * Informational metadata about Partner attachments from Partners to display
     * to customers.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER, not
     * available for DEDICATED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata|null
     */
    public function getPartnerMetadata()
    {
        return $this->partner_metadata;
    }

    public function hasPartnerMetadata()
    {
        return isset($this->partner_metadata);
    }

    public function clearPartnerMetadata()
    {
        unset($this->partner_metadata);
    }

    /**
     * Informational metadata about Partner attachments from Partners to display
     * to customers.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER, not
     * available for DEDICATED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata $var
     * @return $this
     */
    public function setPartnerMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectAttachmentPartnerMetadata::class);
        $this->partner_metadata = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Information specific to an InterconnectAttachment.
     * This property is populated if the interconnect that
     * this is attached to is of type DEDICATED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;</code>
     * @return \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo|null
     */
    public function getPrivateInterconnectInfo()
    {
        return $this->private_interconnect_info;
    }

    public function hasPrivateInterconnectInfo()
    {
        return isset($this->private_interconnect_info);
    }

    public function clearPrivateInterconnectInfo()
    {
        unset($this->private_interconnect_info);
    }

    /**
     * Output only. [Output Only] Information specific to an InterconnectAttachment.
     * This property is populated if the interconnect that
     * this is attached to is of type DEDICATED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;</code>
     * @param \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo $var
     * @return $this
     */
    public function setPrivateInterconnectInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InterconnectAttachmentPrivateInfo::class);
        $this->private_interconnect_info = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] URL of the region where the regional interconnect attachment
     * resides.
     * You must specify this field as part of the HTTP request URL. It is
     * not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : '';
    }

    public function hasRegion()
    {
        return isset($this->region);
    }

    public function clearRegion()
    {
        unset($this->region);
    }

    /**
     * Output only. [Output Only] URL of the region where the regional interconnect attachment
     * resides.
     * You must specify this field as part of the HTTP request URL. It is
     * not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * Output only. [Output Only]
     * If the attachment is on a Cross-Cloud Interconnect connection, this field
     * contains the interconnect's remote location service provider. Example
     * values: "Amazon Web Services" "Microsoft Azure".
     * The field is set only for attachments on Cross-Cloud Interconnect
     * connections. Its value is copied from the InterconnectRemoteLocation
     * remoteService field.
     *
     * Generated from protobuf field <code>optional string remote_service = 391954364;</code>
     * @return string
     */
    public function getRemoteService()
    {
        return isset($this->remote_service) ? $this->remote_service : '';
    }

    public function hasRemoteService()
    {
        return isset($this->remote_service);
    }

    public function clearRemoteService()
    {
        unset($this->remote_service);
    }

    /**
     * Output only. [Output Only]
     * If the attachment is on a Cross-Cloud Interconnect connection, this field
     * contains the interconnect's remote location service provider. Example
     * values: "Amazon Web Services" "Microsoft Azure".
     * The field is set only for attachments on Cross-Cloud Interconnect
     * connections. Its value is copied from the InterconnectRemoteLocation
     * remoteService field.
     *
     * Generated from protobuf field <code>optional string remote_service = 391954364;</code>
     * @param string $var
     * @return $this
     */
    public function setRemoteService($var)
    {
        GPBUtil::checkString($var, True);
        $this->remote_service = $var;

        return $this;
    }

    /**
     * URL of the Cloud Router to be used for dynamic routing. This router must be
     * in the same region as this InterconnectAttachment. The
     * InterconnectAttachment will automatically connect the Interconnect to the
     * network & region within which the Cloud Router is configured.
     *
     * Generated from protobuf field <code>optional string router = 148608841;</code>
     * @return string
     */
    public function getRouter()
    {
        return isset($this->router) ? $this->router : '';
    }

    public function hasRouter()
    {
        return isset($this->router);
    }

    public function clearRouter()
    {
        unset($this->router);
    }

    /**
     * URL of the Cloud Router to be used for dynamic routing. This router must be
     * in the same region as this InterconnectAttachment. The
     * InterconnectAttachment will automatically connect the Interconnect to the
     * network & region within which the Cloud Router is configured.
     *
     * Generated from protobuf field <code>optional string router = 148608841;</code>
     * @param string $var
     * @return $this
     */
    public function setRouter($var)
    {
        GPBUtil::checkString($var, True);
        $this->router = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * Output only. [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * The stack type for this interconnect attachment to identify whether the
     * IPv6 feature is enabled or not. If not specified, IPV4_ONLY
     * will be used.
     * This field can be both set at interconnect attachments creation and
     * update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string stack_type = 425908881;</code>
     * @return string
     */
    public function getStackType()
    {
        return isset($this->stack_type) ? $this->stack_type : '';
    }

    public function hasStackType()
    {
        return isset($this->stack_type);
    }

    public function clearStackType()
    {
        unset($this->stack_type);
    }

    /**
     * The stack type for this interconnect attachment to identify whether the
     * IPv6 feature is enabled or not. If not specified, IPV4_ONLY
     * will be used.
     * This field can be both set at interconnect attachments creation and
     * update interconnect attachment operations.
     * Check the StackType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string stack_type = 425908881;</code>
     * @param string $var
     * @return $this
     */
    public function setStackType($var)
    {
        GPBUtil::checkString($var, True);
        $this->stack_type = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] The current state of this attachment's functionality.
     * Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE,
     * PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values
     * PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used
     * for only PARTNER and PARTNER_PROVIDER interconnect attachments.
     * This state can take one of the following values:
     *    - ACTIVE: The attachment has been turned up and is ready to use.
     *    - UNPROVISIONED: The attachment is not ready to use yet, because turnup
     *    is not complete.
     *    - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet
     *    been configured on the Partner side.
     *    - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of
     *    provisioning after a PARTNER_PROVIDER attachment was created that
     *    references it.
     *    - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER
     *    attachment that is waiting for a customer to activate it.
     *    - DEFUNCT:
     *    The attachment was deleted externally and is no longer functional. This
     *    could be because the associated Interconnect was removed, or because the
     *    other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string state = 109757585;</code>
     * @return string
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : '';
    }

    public function hasState()
    {
        return isset($this->state);
    }

    public function clearState()
    {
        unset($this->state);
    }

    /**
     * Output only. [Output Only] The current state of this attachment's functionality.
     * Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE,
     * PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values
     * PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used
     * for only PARTNER and PARTNER_PROVIDER interconnect attachments.
     * This state can take one of the following values:
     *    - ACTIVE: The attachment has been turned up and is ready to use.
     *    - UNPROVISIONED: The attachment is not ready to use yet, because turnup
     *    is not complete.
     *    - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet
     *    been configured on the Partner side.
     *    - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of
     *    provisioning after a PARTNER_PROVIDER attachment was created that
     *    references it.
     *    - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER
     *    attachment that is waiting for a customer to activate it.
     *    - DEFUNCT:
     *    The attachment was deleted externally and is no longer functional. This
     *    could be because the associated Interconnect was removed, or because the
     *    other side of a Partner attachment was deleted.
     * Check the State enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string state = 109757585;</code>
     * @param string $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkString($var, True);
        $this->state = $var;

        return $this;
    }

    /**
     * Input only. Length of the IPv4 subnet mask.
     * Allowed values:
     *     - 29 (default)
     *     - 30
     * The default value is 29, except for Cross-Cloud Interconnect
     * connections that use an InterconnectRemoteLocation with a
     * constraints.subnetLengthRange.min equal to 30. For example,
     * connections that use an Azure remote location fall into this
     * category. In these cases, the default value is 30, and requesting
     * 29 returns an error.
     * Where both 29 and 30 are allowed, 29 is preferred, because it gives
     * Google Cloud Support more debugging visibility.
     *
     * Generated from protobuf field <code>optional int32 subnet_length = 279831048;</code>
     * @return int
     */
    public function getSubnetLength()
    {
        return isset($this->subnet_length) ? $this->subnet_length : 0;
    }

    public function hasSubnetLength()
    {
        return isset($this->subnet_length);
    }

    public function clearSubnetLength()
    {
        unset($this->subnet_length);
    }

    /**
     * Input only. Length of the IPv4 subnet mask.
     * Allowed values:
     *     - 29 (default)
     *     - 30
     * The default value is 29, except for Cross-Cloud Interconnect
     * connections that use an InterconnectRemoteLocation with a
     * constraints.subnetLengthRange.min equal to 30. For example,
     * connections that use an Azure remote location fall into this
     * category. In these cases, the default value is 30, and requesting
     * 29 returns an error.
     * Where both 29 and 30 are allowed, 29 is preferred, because it gives
     * Google Cloud Support more debugging visibility.
     *
     * Generated from protobuf field <code>optional int32 subnet_length = 279831048;</code>
     * @param int $var
     * @return $this
     */
    public function setSubnetLength($var)
    {
        GPBUtil::checkInt32($var);
        $this->subnet_length = $var;

        return $this;
    }

    /**
     * The type of interconnect attachment this is, which can take one of the
     * following values:
     *    - DEDICATED: an attachment to a Dedicated Interconnect.
     *    - PARTNER: an attachment to a Partner Interconnect, created by the
     *    customer.
     *    - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by
     *    the partner.
     * - L2_DEDICATED: a L2 attachment to a Dedicated Interconnect.
     * Check the Type enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string type = 3575610;</code>
     * @return string
     */
    public function getType()
    {
        return isset($this->type) ? $this->type : '';
    }

    public function hasType()
    {
        return isset($this->type);
    }

    public function clearType()
    {
        unset($this->type);
    }

    /**
     * The type of interconnect attachment this is, which can take one of the
     * following values:
     *    - DEDICATED: an attachment to a Dedicated Interconnect.
     *    - PARTNER: an attachment to a Partner Interconnect, created by the
     *    customer.
     *    - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by
     *    the partner.
     * - L2_DEDICATED: a L2 attachment to a Dedicated Interconnect.
     * Check the Type enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string type = 3575610;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093.
     * Only specified at creation time.
     *
     * Generated from protobuf field <code>optional int32 vlan_tag8021q = 119927836;</code>
     * @return int
     */
    public function getVlanTag8021Q()
    {
        return isset($this->vlan_tag8021q) ? $this->vlan_tag8021q : 0;
    }

    public function hasVlanTag8021Q()
    {
        return isset($this->vlan_tag8021q);
    }

    public function clearVlanTag8021Q()
    {
        unset($this->vlan_tag8021q);
    }

    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093.
     * Only specified at creation time.
     *
     * Generated from protobuf field <code>optional int32 vlan_tag8021q = 119927836;</code>
     * @param int $var
     * @return $this
     */
    public function setVlanTag8021Q($var)
    {
        GPBUtil::checkInt32($var);
        $this->vlan_tag8021q = $var;

        return $this;
    }

}

