<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Instance resource.
 * An instance is a virtual machine that is hosted on Google Cloud Platform.
 * For more information, readVirtual Machine Instances.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Instance</code>
 */
class Instance extends \Google\Protobuf\Internal\Message
{
    /**
     * Controls for advanced machine-related behavior features.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;</code>
     */
    protected $advanced_machine_features = null;
    /**
     * Allows this instance to send and receive packets with non-matching
     * destination or source IPs. This is required if you plan to use this
     * instance to forward routes. For more information, seeEnabling IP Forwarding.
     *
     * Generated from protobuf field <code>optional bool can_ip_forward = 467731324;</code>
     */
    protected $can_ip_forward = null;
    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;</code>
     */
    protected $confidential_instance_config = null;
    /**
     * Output only. [Output Only] The CPU platform used by this instance.
     *
     * Generated from protobuf field <code>optional string cpu_platform = 410285354;</code>
     */
    protected $cpu_platform = null;
    /**
     * Output only. [Output Only] Creation timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    protected $creation_timestamp = null;
    /**
     * Whether the resource should be protected against deletion.
     *
     * Generated from protobuf field <code>optional bool deletion_protection = 458014698;</code>
     */
    protected $deletion_protection = null;
    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    protected $description = null;
    /**
     * Array of disks associated with this instance. Persistent disks must be
     * created before you can assign them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    private $disks;
    /**
     * Enables display device for the instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    protected $display_device = null;
    /**
     * Specifies a fingerprint for this resource, which is essentially a hash of
     * the instance's contents and used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update the instance. You must always provide an
     * up-to-date fingerprint hash in order to update the instance.
     * To see the latest fingerprint, make get() request to the
     * instance.
     *
     * Generated from protobuf field <code>optional string fingerprint = 234678500;</code>
     */
    protected $fingerprint = null;
    /**
     * A list of the type and count of accelerator cards attached to the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;</code>
     */
    private $guest_accelerators;
    /**
     * Specifies the hostname of the instance. The specified hostname must be
     * RFC1035 compliant. If hostname is not specified, the default hostname is
     * [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and
     * [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *
     * Generated from protobuf field <code>optional string hostname = 237067315;</code>
     */
    protected $hostname = null;
    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    protected $id = null;
    /**
     * Encrypts suspended data for an instance with acustomer-managed
     * encryption key.
     * If you are creating a new instance, this field will encrypt the local SSD
     * and in-memory contents of the instance during the suspend operation.
     * If you do not provide an encryption key when creating the instance, then
     * the local SSD and in-memory contents will be encrypted using
     * an automatically generated key during the suspend operation.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;</code>
     */
    protected $instance_encryption_key = null;
    /**
     * KeyRevocationActionType of the instance. Supported options are "STOP" and
     * "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string key_revocation_action_type = 235941474;</code>
     */
    protected $key_revocation_action_type = null;
    /**
     * Output only. [Output Only] Type of the resource. Always compute#instance
     * for instances.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    protected $kind = null;
    /**
     * A fingerprint for this request, which is essentially a hash of
     * the label's contents and used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels.
     * To see the latest fingerprint, make get() request to the
     * instance.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     */
    protected $label_fingerprint = null;
    /**
     * Labels to apply to this instance. These can be later modified by
     * the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     */
    private $labels;
    /**
     * Output only. [Output Only] Last start timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_start_timestamp = 443830736;</code>
     */
    protected $last_start_timestamp = null;
    /**
     * Output only. [Output Only] Last stop timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_stop_timestamp = 412823010;</code>
     */
    protected $last_stop_timestamp = null;
    /**
     * Output only. [Output Only] Last suspended timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_suspended_timestamp = 356275337;</code>
     */
    protected $last_suspended_timestamp = null;
    /**
     * Full or partial URL of the machine type resource to use for this instance,
     * in the format:zones/zone/machineTypes/machine-type. This is provided by the client
     * when the instance is created. For example, the following is a valid partial
     * url to a predefined
     * machine type:
     * zones/us-central1-f/machineTypes/n1-standard-1
     * To create acustom
     * machine type, provide a URL to a machine type in the following format,
     * where CPUS is 1 or an even number up to 32 (2,
     * 4, 6, ... 24, etc), and MEMORY is the total
     * memory for this instance. Memory must be a multiple of 256 MB and must
     * be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     * zones/zone/machineTypes/custom-CPUS-MEMORY
     * For example: zones/us-central1-f/machineTypes/custom-4-5120
     * For a full list of restrictions, read theSpecifications
     * for custom machine types.
     *
     * Generated from protobuf field <code>optional string machine_type = 227711026;</code>
     */
    protected $machine_type = null;
    /**
     * The metadata key/value pairs assigned
     * to this instance. This includes metadata keys that were explicitly defined
     * for the instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    protected $metadata = null;
    /**
     * Specifies aminimum CPU
     * platform for the VM instance. Applicable values are the friendly names
     * of CPU platforms, such as minCpuPlatform: "Intel
     * Haswell" or minCpuPlatform: "Intel Sandy
     * Bridge".
     *
     * Generated from protobuf field <code>optional string min_cpu_platform = 242912759;</code>
     */
    protected $min_cpu_platform = null;
    /**
     * The name of the resource, provided by the client when initially creating
     * the resource. The resource name must be 1-63 characters long, and comply
     * withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be
     * a dash, lowercase letter, or digit, except the last character, which cannot
     * be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    protected $name = null;
    /**
     * An array of network configurations for this instance. These specify how
     * interfaces are configured to interact with other network services, such as
     * connecting to the internet. Multiple interfaces are supported
     * per instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
     */
    private $network_interfaces;
    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;</code>
     */
    protected $network_performance_config = null;
    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    protected $params = null;
    /**
     * The private IPv6 google access type for the VM.
     * If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string private_ipv6_google_access = 48277006;</code>
     */
    protected $private_ipv6_google_access = null;
    /**
     * Specifies the reservations that this instance can consume from.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;</code>
     */
    protected $reservation_affinity = null;
    /**
     * Resource policies applied to this instance.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     */
    private $resource_policies;
    /**
     * Output only. [Output Only] Specifies values set for instance attributes as
     * compared to the values requested by user in the corresponding input only
     * field.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    protected $resource_status = null;
    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     */
    protected $satisfies_pzi = null;
    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     */
    protected $satisfies_pzs = null;
    /**
     * Sets the scheduling options for this instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    protected $scheduling = null;
    /**
     * Output only. [Output Only] Server-defined URL for this resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    protected $self_link = null;
    /**
     * A list of service accounts, with their specified scopes, authorized for
     * this instance. Only one service account per VM instance is supported.
     * Service accounts generate access tokens that can be accessed
     * through the metadata server and used to authenticate applications on the
     * instance. SeeService Accounts
     * for more information.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    private $service_accounts;
    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;</code>
     */
    protected $shielded_instance_config = null;
    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;</code>
     */
    protected $shielded_instance_integrity_policy = null;
    /**
     * Source machine image
     *
     * Generated from protobuf field <code>optional string source_machine_image = 21769791;</code>
     */
    protected $source_machine_image = null;
    /**
     * Source machine image encryption key when creating an instance from a
     * machine image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;</code>
     */
    protected $source_machine_image_encryption_key = null;
    /**
     * Output only. [Output Only] Whether a VM has been restricted for start because Compute
     * Engine has detected suspicious activity.
     *
     * Generated from protobuf field <code>optional bool start_restricted = 123693144;</code>
     */
    protected $start_restricted = null;
    /**
     * Output only. [Output Only] The status of the instance. One of the
     * following values: PROVISIONING, STAGING,RUNNING, STOPPING, SUSPENDING,SUSPENDED, REPAIRING, andTERMINATED. For more information about the status of the
     * instance, see
     * Instance life cycle.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     */
    protected $status = null;
    /**
     * Output only. [Output Only] An optional, human-readable explanation of the status.
     *
     * Generated from protobuf field <code>optional string status_message = 297428154;</code>
     */
    protected $status_message = null;
    /**
     * Tags to apply to this instance. Tags are used to identify valid
     * sources or targets for network firewalls and are specified by the client
     * during instance creation. The tags can be later modified by the setTags
     * method. Each tag within the list must comply withRFC1035.
     * Multiple tags can be specified via the 'tags.items' field.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    protected $tags = null;
    /**
     * Output only. [Output Only] URL of the zone where the instance resides.
     * You must specify this field as part of the HTTP request URL. It is
     * not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string zone = 3744684;</code>
     */
    protected $zone = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Compute\V1\AdvancedMachineFeatures $advanced_machine_features
     *           Controls for advanced machine-related behavior features.
     *     @type bool $can_ip_forward
     *           Allows this instance to send and receive packets with non-matching
     *           destination or source IPs. This is required if you plan to use this
     *           instance to forward routes. For more information, seeEnabling IP Forwarding.
     *     @type \Google\Cloud\Compute\V1\ConfidentialInstanceConfig $confidential_instance_config
     *     @type string $cpu_platform
     *           Output only. [Output Only] The CPU platform used by this instance.
     *     @type string $creation_timestamp
     *           Output only. [Output Only] Creation timestamp inRFC3339 text format.
     *     @type bool $deletion_protection
     *           Whether the resource should be protected against deletion.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you
     *           create the resource.
     *     @type array<\Google\Cloud\Compute\V1\AttachedDisk>|\Google\Protobuf\Internal\RepeatedField $disks
     *           Array of disks associated with this instance. Persistent disks must be
     *           created before you can assign them.
     *     @type \Google\Cloud\Compute\V1\DisplayDevice $display_device
     *           Enables display device for the instance.
     *     @type string $fingerprint
     *           Specifies a fingerprint for this resource, which is essentially a hash of
     *           the instance's contents and used for optimistic locking. The
     *           fingerprint is initially generated by Compute Engine and changes after
     *           every request to modify or update the instance. You must always provide an
     *           up-to-date fingerprint hash in order to update the instance.
     *           To see the latest fingerprint, make get() request to the
     *           instance.
     *     @type array<\Google\Cloud\Compute\V1\AcceleratorConfig>|\Google\Protobuf\Internal\RepeatedField $guest_accelerators
     *           A list of the type and count of accelerator cards attached to the instance.
     *     @type string $hostname
     *           Specifies the hostname of the instance. The specified hostname must be
     *           RFC1035 compliant. If hostname is not specified, the default hostname is
     *           [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and
     *           [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *     @type int|string $id
     *           Output only. [Output Only] The unique identifier for the resource. This identifier is
     *           defined by the server.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $instance_encryption_key
     *           Encrypts suspended data for an instance with acustomer-managed
     *           encryption key.
     *           If you are creating a new instance, this field will encrypt the local SSD
     *           and in-memory contents of the instance during the suspend operation.
     *           If you do not provide an encryption key when creating the instance, then
     *           the local SSD and in-memory contents will be encrypted using
     *           an automatically generated key during the suspend operation.
     *     @type string $key_revocation_action_type
     *           KeyRevocationActionType of the instance. Supported options are "STOP" and
     *           "NONE". The default value is "NONE" if it is not specified.
     *           Check the KeyRevocationActionType enum for the list of possible values.
     *     @type string $kind
     *           Output only. [Output Only] Type of the resource. Always compute#instance
     *           for instances.
     *     @type string $label_fingerprint
     *           A fingerprint for this request, which is essentially a hash of
     *           the label's contents and used for optimistic locking. The
     *           fingerprint is initially generated by Compute Engine and changes after
     *           every request to modify or update labels. You must always provide an
     *           up-to-date fingerprint hash in order to update or change labels.
     *           To see the latest fingerprint, make get() request to the
     *           instance.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this instance. These can be later modified by
     *           the setLabels method.
     *     @type string $last_start_timestamp
     *           Output only. [Output Only] Last start timestamp inRFC3339 text format.
     *     @type string $last_stop_timestamp
     *           Output only. [Output Only] Last stop timestamp inRFC3339 text format.
     *     @type string $last_suspended_timestamp
     *           Output only. [Output Only] Last suspended timestamp inRFC3339 text format.
     *     @type string $machine_type
     *           Full or partial URL of the machine type resource to use for this instance,
     *           in the format:zones/zone/machineTypes/machine-type. This is provided by the client
     *           when the instance is created. For example, the following is a valid partial
     *           url to a predefined
     *           machine type:
     *           zones/us-central1-f/machineTypes/n1-standard-1
     *           To create acustom
     *           machine type, provide a URL to a machine type in the following format,
     *           where CPUS is 1 or an even number up to 32 (2,
     *           4, 6, ... 24, etc), and MEMORY is the total
     *           memory for this instance. Memory must be a multiple of 256 MB and must
     *           be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     *           zones/zone/machineTypes/custom-CPUS-MEMORY
     *           For example: zones/us-central1-f/machineTypes/custom-4-5120
     *           For a full list of restrictions, read theSpecifications
     *           for custom machine types.
     *     @type \Google\Cloud\Compute\V1\Metadata $metadata
     *           The metadata key/value pairs assigned
     *           to this instance. This includes metadata keys that were explicitly defined
     *           for the instance.
     *     @type string $min_cpu_platform
     *           Specifies aminimum CPU
     *           platform for the VM instance. Applicable values are the friendly names
     *           of CPU platforms, such as minCpuPlatform: "Intel
     *           Haswell" or minCpuPlatform: "Intel Sandy
     *           Bridge".
     *     @type string $name
     *           The name of the resource, provided by the client when initially creating
     *           the resource. The resource name must be 1-63 characters long, and comply
     *           withRFC1035.
     *           Specifically, the name must be 1-63 characters long and match the regular
     *           expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     *           character must be a lowercase letter, and all following characters must be
     *           a dash, lowercase letter, or digit, except the last character, which cannot
     *           be a dash.
     *     @type array<\Google\Cloud\Compute\V1\NetworkInterface>|\Google\Protobuf\Internal\RepeatedField $network_interfaces
     *           An array of network configurations for this instance. These specify how
     *           interfaces are configured to interact with other network services, such as
     *           connecting to the internet. Multiple interfaces are supported
     *           per instance.
     *     @type \Google\Cloud\Compute\V1\NetworkPerformanceConfig $network_performance_config
     *     @type \Google\Cloud\Compute\V1\InstanceParams $params
     *           Input only. [Input Only] Additional params passed with the request, but not persisted
     *           as part of resource payload.
     *     @type string $private_ipv6_google_access
     *           The private IPv6 google access type for the VM.
     *           If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     *           Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     *     @type \Google\Cloud\Compute\V1\ReservationAffinity $reservation_affinity
     *           Specifies the reservations that this instance can consume from.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $resource_policies
     *           Resource policies applied to this instance.
     *     @type \Google\Cloud\Compute\V1\ResourceStatus $resource_status
     *           Output only. [Output Only] Specifies values set for instance attributes as
     *           compared to the values requested by user in the corresponding input only
     *           field.
     *     @type bool $satisfies_pzi
     *           Output only. [Output Only] Reserved for future use.
     *     @type bool $satisfies_pzs
     *           Output only. [Output Only] Reserved for future use.
     *     @type \Google\Cloud\Compute\V1\Scheduling $scheduling
     *           Sets the scheduling options for this instance.
     *     @type string $self_link
     *           Output only. [Output Only] Server-defined URL for this resource.
     *     @type array<\Google\Cloud\Compute\V1\ServiceAccount>|\Google\Protobuf\Internal\RepeatedField $service_accounts
     *           A list of service accounts, with their specified scopes, authorized for
     *           this instance. Only one service account per VM instance is supported.
     *           Service accounts generate access tokens that can be accessed
     *           through the metadata server and used to authenticate applications on the
     *           instance. SeeService Accounts
     *           for more information.
     *     @type \Google\Cloud\Compute\V1\ShieldedInstanceConfig $shielded_instance_config
     *     @type \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy $shielded_instance_integrity_policy
     *     @type string $source_machine_image
     *           Source machine image
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_machine_image_encryption_key
     *           Source machine image encryption key when creating an instance from a
     *           machine image.
     *     @type bool $start_restricted
     *           Output only. [Output Only] Whether a VM has been restricted for start because Compute
     *           Engine has detected suspicious activity.
     *     @type string $status
     *           Output only. [Output Only] The status of the instance. One of the
     *           following values: PROVISIONING, STAGING,RUNNING, STOPPING, SUSPENDING,SUSPENDED, REPAIRING, andTERMINATED. For more information about the status of the
     *           instance, see
     *           Instance life cycle.
     *           Check the Status enum for the list of possible values.
     *     @type string $status_message
     *           Output only. [Output Only] An optional, human-readable explanation of the status.
     *     @type \Google\Cloud\Compute\V1\Tags $tags
     *           Tags to apply to this instance. Tags are used to identify valid
     *           sources or targets for network firewalls and are specified by the client
     *           during instance creation. The tags can be later modified by the setTags
     *           method. Each tag within the list must comply withRFC1035.
     *           Multiple tags can be specified via the 'tags.items' field.
     *     @type string $zone
     *           Output only. [Output Only] URL of the zone where the instance resides.
     *           You must specify this field as part of the HTTP request URL. It is
     *           not settable as a field in the request body.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Controls for advanced machine-related behavior features.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;</code>
     * @return \Google\Cloud\Compute\V1\AdvancedMachineFeatures|null
     */
    public function getAdvancedMachineFeatures()
    {
        return $this->advanced_machine_features;
    }

    public function hasAdvancedMachineFeatures()
    {
        return isset($this->advanced_machine_features);
    }

    public function clearAdvancedMachineFeatures()
    {
        unset($this->advanced_machine_features);
    }

    /**
     * Controls for advanced machine-related behavior features.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;</code>
     * @param \Google\Cloud\Compute\V1\AdvancedMachineFeatures $var
     * @return $this
     */
    public function setAdvancedMachineFeatures($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\AdvancedMachineFeatures::class);
        $this->advanced_machine_features = $var;

        return $this;
    }

    /**
     * Allows this instance to send and receive packets with non-matching
     * destination or source IPs. This is required if you plan to use this
     * instance to forward routes. For more information, seeEnabling IP Forwarding.
     *
     * Generated from protobuf field <code>optional bool can_ip_forward = 467731324;</code>
     * @return bool
     */
    public function getCanIpForward()
    {
        return isset($this->can_ip_forward) ? $this->can_ip_forward : false;
    }

    public function hasCanIpForward()
    {
        return isset($this->can_ip_forward);
    }

    public function clearCanIpForward()
    {
        unset($this->can_ip_forward);
    }

    /**
     * Allows this instance to send and receive packets with non-matching
     * destination or source IPs. This is required if you plan to use this
     * instance to forward routes. For more information, seeEnabling IP Forwarding.
     *
     * Generated from protobuf field <code>optional bool can_ip_forward = 467731324;</code>
     * @param bool $var
     * @return $this
     */
    public function setCanIpForward($var)
    {
        GPBUtil::checkBool($var);
        $this->can_ip_forward = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;</code>
     * @return \Google\Cloud\Compute\V1\ConfidentialInstanceConfig|null
     */
    public function getConfidentialInstanceConfig()
    {
        return $this->confidential_instance_config;
    }

    public function hasConfidentialInstanceConfig()
    {
        return isset($this->confidential_instance_config);
    }

    public function clearConfidentialInstanceConfig()
    {
        unset($this->confidential_instance_config);
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;</code>
     * @param \Google\Cloud\Compute\V1\ConfidentialInstanceConfig $var
     * @return $this
     */
    public function setConfidentialInstanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ConfidentialInstanceConfig::class);
        $this->confidential_instance_config = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] The CPU platform used by this instance.
     *
     * Generated from protobuf field <code>optional string cpu_platform = 410285354;</code>
     * @return string
     */
    public function getCpuPlatform()
    {
        return isset($this->cpu_platform) ? $this->cpu_platform : '';
    }

    public function hasCpuPlatform()
    {
        return isset($this->cpu_platform);
    }

    public function clearCpuPlatform()
    {
        unset($this->cpu_platform);
    }

    /**
     * Output only. [Output Only] The CPU platform used by this instance.
     *
     * Generated from protobuf field <code>optional string cpu_platform = 410285354;</code>
     * @param string $var
     * @return $this
     */
    public function setCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->cpu_platform = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Creation timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * Output only. [Output Only] Creation timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * Whether the resource should be protected against deletion.
     *
     * Generated from protobuf field <code>optional bool deletion_protection = 458014698;</code>
     * @return bool
     */
    public function getDeletionProtection()
    {
        return isset($this->deletion_protection) ? $this->deletion_protection : false;
    }

    public function hasDeletionProtection()
    {
        return isset($this->deletion_protection);
    }

    public function clearDeletionProtection()
    {
        unset($this->deletion_protection);
    }

    /**
     * Whether the resource should be protected against deletion.
     *
     * Generated from protobuf field <code>optional bool deletion_protection = 458014698;</code>
     * @param bool $var
     * @return $this
     */
    public function setDeletionProtection($var)
    {
        GPBUtil::checkBool($var);
        $this->deletion_protection = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Array of disks associated with this instance. Persistent disks must be
     * created before you can assign them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDisks()
    {
        return $this->disks;
    }

    /**
     * Array of disks associated with this instance. Persistent disks must be
     * created before you can assign them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     * @param array<\Google\Cloud\Compute\V1\AttachedDisk>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDisks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\AttachedDisk::class);
        $this->disks = $arr;

        return $this;
    }

    /**
     * Enables display device for the instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     * @return \Google\Cloud\Compute\V1\DisplayDevice|null
     */
    public function getDisplayDevice()
    {
        return $this->display_device;
    }

    public function hasDisplayDevice()
    {
        return isset($this->display_device);
    }

    public function clearDisplayDevice()
    {
        unset($this->display_device);
    }

    /**
     * Enables display device for the instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     * @param \Google\Cloud\Compute\V1\DisplayDevice $var
     * @return $this
     */
    public function setDisplayDevice($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\DisplayDevice::class);
        $this->display_device = $var;

        return $this;
    }

    /**
     * Specifies a fingerprint for this resource, which is essentially a hash of
     * the instance's contents and used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update the instance. You must always provide an
     * up-to-date fingerprint hash in order to update the instance.
     * To see the latest fingerprint, make get() request to the
     * instance.
     *
     * Generated from protobuf field <code>optional string fingerprint = 234678500;</code>
     * @return string
     */
    public function getFingerprint()
    {
        return isset($this->fingerprint) ? $this->fingerprint : '';
    }

    public function hasFingerprint()
    {
        return isset($this->fingerprint);
    }

    public function clearFingerprint()
    {
        unset($this->fingerprint);
    }

    /**
     * Specifies a fingerprint for this resource, which is essentially a hash of
     * the instance's contents and used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update the instance. You must always provide an
     * up-to-date fingerprint hash in order to update the instance.
     * To see the latest fingerprint, make get() request to the
     * instance.
     *
     * Generated from protobuf field <code>optional string fingerprint = 234678500;</code>
     * @param string $var
     * @return $this
     */
    public function setFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->fingerprint = $var;

        return $this;
    }

    /**
     * A list of the type and count of accelerator cards attached to the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestAccelerators()
    {
        return $this->guest_accelerators;
    }

    /**
     * A list of the type and count of accelerator cards attached to the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;</code>
     * @param array<\Google\Cloud\Compute\V1\AcceleratorConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestAccelerators($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\AcceleratorConfig::class);
        $this->guest_accelerators = $arr;

        return $this;
    }

    /**
     * Specifies the hostname of the instance. The specified hostname must be
     * RFC1035 compliant. If hostname is not specified, the default hostname is
     * [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and
     * [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *
     * Generated from protobuf field <code>optional string hostname = 237067315;</code>
     * @return string
     */
    public function getHostname()
    {
        return isset($this->hostname) ? $this->hostname : '';
    }

    public function hasHostname()
    {
        return isset($this->hostname);
    }

    public function clearHostname()
    {
        unset($this->hostname);
    }

    /**
     * Specifies the hostname of the instance. The specified hostname must be
     * RFC1035 compliant. If hostname is not specified, the default hostname is
     * [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and
     * [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *
     * Generated from protobuf field <code>optional string hostname = 237067315;</code>
     * @param string $var
     * @return $this
     */
    public function setHostname($var)
    {
        GPBUtil::checkString($var, True);
        $this->hostname = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Encrypts suspended data for an instance with acustomer-managed
     * encryption key.
     * If you are creating a new instance, this field will encrypt the local SSD
     * and in-memory contents of the instance during the suspend operation.
     * If you do not provide an encryption key when creating the instance, then
     * the local SSD and in-memory contents will be encrypted using
     * an automatically generated key during the suspend operation.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getInstanceEncryptionKey()
    {
        return $this->instance_encryption_key;
    }

    public function hasInstanceEncryptionKey()
    {
        return isset($this->instance_encryption_key);
    }

    public function clearInstanceEncryptionKey()
    {
        unset($this->instance_encryption_key);
    }

    /**
     * Encrypts suspended data for an instance with acustomer-managed
     * encryption key.
     * If you are creating a new instance, this field will encrypt the local SSD
     * and in-memory contents of the instance during the suspend operation.
     * If you do not provide an encryption key when creating the instance, then
     * the local SSD and in-memory contents will be encrypted using
     * an automatically generated key during the suspend operation.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setInstanceEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->instance_encryption_key = $var;

        return $this;
    }

    /**
     * KeyRevocationActionType of the instance. Supported options are "STOP" and
     * "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string key_revocation_action_type = 235941474;</code>
     * @return string
     */
    public function getKeyRevocationActionType()
    {
        return isset($this->key_revocation_action_type) ? $this->key_revocation_action_type : '';
    }

    public function hasKeyRevocationActionType()
    {
        return isset($this->key_revocation_action_type);
    }

    public function clearKeyRevocationActionType()
    {
        unset($this->key_revocation_action_type);
    }

    /**
     * KeyRevocationActionType of the instance. Supported options are "STOP" and
     * "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string key_revocation_action_type = 235941474;</code>
     * @param string $var
     * @return $this
     */
    public function setKeyRevocationActionType($var)
    {
        GPBUtil::checkString($var, True);
        $this->key_revocation_action_type = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Type of the resource. Always compute#instance
     * for instances.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * Output only. [Output Only] Type of the resource. Always compute#instance
     * for instances.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for this request, which is essentially a hash of
     * the label's contents and used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels.
     * To see the latest fingerprint, make get() request to the
     * instance.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return isset($this->label_fingerprint) ? $this->label_fingerprint : '';
    }

    public function hasLabelFingerprint()
    {
        return isset($this->label_fingerprint);
    }

    public function clearLabelFingerprint()
    {
        unset($this->label_fingerprint);
    }

    /**
     * A fingerprint for this request, which is essentially a hash of
     * the label's contents and used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels.
     * To see the latest fingerprint, make get() request to the
     * instance.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels to apply to this instance. These can be later modified by
     * the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this instance. These can be later modified by
     * the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. [Output Only] Last start timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_start_timestamp = 443830736;</code>
     * @return string
     */
    public function getLastStartTimestamp()
    {
        return isset($this->last_start_timestamp) ? $this->last_start_timestamp : '';
    }

    public function hasLastStartTimestamp()
    {
        return isset($this->last_start_timestamp);
    }

    public function clearLastStartTimestamp()
    {
        unset($this->last_start_timestamp);
    }

    /**
     * Output only. [Output Only] Last start timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_start_timestamp = 443830736;</code>
     * @param string $var
     * @return $this
     */
    public function setLastStartTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_start_timestamp = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Last stop timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_stop_timestamp = 412823010;</code>
     * @return string
     */
    public function getLastStopTimestamp()
    {
        return isset($this->last_stop_timestamp) ? $this->last_stop_timestamp : '';
    }

    public function hasLastStopTimestamp()
    {
        return isset($this->last_stop_timestamp);
    }

    public function clearLastStopTimestamp()
    {
        unset($this->last_stop_timestamp);
    }

    /**
     * Output only. [Output Only] Last stop timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_stop_timestamp = 412823010;</code>
     * @param string $var
     * @return $this
     */
    public function setLastStopTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_stop_timestamp = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Last suspended timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_suspended_timestamp = 356275337;</code>
     * @return string
     */
    public function getLastSuspendedTimestamp()
    {
        return isset($this->last_suspended_timestamp) ? $this->last_suspended_timestamp : '';
    }

    public function hasLastSuspendedTimestamp()
    {
        return isset($this->last_suspended_timestamp);
    }

    public function clearLastSuspendedTimestamp()
    {
        unset($this->last_suspended_timestamp);
    }

    /**
     * Output only. [Output Only] Last suspended timestamp inRFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_suspended_timestamp = 356275337;</code>
     * @param string $var
     * @return $this
     */
    public function setLastSuspendedTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_suspended_timestamp = $var;

        return $this;
    }

    /**
     * Full or partial URL of the machine type resource to use for this instance,
     * in the format:zones/zone/machineTypes/machine-type. This is provided by the client
     * when the instance is created. For example, the following is a valid partial
     * url to a predefined
     * machine type:
     * zones/us-central1-f/machineTypes/n1-standard-1
     * To create acustom
     * machine type, provide a URL to a machine type in the following format,
     * where CPUS is 1 or an even number up to 32 (2,
     * 4, 6, ... 24, etc), and MEMORY is the total
     * memory for this instance. Memory must be a multiple of 256 MB and must
     * be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     * zones/zone/machineTypes/custom-CPUS-MEMORY
     * For example: zones/us-central1-f/machineTypes/custom-4-5120
     * For a full list of restrictions, read theSpecifications
     * for custom machine types.
     *
     * Generated from protobuf field <code>optional string machine_type = 227711026;</code>
     * @return string
     */
    public function getMachineType()
    {
        return isset($this->machine_type) ? $this->machine_type : '';
    }

    public function hasMachineType()
    {
        return isset($this->machine_type);
    }

    public function clearMachineType()
    {
        unset($this->machine_type);
    }

    /**
     * Full or partial URL of the machine type resource to use for this instance,
     * in the format:zones/zone/machineTypes/machine-type. This is provided by the client
     * when the instance is created. For example, the following is a valid partial
     * url to a predefined
     * machine type:
     * zones/us-central1-f/machineTypes/n1-standard-1
     * To create acustom
     * machine type, provide a URL to a machine type in the following format,
     * where CPUS is 1 or an even number up to 32 (2,
     * 4, 6, ... 24, etc), and MEMORY is the total
     * memory for this instance. Memory must be a multiple of 256 MB and must
     * be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     * zones/zone/machineTypes/custom-CPUS-MEMORY
     * For example: zones/us-central1-f/machineTypes/custom-4-5120
     * For a full list of restrictions, read theSpecifications
     * for custom machine types.
     *
     * Generated from protobuf field <code>optional string machine_type = 227711026;</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * The metadata key/value pairs assigned
     * to this instance. This includes metadata keys that were explicitly defined
     * for the instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     * @return \Google\Cloud\Compute\V1\Metadata|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * The metadata key/value pairs assigned
     * to this instance. This includes metadata keys that were explicitly defined
     * for the instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     * @param \Google\Cloud\Compute\V1\Metadata $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Metadata::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * Specifies aminimum CPU
     * platform for the VM instance. Applicable values are the friendly names
     * of CPU platforms, such as minCpuPlatform: "Intel
     * Haswell" or minCpuPlatform: "Intel Sandy
     * Bridge".
     *
     * Generated from protobuf field <code>optional string min_cpu_platform = 242912759;</code>
     * @return string
     */
    public function getMinCpuPlatform()
    {
        return isset($this->min_cpu_platform) ? $this->min_cpu_platform : '';
    }

    public function hasMinCpuPlatform()
    {
        return isset($this->min_cpu_platform);
    }

    public function clearMinCpuPlatform()
    {
        unset($this->min_cpu_platform);
    }

    /**
     * Specifies aminimum CPU
     * platform for the VM instance. Applicable values are the friendly names
     * of CPU platforms, such as minCpuPlatform: "Intel
     * Haswell" or minCpuPlatform: "Intel Sandy
     * Bridge".
     *
     * Generated from protobuf field <code>optional string min_cpu_platform = 242912759;</code>
     * @param string $var
     * @return $this
     */
    public function setMinCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->min_cpu_platform = $var;

        return $this;
    }

    /**
     * The name of the resource, provided by the client when initially creating
     * the resource. The resource name must be 1-63 characters long, and comply
     * withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be
     * a dash, lowercase letter, or digit, except the last character, which cannot
     * be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * The name of the resource, provided by the client when initially creating
     * the resource. The resource name must be 1-63 characters long, and comply
     * withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be
     * a dash, lowercase letter, or digit, except the last character, which cannot
     * be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * An array of network configurations for this instance. These specify how
     * interfaces are configured to interact with other network services, such as
     * connecting to the internet. Multiple interfaces are supported
     * per instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNetworkInterfaces()
    {
        return $this->network_interfaces;
    }

    /**
     * An array of network configurations for this instance. These specify how
     * interfaces are configured to interact with other network services, such as
     * connecting to the internet. Multiple interfaces are supported
     * per instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
     * @param array<\Google\Cloud\Compute\V1\NetworkInterface>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNetworkInterfaces($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\NetworkInterface::class);
        $this->network_interfaces = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;</code>
     * @return \Google\Cloud\Compute\V1\NetworkPerformanceConfig|null
     */
    public function getNetworkPerformanceConfig()
    {
        return $this->network_performance_config;
    }

    public function hasNetworkPerformanceConfig()
    {
        return isset($this->network_performance_config);
    }

    public function clearNetworkPerformanceConfig()
    {
        unset($this->network_performance_config);
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;</code>
     * @param \Google\Cloud\Compute\V1\NetworkPerformanceConfig $var
     * @return $this
     */
    public function setNetworkPerformanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\NetworkPerformanceConfig::class);
        $this->network_performance_config = $var;

        return $this;
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     * @return \Google\Cloud\Compute\V1\InstanceParams|null
     */
    public function getParams()
    {
        return $this->params;
    }

    public function hasParams()
    {
        return isset($this->params);
    }

    public function clearParams()
    {
        unset($this->params);
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     * @param \Google\Cloud\Compute\V1\InstanceParams $var
     * @return $this
     */
    public function setParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InstanceParams::class);
        $this->params = $var;

        return $this;
    }

    /**
     * The private IPv6 google access type for the VM.
     * If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string private_ipv6_google_access = 48277006;</code>
     * @return string
     */
    public function getPrivateIpv6GoogleAccess()
    {
        return isset($this->private_ipv6_google_access) ? $this->private_ipv6_google_access : '';
    }

    public function hasPrivateIpv6GoogleAccess()
    {
        return isset($this->private_ipv6_google_access);
    }

    public function clearPrivateIpv6GoogleAccess()
    {
        unset($this->private_ipv6_google_access);
    }

    /**
     * The private IPv6 google access type for the VM.
     * If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string private_ipv6_google_access = 48277006;</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateIpv6GoogleAccess($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_ipv6_google_access = $var;

        return $this;
    }

    /**
     * Specifies the reservations that this instance can consume from.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;</code>
     * @return \Google\Cloud\Compute\V1\ReservationAffinity|null
     */
    public function getReservationAffinity()
    {
        return $this->reservation_affinity;
    }

    public function hasReservationAffinity()
    {
        return isset($this->reservation_affinity);
    }

    public function clearReservationAffinity()
    {
        unset($this->reservation_affinity);
    }

    /**
     * Specifies the reservations that this instance can consume from.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;</code>
     * @param \Google\Cloud\Compute\V1\ReservationAffinity $var
     * @return $this
     */
    public function setReservationAffinity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ReservationAffinity::class);
        $this->reservation_affinity = $var;

        return $this;
    }

    /**
     * Resource policies applied to this instance.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourcePolicies()
    {
        return $this->resource_policies;
    }

    /**
     * Resource policies applied to this instance.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourcePolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_policies = $arr;

        return $this;
    }

    /**
     * Output only. [Output Only] Specifies values set for instance attributes as
     * compared to the values requested by user in the corresponding input only
     * field.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     * @return \Google\Cloud\Compute\V1\ResourceStatus|null
     */
    public function getResourceStatus()
    {
        return $this->resource_status;
    }

    public function hasResourceStatus()
    {
        return isset($this->resource_status);
    }

    public function clearResourceStatus()
    {
        unset($this->resource_status);
    }

    /**
     * Output only. [Output Only] Specifies values set for instance attributes as
     * compared to the values requested by user in the corresponding input only
     * field.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     * @param \Google\Cloud\Compute\V1\ResourceStatus $var
     * @return $this
     */
    public function setResourceStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ResourceStatus::class);
        $this->resource_status = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return isset($this->satisfies_pzi) ? $this->satisfies_pzi : false;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Sets the scheduling options for this instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     * @return \Google\Cloud\Compute\V1\Scheduling|null
     */
    public function getScheduling()
    {
        return $this->scheduling;
    }

    public function hasScheduling()
    {
        return isset($this->scheduling);
    }

    public function clearScheduling()
    {
        unset($this->scheduling);
    }

    /**
     * Sets the scheduling options for this instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     * @param \Google\Cloud\Compute\V1\Scheduling $var
     * @return $this
     */
    public function setScheduling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Scheduling::class);
        $this->scheduling = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Server-defined URL for this resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * Output only. [Output Only] Server-defined URL for this resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * A list of service accounts, with their specified scopes, authorized for
     * this instance. Only one service account per VM instance is supported.
     * Service accounts generate access tokens that can be accessed
     * through the metadata server and used to authenticate applications on the
     * instance. SeeService Accounts
     * for more information.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceAccounts()
    {
        return $this->service_accounts;
    }

    /**
     * A list of service accounts, with their specified scopes, authorized for
     * this instance. Only one service account per VM instance is supported.
     * Service accounts generate access tokens that can be accessed
     * through the metadata server and used to authenticate applications on the
     * instance. SeeService Accounts
     * for more information.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     * @param array<\Google\Cloud\Compute\V1\ServiceAccount>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceAccounts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\ServiceAccount::class);
        $this->service_accounts = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;</code>
     * @return \Google\Cloud\Compute\V1\ShieldedInstanceConfig|null
     */
    public function getShieldedInstanceConfig()
    {
        return $this->shielded_instance_config;
    }

    public function hasShieldedInstanceConfig()
    {
        return isset($this->shielded_instance_config);
    }

    public function clearShieldedInstanceConfig()
    {
        unset($this->shielded_instance_config);
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;</code>
     * @param \Google\Cloud\Compute\V1\ShieldedInstanceConfig $var
     * @return $this
     */
    public function setShieldedInstanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ShieldedInstanceConfig::class);
        $this->shielded_instance_config = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;</code>
     * @return \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy|null
     */
    public function getShieldedInstanceIntegrityPolicy()
    {
        return $this->shielded_instance_integrity_policy;
    }

    public function hasShieldedInstanceIntegrityPolicy()
    {
        return isset($this->shielded_instance_integrity_policy);
    }

    public function clearShieldedInstanceIntegrityPolicy()
    {
        unset($this->shielded_instance_integrity_policy);
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;</code>
     * @param \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy $var
     * @return $this
     */
    public function setShieldedInstanceIntegrityPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy::class);
        $this->shielded_instance_integrity_policy = $var;

        return $this;
    }

    /**
     * Source machine image
     *
     * Generated from protobuf field <code>optional string source_machine_image = 21769791;</code>
     * @return string
     */
    public function getSourceMachineImage()
    {
        return isset($this->source_machine_image) ? $this->source_machine_image : '';
    }

    public function hasSourceMachineImage()
    {
        return isset($this->source_machine_image);
    }

    public function clearSourceMachineImage()
    {
        unset($this->source_machine_image);
    }

    /**
     * Source machine image
     *
     * Generated from protobuf field <code>optional string source_machine_image = 21769791;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceMachineImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_machine_image = $var;

        return $this;
    }

    /**
     * Source machine image encryption key when creating an instance from a
     * machine image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceMachineImageEncryptionKey()
    {
        return $this->source_machine_image_encryption_key;
    }

    public function hasSourceMachineImageEncryptionKey()
    {
        return isset($this->source_machine_image_encryption_key);
    }

    public function clearSourceMachineImageEncryptionKey()
    {
        unset($this->source_machine_image_encryption_key);
    }

    /**
     * Source machine image encryption key when creating an instance from a
     * machine image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceMachineImageEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_machine_image_encryption_key = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Whether a VM has been restricted for start because Compute
     * Engine has detected suspicious activity.
     *
     * Generated from protobuf field <code>optional bool start_restricted = 123693144;</code>
     * @return bool
     */
    public function getStartRestricted()
    {
        return isset($this->start_restricted) ? $this->start_restricted : false;
    }

    public function hasStartRestricted()
    {
        return isset($this->start_restricted);
    }

    public function clearStartRestricted()
    {
        unset($this->start_restricted);
    }

    /**
     * Output only. [Output Only] Whether a VM has been restricted for start because Compute
     * Engine has detected suspicious activity.
     *
     * Generated from protobuf field <code>optional bool start_restricted = 123693144;</code>
     * @param bool $var
     * @return $this
     */
    public function setStartRestricted($var)
    {
        GPBUtil::checkBool($var);
        $this->start_restricted = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] The status of the instance. One of the
     * following values: PROVISIONING, STAGING,RUNNING, STOPPING, SUSPENDING,SUSPENDED, REPAIRING, andTERMINATED. For more information about the status of the
     * instance, see
     * Instance life cycle.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @return string
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : '';
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * Output only. [Output Only] The status of the instance. One of the
     * following values: PROVISIONING, STAGING,RUNNING, STOPPING, SUSPENDING,SUSPENDED, REPAIRING, andTERMINATED. For more information about the status of the
     * instance, see
     * Instance life cycle.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @param string $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->status = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] An optional, human-readable explanation of the status.
     *
     * Generated from protobuf field <code>optional string status_message = 297428154;</code>
     * @return string
     */
    public function getStatusMessage()
    {
        return isset($this->status_message) ? $this->status_message : '';
    }

    public function hasStatusMessage()
    {
        return isset($this->status_message);
    }

    public function clearStatusMessage()
    {
        unset($this->status_message);
    }

    /**
     * Output only. [Output Only] An optional, human-readable explanation of the status.
     *
     * Generated from protobuf field <code>optional string status_message = 297428154;</code>
     * @param string $var
     * @return $this
     */
    public function setStatusMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->status_message = $var;

        return $this;
    }

    /**
     * Tags to apply to this instance. Tags are used to identify valid
     * sources or targets for network firewalls and are specified by the client
     * during instance creation. The tags can be later modified by the setTags
     * method. Each tag within the list must comply withRFC1035.
     * Multiple tags can be specified via the 'tags.items' field.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     * @return \Google\Cloud\Compute\V1\Tags|null
     */
    public function getTags()
    {
        return $this->tags;
    }

    public function hasTags()
    {
        return isset($this->tags);
    }

    public function clearTags()
    {
        unset($this->tags);
    }

    /**
     * Tags to apply to this instance. Tags are used to identify valid
     * sources or targets for network firewalls and are specified by the client
     * during instance creation. The tags can be later modified by the setTags
     * method. Each tag within the list must comply withRFC1035.
     * Multiple tags can be specified via the 'tags.items' field.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     * @param \Google\Cloud\Compute\V1\Tags $var
     * @return $this
     */
    public function setTags($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Tags::class);
        $this->tags = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] URL of the zone where the instance resides.
     * You must specify this field as part of the HTTP request URL. It is
     * not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string zone = 3744684;</code>
     * @return string
     */
    public function getZone()
    {
        return isset($this->zone) ? $this->zone : '';
    }

    public function hasZone()
    {
        return isset($this->zone);
    }

    public function clearZone()
    {
        unset($this->zone);
    }

    /**
     * Output only. [Output Only] URL of the zone where the instance resides.
     * You must specify this field as part of the HTTP request URL. It is
     * not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string zone = 3744684;</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

}

