<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/auth.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configurations for authentication using a custom service account.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.ServiceAccountAuthConfig</code>
 */
class ServiceAccountAuthConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The email address of the service account used for authentication.
     * CES uses this service account to exchange an access token and the access
     * token is then sent in the `Authorization` header of the request.
     * The service account must have the
     * `roles/iam.serviceAccountTokenCreator` role granted to the
     * CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $service_account = '';
    /**
     * Optional. The OAuth scopes to grant. If not specified, the default scope
     * `https://www.googleapis.com/auth/cloud-platform` is used.
     *
     * Generated from protobuf field <code>repeated string scopes = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $scopes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_account
     *           Required. The email address of the service account used for authentication.
     *           CES uses this service account to exchange an access token and the access
     *           token is then sent in the `Authorization` header of the request.
     *           The service account must have the
     *           `roles/iam.serviceAccountTokenCreator` role granted to the
     *           CES service agent
     *           `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $scopes
     *           Optional. The OAuth scopes to grant. If not specified, the default scope
     *           `https://www.googleapis.com/auth/cloud-platform` is used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\Auth::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The email address of the service account used for authentication.
     * CES uses this service account to exchange an access token and the access
     * token is then sent in the `Authorization` header of the request.
     * The service account must have the
     * `roles/iam.serviceAccountTokenCreator` role granted to the
     * CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Required. The email address of the service account used for authentication.
     * CES uses this service account to exchange an access token and the access
     * token is then sent in the `Authorization` header of the request.
     * The service account must have the
     * `roles/iam.serviceAccountTokenCreator` role granted to the
     * CES service agent
     * `service-<PROJECT-NUMBER>&#64;gcp-sa-ces.iam.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Optional. The OAuth scopes to grant. If not specified, the default scope
     * `https://www.googleapis.com/auth/cloud-platform` is used.
     *
     * Generated from protobuf field <code>repeated string scopes = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getScopes()
    {
        return $this->scopes;
    }

    /**
     * Optional. The OAuth scopes to grant. If not specified, the default scope
     * `https://www.googleapis.com/auth/cloud-platform` is used.
     *
     * Generated from protobuf field <code>repeated string scopes = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setScopes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->scopes = $arr;

        return $this;
    }

}

